var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDetailComponent } from '../../../../components/common/base-detail.component';
import { ContextMenuView, OperationType, RecordOperationMode } from '../../../../core/enums/common-enums';
import { ContextMenu } from '../../../../core/models/common/context-menu';
import { Menu } from '../../../../core/models/common/menu';
import { PhoneState } from '../../../../core/models/common/phone-state';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { CreateOrganizationRequest } from '../../../../core/models/organization/create-organization-request';
import { CallerIdInfoDto } from '../../../../core/models/phone/phone-caller-id-infoDto';
import { PhoneCallerInfoDto } from '../../../../core/models/phone/phone-caller-infoDto';
import { BroadCastEventKeys } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
let OrganizationDetailComponent = class OrganizationDetailComponent extends BaseDetailComponent {
    constructor(sessionManager, contextMenuService, integrationSettingManager, eventProvider, organizationService, phoneService, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.sessionManager = sessionManager;
        this.contextMenuService = contextMenuService;
        this.integrationSettingManager = integrationSettingManager;
        this.eventProvider = eventProvider;
        this.organizationService = organizationService;
        this.phoneService = phoneService;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.phoneState = new PhoneState();
        this.callerIdInfo = new CallerIdInfoDto();
        this.organizationPrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Organization, OperationType.PrivateField);
        this.fetchOrganizationDetailResponse = this.fetchOrganizationDetailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.phoneState = this.phoneManager.phoneState;
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        this.loadOrganizationDetail();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    loadOrganizationDetail() {
        this.hasRightLocation = GlobalFunctions.hasRight(GlobalFunctions.toContentType("Location"), OperationType.View) && GlobalFunctions.isValidToShowMap(this.organizationPrivateFields);
        this.menu.addOrUpdateMenuItem(0, "OrganizationDetail", this.translateService.instant("LBL_ORGANIZATION"), false, true, true);
        this.addMenuItem.emit(this.menu);
        this.sendRelatedRequest.emit();
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.Partial == true) {
            let partialDto = new Object();
            partialDto.Id = this.sessionManager.selectedEntity.Id;
            partialDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
            this.organizationService.fetchDetail(partialDto, this.fetchOrganizationDetailResponse);
            this.startSpinner();
        }
        else
            this.updateCallerIdInfo();
    }
    updateCallerIdInfo() {
        if (this.phoneManager.phoneState.IsPhoneBasicFeatureEnabled && !GlobalFunctions.isEmpty(this.phoneManager.phoneState.CurrentCaller.PhoneNumber)) {
            this.callerIdInfo.IsPhone = true;
            this.callerIdInfo.OldPhoneNumber = this.sessionManager.selectedEntity.PhoneNumber;
            if (this.callerIdInfo.OldPhoneNumber == this.phoneManager.phoneState.CurrentCaller.PhoneNumber && this.phoneManager.phoneState.CurrentCaller.Item != null) {
                this.callerIdInfo.Resolved = true;
                this.callerIdInfo.ToolTipText = this.translateService.instant("LBL_REMOVE_PHONE_NUMBER") + " {" + this.phoneManager.phoneState.CurrentCaller.PhoneNumber + "}";
            }
            else {
                this.callerIdInfo.Resolved = false;
                this.callerIdInfo.ToolTipText = this.translateService.instant("LBL_ADD_PHONE_NUMBER") + " {" + this.phoneManager.phoneState.CurrentCaller.PhoneNumber + "}";
            }
        }
    }
    fetchOrganizationDetailResponse(result) {
        this.stopSpinner();
        this.sessionManager.loadedFromRelatedView = false;
        if (result != null) {
            this.sessionManager.setBreadcrumbGrammer(result);
            this.sessionManager.selectedEntity = result;
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL, this.sessionManager.selectedEntity);
            this.sessionManager.addItemToSession(result);
            this.sessionManager.selectedEntity.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
            this.updateCallerIdInfo();
        }
    }
    createOrganizationRequest(lastLoadedPersonOrOrganizationEntity) {
        let organizationRequest = new CreateOrganizationRequest();
        organizationRequest.Mode = RecordOperationMode.Edit;
        organizationRequest.OrganizationDto = lastLoadedPersonOrOrganizationEntity;
        this.organizationService.createOrganizationEntity(organizationRequest, null, null);
    }
    changeCallerId() {
        let callerInfoDto = new PhoneCallerInfoDto();
        callerInfoDto.PhoneNumber = this.phoneManager.phoneState.CurrentCaller.PhoneNumber;
        callerInfoDto.ObjectId = this.sessionManager.selectedEntity.Id;
        callerInfoDto.ObjectType = GlobalFunctions.toContentType(GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn));
        callerInfoDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
        if (this.callerIdInfo.Resolved) {
            this.phoneService.updateCallerIdRequest(callerInfoDto);
            this.sessionManager.selectedEntity.PhoneNumber = callerInfoDto.PhoneNumber;
            this.phoneManager.phoneState.CurrentCaller.Item = this.sessionManager.selectedEntity;
            this.callerIdInfo.ToolTipText = this.translateService.instant("LBL_REMOVE_PHONE_NUMBER") + " {" + this.phoneManager.phoneState.CurrentCaller.PhoneNumber + "}";
        }
        else {
            this.phoneService.deleteCallerIdRequest(callerInfoDto);
            this.sessionManager.selectedEntity.PhoneNumber = this.callerIdInfo.OldPhoneNumber;
            this.callerIdInfo.ToolTipText = this.translateService.instant("LBL_ADD_PHONE_NUMBER") + " {" + this.phoneManager.phoneState.CurrentCaller.PhoneNumber + "}";
        }
        this.createOrganizationRequest(this.sessionManager.selectedEntity);
    }
    select(url) {
        if (!GlobalFunctions.isEmpty(url)) {
            url = GlobalFunctions.ensureHttpPrefix(url);
            GlobalFunctions.popUpCenter(url, 1024, 550);
        }
    }
};
OrganizationDetailComponent = __decorate([
    Component({
        selector: 'organization-detail',
        templateUrl: './organization-detail.component.html',
        styleUrls: ['./organization-detail.component.scss']
    })
], OrganizationDetailComponent);
export { OrganizationDetailComponent };
//# sourceMappingURL=organization-detail.component.js.map