var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { SubSink } from 'subsink';
import { MessageboxComponent } from '../../../../components/common/messagebox/messagebox.component';
import { OperationType } from '../../../../core/enums/common-enums';
import { BulkDeleteNoteRequest } from '../../../../core/models/note/bulk-delete-note-request';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
let NoteBulkDeleteComponent = class NoteBulkDeleteComponent extends BaseDialogComponent {
    constructor(result, dialogRef, sessionManager, translateService, shortcutManager, noteService, dialog, datePipe) {
        super();
        this.result = result;
        this.dialogRef = dialogRef;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.shortcutManager = shortcutManager;
        this.noteService = noteService;
        this.dialog = dialog;
        this.datePipe = datePipe;
        this.title = '';
        this.resultList = this.result.resultList;
        this.handleUntilDate = new Date();
        this.maxDate = new Date();
        this.timeoutIds = [];
        this.subs = new SubSink();
        this.bulkDeleteNoteResponse = this.bulkDeleteNoteResponse.bind(this);
    }
    ;
    ngOnInit() {
        this.timeoutIds.push(setTimeout(() => {
            GlobalFunctions.setDateFormat("handleUntilDateDatePicker", this.maxDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        }, 100));
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.bulkDelete());
    }
    ;
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    bulkDelete() {
        if (this.resultList?.length > 0) {
            this.startSpinner();
            let noteIds = [];
            let isAllowed = GlobalFunctions.hasRight(GlobalFunctions.toContentType("NOTEENTITY"), OperationType.BulkDelete) ? true : false;
            let selectedUntilDate = new Date(this.handleUntilDate);
            let untilDate = new Date(selectedUntilDate.getFullYear(), selectedUntilDate.getMonth(), selectedUntilDate.getDate(), 23, 59, 0, 0);
            let count = 0;
            if (isAllowed) {
                for (let i = 0; i < this.resultList.length; i++) {
                    let noteEndDateTime = new Date(this.resultList[i].OnDateTime);
                    if (noteEndDateTime <= untilDate) {
                        count++;
                        noteIds.push(this.resultList[i].Id);
                    }
                }
            }
            this.stopSpinner();
            let message = this.translateService.instant("LBL_MSG_BULK_DELETE");
            let header = this.translateService.instant("LBL_BULK_DELETE");
            if (count == 0) {
                message = this.translateService.instant("LBL_MSG_BULK_DELETE_NO_NOTE");
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message });
            }
            else {
                message = GlobalFunctions.formatStringValue(message, [count]);
                let messageInfo = DialogHelper.getMessage(header, message, true, null, null, null, null, this.translateService);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
                    if (result) {
                        let req = new BulkDeleteNoteRequest();
                        req.NoteDate = new Date(this.handleUntilDate);
                        req.NoteIdList = noteIds;
                        this.startSpinner();
                        this.noteService.bulkDeleteNote(req, this.bulkDeleteNoteResponse, null);
                    }
                });
            }
        }
    }
    ;
    bulkDeleteNoteResponse(result) {
        this.stopSpinner();
        switch (result.Result) {
            case 0:
                {
                    this.close(true);
                    break;
                }
            case 1:
                {
                    let header = this.translateService.instant("LBL_BULK_DELETE");
                    let message = this.translateService.instant("LBL_MSG_BULK_DELETE_FAIL");
                    let messageInfo = DialogHelper.getMessage(header, message, true, null, null, null, null, this.translateService);
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(() => { this.close(false); });
                    break;
                }
        }
    }
    ;
    close(result) {
        this.dialogRef.close(result);
    }
    bulkDeleteDOBChange(event, inputId) {
        GlobalFunctions.setDateFormat(inputId, event.target.value, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
    }
    toggleClick() {
        GlobalFunctions.setDateFormat('handleUntilDateDatePicker', this.handleUntilDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
    }
};
NoteBulkDeleteComponent = __decorate([
    Component({
        selector: 'note-bulk-delete',
        templateUrl: './note-bulk-delete.component.html',
        styleUrls: ['./note-bulk-delete.component.scss']
    }),
    __param(0, Inject(MAT_DIALOG_DATA))
], NoteBulkDeleteComponent);
export { NoteBulkDeleteComponent };
//# sourceMappingURL=note-bulk-delete.component.js.map