var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { FileUploadSource, KeyCode, ScreenMode } from '../../../../core/enums/common-enums';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { NoteNotificationMessageDto } from '../../../../core/models/note/note-notification-messageDto';
import { NoteEntityDto } from '../../../../core/models/note/note-entityDto';
import { HandlerType, NoteStatus, NoteType, PublishTo } from '../../../../core/enums/notes-enum';
import { AddNoteRequest } from '../../../../core/models/note/add-note-request';
import { NoteRelatedEntityDto } from '../../../../core/models/note/note-related-entityDto';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { SubSink } from 'subsink';
import { BroadCastEventKeys, EntityName, RoutePath, TinyMCE } from 'src/app/shared/constants';
import { MessageboxComponent } from 'src/app/components/common/messagebox/messagebox.component';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { JkcDatePickerHelper } from '../../../../shared/helper/jkc-date-picker-helper';
import { CommonHelper } from '../../../../shared/helper/common-helper';
let NoteAddEditComponent = class NoteAddEditComponent extends BaseDialogComponent {
    constructor(sessionManager, dialogManager, translateService, shortcutManager, noteService, userService, cacheManager, integrationSettingManager, employeeService, dialog, router, eventProvider, formatManager, datePipe, renderer, searchService, dateAdapter, fileService, applicationSettingManager, fileManager) {
        super();
        this.sessionManager = sessionManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.shortcutManager = shortcutManager;
        this.noteService = noteService;
        this.userService = userService;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.employeeService = employeeService;
        this.dialog = dialog;
        this.router = router;
        this.eventProvider = eventProvider;
        this.formatManager = formatManager;
        this.datePipe = datePipe;
        this.renderer = renderer;
        this.searchService = searchService;
        this.dateAdapter = dateAdapter;
        this.fileService = fileService;
        this.applicationSettingManager = applicationSettingManager;
        this.fileManager = fileManager;
        this.DateJS = Date;
        this.notificationMessageDto = null;
        this.enableDuedate = false;
        this.enablePublishDate = false;
        this.enableAnnouncement = false;
        this.noteEntityDto = new NoteEntityDto();
        this.title = this.translateService.instant("LBL_ADD_NOTE").toUpperCase();
        this.publishTo = "announcement";
        this.publishToPlaceholder = this.translateService.instant("LBL_SELECT_HANDLER");
        this.localUserGroups = [];
        this.isLocalGroupEnabled = false;
        this.editMode = false;
        this.publishToHandlerTags = [];
        this.publishToHandlerTagItems = [];
        this.createNoteStatus = "";
        this.publishToList = [];
        this.showAssignee = false;
        this.cachedEmployeeEntities = [];
        this.subs = new SubSink();
        this.minDate = new Date();
        this.datePickerClosed = true;
        this.dateJS = Date;
        this.noteEditorId = "tinymceNote" + GlobalFunctions.getGuid();
        this.timeoutIds = [];
        this.isManualEntry = false;
        this.uploadedFile = null;
        this.enableDepartmentNameInHandler = this.applicationSettingManager.isDepartmentNameInHandlerEnabled();
        this.addNoteResponse = this.addNoteResponse.bind(this);
        this.addNoteErrorCallback = this.addNoteErrorCallback.bind(this);
        this.sessionManager.jkcParentPanel.parameters.Scope = this;
        this.editMode = this.sessionManager.jkcParentPanel.parameters.EditMode;
        this.noteSessionData = this.sessionManager.jkcParentPanel.parameters.EditedData;
        this.selectedEntity = this.sessionManager.selectedEntity;
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        this.initPublishToList();
        this.initLocalGroups();
        this.init();
        this.initEditor();
        this.setHandlerTags();
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    init() {
        try {
            this.sessionManager.startSessionIfPossible("NOTEENTITY", this.sessionManager.jkcParentPanel.parameters.EditMode ? ScreenMode.Edit : ScreenMode.Add);
            if (this.editMode === true) {
                if (this.selectedEntity != null && !GlobalFunctions.isEmpty(this.selectedEntity.Publish)) {
                    if (this.selectedEntity.Publish !== -1) {
                        this.publishTo = PublishTo[this.selectedEntity.Publish].toLowerCase();
                        this.enableAnnouncement = true;
                    }
                    //Set other employee/department if any set
                    let handlerData = null;
                    if (this.selectedEntity.Publish == PublishTo.OtherEmployee) {
                        handlerData = this.cacheManager.getEmployeeById(this.selectedEntity.HandlerId);
                        this.publishToPlaceholder = this.translateService.instant("LBL_SELECT_HANDLER");
                    }
                    else if (this.selectedEntity.Publish == PublishTo.OtherDepartment) {
                        handlerData = this.cacheManager.getDepartmentById(this.selectedEntity.HandlerId);
                        this.publishToPlaceholder = this.translateService.instant("LBL_SELECT_DEPARTMENT");
                    }
                    if (handlerData != null) {
                        handlerData.text = handlerData.StringRepresentation;
                        this.publishToHandlerTags = [];
                        this.publishToHandlerTags.push(handlerData);
                    }
                }
                this.noteEntityDto = jQuery.extend(true, {}, this.selectedEntity);
                this.title = this.translateService.instant("LBL_EDIT").toUpperCase() + ' ' + this.translateService.instant("LBL_NOTE").toUpperCase();
                if (this.noteEntityDto.EndDateTime != null) {
                    this.enableDuedate = true;
                    this.dueDate = this.noteEntityDto.EndDateTime;
                }
                if (this.noteEntityDto.StartDateTime != null) {
                    this.enablePublishDate = true;
                    this.publishDate = this.noteEntityDto.StartDateTime;
                }
                this.showAssignee = false;
                this.timeoutIds.push(setTimeout(() => {
                    GlobalFunctions.setDateFormat("publishDateDatePicker", this.publishDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
                    GlobalFunctions.setDateFormat("dueDateDatePicker", this.dueDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
                }, 50));
            }
            else
                this.showAssignee = true;
            if (this.selectedEntity != null && this.editMode === false) {
                let type = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn);
                type = this.translateService.instant("LBL_" + type.toUpperCase());
                if (!GlobalFunctions.isEmpty(type))
                    this.title = this.title + " " + this.translateService.instant("LBL_TO").toUpperCase() + " " + type.toUpperCase() + " " + this.selectedEntity.StringRepresentation.toUpperCase();
            }
            if (!this.editMode) {
                let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Notes_Entities_NoteEntity, "SETDEFAULTDUEDATESTATE");
                if (!GlobalFunctions.isEmpty(result))
                    this.enableDuedate = result.toUpperCase() === "TRUE";
            }
            if (this.sessionManager.detailViewCachedEntityList != null && this.sessionManager.detailViewCachedEntityList != undefined) {
                let cachedEntities = this.sessionManager.detailViewCachedEntityList;
                if (cachedEntities != null && cachedEntities.length > 0) {
                    this.cachedEmployeeEntities = [];
                    cachedEntities.forEach(value => {
                        let actualEntityType = value.value.replace(/\./g, '_');
                        if (EntityFqdn["" + actualEntityType + ""] == 22)
                            this.cachedEmployeeEntities.push(value.key);
                    });
                }
            }
            this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.createNote());
            if (this.noteSessionData != null)
                this.assignSessionDataToDto(this.noteSessionData);
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        }
        catch (e) {
            console.error(e.message);
        }
    }
    initDatePickerState() {
        this.isManualEntry = false;
        JkcDatePickerHelper.setMargin('131px', '-26px', 'fixed', this.renderer); // Renderere2 - class used to make custom UI changes
        JkcDatePickerHelper.setOverlayBackgroundColor(false, this.renderer);
        JkcDatePickerHelper.isDatePickerClosed = false;
        this.dateAdapter.setLocale(CommonHelper.getLanguageCode());
        if ((this.publishDate && this.datePipe.transform(this.publishDate, this.sessionManager.defaultOptions.mdyyyy) !== '1/1/1970') || (this.dueDate && this.datePipe.transform(this.dueDate, this.sessionManager.defaultOptions.mdyyyy) !== '1/1/1970')) {
            GlobalFunctions.setDateFormat("publishDateDatePicker", this.publishDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
            GlobalFunctions.setDateFormat("dueDateDatePicker", this.dueDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        }
    }
    initPublishToList() {
        this.publishToList = [
            { publishToValue: "announcement", publishToText: this.translateService.instant("LBL_ANNOUNCEMENT") },
            { publishToValue: "everyone", publishToText: this.translateService.instant("LBL_EVERYONE") },
            { publishToValue: "myself", publishToText: this.translateService.instant("LBL_MYSELF") },
            { publishToValue: "mydepartment", publishToText: this.translateService.instant("LBL_MY_DEPARTMENT") },
            { publishToValue: "otheremployee", publishToText: this.translateService.instant("LBL_OTHER_EMPLOYEE") },
            { publishToValue: "otherdepartment", publishToText: this.translateService.instant("LBL_OTHER_DEPARTMENT") }
        ];
    }
    initLocalGroups() {
        this.localUserGroups = this.userService.getNativeUsergroupList();
        this.isLocalGroupEnabled = this.localUserGroups?.length > 0;
    }
    initEditor() {
        this.tinymceOptions = {
            base_url: '/tinymce',
            selector: this.noteEditorId,
            plugins: 'autolink lists image',
            iframe_aria_text: GlobalFunctions.removeHTMLTags(this.noteEntityDto.Description),
            toolbar: 'undo redo removeformat | fontfamily blocks fontsize | bold italic underline | alignleft aligncenter alignright | bullist numlist | outdent indent | table | forecolor backcolor | link | standardFormat | image | sections',
            font_size_formats: TinyMCE.FONT_SIZE_FORMATS,
            font_family_formats: TinyMCE.FONT_FAMILY_FORMATS,
            resize: false,
            contextmenu: false,
            browser_spellcheck: true,
            elementpath: false,
            menubar: false,
            apply_source_formatting: true,
            statusbar: false,
            entity_encoding: 'raw',
            content_style: "p {margin: 0; padding: 0}",
            height: $("#jkcParentPanel").height() - $("#createNoteHeader").height() - $("#addNoteFooter").height() - 220 + "px",
            paste_postprocess: (plugin, args) => args.node.setAttribute('id', '42'),
            paste_data_images: true,
            automatic_uploads: true,
            file_picker_types: 'image',
            force_br_newlines: false,
            forced_root_block: 'div',
            images_upload_base_path: '/assets/images/note/',
            init_instance_callback: (editor) => {
                GlobalFunctions.setEditorBodyHeight();
                this.editor = editor;
                editor.on('keydown', (e) => {
                    let event = e;
                    if (event.key.toLocaleLowerCase() === KeyCode.Escape)
                        this.close(false);
                });
            },
            file_picker_callback: (callback, value, meta) => {
                this.fileManager.setFilePickerCallback(callback, value, meta, this.editor, EntityName.NOTE_ENTITY);
            },
            images_upload_handler: (blobInfo, progress) => {
                return this.fileManager.setFileUploadHandler(blobInfo, progress, this.tinymceOptions.images_upload_base_path, FileUploadSource.Note);
            },
            setup: (editor) => {
                if (this.isLocalGroupEnabled) {
                    editor.ui.registry.addButton('sections', {
                        text: this.translateService.instant("LBL_ADD_BLOCK"),
                        onAction: () => {
                            try {
                                let tempContent = editor.getContent();
                                let uniqueId = GlobalFunctions.createGuid().replace(/-/g, '');
                                tempContent = tempContent + '<br/><section id="' + uniqueId + '" style="border: lightgray 2px solid;min-height:150px;height:auto;">  </section> <br/> <br/> <br/>';
                                editor.setContent(tempContent);
                                let editorWindow = document.getElementsByTagName('iframe');
                                if (editorWindow != null) {
                                    let body = editorWindow[0].contentWindow.document.getElementById('tinymce');
                                    body.style.height = editorWindow[0].style.height;
                                    editorWindow[0].contentWindow.scrollTo(0, body.scrollHeight);
                                }
                            }
                            catch (e) {
                                console.error(e);
                            }
                        }
                    });
                }
            }
        };
    }
    publishToHandlerAdded(tag) {
        let inputbox = $("#publishToHandlerTagControl").find("input");
        if (inputbox != undefined && inputbox != null) {
            inputbox[0].attributes["placeholder"].value = "";
        }
    }
    publishToHandlerRemoved(tag) {
        let inputbox = $("#publishToHandlerTagControl").find("input");
        if (inputbox != undefined && inputbox != null) {
            if (this.publishTo == "otheremployee")
                inputbox[0].attributes["placeholder"].value = this.translateService.instant("LBL_SELECT_HANDLER");
            else if (this.publishTo == "otherdepartment")
                inputbox[0].attributes["placeholder"].value = this.translateService.instant("LBL_SELECT_DEPARTMENT");
        }
    }
    setHandlerTags() {
        if (this.publishTo == "otheremployee")
            this.publishToHandlerTagItems = this.cacheManager.getEmployeeList(true);
        else if (this.publishTo == "otherdepartment")
            this.publishToHandlerTagItems = this.cacheManager.getDepartmentList();
    }
    changePublishOptions() {
        this.setHandlerTags();
        this.publishToHandlerTags = [];
        if (this.publishTo == "otheremployee")
            this.publishToPlaceholder = this.translateService.instant("LBL_SELECT_HANDLER");
        else if (this.publishTo == "otherdepartment")
            this.publishToPlaceholder = this.translateService.instant("LBL_SELECT_DEPARTMENT");
    }
    addNoteErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_CREATE_ERROR_MSG"), [this.translateService.instant("LBL_NOTE")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_NOTE"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    createNote() {
        if (this.validate()) {
            this.startSpinner();
            let addNoteRequest = new AddNoteRequest();
            this.setNoteEntityDto();
            addNoteRequest.NoteEntityDto = this.noteEntityDto;
            addNoteRequest.NotificationMessageDto = this.getNotificationMessageDto();
            if (this.selectedEntity != null && this.editMode == false) {
                let relatedEntity = new NoteRelatedEntityDto();
                relatedEntity.ContentType = GlobalFunctions.getContentTypeByPropertyName("RelatedEntityFqdn", this.selectedEntity);
                if (ContentType.Note != relatedEntity.ContentType) {
                    relatedEntity.RelatedEntityId = this.selectedEntity.Id;
                    relatedEntity.ObjectSource = this.selectedEntity.ObjectSource;
                    addNoteRequest.NoteEntityDto.RelatedEntities.push(relatedEntity);
                }
            }
            this.noteService.addNoteRequest(addNoteRequest, this.addNoteResponse, this.addNoteErrorCallback);
        }
    }
    validate() {
        let isValid = this.form.valid;
        this.createNoteStatus = null;
        let today = new Date(new Date().getFullYear(), new Date().getMonth(), new Date().getDate(), 0, 0, 0, 0);
        if (this.enableDuedate) {
            if (this.dueDate == null)
                this.createNoteStatus = this.translateService.instant("LBL_VAL_EXPIRE_DATE_EMPTY");
            if (this.dueDate < today)
                this.createNoteStatus = this.translateService.instant("LBL_VAL_EXPIRE_DATE_LT_TODAY_DATE");
        }
        else
            this.dueDate = null;
        if (this.enablePublishDate) {
            if (this.publishDate == null)
                this.createNoteStatus = this.translateService.instant("LBL_VAL_PUBLISH_DATE_EMPTY");
            else if (this.publishDate < today)
                this.createNoteStatus = this.translateService.instant("LBL_VAL_PUBLISH_DATE_LT_TODAY_DATE");
        }
        else
            this.publishDate = null;
        if (this.enableAnnouncement) {
            if (GlobalFunctions.isEmpty(this.publishTo) || this.publishTo == "announcement")
                this.createNoteStatus = this.translateService.instant("LBL_SELECT_PUBLISH_DESTINATION");
            else if (this.publishTo == "otheremployee" || this.publishTo == "otherdepartment") {
                if (GlobalFunctions.isEmpty(this.publishToHandlerTags))
                    this.createNoteStatus = this.translateService.instant("LBL_SELECT_PUBLISH_DESTINATION");
                else if (this.publishToHandlerTags.length > 1)
                    isValid = false;
            }
        }
        if (this.createNoteStatus != null)
            isValid = false;
        return isValid;
    }
    setNoteEntityDto() {
        if (GlobalFunctions.isEmpty(this.noteEntityDto.Id))
            this.noteEntityDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        this.noteEntityDto.Description = this.editor.getContent();
        this.noteEntityDto.OnDateTime = new this.DateJS().toString('M/d/yyyy HH:mm:ss'); //new Date();
        this.noteEntityDto.ParentId = '';
        this.noteEntityDto.Status = NoteStatus.Active;
        this.noteEntityDto.StatusText = this.translateService.instant("LBL_ACTIVE");
        this.noteEntityDto.NoteType = NoteType.Note;
        this.noteEntityDto.NoteTypeText = this.translateService.instant("LBL_NOTE");
        if (this.enableDuedate)
            this.noteEntityDto.EndDateTime = new this.dateJS(this.dueDate).toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        else
            this.noteEntityDto.EndDateTime = null;
        if (this.enablePublishDate)
            this.noteEntityDto.StartDateTime = new this.dateJS(this.publishDate).toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        else
            this.noteEntityDto.StartDateTime = null;
        this.noteEntityDto.StringRepresentation = "";
        if (!GlobalFunctions.isEmpty(this.noteEntityDto.Title))
            this.noteEntityDto.StringRepresentation = this.noteEntityDto.Title;
        else
            this.sessionManager.setBreadcrumbGrammer(this.noteEntityDto);
    }
    getNotificationMessageDto() {
        if (this.enableAnnouncement) {
            if (!this.notificationMessageDto && this.notificationMessageDto === null)
                this.notificationMessageDto = new NoteNotificationMessageDto();
            this.notificationMessageDto.NoteEntity = this.noteEntityDto;
            //check publish options
            switch (this.publishTo) {
                case "everyone":
                    {
                        this.notificationMessageDto.Publish = PublishTo.Everyone;
                        break;
                    }
                case "myself":
                    {
                        this.notificationMessageDto.Publish = PublishTo.Myself;
                        this.notificationMessageDto.HandlerId = this.employeeService.loggedInEmployee.Id;
                        this.notificationMessageDto.HandlerType = HandlerType.Employee;
                        break;
                    }
                case "mydepartment":
                    {
                        if (this.employeeService.loggedInEmployee.Department != null)
                            this.notificationMessageDto.HandlerId = this.employeeService.loggedInEmployee.Department.Id;
                        else
                            this.notificationMessageDto.HandlerId = this.employeeService.loggedInEmployee.DepartmentId;
                        this.notificationMessageDto.HandlerType = HandlerType.Department;
                        this.notificationMessageDto.Publish = PublishTo.MyDepartment;
                        break;
                    }
                case "otheremployee":
                    {
                        if (this.publishToHandlerTags != undefined && this.publishToHandlerTags != null && this.publishToHandlerTags.length > 0) {
                            for (let i = 0; i < this.publishToHandlerTags.length; i++) {
                                this.notificationMessageDto.HandlerId = this.publishToHandlerTags[i].Id;
                                this.notificationMessageDto.HandlerType = HandlerType.Employee;
                                this.notificationMessageDto.Publish = PublishTo.OtherEmployee;
                            }
                        }
                        break;
                    }
                case "otherdepartment":
                    {
                        if (this.publishToHandlerTags != undefined && this.publishToHandlerTags != null && this.publishToHandlerTags.length > 0) {
                            for (let i = 0; i < this.publishToHandlerTags.length; i++) {
                                this.notificationMessageDto.HandlerId = this.publishToHandlerTags[i].Id;
                                this.notificationMessageDto.HandlerType = HandlerType.Department;
                                this.notificationMessageDto.Publish = PublishTo.OtherDepartment;
                            }
                        }
                        break;
                    }
            }
        }
        return this.notificationMessageDto;
    }
    addNoteResponse(response) {
        this.stopSpinner();
        if (response != null && response.Result == 0 && response.NoteEntityDto != null) {
            this.close(false);
            this.sessionManager.loadedFromRelatedView = false;
            this.formatManager.setCreatedBy([response.NoteEntityDto]);
            this.sessionManager.selectedEntity = response.NoteEntityDto;
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/noteentity`;
            if (!this.editMode)
                this.sessionManager.addBreadcrumbItems([response.NoteEntityDto], null, RoutePath.DETAIL_PATH);
            else {
                let selectedIndex = this.sessionManager.BreadcrumbItems.length - 1;
                this.sessionManager.BreadcrumbItems.splice(selectedIndex, 1);
                this.sessionManager.addBreadcrumbItems([response.NoteEntityDto], null, RoutePath.DETAIL_PATH);
                this.cacheManager.updateDashboardCache(response.NoteEntityDto);
            }
            this.cacheManager.removeDashboardCache();
            const isDetailView = this.router.url.includes(RoutePath.DETAIL_PATH);
            this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
            if (isDetailView)
                this.timeoutIds.push(setTimeout(() => this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW), 1000));
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_NOTE'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_NOTE") });
    }
    assignSessionDataToDto(sessionData) {
        this.noteEntityDto = sessionData.NoteEntityDto;
        this.noteEntityDto.ManageLocalGroupPrivilege = sessionData.ManageLocalGroupPrivilege;
        this.enableDuedate = sessionData.EnableDuedate;
        this.enablePublishDate = sessionData.EnablePublishDate;
        this.dueDate = sessionData.DueDate;
        this.publishDate = sessionData.PublishDate;
        this.enableAnnouncement = sessionData.EnableAnnouncement;
        this.publishTo = sessionData.PublishTo;
        this.publishToHandlerTags = sessionData.PublishToHandlerTags;
    }
    resize() {
        const windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel.parameters.TopSpace) - 100 + "px") });
        const newHeight = $("#jkcParentPanel").height() - $("#createNoteHeader").height() - $("#addNoteFooter").height();
        $("#addNoteContainer").height(newHeight + "px");
        $('.tox-tinymce').height(newHeight - 220 + "px");
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    manageLocalGroupPrivilege() {
        this.dialogManager.manageBlockWiseLocalGroupPrivilege(this.localUserGroups, this.noteEntityDto.ManageLocalGroupPrivilege, this.noteEntityDto.Description).afterClosed().toPromise().then((manageLocalGroupPrivilege) => this.noteEntityDto.ManageLocalGroupPrivilege = manageLocalGroupPrivilege);
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close(false);
    }
    close(result) {
        this.editor?.remove();
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
    noteDOBChange(event, inputId) {
        this.timeoutIds.push(setTimeout(() => {
            if (this.publishDate && inputId === 'publishDateDatePicker' && this.datePipe.transform(this.publishDate, this.sessionManager.defaultOptions.mdyyyy) !== '1/1/1970')
                GlobalFunctions.setDateFormat(inputId, this.publishDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
            if (this.dueDate && inputId === 'dueDateDatePicker' && this.datePipe.transform(this.dueDate, this.sessionManager.defaultOptions.mdyyyy) !== '1/1/1970')
                GlobalFunctions.setDateFormat(inputId, this.dueDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
            if (this.isManualEntry && this.manualPublishDate && inputId === 'publishDateDatePicker')
                GlobalFunctions.setDateFormat(inputId, this.manualPublishDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
            if (this.isManualEntry && this.manualDueDate && inputId === 'dueDateDatePicker')
                GlobalFunctions.setDateFormat(inputId, this.manualDueDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        }));
        JkcDatePickerHelper.isDatePickerClosed = true;
    }
    handleManualDateInput_Note(target, inputId) {
        this.isManualEntry = true;
        if (inputId === 'publishDateDatePicker')
            this.manualPublishDate = GlobalFunctions.handleManualDateInput(target, this.sessionManager);
        else if (inputId === 'dueDateDatePicker')
            this.manualDueDate = GlobalFunctions.handleManualDateInput(target, this.sessionManager);
    }
};
__decorate([
    ViewChild('form')
], NoteAddEditComponent.prototype, "form", void 0);
__decorate([
    ViewChild('publishDateInput')
], NoteAddEditComponent.prototype, "publishDateInput", void 0);
__decorate([
    ViewChild('dueDateInput')
], NoteAddEditComponent.prototype, "dueDateInput", void 0);
__decorate([
    ViewChild('picker')
], NoteAddEditComponent.prototype, "publishDatePicker", void 0);
__decorate([
    ViewChild('picker1')
], NoteAddEditComponent.prototype, "dueDatePicker", void 0);
NoteAddEditComponent = __decorate([
    Component({
        selector: 'note-add-edit',
        templateUrl: './note-add-edit.component.html',
        styleUrls: ['./note-add-edit.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], NoteAddEditComponent);
export { NoteAddEditComponent };
//# sourceMappingURL=note-add-edit.component.js.map