var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Input } from '@angular/core';
import { OperationType } from 'src/app/core/enums/common-enums';
import { LocationDto } from 'src/app/core/models/common/locationDto';
import { EntityName, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
let LocationRelatedListComponent = class LocationRelatedListComponent {
    constructor(router, sessionManager, geoLayerService) {
        this.router = router;
        this.sessionManager = sessionManager;
        this.geoLayerService = geoLayerService;
    }
    ngOnInit() {
        this.privateFields = GlobalFunctions.getAllowedDataRights(GlobalFunctions.toContentType(ContentType.Location), OperationType.PrivateField);
        if (GlobalFunctions.isValidToShowMap(this.privateFields))
            this.geoLayerService.plotGeoMap();
    }
    loadDetail() {
        const locationDto = new LocationDto();
        locationDto.Id = GlobalFunctions.getGuid();
        locationDto.Partial = false;
        if (GlobalFunctions.isValidToShowMap(this.privateFields)) {
            locationDto.GeoSeachCriteria = this.geoLayerService.getSearchCriteriaForGeo();
            locationDto.GeoCoordinatesCriteria = this.geoLayerService.getCoordinatesForGeo();
        }
        locationDto.StringRepresentation = !GlobalFunctions.isEmpty(locationDto.GeoSeachCriteria) ? locationDto.GeoSeachCriteria : locationDto.GeoCoordinatesCriteria;
        locationDto.locationUrl = `${RoutePath.DETAIL_PATH}/${EntityName.LOCATION}`;
        locationDto.RelatedEntityFqdn = 'Decos_Kcs_Locations_Entities_AddressableObjectMark';
        this.sessionManager.selectedEntity = locationDto;
        this.sessionManager.addBreadcrumbItems([locationDto], null, this.router.url);
        this.router.navigate([locationDto.locationUrl]);
    }
};
__decorate([
    Input()
], LocationRelatedListComponent.prototype, "type", void 0);
__decorate([
    Input()
], LocationRelatedListComponent.prototype, "relatedFor", void 0);
LocationRelatedListComponent = __decorate([
    Component({
        selector: 'location-related-list',
        templateUrl: './location-related-list.component.html',
        styleUrls: ['./location-related-list.component.scss']
    })
], LocationRelatedListComponent);
export { LocationRelatedListComponent };
//# sourceMappingURL=location-related-list.component.js.map