var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ContextMenuView } from 'src/app/core/enums/common-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu } from 'src/app/core/models/common/menu';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { BroadCastEventKeys } from '../../../../shared/constants';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDetailComponent } from '../../../common/base-detail.component';
let LinkDetailComponent = class LinkDetailComponent extends BaseDetailComponent {
    constructor(cacheManager, sessionManager, dialog, contextMenuService, linkService, eventProvider, integrationSettingManager, formatManager, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.dialog = dialog;
        this.contextMenuService = contextMenuService;
        this.linkService = linkService;
        this.eventProvider = eventProvider;
        this.integrationSettingManager = integrationSettingManager;
        this.formatManager = formatManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.fetchLinkDetailResponse = this.fetchLinkDetailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        this.loadLinkDetail();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    loadLinkDetail() {
        try {
            this.menu.addOrUpdateMenuItem(0, "LinkDetail", this.translateService.instant("LBL_QUICK_LINK"), false, true, true);
            this.addMenuItem.emit(this.menu);
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.Partial == true) {
                let partialDto = new Object();
                partialDto.Id = this.sessionManager.selectedEntity.Id;
                partialDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
                this.linkService.fetchDetail(partialDto, this.fetchLinkDetailResponse, null);
                this.startSpinner();
            }
            else {
                this.formatManager.setCreatedBy([this.sessionManager.selectedEntity]);
                this.sendRelatedRequest.emit();
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    fetchLinkDetailResponse(result) {
        this.stopSpinner();
        this.sessionManager.loadedFromRelatedView = false;
        if (result != null && result.LinkDto != null) {
            this.formatManager.setCreatedBy([result.LinkDto]);
            this.sessionManager.setBreadcrumbGrammer(result.LinkDto);
            this.sessionManager.selectedEntity = result.LinkDto;
            this.sendRelatedRequest.emit();
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL, this.sessionManager.selectedEntity);
        }
        else {
            let helpText = "";
            if (this.sessionManager.currentSession != null && this.sessionManager.currentSession.LoadingDetail) {
                this.sessionManager.currentSession.LoadingDetail = false;
                helpText = this.translateService.instant("LBL_LINK_NOT_FOUND_SESSION_MESSAGE");
            }
            else
                helpText = this.translateService.instant("LBL_LINK_NOT_FOUND_MESSAGE");
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_LINK_NOT_FOUND"), helpText, this.translateService.instant("LBL_QUICKLINK"));
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    openLink(url) {
        if (!GlobalFunctions.isEmpty(url))
            window.open(url, "_blank");
    }
};
LinkDetailComponent = __decorate([
    Component({
        selector: 'link-detail',
        templateUrl: './link-detail.component.html',
        styleUrls: ['./link-detail.component.scss']
    })
], LinkDetailComponent);
export { LinkDetailComponent };
//# sourceMappingURL=link-detail.component.js.map