var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { BroadCastEventKeys, RoutePath } from 'src/app/shared/constants';
import { SubSink } from 'subsink';
import { LinkDto } from '../../../..//core/models/link/linkDto';
import { MessageboxComponent } from '../../../../components/common/messagebox/messagebox.component';
import { RecordOperationMode, ScreenMode } from '../../../../core/enums/common-enums';
import { CreateOrUpdateLinkRequest } from '../../../../core/models/link/create-update-link-request';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { ManageLocalGroupPrivilegeComponent } from '../../../common/manage-local-group-privilege/manage-local-group-privilege.component';
let LinkAddEditComponent = class LinkAddEditComponent extends BaseDialogComponent {
    constructor(sessionManager, dialogManager, translateService, shortcutManager, linkService, userService, dialog, router, eventProvider, formatManager, cacheManager) {
        super();
        this.sessionManager = sessionManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.shortcutManager = shortcutManager;
        this.linkService = linkService;
        this.userService = userService;
        this.dialog = dialog;
        this.router = router;
        this.eventProvider = eventProvider;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.linkDto = new LinkDto();
        this.title = "";
        this.isLocalGroupEnabled = false;
        this.localUserGroups = [];
        this.editMode = false;
        this.linkSessionData = null;
        this.subs = new SubSink();
        this.addLinkResponse = this.addLinkResponse.bind(this);
        this.sessionManager.startSessionIfPossible("link", sessionManager.jkcParentPanel.parameters.EditMode ? ScreenMode.Edit : ScreenMode.Add);
        if (sessionManager.jkcParentPanel.parameters.IsChildPanel) {
            this.editMode = sessionManager.jkcChildPanel.parameters.EditMode;
            this.linkSessionData = sessionManager.jkcChildPanel.parameters.EditedData;
            sessionManager.jkcChildPanel.parameters.Scope = this;
        }
        else {
            this.editMode = sessionManager.jkcParentPanel.parameters.EditMode;
            this.linkSessionData = sessionManager.jkcParentPanel.parameters.EditedData;
            sessionManager.jkcParentPanel.parameters.Scope = this;
        }
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ;
    ngOnInit() {
        this.init();
        this.initLocalGroups();
    }
    ;
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    init() {
        try {
            if (this.editMode) {
                this.linkDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
                this.title = this.translateService.instant("LBL_EDIT_LINK").toUpperCase();
            }
            else {
                this.title = this.translateService.instant("LBL_ADD_LINK").toUpperCase();
                if (this.linkSessionData != null)
                    this.assignLinkSessionToDto(this.linkSessionData);
            }
            this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.createLink());
            this.resize();
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ;
    assignLinkSessionToDto(sessionData) {
        this.linkDto.Title = sessionData.Title;
        this.linkDto.Url = sessionData.Url;
        this.linkDto.Description = sessionData.Description;
    }
    ;
    createLink() {
        if (this.form.invalid)
            return;
        if (GlobalFunctions.isEmpty(this.linkDto.Id))
            this.linkDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        this.linkDto.LastChangedDate = new Date();
        this.linkDto.StringRepresentation = "";
        this.sessionManager.setBreadcrumbGrammer(this.linkDto);
        this.startSpinner();
        let req = new CreateOrUpdateLinkRequest();
        req.Mode = this.editMode ? RecordOperationMode.Edit : RecordOperationMode.New;
        req.LinkDto = this.linkDto;
        this.linkService.createLink(req, this.addLinkResponse, this.addLinkErrorCallback);
    }
    ;
    addLinkResponse(response) {
        this.stopSpinner();
        if (response != null && response.Result == 0 && response.LinkDto != null) {
            let newLinkDto = response.LinkDto;
            this.formatManager.setCreatedBy([newLinkDto]);
            this.close(false);
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = newLinkDto;
            this.sessionManager.selectedEntity.ObjectSource = newLinkDto.ObjectSource;
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/link`;
            if (this.editMode) {
                let selectedIndex = 0;
                this.sessionManager.BreadcrumbItems.splice(selectedIndex, 1);
                this.cacheManager.updateDashboardCache(response.LinkDto);
                this.sessionManager.addBreadcrumbItems([newLinkDto], null, RoutePath.DETAIL_PATH);
            }
            else
                this.sessionManager.addBreadcrumbItems([newLinkDto], null, RoutePath.DETAIL_PATH);
            this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
        }
        else
            this.showMessageBox(this.translateService.instant('LBL_LINK'), this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_LINK"));
    }
    ;
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close(false);
    }
    ;
    addLinkErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_CREATE_ERROLBL_ADD_ERROR_MSGR_MSG"), [this.translateService.instant("LBL_LINK")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_LINK"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    ;
    showMessageBox(header, message) {
        let messageInfo = DialogHelper.getMessage(header, message, true, null, null, null, null, this.translateService);
        return DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
    }
    ;
    manageLocalGroupPrivilege() {
        DialogHelper.openDialog(this.dialog, ManageLocalGroupPrivilegeComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { localUserGroups: this.localUserGroups, privilegedGroupIds: this.linkDto.ManageLocalGroupPrivilege }).afterClosed().subscribe(privilegedGroupIds => {
            if (!GlobalFunctions.isEmpty(privilegedGroupIds))
                this.linkDto.ManageLocalGroupPrivilege = privilegedGroupIds;
        });
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel?.parameters?.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#addLinkHeader").height() - $("#addLinkFooter").height() + "px";
        $("#addLinkContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    ;
    initLocalGroups() {
        this.localUserGroups = this.userService.getNativeUsergroupList();
        this.isLocalGroupEnabled = this.localUserGroups.length > 0 ? true : false;
    }
    ;
    close(result) {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel?.parameters?.CallbackMethod) && !GlobalFunctions.isEmpty(this.linkDto))
            this.sessionManager.jkcParentPanel?.parameters?.CallbackMethod(this.linkDto);
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
    ;
};
__decorate([
    ViewChild('form')
], LinkAddEditComponent.prototype, "form", void 0);
LinkAddEditComponent = __decorate([
    Component({
        selector: 'link-add-edit',
        templateUrl: './link-add-edit.component.html',
        styleUrls: ['./link-add-edit.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], LinkAddEditComponent);
export { LinkAddEditComponent };
//# sourceMappingURL=link-add-edit.component.js.map