var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ContextMenuView } from 'src/app/core/enums/common-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu } from 'src/app/core/models/common/menu';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { BroadCastEventKeys } from '../../../../shared/constants';
import { BaseDetailComponent } from '../../../common/base-detail.component';
let IssueDetailComponent = class IssueDetailComponent extends BaseDetailComponent {
    constructor(cacheManager, sessionManager, contextMenuService, integrationSettingManager, eventProvider, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.contextMenuService = contextMenuService;
        this.integrationSettingManager = integrationSettingManager;
        this.eventProvider = eventProvider;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.url = '';
        this.timeoutIds = [];
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        try {
            this.menu.addOrUpdateMenuItem(0, "IssueDetail", this.translateService.instant("LBL_ISSUE"), false, true, true, true, false, null);
            this.addMenuItem.emit(this.menu);
            let detailQuery = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Issues_Entities_Issue, "DETAILQUERY");
            let appUrl = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Issues_Entities_Issue, "APPURL");
            if (!GlobalFunctions.isEmpty(detailQuery) && !GlobalFunctions.isEmpty(appUrl))
                this.url = appUrl + detailQuery + this.sessionManager.selectedEntity.Id;
            this.sendRelatedRequest.emit();
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ;
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    resize() {
        $("#frame").height($(window).height() - 126 + "px");
    }
    ;
};
IssueDetailComponent = __decorate([
    Component({
        selector: 'issue-detail',
        templateUrl: './issue-detail.component.html',
        styleUrls: ['./issue-detail.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], IssueDetailComponent);
export { IssueDetailComponent };
;
//# sourceMappingURL=issue-detail.component.js.map