var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, HostListener } from '@angular/core';
import { ScreenMode } from 'src/app/core/enums/common-enums';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { MessageboxComponent } from 'src/app/components/common/messagebox/messagebox.component';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { PersonFormattedAddressPipe } from '../../../../shared/pipes/person-formated-address.pipe';
import { OrganizationFormattedAddressPipe } from '../../../../shared/pipes/organization-formated-address.pipe';
import { BroadCastEventKeys } from 'src/app/shared/constants';
import { SubSink } from 'subsink';
let IssueAddComponent = class IssueAddComponent extends BaseDialogComponent {
    constructor(dialogManager, sessionManager, dialog, translateService, issueService, integrationSettingManager, applicationSettingManager, eventProvider) {
        super();
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.dialog = dialog;
        this.translateService = translateService;
        this.issueService = issueService;
        this.integrationSettingManager = integrationSettingManager;
        this.applicationSettingManager = applicationSettingManager;
        this.eventProvider = eventProvider;
        this.title = this.translateService.instant('LBL_ADD_ISSUE').toUpperCase();
        this.emailAddress = "";
        this.address = "";
        this.phoneNumber = "";
        this.customer = "";
        this.subs = new SubSink();
        this.timeoutIds = [];
        this.sessionManager.startSessionIfPossible("issue", sessionManager.jkcParentPanel.parameters.EditMode ? ScreenMode.Edit : ScreenMode.Add);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        this.init();
    }
    ;
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    ngAfterViewInit() {
        this.resize();
    }
    ;
    init() {
        try {
            let appUrl = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Issues_Entities_Issue, "APPURL");
            let addQuery = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Issues_Entities_Issue, "ADDQUERY");
            ;
            if (this.sessionManager.selectedEntity != null && (this.sessionManager.selectedEntity.RelatedEntityFqdn == EntityFqdn[EntityFqdn.Decos_Kcs_Persons_Entities_Person] || this.sessionManager.selectedEntity.RelatedEntityFqdn == EntityFqdn[EntityFqdn.Decos_Kcs_Organizations_Entities_Organization])) {
                if (this.sessionManager.selectedEntity.RelatedEntityFqdn == EntityFqdn[EntityFqdn.Decos_Kcs_Persons_Entities_Person]) {
                    let selectedPerson = { ...this.sessionManager.selectedEntity };
                    if (!GlobalFunctions.isPrivateField("EMAILADDRESS", ContentType.Person))
                        this.emailAddress = selectedPerson.EmailAddress;
                    let grammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_Issue");
                    GlobalFunctions.setStringPresentation(selectedPerson, grammerValue);
                    this.customer = selectedPerson.StringRepresentation;
                    this.address = new PersonFormattedAddressPipe(this.translateService).transform(selectedPerson, false);
                    if (!GlobalFunctions.isEmpty(this.sessionManager.currentCallerId) && this.sessionManager.currentCallerId.length >= 10)
                        this.phoneNumber = this.sessionManager.currentCallerId;
                    else if (!GlobalFunctions.isEmpty(selectedPerson.MobileNumber) && !GlobalFunctions.isPrivateField("MOBILENUMBER", ContentType.Person))
                        this.phoneNumber = selectedPerson.MobileNumber;
                    else if (!GlobalFunctions.isEmpty(selectedPerson.PhoneNumber) && !GlobalFunctions.isPrivateField("PHONENUMBER", ContentType.Person))
                        this.phoneNumber = selectedPerson.PhoneNumber;
                }
                else {
                    if (!GlobalFunctions.isPrivateField("EMAILADDRESS", ContentType.Organization))
                        this.emailAddress = this.sessionManager.selectedEntity.EmailAddress;
                    this.customer = this.sessionManager.selectedEntity.Name;
                    this.address = new OrganizationFormattedAddressPipe(this.translateService).transform(this.sessionManager.selectedEntity, false);
                    if (!GlobalFunctions.isEmpty(this.sessionManager.currentCallerId) && this.sessionManager.currentCallerId.length >= 10)
                        this.phoneNumber = this.sessionManager.currentCallerId;
                    else if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.PhoneNumber) && !GlobalFunctions.isPrivateField("PHONENUMBER", ContentType.Organization))
                        this.phoneNumber = this.sessionManager.selectedEntity.PhoneNumber;
                }
                addQuery = addQuery.replace("{{PERSON}}", this.customer);
                addQuery = addQuery.replace("{{EMAIL}}", GlobalFunctions.isEmpty(this.emailAddress) ? "" : this.emailAddress);
                addQuery = addQuery.replace("{{PHONENUMBER}}", GlobalFunctions.isEmpty(this.phoneNumber) ? "" : encodeURIComponent(this.phoneNumber));
                addQuery = addQuery.replace("{{ADDRESS}}", this.address == this.translateService.instant("LBL_NO_ADDRESS_FOUND") ? "" : this.address);
            }
            else {
                addQuery = addQuery.replace("{{PERSON}}", "");
                addQuery = addQuery.replace("{{EMAIL}}", "");
                addQuery = addQuery.replace("{{PHONENUMBER}}", "");
                addQuery = addQuery.replace("{{ADDRESS}}", "");
            }
            if (!GlobalFunctions.isEmpty(appUrl))
                this.url = appUrl + addQuery;
            else {
                let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_ISSUE"), this.translateService.instant("LBL_FIXI_APPURL_NOT_CONFIGURE"), true, null, null, null, null, this.translateService);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
                this.dialogManager.removeComponent();
                this.sessionManager.closeJkcParentPanel();
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ;
    fetchResultFoundCallback(result) {
        if (result != null)
            this.sessionManager.addEntityToSession(result, "Issue");
    }
    ;
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.timeoutIds.push(setTimeout(() => { this.close(false); }, 10));
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel.parameters.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#addIssueHeader").height() + "px";
        $("#addIssueContainer").height(newHeight);
        $("#fixiFrame").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    close(result) {
        if (!GlobalFunctions.isEmpty(this.emailAddress))
            this.issueService.fetchDetailRequest(this.emailAddress, this.fetchResultFoundCallback);
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
    onKeydownHandler(event) {
        if (event.key === "Escape") {
            this.close(true);
        }
    }
};
__decorate([
    HostListener('document:keydown', ['$event'])
], IssueAddComponent.prototype, "onKeydownHandler", null);
IssueAddComponent = __decorate([
    Component({
        selector: 'issue-add',
        templateUrl: './issue-add.component.html',
        styleUrls: ['./issue-add.component.scss'],
        host: { '(window:resize)': 'resize();' }
    })
], IssueAddComponent);
export { IssueAddComponent };
//# sourceMappingURL=issue-add.component.js.map