var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { AttachmentType } from 'src/app/core/enums/files-enum';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { SubSink } from 'subsink';
import { BaseViewerComponent } from '../../../common/base-viewer.component';
let FileViewerComponent = class FileViewerComponent extends BaseViewerComponent {
    constructor(cacheManager, sessionManager, dialogManager, dialog, translateService, downloadService, phoneManager) {
        super(phoneManager, dialogManager, translateService);
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.dialogManager = dialogManager;
        this.dialog = dialog;
        this.translateService = translateService;
        this.downloadService = downloadService;
        this.phoneManager = phoneManager;
        this.subs = new SubSink();
    }
    ;
    ngOnInit() {
        this.setCreateByName();
    }
    ;
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    setCreateByName() {
        if (!GlobalFunctions.isEmpty(this.selectedViewerEntity.CreatedById) && GlobalFunctions.isEmpty(this.selectedViewerEntity.CreatedBy)) {
            let employee = this.cacheManager.getEmployeeById(this.selectedViewerEntity.CreatedById);
            if (employee != null)
                this.selectedViewerEntity.CreatedBy = employee.StringRepresentation;
        }
    }
    ;
    downloadFile(file) {
        if (!GlobalFunctions.isEmpty(file.TicketId))
            this.subs.sink = this.downloadService.downloadFile(file.TicketId).subscribe(res => GlobalFunctions.downloadFileAsBlob(res));
        else {
            let helpText = "";
            if (file.AttachmentType == AttachmentType.Upload)
                helpText = this.translateService.instant("LBL_FILE_ENTITY_NOT_FOUND_MESSAGE");
            else
                helpText = this.translateService.instant("LBL_FILE_ENTITY_LINK_NOT_FOUND_MESSAGE");
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_FILE_ENTITY_NOT_FOUND"), helpText, this.translateService.instant("LBL_FILE_ENTITY"));
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    ;
};
FileViewerComponent = __decorate([
    Component({
        selector: 'file-viewer',
        templateUrl: './file-viewer.component.html',
        styleUrls: ['./file-viewer.component.scss']
    })
], FileViewerComponent);
export { FileViewerComponent };
//# sourceMappingURL=file-viewer.component.js.map