var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseRelatedListComponent } from '../../../common/base-related-list.component';
let FileRelatedListComponent = class FileRelatedListComponent extends BaseRelatedListComponent {
    constructor(sessionManager, fileService, emailService, documentService, translateService, dialog, cacheManager, downloadService, activatedRoute, applicationSettingManager, eventProvider, dialogManager, router, phoneManager) {
        super(translateService, activatedRoute, sessionManager, eventProvider, dialogManager, applicationSettingManager, router, phoneManager);
        this.sessionManager = sessionManager;
        this.fileService = fileService;
        this.emailService = emailService;
        this.documentService = documentService;
        this.translateService = translateService;
        this.dialog = dialog;
        this.cacheManager = cacheManager;
        this.downloadService = downloadService;
        this.activatedRoute = activatedRoute;
        this.applicationSettingManager = applicationSettingManager;
        this.eventProvider = eventProvider;
        this.dialogManager = dialogManager;
        this.router = router;
        this.phoneManager = phoneManager;
        this.downloadFileDocumentResponse = this.downloadFileDocumentResponse.bind(this);
    }
    ;
    ngOnInit() {
        this.setCreateByName();
        super.ngOnInit();
    }
    ;
    downloadFileDocument(file) {
        if (file.IsExist) {
            if (file.ObjectSource.toUpperCase().indexOf("DECOS.KCS.DOCUMENTS") != -1)
                this.documentService.downloadFileDocument(file, this.downloadFileDocumentResponse);
            else if (file.ObjectSource.toUpperCase().indexOf("DECOS.KCS.EMAIL") != -1)
                this.emailService.downloadFileDocument(file, this.downloadFileDocumentResponse);
            else if (file.ObjectSource.toUpperCase().indexOf("DECOS.KCS.FILES") != -1)
                this.fileService.downloadFile(file, this.downloadFileDocumentResponse);
            this.startSpinner();
        }
        else {
            this.stopSpinner();
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_FILE_ENTITY_NOT_FOUND"), this.translateService.instant("LBL_FILE_ENTITY_LINK_NOT_FOUND_MESSAGE"), this.translateService.instant("LBL_FILE_ENTITY"));
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    ;
    downloadFileDocumentResponse(message) {
        this.stopSpinner();
        if (!GlobalFunctions.isEmpty(message.TicketId))
            this.subs.sink = this.downloadService.downloadFile(message.TicketId).subscribe(res => GlobalFunctions.downloadFileAsBlob(res));
        else {
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_FILE_ENTITY_NOT_FOUND"), this.translateService.instant("LBL_FILE_ENTITY_LINK_NOT_FOUND_MESSAGE"), this.translateService.instant("LBL_FILE_ENTITY"));
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    ;
    setCreateByName() {
        for (let index = 0; index < this.relatedResultList.length; index++) {
            if (!GlobalFunctions.isEmpty(this.relatedResultList[index].CreatedById) && GlobalFunctions.isEmpty(this.relatedResultList[index].CreatedBy)) {
                let employee = this.cacheManager.getEmployeeById(this.relatedResultList[index].CreatedById);
                if (employee != null)
                    this.relatedResultList[index].CreatedBy = employee.StringRepresentation;
            }
        }
    }
    ;
};
FileRelatedListComponent = __decorate([
    Component({
        selector: 'file-related-list',
        templateUrl: './file-related-list.component.html',
        styleUrls: ['./file-related-list.component.scss']
    })
], FileRelatedListComponent);
export { FileRelatedListComponent };
//# sourceMappingURL=file-related-list.component.js.map