var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ContextMenuView } from 'src/app/core/enums/common-enums';
import { AttachmentType } from 'src/app/core/enums/files-enum';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu } from 'src/app/core/models/common/menu';
import { RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { BroadCastEventKeys } from '../../../../shared/constants';
import { BaseDetailComponent } from '../../../common/base-detail.component';
let FileDetailComponent = class FileDetailComponent extends BaseDetailComponent {
    constructor(cacheManager, sessionManager, dialog, contextMenuService, fileService, downloadService, formatManager, router, eventProvider, integrationSettingManager, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.dialog = dialog;
        this.contextMenuService = contextMenuService;
        this.fileService = fileService;
        this.downloadService = downloadService;
        this.formatManager = formatManager;
        this.router = router;
        this.eventProvider = eventProvider;
        this.integrationSettingManager = integrationSettingManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.fetchFileDetailResponse = this.fetchFileDetailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        this.loadFileDetail();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    loadFileDetail() {
        try {
            this.menu.addOrUpdateMenuItem(0, "FileEntityDetail", this.translateService.instant("LBL_FILE_ENTITY"), false, true, true);
            this.addMenuItem.emit(this.menu);
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.Partial == true) {
                let partialDto = new Object();
                partialDto.Id = this.sessionManager.selectedEntity.Id;
                partialDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
                this.fileService.fetchDetail(partialDto, this.fetchFileDetailResponse, null);
                this.startSpinner();
            }
            else {
                this.sendRelatedRequest.emit();
                if (GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.CreatedBy))
                    this.formatManager.setCreatedBy([this.sessionManager.selectedEntity]);
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    fetchFileDetailResponse(result) {
        this.stopSpinner();
        this.sessionManager.loadedFromRelatedView = false;
        if (result != null) {
            this.formatManager.setCreatedBy([result]);
            this.sessionManager.setBreadcrumbGrammer(result);
            this.sessionManager.selectedEntity = result;
            this.sendRelatedRequest.emit();
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL, this.sessionManager.selectedEntity);
        }
        else {
            let helpText = "";
            if (this.sessionManager.currentSession != null && this.sessionManager.currentSession.LoadingDetail) {
                this.sessionManager.currentSession.LoadingDetail = false;
                helpText = this.translateService.instant("LBL_FILE_ENTITY_NOT_FOUND_SESSION_MESSAGE");
            }
            else
                helpText = this.translateService.instant("LBL_FILE_ENTITY_NOT_FOUND_MESSAGE");
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_FILE_ENTITY_NOT_FOUND"), helpText, this.translateService.instant("LBL_FILE_ENTITY"));
            ExceptionHelper.showException(this.dialog, exception, true);
            this.router.navigate([RoutePath.DASHBOARD]);
        }
    }
    downloadFile(file) {
        if (!GlobalFunctions.isEmpty(file.TicketId))
            this.subs.sink = this.downloadService.downloadFile(file.TicketId).subscribe(res => GlobalFunctions.downloadFileAsBlob(res));
        else {
            let helpText = "";
            if (file.AttachmentType == AttachmentType.Upload)
                helpText = this.translateService.instant("LBL_FILE_ENTITY_NOT_FOUND_MESSAGE");
            else
                helpText = this.translateService.instant("LBL_FILE_ENTITY_LINK_NOT_FOUND_MESSAGE");
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_FILE_ENTITY_NOT_FOUND"), helpText, this.translateService.instant("LBL_FILE_ENTITY"));
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
};
FileDetailComponent = __decorate([
    Component({
        selector: 'file-detail',
        templateUrl: './file-detail.component.html',
        styleUrls: ['./file-detail.component.scss']
    })
], FileDetailComponent);
export { FileDetailComponent };
//# sourceMappingURL=file-detail.component.js.map