var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { EmployeeCalendarComponent } from 'src/app/components/domain/employee/employee-calendar-component';
import { OperationType } from 'src/app/core/enums/common-enums';
import { ContentType } from 'src/app/core/models/jkc-object/jkc-object';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { RoutePath } from '../../../../shared/constants';
let EmployeeViewerComponent = class EmployeeViewerComponent extends EmployeeCalendarComponent {
    constructor(translateService, dialogManager, phoneManager, phoneService, applicationFeatureManager, availabilityService, availibilityRuleService, applicationSettingManager, cacheManager, sessionManager, employeeService, userSettingManager, systemComponentService, router, eventProvider) {
        super(phoneManager, phoneService, dialogManager, eventProvider, sessionManager, employeeService, translateService, userSettingManager, systemComponentService, availibilityRuleService);
        this.translateService = translateService;
        this.dialogManager = dialogManager;
        this.phoneManager = phoneManager;
        this.phoneService = phoneService;
        this.applicationFeatureManager = applicationFeatureManager;
        this.availabilityService = availabilityService;
        this.availibilityRuleService = availibilityRuleService;
        this.applicationSettingManager = applicationSettingManager;
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.employeeService = employeeService;
        this.userSettingManager = userSettingManager;
        this.systemComponentService = systemComponentService;
        this.router = router;
        this.eventProvider = eventProvider;
        this.onItemSelect = new EventEmitter();
        this.isAvailabilityCdrEnabled = false;
        this.isExtraInfoEnabled = false;
    }
    ngOnInit() {
        try {
            this.calendarContentHeight = 400;
            this.phoneState = this.phoneManager.phoneState;
            this.employeePrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Employee, OperationType.PrivateField);
            this.isAvailabilityCdrEnabled = this.applicationSettingManager.isAvailabilityCdrEnabled();
            this.isExtraInfoEnabled = GlobalFunctions.hasRight(GlobalFunctions.toContentType("EMPLOYEE"), OperationType.CanViewEmployeeExtraInfo);
            if (!GlobalFunctions.isEmpty(this.selectedViewerEntity) && this.selectedViewerEntity.Partial) {
                this.selectedViewerEntity = this.cacheManager.getEmployeeById(this.selectedViewerEntity.Id);
                this.router.navigate([RoutePath.DASHBOARD]);
            }
            this.availabilityService.getAvailabilityByKey(this.selectedViewerEntity.EmailAddress.toLowerCase(), this.completedAvailabilityFetchByKey);
            if (this.phoneManager.phoneState.IsPhoneFeatureEnabled)
                this.phoneStatusInfo.ExtensionFontColor = 'blueFontColor';
            if (this.applicationFeatureManager.isPhoneStatusEnabled) {
                this.phoneStatusInfo.IsPhoneStatusEnabled = this.applicationFeatureManager.isPhoneStatusEnabled;
                this.getSelectedEmployeePhoneStatus(this.selectedViewerEntity.Id, this.selectedViewerEntity.ExtensionNumber);
            }
            super.ngOnInit(this.selectedViewerEntity);
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    transferCall(phoneNumber, name, picture, transferType, employeeId = null, transferSession = false) {
        this.phoneManager.transferCall(phoneNumber, name, picture, transferType, employeeId, transferSession);
    }
    ;
};
__decorate([
    Input()
], EmployeeViewerComponent.prototype, "selectedViewerEntity", void 0);
__decorate([
    Input()
], EmployeeViewerComponent.prototype, "relatedFor", void 0);
__decorate([
    Output()
], EmployeeViewerComponent.prototype, "onItemSelect", void 0);
EmployeeViewerComponent = __decorate([
    Component({
        selector: 'employee-viewer',
        templateUrl: './employee-viewer.component.html',
        styleUrls: ['./employee-viewer.component.scss']
    })
], EmployeeViewerComponent);
export { EmployeeViewerComponent };
//# sourceMappingURL=employee-viewer.component.js.map