var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { OperationType } from '../../../../core/enums/common-enums';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { EmployeeCalendarComponent } from '../employee-calendar-component';
let EmployeePopupComponent = class EmployeePopupComponent extends EmployeeCalendarComponent {
    constructor(employee, dialogRef, dialogManager, translateService, phoneManager, phoneService, availibilityService, userSettingManager, availibilityRuleService, systemComponentService, applicationSettingManager, sessionManager, employeeService, eventProvider) {
        super(phoneManager, phoneService, dialogManager, eventProvider, sessionManager, employeeService, translateService, userSettingManager, systemComponentService, availibilityRuleService);
        this.employee = employee;
        this.dialogRef = dialogRef;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.phoneManager = phoneManager;
        this.phoneService = phoneService;
        this.availibilityService = availibilityService;
        this.userSettingManager = userSettingManager;
        this.availibilityRuleService = availibilityRuleService;
        this.systemComponentService = systemComponentService;
        this.applicationSettingManager = applicationSettingManager;
        this.sessionManager = sessionManager;
        this.employeeService = employeeService;
        this.eventProvider = eventProvider;
        this.phoneState = this.phoneManager.phoneState;
        this.isAvailabilityCdrEnabled = this.applicationSettingManager.isAvailabilityCdrEnabled();
        this.employeePrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Employee, OperationType.PrivateField);
        this.isExtraInfoEnabled = GlobalFunctions.hasRight(GlobalFunctions.toContentType("EMPLOYEE"), OperationType.CanViewEmployeeExtraInfo);
        this.completedAvailabilityFetchByKey = this.completedAvailabilityFetchByKey.bind(this);
    }
    ngOnInit() {
        try {
            if (this.employee?.EmailAddress)
                this.availibilityService.getAvailabilityByKey(this.employee.EmailAddress.toLowerCase(), this.completedAvailabilityFetchByKey);
            if (this.employee && (!this.employee.PictureData || (this.employee.PictureData != 'assets/images/nophoto.png' && this.employee.PictureData.indexOf('DownloadFile') < 0)))
                this.employeeService.setEmployeePicture([this.employee]);
            super.ngOnInit(this.employee);
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    completedAvailabilityFetchByKey(valueData) {
        if (valueData?.length > 0)
            this.employee.AvailabilityStatusInfo = this.availibilityRuleService.getAvailabilityStatusInfo(valueData);
    }
    ;
    close(emailId, targetButton) {
        let option = new Object();
        option.emailId = emailId;
        option.targetButton = targetButton;
        this.dialogRef.close(option);
    }
    ;
    placeCall(phoneNumber, name, picture, id = null) {
        if (this.phoneManager.phoneState.IsPhoneFeatureEnabled) {
            this.dialogRef.close();
            this.phoneManager.placeCall(phoneNumber, name, picture, id);
        }
    }
    ;
    transferCall(phoneNumber, name, picture, transferType, employeeId = null, transferSession = false) {
        this.phoneManager.transferCall(phoneNumber, name, picture, transferType, employeeId, transferSession);
    }
    ;
    loadSendEmailDialog(emailId) {
        if (!GlobalFunctions.checkRights('Email'))
            return;
        this.close(emailId, "SEND_EMAIL");
    }
    ;
};
EmployeePopupComponent = __decorate([
    Component({
        selector: 'employee-popup',
        templateUrl: './employee-popup.component.html',
        styleUrls: ['./employee-popup.component.scss']
    }),
    __param(0, Inject(MAT_DIALOG_DATA))
], EmployeePopupComponent);
export { EmployeePopupComponent };
//# sourceMappingURL=employee-popup.component.js.map