var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseSearchResultComponent } from '../../../../common/base-search-result.component';
import { OperationType } from '../../../../../core/enums/common-enums';
import { ContentType, SourceType } from '../../../../../core/models/jkc-object/jkc-object';
import { BroadCastEventKeys } from '../../../../../shared/constants';
import { GlobalFunctions } from '../../../../../shared/global-functions';
let PopularNumberSearchResultComponent = class PopularNumberSearchResultComponent extends BaseSearchResultComponent {
    constructor(router, translateService, sessionManager, applicationSettingManager, sortManager, changeDetectorRef, activatedRoute, eventProvider, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService, localSearchResultDataService, employeeFilterPipe) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.router = router;
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.applicationSettingManager = applicationSettingManager;
        this.sortManager = sortManager;
        this.changeDetectorRef = changeDetectorRef;
        this.activatedRoute = activatedRoute;
        this.eventProvider = eventProvider;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.searchService = searchService;
        this.localSearchResultDataService = localSearchResultDataService;
        this.employeeFilterPipe = employeeFilterPipe;
        this.employeePrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Employee, OperationType.PrivateField);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = "employee";
        try {
            if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && (this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == this.type.toLowerCase() || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "advanced")) {
                this.sourceCount = 0;
                this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
                this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
                this.localSearchResultDataService.localSearchResultData.localResult = [];
                this.localSearchResultDataService.localSearchResultData.contentType = "";
            }
            else {
                this.resultCount = 0;
                this.resultList = [];
                this.filteredSearchResult = [];
                this.searchStatusMessage = '';
                this.searchPopular();
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    searchPopular() {
        // this.updateSearchStatus(this.activeHandlersObj);
        let updateSearchStatus = new Object();
        updateSearchStatus.ActiveHandlers = [];
        updateSearchStatus.ActiveHandlers.push("Employee");
        this.updateSearchStatus(updateSearchStatus);
        let popularEmployeeList = this.cacheManager.getPopularEmployeeList();
        if (!GlobalFunctions.isEmpty(popularEmployeeList) && popularEmployeeList.length > 0) {
            var result = this.employeeFilterPipe.transform(popularEmployeeList, this.searchStatusQuery);
            for (var i = 0; i < result.length; i++) {
                result[i].RelatedEntityFqdn = "Decos_Kcs_Employees_Entities_PopularNumber";
                result[i].ObjectSource = SourceType.Employee_Native;
            }
            this.searchResultFound(result);
        }
        updateSearchStatus.ActiveHandlers = [];
        this.updateSearchStatus(updateSearchStatus);
    }
};
PopularNumberSearchResultComponent = __decorate([
    Component({
        selector: 'popularnumber-search-result',
        templateUrl: './popularnumber-search-result.component.html',
        styleUrls: ['./popularnumber-search-result.component.scss']
    })
], PopularNumberSearchResultComponent);
export { PopularNumberSearchResultComponent };
//# sourceMappingURL=popularnumber-search-result.component.js.map