var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { cloneDeep } from "lodash";
import { TaskHandlerType } from '../../../../core/enums/task-enum';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { BooleanHelper } from '../../../../shared/helper/boolean-helper';
let EmployeeAgendaComponent = class EmployeeAgendaComponent {
    constructor(dialogRef, cacheManager, sessionManager, employeeService, translateService, userSettingManager, searchServive, datePipe) {
        this.dialogRef = dialogRef;
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.userSettingManager = userSettingManager;
        this.searchServive = searchServive;
        this.datePipe = datePipe;
        this.dateJS = Date;
        this.calendarWeekView = BooleanHelper.stringToBoolean(this.userSettingManager.getUserSettingValueByKey("CalendarWeekView"));
        this.calendarContentHeight = 500;
        this.calendarOptions = {
            allDayText: this.translateService.instant("LBL_ALL_DAY"),
            allDaySlot: false,
            contentHeight: this.calendarContentHeight,
            dayHeaders: this.calendarWeekView,
            dayHeaderFormat: 'D/M dddd',
            headerToolbar: false,
            initialView: this.calendarWeekView ? 'timeGridWeek' : 'timeGridDay',
            locale: this.translateService.currentLang,
            plugins: GlobalFunctions.getFullCalendarPlugins(),
            scrollTime: new this.dateJS().toString('HH:mm:ss'),
            slotDuration: '00:15:00',
            slotEventOverlap: false,
            slotLabelFormat: 'HH:mm',
            timeZone: 'local',
            weekends: !this.calendarWeekView
        };
        this.taskHandler = null;
        this.enableDurationBox = true;
        this.enableWorkweek = false;
        this.currentDate = new Date();
        this.currentHandlerName = '';
        this.dropdownSlots = [
            { slotLength: 15, slotTime: '15 ' + this.translateService.instant('LBL_MINUTES') },
            { slotLength: 30, slotTime: '30 ' + this.translateService.instant('LBL_MINUTES') },
            { slotLength: 45, slotTime: '45 ' + this.translateService.instant('LBL_MINUTES') },
            { slotLength: 60, slotTime: '1 ' + this.translateService.instant('LBL_HOUR') },
            { slotLength: 120, slotTime: '2 ' + this.translateService.instant('LBL_HOURS') }
        ];
        this.priorities = [
            { priorityValue: 1, priorityText: this.translateService.instant('LBL_LOW') },
            { priorityValue: 2, priorityText: this.translateService.instant('LBL_MEDIUM') },
            { priorityValue: 3, priorityText: this.translateService.instant('LBL_HIGH') }
        ];
        this.priorityValue = 2;
        this.slotLength = 15;
        this.agendaItems = [];
        this.timeoutIds = [];
        this._currentAvailability = [];
        this._selectedDateFromPicker = new Date();
        this.dateClass = (cellDate, view) => {
            const day = cellDate.getDate();
            this.timeoutIds.push(setTimeout(() => GlobalFunctions.formatDaysWithLeadingZeros()));
            if (!GlobalFunctions.isEmpty(view) && view.toLowerCase() == 'month')
                return (day >= 1 && day <= 9) ? 'custom-cell' : '';
        };
        this.searchAgendaFound = this.searchAgendaFound.bind(this);
        this.selectedSlotCallback = this.selectedSlotCallback.bind(this);
    }
    get currentAvailability() {
        return this._currentAvailability;
    }
    set currentAvailability(currentAvailability) {
        this._currentAvailability = currentAvailability;
        this.refreshCalendar();
    }
    ;
    get selectedDateFromPicker() {
        return this._selectedDateFromPicker;
    }
    set selectedDateFromPicker(selectedDateFromPicker) {
        this._selectedDateFromPicker = selectedDateFromPicker;
        this.timeoutIds.push(setTimeout(() => GlobalFunctions.setDateFormat('selectDatePicker', selectedDateFromPicker, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe)));
        this.dateChanged();
    }
    ;
    ngOnInit() {
        try {
            this.enableWorkweek = this.calendarWeekView;
            this.calendarOptions.selectAllow = this.selectedSlotCallback.bind(this);
            if (this.sessionManager != null && this.sessionManager.selectedEntity != null && this.sessionManager.selectedEntity.TaskHistoryList != null && this.sessionManager.selectedEntity.TaskHistoryList.length > 0) {
                let taskHandlerList = this.sessionManager.selectedEntity.TaskHistoryList[0].TaskHandlerList;
                if (taskHandlerList != null && taskHandlerList.length > 0) {
                    let taskHandler = taskHandlerList[0];
                    if (taskHandler != null) {
                        if (!GlobalFunctions.isEmpty(taskHandler.HandlerType) && (taskHandler.HandlerType == TaskHandlerType.Employee || taskHandler.HandlerType == 'Employee'))
                            this.taskHandler = this.cacheManager.getEmployeeById(taskHandler.HandlerId);
                    }
                }
            }
            this.searchAgenda(this.taskHandler);
        }
        catch (e) {
            console.error(e);
        }
    }
    ngAfterViewInit() {
        this.timeoutIds.push(setTimeout(() => this.refreshCalendar(), 100));
    }
    ngOnDestroy() {
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    disableWeekendDates(date, mode) {
        return mode === 'day' && (date.getDay() === 0 || date.getDay() === 6);
    }
    ;
    dateChanged() {
        if (this.selectedDateFromPicker) {
            let dtNow = new Date();
            this.currentDate = this.selectedDateFromPicker;
            this.currentDate.setHours(dtNow.getHours());
            this.currentDate.setMinutes(dtNow.getMinutes());
            if (this.enableDurationBox) {
                let selectedStartDateTime = new Date(dtNow.getFullYear(), dtNow.getMonth(), dtNow.getDate(), dtNow.getHours(), dtNow.getMinutes(), dtNow.getSeconds());
                let minuteDiff = selectedStartDateTime.getMinutes() % this.slotLength;
                if (minuteDiff != 0)
                    selectedStartDateTime = selectedStartDateTime.addMinutes(this.slotLength - minuteDiff);
                let selectedEndDateTime = new Date(selectedStartDateTime.getFullYear(), selectedStartDateTime.getMonth(), selectedStartDateTime.getDate(), selectedStartDateTime.getHours(), selectedStartDateTime.getMinutes(), selectedStartDateTime.getSeconds());
                selectedEndDateTime.addMinutes(this.slotLength);
                this.selectedStartDateTime = selectedStartDateTime;
                this.selectedEndDateTime = selectedEndDateTime;
                this.startTime = this.selectedStartDateTime.toString();
                this.endTime = this.selectedEndDateTime.toString();
            }
            else {
                this.selectedStartDateTime = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate(), 8, 0, 0, 0);
                this.selectedEndDateTime = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate(), 17, 0, 0, 0);
                this.startTime = this.selectedStartDateTime.toString();
                this.endTime = this.selectedEndDateTime.toString();
            }
            this.searchAgenda(this.taskHandler);
        }
    }
    setCallbackBetweenTime() {
        let dt = this.currentDate;
        this.startTime = dt.toString("HH:mm");
        dt.setMinutes(dt.getMinutes() + 15);
        this.endTime = dt.toString("HH:mm");
    }
    nextDayButtonClick() {
        if (this.enableWorkweek)
            this.currentDate.setDate(this.currentDate.getDate() + 7);
        else
            this.currentDate.setDate(this.currentDate.getDate() + 1);
        this.selectedDateFromPicker = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate());
    }
    ;
    previousDayButtonClick() {
        if (this.enableWorkweek)
            this.currentDate.setDate(this.currentDate.getDate() - 7);
        else
            this.currentDate.setDate(this.currentDate.getDate() - 1);
        this.selectedDateFromPicker = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate());
    }
    ;
    selectedSlotCallback(dates) {
        let dateMoment = new Date(dates.start);
        let hr = dateMoment.getHours();
        let min = dateMoment.getMinutes();
        this.selectedStartDateTime = new Date(dateMoment.getFullYear(), dateMoment.getMonth(), dateMoment.getDate(), hr, min, 0, 0);
        dateMoment = new Date(dates.end);
        hr = dateMoment.getHours();
        min = dateMoment.getMinutes();
        this.selectedEndDateTime = new Date(dateMoment.getFullYear(), dateMoment.getMonth(), dateMoment.getDate(), hr, min, 0, 0);
        this.startTime = dates.start.toString();
        this.endTime = dates.end.toString();
        this.calendar.getApi()?.getEventById('selectedEvent')?.remove();
        this.calendar.getApi()?.addEvent({
            id: 'selectedEvent',
            allDay: false,
            editable: false,
            end: new Date(dates.end),
            backgroundColor: '#34b7db',
            start: new Date(dates.start)
        });
    }
    ;
    calendarStateChanged() {
        let dtNow = new Date();
        this.currentDate.setHours(dtNow.getHours());
        this.currentDate.setMinutes(dtNow.getMinutes());
        this.selectedStartDateTime = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate(), 8, 0, 0, 0);
        this.selectedEndDateTime = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate(), 8, this.slotLength, 0, 0);
        this.startTime = this.selectedStartDateTime.toString();
        this.endTime = this.selectedEndDateTime.toString();
        this.selectedDateFromPicker = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate());
        this.refreshCalendar();
    }
    ;
    refreshCalendar() {
        if (!this.enableWorkweek)
            GlobalFunctions.refreshCalendar(this.calendar.getApi(), this.calendarOptions, 'timeGridDay', this.agendaItems, this.currentDate, this.currentAvailability, 500, this.translateService, this.selectedSlotCallback, true, this.slotLength, false, true);
        else
            GlobalFunctions.refreshCalendar(this.calendar.getApi(), this.calendarOptions, 'timeGridWeek', this.agendaItems, this.currentDate, this.currentAvailability, 500, this.translateService, this.selectedSlotCallback, true, this.slotLength, false, true);
    }
    searchAgenda(taskHandler) {
        if (this.calendar)
            this.refreshCalendar();
        if (taskHandler) {
            let employeeIdList = [];
            employeeIdList.push(taskHandler.Id);
            if (this.enableWorkweek) {
                let mondayDate = cloneDeep(this.currentDate);
                let fridayDate = cloneDeep(this.currentDate);
                mondayDate.last().monday();
                if (!fridayDate.is().friday())
                    fridayDate.next().friday();
                this.employeeService.searchAgenda(employeeIdList, mondayDate, fridayDate, this.searchAgendaFound);
            }
            else
                this.employeeService.searchAgenda(employeeIdList, this.currentDate, null, this.searchAgendaFound);
            this.currentHandlerName = "(" + this.translateService.instant('LBL_AGENDA_FOR') + " : " + taskHandler.StringRepresentation + ")";
        }
    }
    searchAgendaFound(result) {
        console.log('CreateCallback->searchAgendaFound:', result);
        if (result && result.length > 0 && result[0].AvailabilityCollection != null && result[0].AvailabilityCollection.length > 0) {
            this.agendaItems = result[0].AvailabilityCollection[0].AgendaItems;
            this.currentAvailability = result[0].AvailabilityCollection[0].Availability;
        }
    }
    close(result) {
        const option = new Object();
        option.result = result;
        option.selectedStartDateTime = this.selectedStartDateTime;
        option.selectedEndDateTime = this.selectedEndDateTime;
        this.dialogRef.close(option);
    }
    ;
};
__decorate([
    ViewChild('calendar')
], EmployeeAgendaComponent.prototype, "calendar", void 0);
EmployeeAgendaComponent = __decorate([
    Component({
        selector: 'employee-agenda',
        templateUrl: './employee-agenda.component.html',
        styleUrls: ['./employee-agenda.component.scss']
    })
], EmployeeAgendaComponent);
export { EmployeeAgendaComponent };
//# sourceMappingURL=employee-agenda.component.js.map