var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseRelatedListComponent } from '../../../../components/common/base-related-list.component';
import { EmailSource } from '../../../../core/enums/global-enum';
import { BroadCastEventKeys } from '../../../../shared/constants';
let EmailRelatedListComponent = class EmailRelatedListComponent extends BaseRelatedListComponent {
    constructor(activatedRoute, translateService, sessionManager, eventProvider, applicationSettingManager, dialogManager, router, phoneManager, mailCount, filterPipe) {
        super(translateService, activatedRoute, sessionManager, eventProvider, dialogManager, applicationSettingManager, router, phoneManager);
        this.activatedRoute = activatedRoute;
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.dialogManager = dialogManager;
        this.router = router;
        this.phoneManager = phoneManager;
        this.mailCount = mailCount;
        this.filterPipe = filterPipe;
        this.emailFolders = {
            inboxEmailsCount: 0,
            archiveEmailsCount: 0,
            sentBoxEmailsCount: 0
        };
        this.relatedEmailTab = EmailSource.Inbox;
        this.relatedItemsToDisplayTabs = {
            inbox: 5,
            archive: 5,
            sentBox: 5
        };
        this.showMoreOrLessTextTabs = {
            inbox: this.translateService.instant('LBL_SHOW_MORE'),
            archive: this.translateService.instant('LBL_SHOW_MORE'),
            sentBox: this.translateService.instant('LBL_SHOW_MORE')
        };
        this.inboxRelatedResultList = [];
        this.archiveRelatedResultList = [];
        this.sentboxRelatedResultList = [];
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_EMAIL_TABS).subscribe(obj => this.filteredTabEmails(obj.filteredEmailsCount, obj.folder));
    }
    ngOnChanges(changes) {
        this.inboxRelatedResultList = this.filterPipe.transform(changes.relatedResultList.currentValue, ['Header', 'EmailSource'], 'Inbox');
        this.inboxRelatedResultList.sort((a, b) => new Date(b.Header.Date).getTime() - new Date(a.Header.Date).getTime());
        this.inboxRelatedResultList = [...this.inboxRelatedResultList];
        this.archiveRelatedResultList = this.filterPipe.transform(changes.relatedResultList.currentValue, ['Header', 'EmailSource'], 'Archive');
        this.archiveRelatedResultList.sort((a, b) => new Date(b.Header.Date).getTime() - new Date(a.Header.Date).getTime());
        this.archiveRelatedResultList = [...this.archiveRelatedResultList];
        this.sentboxRelatedResultList = this.filterPipe.transform(changes.relatedResultList.currentValue, ['Header', 'EmailSource'], 'SentBox');
        this.sentboxRelatedResultList.sort((a, b) => new Date(b.Header.Date).getTime() - new Date(a.Header.Date).getTime());
        this.sentboxRelatedResultList = [...this.sentboxRelatedResultList];
    }
    filteredTabEmails(itemsLength, folder) {
        if (folder === "Inbox")
            this.emailFolders.inboxEmailsCount = itemsLength;
        if (folder === "Archive")
            this.emailFolders.archiveEmailsCount = itemsLength;
        if (folder === "SentBox")
            this.emailFolders.sentBoxEmailsCount = itemsLength;
    }
    showMoreOrLessItemsTabs(relatedResultList, tab) {
        if (this.relatedItemsToDisplayTabs[tab] === 5) {
            this.relatedItemsToDisplayTabs[tab] = relatedResultList.length;
            this.showMoreOrLessTextTabs[tab] = this.translateService.instant('LBL_SHOW_LESS');
        }
        else {
            this.relatedItemsToDisplayTabs[tab] = 5;
            this.showMoreOrLessTextTabs[tab] = this.translateService.instant('LBL_SHOW_MORE');
        }
    }
};
EmailRelatedListComponent = __decorate([
    Component({
        selector: 'email-related-list',
        templateUrl: './email-related-list.component.html',
        styleUrls: ['./email-related-list.component.scss']
    })
], EmailRelatedListComponent);
export { EmailRelatedListComponent };
//# sourceMappingURL=email-related-list.component.js.map