var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let EmailMemoComponent = class EmailMemoComponent extends BaseDialogComponent {
    constructor(dialog, emailService, sessionManager, translateService, dialogRef) {
        super();
        this.dialog = dialog;
        this.emailService = emailService;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.memoText = '';
        this.addMemoResponse = this.addMemoResponse.bind(this);
    }
    ngOnInit() {
        this.memoText = this.sessionManager.selectedEntity.Memo;
    }
    addMemo() {
        this.startSpinner();
        this.emailService.updateMemo(this.memoText, this.sessionManager.selectedEntity.Id, this.addMemoResponse);
    }
    ;
    addMemoResponse(response) {
        this.stopSpinner();
        if (response != null && response.Result === 0) {
            this.sessionManager.selectedEntity.Memo = this.memoText;
            this.close();
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_MEMO'), textMsg: this.translateService.instant('LBL_MESSAGE_FAIL_SAVE_MEMO') });
    }
    ;
    close() {
        this.dialogRef.close();
    }
    ;
};
EmailMemoComponent = __decorate([
    Component({
        selector: 'email-memo',
        templateUrl: './email-memo.component.html',
        styleUrls: ['./email-memo.component.scss']
    })
], EmailMemoComponent);
export { EmailMemoComponent };
//# sourceMappingURL=email-memo.component.js.map