var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { FileUploadSource, ScreenMode } from 'src/app/core/enums/common-enums';
import { BroadCastEventKeys, EntityName, TinyMCE } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { UrlHelper } from 'src/app/shared/helper/url-helper';
import { environment } from 'src/environments/environment';
import { SubSink } from 'subsink';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { EmailSource, EmailType } from '../../../../core/enums/global-enum';
import { BasketItemDto } from '../../../../core/models/basket/basket-itemDto';
import { BasketDto } from '../../../../core/models/basket/basketdto';
import { SendBasketRequest } from '../../../../core/models/basket/send-basket-request';
import { EmailTemplateSetting } from '../../../../core/models/common/email-template-setting';
import { SearchObject } from '../../../../core/models/common/search-objectDto';
import { EmailAttachmentDto } from '../../../../core/models/email/email-attachmentDto';
import { EmailCountDto } from '../../../../core/models/email/email-countDto';
import { EmailDto } from '../../../../core/models/email/emailDto';
import { JsonDtoType } from '../../../../core/models/jkc-object/jkc-object';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let EmailBasketComponent = class EmailBasketComponent extends BaseDialogComponent {
    constructor(translateService, sessionManager, applicationSettingManager, shortcutManager, integrationSettingManager, phoneManager, ticketService, employeeService, basketService, formatManager, applicationFeatureManager, dialog, dialogManager, eventProvider, cacheManager, router, fileService, emailService, localSearchResultDataService) {
        super();
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.applicationSettingManager = applicationSettingManager;
        this.shortcutManager = shortcutManager;
        this.integrationSettingManager = integrationSettingManager;
        this.phoneManager = phoneManager;
        this.ticketService = ticketService;
        this.employeeService = employeeService;
        this.basketService = basketService;
        this.formatManager = formatManager;
        this.applicationFeatureManager = applicationFeatureManager;
        this.dialog = dialog;
        this.dialogManager = dialogManager;
        this.eventProvider = eventProvider;
        this.cacheManager = cacheManager;
        this.router = router;
        this.fileService = fileService;
        this.emailService = emailService;
        this.localSearchResultDataService = localSearchResultDataService;
        this.title = this.translateService.instant('LBL_SEND_VIA_EMAIL').toUpperCase();
        this.DateJS = Date;
        this.fileAttachments = [];
        this.uploadedFiles = [];
        this.query = "";
        this.defaultEmailSignature = "";
        this.validationStatus = "";
        this.toEmailList = [];
        this.ccEmailList = [];
        this.bccEmailList = [];
        this.emailPrefetchList = [];
        this.emailDto = new EmailDto();
        this.referenceEmailDto = null;
        this.OutboxItems = this.sessionManager.jkcParentPanel.parameters.EntityObject;
        this.emailType = this.sessionManager.jkcParentPanel.parameters.EntitySubType;
        this.emailUIObject = this.sessionManager.jkcParentPanel.parameters.EditedData;
        this.isArchiveEmail = false;
        this.sendAsPersonalMessage = false;
        this.isArchiveMailOptionSelected = false;
        this.userMailboxes = [];
        this.defaultUserMailbox = new EmailCountDto();
        this.emailTemplates = [];
        this.templateTypes = [];
        this.editorInstance = null;
        this.selectedEmailTemplates = [];
        this.selectedEmailTemplateItems = [];
        this.emailBodyWithoutSignature = '';
        this.emailTemplateSettings = new EmailTemplateSetting();
        this.standardStyle = this.applicationSettingManager.getEmailStandardStyle();
        this.sendEmailAsSecure = false;
        this.enableSecureEmail = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Email_Entities_Email, "ENABLESECUREEMAIL")?.toLowerCase() === "true" && this.sessionManager.isSecureEmailFeatureEnabled;
        this.showBccField = false;
        this.selectedEmailTemplateType = '';
        this.files = [];
        this.uploadedFile = null;
        this.emailItems = [];
        this.emailQuery = "";
        this.subs = new SubSink();
        this.emailBodyContentId = "tinymceEmail" + GlobalFunctions.getGuid();
        this.uploadHandler = (blobInfo, progress) => new Promise(async (resolve, reject) => {
            try {
                // Condition if the image is being pasted instead of using image upload button
                if (!this.uploadedFile)
                    this.uploadedFile = new File([blobInfo.blob()], blobInfo.filename(), { type: blobInfo.blob().type });
                const formData = new FormData();
                formData.append('file', this.uploadedFile);
                // TODO: find out why we are seperately uploading the image to backend as well?
                await this.fileService.uploadFileAsync(formData, UrlHelper.getUploadFileURL(environment.api_url, FileUploadSource.Email, GlobalFunctions.getSessionTokenAsString()));
                this.uploadedFile = null;
                // Keep base64 format since it is needed in the email body
                const reader = new FileReader();
                reader.readAsDataURL(blobInfo.blob());
                reader.onload = () => resolve(reader.result);
            }
            catch (e) {
                console.error(e);
                reject({ message: this.translateService.instant('LBL_ERROR_MSG'), remove: true });
            }
        });
        this.setBasketResponseReceived = this.setBasketResponseReceived.bind(this);
        this.sendBasketRelatedErrorCallback = this.sendBasketRelatedErrorCallback.bind(this);
        this.setFetchEmailAddressReceived = this.setFetchEmailAddressReceived.bind(this);
        this.sessionManager.startSessionIfPossible("PERSON", this.sessionManager.jkcParentPanel.parameters.EditMode ? ScreenMode.Edit : ScreenMode.Add);
        if (this.sessionManager.jkcParentPanel.parameters.IsChildPanel)
            this.sessionManager.jkcChildPanel.parameters.Scope = this;
        else
            this.sessionManager.jkcParentPanel.parameters.Scope = this;
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        try {
            this.sessionManager.startSessionIfPossible("EMAIL", ScreenMode.Add);
            let emailTemplateSetting = this.applicationSettingManager.getApplicationSettingValueByKey("EMAILTEMPLATES");
            this.emailTemplateSettings.setSettings(emailTemplateSetting);
            this.preFillEmailData();
            this.SetCheckBoxVisibility();
            this.fetchEmailBasketRelatedSettings();
            this.assignTypeAsPerTicketType();
            this.registerDialogShortcutKey();
            this.setDefaultEmailTemplate();
            this.initEditor();
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
            if (this.emailType == EmailType.Reply || this.emailType == EmailType.Forward)
                this.phoneManager.setPhoneStatusAction("1");
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    onUpload(upload) {
        if (!GlobalFunctions.isEmpty(upload)) {
            this.startSpinner();
            let fileDocument = { Text: upload.name, NameOnServer: "" };
            this.fileAttachments.push(fileDocument);
            this.errorMessage = '';
        }
    }
    onError(response) {
        if (!GlobalFunctions.isEmpty(this.uploadedFiles) && this.uploadedFiles.length > 0)
            this.uploadedFiles.splice(this.uploadedFiles.length - 1, 1);
        this.fileAttachments.splice(this.fileAttachments.length - 1, 1);
        this.errorMessage = GlobalFunctions.getFileUploadErrorText(response, this.translateService);
        this.stopSpinner();
    }
    onSuccess(response) {
        let fileLength = this.fileAttachments.length - 1;
        this.fileAttachments[fileLength].NameOnServer = response[0].fileName;
        this.errorMessage = '';
        this.stopSpinner();
    }
    preFillEmailData() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && (this.emailType == EmailType.Reply || this.emailType == EmailType.Forward)) {
            this.emailDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
            this.referenceEmailDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
            switch (this.emailDto.EmailType) {
                case EmailType.Reply:
                    {
                        let toItemList = [];
                        let ccItemList = [];
                        if (!GlobalFunctions.isEmpty(this.emailDto.Header.Sender)) {
                            toItemList.push(this.emailDto.Header.Sender);
                            toItemList.forEach(email => this.toEmailList.push({ text: email }));
                        }
                        if (!GlobalFunctions.isEmpty(this.emailDto.Header.Cc)) {
                            ccItemList.push(this.emailDto.Header.Cc);
                            ccItemList.forEach(CCemail => {
                                for (let i = 0; i < CCemail.length; i++) {
                                    this.ccEmailList.push({ text: CCemail[i] });
                                }
                            });
                        }
                        this.emailDto.AttachmentList = null;
                        this.emailDto.Header.Subject = "RE: " + this.emailDto.Header.Subject;
                        break;
                    }
                case EmailType.Forward:
                    {
                        this.emailDto.Header.Subject = "FW: " + this.emailDto.Header.Subject;
                        if (!GlobalFunctions.isEmpty(this.emailDto.AttachmentList) && this.emailDto.AttachmentList.length > 0) {
                            this.emailDto.AttachmentList.forEach((attachment, i) => {
                                let fileLength = this.fileAttachments.length;
                                this.fileAttachments[fileLength] = new Object();
                                this.fileAttachments[fileLength].Text = this.emailDto.AttachmentList[i].FileName;
                                this.fileAttachments[fileLength].NameOnServer = '';
                                this.fileAttachments[fileLength].IsFromMailBodyAttachment = true;
                                this.fileAttachments[fileLength].fileDocumentItem = this.emailDto.AttachmentList[i];
                            });
                        }
                        break;
                    }
            }
        }
        if (this.emailUIObject != undefined && this.emailUIObject != null) {
            if (!GlobalFunctions.isEmpty(this.emailUIObject.Cc))
                this.ccEmailList = this.emailUIObject.Cc.split(';').map(ccEmail => ({ text: ccEmail }));
            if (!GlobalFunctions.isEmpty(this.emailUIObject.To))
                this.toEmailList = this.emailUIObject.To.split(';').map(toEmail => ({ text: toEmail }));
            if (!GlobalFunctions.isEmpty(this.emailUIObject.Bcc)) {
                this.bccEmailList = this.emailUIObject.Bcc.split(';').map(bccEmail => ({ text: bccEmail }));
                this.showBccField = true;
            }
            this.emailDto.Header.Subject = this.emailUIObject.Subject;
            this.emailDto.EmailType = this.emailUIObject.EmailType;
            this.fileAttachments = this.emailUIObject.Attachments;
            this.selectedEmailTemplates = this.emailUIObject.SelectedEmailTemplates;
            this.selectedEmailTemplateType = this.emailUIObject.SelectedEmailTemplateType;
            this.defaultUserMailbox.MailboxId = this.emailUIObject.DefaultMailbox;
        }
        if (typeof this.OutboxItems === 'string') {
            let toItemList = [];
            toItemList.push({ text: this.OutboxItems });
            this.toEmailList = toItemList;
            this.OutboxItems = [];
        }
        // If Email Type is Forward and the session is not parked
        else if (this.emailDto.EmailType == EmailType.Forward && GlobalFunctions.isEmpty(this.emailUIObject)) {
            this.toEmailList = [];
        }
        else if (this.emailDto.EmailType != EmailType.Reply) {
            let emailAddress = GlobalFunctions.getLastPersonOrOrganizationEmailAddress(this.sessionManager.detailViewCachedEntityList);
            if (!GlobalFunctions.isEmpty(emailAddress)) {
                let toItemList = [];
                toItemList.push({ text: emailAddress });
                this.toEmailList = toItemList;
            }
        }
    }
    SetCheckBoxVisibility() {
        let valueData = this.applicationSettingManager.getApplicationSettingValueByKey("IsArchiveMailOptionRequired");
        if (!GlobalFunctions.isEmpty(valueData)) {
            this.isArchiveMailOptionSelected = valueData?.toLowerCase() == "true" ? true : false;
            if (this.emailType == EmailType.Reply || this.emailType == EmailType.Forward) {
                if (this.isArchiveMailOptionSelected) {
                    this.isArchiveEmail = true;
                }
            }
        }
    }
    getOriginalMessageHeader() {
        let originalMessageHeader = "";
        if (this.emailDto != null) {
            originalMessageHeader = "--- Original message ---" + "<p></p>" +
                "From: " + this.emailDto.Header.From + "<p></p>" +
                "To: " + this.emailDto.Header.To /*.join()*/ + "<p></p>" + /*"TBD_Mrudang"*/
                "Date: " + (new this.DateJS(this.emailDto.Header.Date).toString('dd-MM-yyyy HH:mm')) + "<p></p>" +
                "Subject: " + this.emailDto.Header.Subject;
        }
        return originalMessageHeader;
    }
    setBodyContent(emailSignature) {
        let setBodyContentWithSignature = "";
        //adding signature
        this.defaultEmailSignature = emailSignature;
        setBodyContentWithSignature = "<div id='newEmailContent'> <br/><div id='emailSignatureDiv'>" + emailSignature + "</div></div>";
        if (!GlobalFunctions.isEmpty(this.emailDto) && (this.emailType == EmailType.Reply || this.emailType == EmailType.Forward)) {
            //adding forward or reply message header
            setBodyContentWithSignature += "<div id='replyOrForwardEmailBody'><div id='originalMessageHeader'><p></p><p></p>";
            let originalMessageHeader = this.getOriginalMessageHeader();
            setBodyContentWithSignature += originalMessageHeader + "</div>";
            //adding forward or reply message content
            if (this.emailDto.Body != null && this.emailDto.Body != undefined) {
                setBodyContentWithSignature += "<div id='replyOrForwardEmailBodyContent'><p></p><p></p>";
                setBodyContentWithSignature += this.emailDto.Body.Body + "</div>";
                this.emailBodyWithoutSignature = "<p></p><p></p>" + originalMessageHeader + this.emailDto.Body.Body;
            }
            setBodyContentWithSignature += "</div>";
        }
        return setBodyContentWithSignature;
    }
    fetchEmailBasketRelatedSettings() {
        if (this.sessionManager.isEWSEnabled) {
            if (!GlobalFunctions.isEmpty(this.sessionManager.pendingCount.EmailCount)) {
                for (let i = 0; i < this.sessionManager.pendingCount.EmailCount.length; i++) {
                    if (this.sessionManager.pendingCount.EmailCount[i].IsMarked && !this.isMailboxExist(this.sessionManager.pendingCount.EmailCount[i], this.userMailboxes))
                        this.userMailboxes.push(this.sessionManager.pendingCount.EmailCount[i]);
                    if (GlobalFunctions.isEmpty(this.defaultUserMailbox.MailboxId) && ((!GlobalFunctions.isEmpty(this.emailUIObject) && !GlobalFunctions.isEmpty(this.emailUIObject.DefaultMailbox) && this.sessionManager.pendingCount.EmailCount[i].MailboxId?.toLowerCase() == this.emailUIObject.DefaultMailbox?.toLowerCase()) || this.sessionManager.pendingCount.EmailCount[i].IsDefault))
                        this.defaultUserMailbox.MailboxId = this.sessionManager.pendingCount.EmailCount[i].MailboxId;
                }
            }
        }
        if (!GlobalFunctions.isEmpty(this.emailUIObject))
            this.emailDto.Body.Body = this.emailUIObject.Body;
        else {
            if (this.sessionManager.isEWSEnabled && this.emailDto.EmailType == EmailType.Reply) {
                let mailbox = { MailboxId: "" };
                let isExistsInTo = false;
                if (!GlobalFunctions.isEmpty(this.emailDto.Header.To)) {
                    for (let i = 0; i < this.emailDto.Header.To.length; i++) {
                        mailbox.MailboxId = this.emailDto.Header.To[i]?.toLowerCase();
                        if (this.isMailboxExist(mailbox, this.userMailboxes)) {
                            this.defaultUserMailbox.MailboxId = mailbox.MailboxId;
                            isExistsInTo = true;
                            break;
                        }
                    }
                }
                if (!isExistsInTo && !GlobalFunctions.isEmpty(this.emailDto.Header.Cc)) {
                    for (let i = 0; i < this.emailDto.Header.Cc.length; i++) {
                        mailbox.MailboxId = this.emailDto.Header.Cc[i]?.toLowerCase();
                        if (this.isMailboxExist(mailbox, this.userMailboxes)) {
                            this.defaultUserMailbox.MailboxId = mailbox.MailboxId;
                            break;
                        }
                    }
                }
            }
            let emailSignature = this.sessionManager.isEWSEnabled ? this.getSignatureFromMultipleEmailConfig(this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Email_Entities_Email, "MULTIPLEEMAILCONFIGURATION")) : this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Email_Entities_Email, "EMAILBASKETSIGNATURE");
            if (!GlobalFunctions.isEmpty(this.emailDto.Body))
                this.emailDto.Body.Body = this.setBodyContent(emailSignature);
        }
        if (this.emailTemplateSettings.TemplateList.length > 0)
            this.emailTemplates = this.emailTemplateSettings.TemplateList;
        if (this.emailTemplateSettings.TypeList.length > 0)
            this.templateTypes = this.emailTemplateSettings.TypeList;
        this.setTemplates('');
    }
    isMailboxExist(mailbox, existingMailboxList) {
        let retValue = false;
        if (existingMailboxList.length == 0 || GlobalFunctions.isEmpty(mailbox))
            return retValue;
        for (let i = 0; i < existingMailboxList.length; i++) {
            if (!GlobalFunctions.isEmpty(existingMailboxList[i].MailboxId) && !GlobalFunctions.isEmpty(mailbox.MailboxId) && existingMailboxList[i].MailboxId?.toLowerCase() == mailbox.MailboxId?.toLowerCase()) {
                retValue = true;
                break;
            }
        }
        ;
        return retValue;
    }
    fillLocalAttachments(BasketItemList) {
        let i = 0;
        let localAttachment;
        for (i = 0; i < this.fileAttachments.length; i++) {
            if (!GlobalFunctions.isEmpty(this.fileAttachments[i].IsFromMailBodyAttachment) && this.fileAttachments[i].IsFromMailBodyAttachment) {
                let contentType = GlobalFunctions.getContentTypeByPropertyName("RelatedEntityFqdn", this.fileAttachments[i].fileDocumentItem);
                let objectTypeName = GlobalFunctions.getObjectTypeName(contentType);
                let basketItem = new BasketItemDto();
                basketItem.Item = GlobalFunctions.setEntityType(this.fileAttachments[i].fileDocumentItem, GlobalFunctions.toJsonFqdnType(objectTypeName));
                basketItem.Type = EntityFqdn.Decos_Kcs_Documents_Entities_FileDocument;
                BasketItemList.push(basketItem);
                continue;
            }
            localAttachment = new EmailAttachmentDto;
            localAttachment.OnServer = true;
            localAttachment.FileName = this.fileAttachments[i].NameOnServer;
            localAttachment.Name = this.fileAttachments[i].Text;
            localAttachment.IsMarked = true;
            let contentType = GlobalFunctions.getContentTypeByPropertyName("RelatedEntityFqdn", localAttachment);
            let objectTypeName = GlobalFunctions.getObjectTypeName(contentType);
            let basketItem = new BasketItemDto();
            basketItem.Item = GlobalFunctions.setEntityType(localAttachment, GlobalFunctions.toJsonFqdnType(objectTypeName));
            basketItem.Type = localAttachment.RelatedEntityFqdn;
            BasketItemList.push(basketItem);
        }
    }
    sendBasketRelatedErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_SEND_ERROR_MSG"), [this.translateService.instant("LBL_EMAIL")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_EMAIL"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    send() {
        if (this.form.invalid)
            return;
        this.startSpinner();
        if (this.emailDto != null && this.emailDto != undefined && this.toEmailList != null && this.toEmailList != undefined && this.toEmailList.length > 0) {
            this.emailDto.EmailType = this.emailType;
            if (this.emailType == EmailType.Send)
                this.emailDto.Header.Date = new Date();
            if (this.toEmailList != null && this.toEmailList != undefined && this.toEmailList.length > 0) {
                let emailToText = [];
                for (let index = 0; index < this.toEmailList.length; index++) {
                    emailToText.push(this.toEmailList[index].text);
                }
                this.emailDto.Header.To = emailToText;
            }
            this.emailDto.Header.From = "";
            this.emailDto.Header.Cc = ""; // []; TBD_Mrudang
            this.emailDto.Header.Bcc = ""; // []; TBD_Mrudang
            if (!GlobalFunctions.isEmpty(this.ccEmailList)) {
                let emailCcText = [];
                for (let index = 0; index < this.ccEmailList.length; index++) {
                    emailCcText.push(this.ccEmailList[index].text);
                }
                this.emailDto.Header.Cc = emailCcText;
            }
            if (!GlobalFunctions.isEmpty(this.bccEmailList)) {
                let emailBccText = [];
                for (let index = 0; index < this.bccEmailList.length; index++) {
                    emailBccText.push(this.bccEmailList[index].text);
                }
                this.emailDto.Header.Bcc = emailBccText;
            }
            let head = "<head><style>p{margin:0;padding:0}</style></head>";
            // Clean up and apply inline styles to all <p> tags that don’t already have a style attribute - to prevent extra spacing issues in outlook/email
            if (!GlobalFunctions.isEmpty(this.emailDto) && !GlobalFunctions.isEmpty(this.emailDto.Body) && !GlobalFunctions.isEmpty(this.emailDto.Body.Body))
                this.emailDto.Body.Body = this.emailDto.Body.Body.replace(/<p(?![^>]*style)/g, '<p style="margin:0; padding:0; line-height:1.2;"');
            this.emailDto.Body.IsBodyHtml = true;
            if (this.emailType == EmailType.Reply || this.emailType == EmailType.Forward) {
                this.referenceEmailDto.IsArchivable = this.isArchiveEmail;
            }
            if (this.sendAsPersonalMessage == true && this.employeeService.loggedInEmployee != null)
                this.emailDto.Header.From = this.employeeService.loggedInEmployee.EmailAddress;
            if (this.sessionManager.isEWSEnabled)
                this.emailDto.Header.From = this.defaultUserMailbox.MailboxId;
            let sendBasketRequest = new SendBasketRequest();
            sendBasketRequest.SendAsPersonal = this.sendAsPersonalMessage;
            sendBasketRequest.SendEmailSecurely = this.sendEmailAsSecure;
            sendBasketRequest.HandlerId = GlobalFunctions.getLoggedInUserId();
            sendBasketRequest.SendDto = GlobalFunctions.setEntityType(this.emailDto, JsonDtoType.Email);
            if (this.emailType == EmailType.Forward) {
                let sendDto = sendBasketRequest.SendDto;
                sendDto.AttachmentList = null;
                sendBasketRequest.SendDto = sendDto;
            }
            if (this.referenceEmailDto != null && this.referenceEmailDto != undefined) {
                this.referenceEmailDto.AttachmentList = [];
                this.referenceEmailDto.Body = null;
                sendBasketRequest.ReferenceDto = GlobalFunctions.setEntityType(this.referenceEmailDto, JsonDtoType.Email);
            }
            let basketDto = new BasketDto();
            basketDto.BasketItemList = [];
            this.fillLocalAttachments(basketDto.BasketItemList);
            if (this.OutboxItems != undefined && this.OutboxItems != null && this.OutboxItems.length > 0)
                basketDto.BasketItemList = basketDto.BasketItemList.concat(this.OutboxItems);
            sendBasketRequest.BasketDto = basketDto;
            this.basketService.emailBasket(sendBasketRequest, this.setBasketResponseReceived, this.sendBasketRelatedErrorCallback);
            let sentEmailDto = jQuery.extend(true, {}, sendBasketRequest.SendDto);
            this.saveSentEmailDetail(sentEmailDto, basketDto);
        }
        else
            this.validationStatus = this.translateService.instant("LBL_TO_FIELD_VALIDATION_EXCEPTION");
    }
    saveSentEmailDetail(emailDto, basketDto) {
        if (this.emailType == EmailType.Reply)
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType = "Email";
        let prefillEmailReplies = this.applicationSettingManager.getApplicationSettingValueByKey("PrefillEmailRepliesInContactSessionNotes");
        if (!GlobalFunctions.isEmpty(prefillEmailReplies) && prefillEmailReplies?.toLowerCase() === "true") {
            emailDto.AttachmentList = basketDto.BasketItemList;
            let bodyContent = emailDto.Body.Body.replace(this.defaultEmailSignature, ' ').replace(/<br>/gi, '').replace(/<br\/>/gi, '').replace(/<div>/g, ' ').replace(/<\/div>/g, ' ').replace(/\r?\n|\r/g, ' ').replace(/\s+/g, ' ');
            if ((this.emailType == EmailType.Reply || this.emailType == EmailType.Forward)) {
                let orginalMessage = bodyContent.split("--- Original message ---");
                bodyContent = orginalMessage[0];
            }
            emailDto.Body.Body = bodyContent;
            this.sessionManager.saveSentEmailDetail(emailDto, this.emailType);
        }
    }
    setBasketResponseReceived(result) {
        if (result)
            this.showEmailResult(result);
    }
    setFetchEmailAddressReceived(result) {
        this.emailItems = [];
        if (result?.EmailBasketAddressDtoList?.length > 0) {
            result.EmailBasketAddressDtoList.forEach(email => {
                if (!GlobalFunctions.isEmpty(email))
                    this.emailItems.push({ text: email.EmailAddress });
            });
        }
        else {
            if (this.query != null && this.query.length > 0)
                this.emailItems.push({ text: this.emailQuery });
        }
    }
    loadItems(event) {
        this.emailQuery = event.target.value.trim();
        if (this.emailQuery.length > 2)
            this.emailService.fetchEmailAddress(this.emailQuery, this.setFetchEmailAddressReceived);
    }
    loadLastSelectedSearchResult() {
        if (this.applicationFeatureManager.isShowNextEmailFeatureEnabled == false) {
            let index = this.sessionManager.selectedBreadcrumbIndex;
            let currentBreadcrumItem = this.sessionManager.BreadcrumbItems[index];
            this.sessionManager.BreadcrumbItems[index][0].isDeleted = true;
            if (index < this.sessionManager.BreadcrumbItems.length)
                index = index + 1;
            let breadCrumbItems = this.sessionManager.BreadcrumbItems[index];
            if (breadCrumbItems != undefined || breadCrumbItems != null)
                breadCrumbItems.forEach(breadCrumbItem => {
                    if (currentBreadcrumItem != undefined && currentBreadcrumItem[0].itemData != null && currentBreadcrumItem[0].itemData.Id == breadCrumbItem.itemData.Id) {
                        if (breadCrumbItems.length == 1)
                            breadCrumbItems[0].isDeleted = true;
                        else {
                            let index = breadCrumbItems.indexOf(breadCrumbItem);
                            breadCrumbItems.splice(index, 1);
                        }
                    }
                });
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
            if (breadCrumbItems != null && breadCrumbItems.length > 0) {
                this.localSearchResultDataService.localSearchResultData.contentType = breadCrumbItems[0].sourceUrl.substring(breadCrumbItems[0].sourceUrl.lastIndexOf("/") + 1);
                breadCrumbItems.forEach(el => {
                    if (!el.isDeleted)
                        this.localSearchResultDataService.localSearchResultData.localResult.push(el.itemData);
                    this.localSearchResultDataService.localSearchResultData.contentType = el.sourceUrl.substring(el.sourceUrl.lastIndexOf("/") + 1);
                });
                breadCrumbItems[0].isSelected = true;
                this.sessionManager.addBreadcrumbTypeItems(breadCrumbItems, false);
                GlobalFunctions.navigateWithOptionalQueryParam(this.router, breadCrumbItems[0].sourceUrl);
            }
        }
    }
    showEmailResult(basketResponse) {
        this.stopSpinner();
        let message = null;
        switch (basketResponse.Result) {
            case 0:
                if (basketResponse.SendDto && !GlobalFunctions.isEmpty(basketResponse.SendDto.Id))
                    this.emailDto = basketResponse.SendDto;
                this.sessionManager.clearBasketItems();
                this.linkEmailToTicket(this.emailDto, basketResponse.SentEmailId);
                if (this.emailType == EmailType.Send && !GlobalFunctions.isEmpty(this.emailDto.Id) && !GlobalFunctions.isEmpty(this.emailDto.ObjectSource) && !GlobalFunctions.isEmpty(this.emailDto.StringRepresentation)) {
                    this.sessionManager.addItemsToDetailViewCacheList(this.emailDto, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email]));
                    this.sessionManager.startSessionIfPossible("EMAIL", ScreenMode.Add);
                }
                if (this.emailType == EmailType.Reply || this.emailType == EmailType.Forward) {
                    if (this.sessionManager.isAssignmentTaskAutoIgnoreSessionValid(this.cacheManager, "email"))
                        this.sessionManager.autoIgnoreSession(this.dialog, this.dialogManager, this.cacheManager, this.phoneManager);
                    else {
                        if (this.isArchiveEmail) {
                            if (basketResponse.SendDto && !GlobalFunctions.isEmpty(basketResponse.SendDto.Id)) {
                                this.sessionManager.selectedEntity.Id = basketResponse.SendDto.Id;
                                if (this.sessionManager.selectedEntity.Header != null) {
                                    this.sessionManager.selectedEntity.Header.Id = basketResponse.SendDto.Header.Id;
                                    this.sessionManager.selectedEntity.Header.Uid = basketResponse.SendDto.Header.Uid;
                                    this.sessionManager.selectedEntity.Header.EmailSource = EmailSource[EmailSource.Archive];
                                }
                                this.close(true);
                                this.loadLastSelectedSearchResult();
                            }
                            else {
                                message = this.translateService.instant("LBL_MSG_FAILED_TO_ARCHIVE_EMAIL");
                            }
                        }
                        else {
                            this.close(true);
                            if (this.emailDto)
                                this.sessionManager.removeFromDetailViewCachedEntityList(this.emailDto.Id);
                            this.loadLastSelectedSearchResult();
                        }
                        if (this.applicationSettingManager.autoEndSession)
                            this.eventProvider.BroadcastEvent(BroadCastEventKeys.AUTO_END_SESSION, EntityFqdn.Decos_Kcs_Email_Entities_Email);
                        else
                            this.dialogManager.openJsPanelOrDialog("END_SESSION_DIALOG");
                    }
                }
                else
                    this.close(true);
                break;
            case 1:
                message = this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_EMAIL_BASKET");
                break;
            case 3:
                message = this.translateService.instant("LBL_MESSAGE_FAIL_SEND_EMAIL_RIGHT");
                break;
            default:
                message = this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_EMAIL_BASKET");
                break;
        }
        if (!GlobalFunctions.isEmpty(message)) {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: message }).afterClosed().subscribe(() => {
                if (basketResponse.Result == 0)
                    this.close(false);
            });
        }
    }
    templateChanged(isTagRemoved, tag) {
        if (GlobalFunctions.isEmpty(this.emailDto.Body.Body))
            this.emailDto.Body.Body = this.getHtmlBody();
        let emailBodyContent = this.emailDto.Body.Body;
        let emailBody = $(emailBodyContent);
        if (emailBody.length > 0) {
            emailBodyContent = "";
            emailBody.each((i, eachEmailNode) => {
                if (eachEmailNode.nodeName.toUpperCase() == "DIV" && !GlobalFunctions.isEmpty(eachEmailNode.id) && eachEmailNode.id == "newEmailContent") {
                    if (this.selectedEmailTemplates[0])
                        this.selectedEmailTemplates[0].Content = this.selectedEmailTemplates[0].Content.replace(/&amp;/g, "&");
                    if (!GlobalFunctions.isEmpty(eachEmailNode.outerHTML) && eachEmailNode.outerHTML.indexOf("emailSelectedTemplate") == -1)
                        eachEmailNode.innerHTML = "<div id='emailSelectedTemplate'>" + (this.selectedEmailTemplates[0] ? this.formatManager.mergeTemplateFields(this.selectedEmailTemplates[0].Content).replace(/([\"]*[\&]*amp;[amp;]*[\"]*)/g, "") : "") + "</div>" + eachEmailNode.innerHTML.replace(/<p><\/p><p><\/p><p><\/p> <br><br><br><br>/gi, '');
                    else {
                        eachEmailNode.childNodes.forEach(childNode => {
                            if (childNode.nodeName.toUpperCase() == "DIV" && !GlobalFunctions.isEmpty(childNode.id) && childNode.id == "emailSelectedTemplate")
                                childNode.innerHTML = this.selectedEmailTemplates[0] ? this.formatManager.mergeTemplateFields(this.selectedEmailTemplates[0].Content) : "";
                        });
                    }
                }
            });
        }
        emailBody.each((i, eachEmailNode) => {
            if (eachEmailNode.nodeName.toUpperCase() == "#TEXT")
                emailBodyContent += eachEmailNode.data;
            else
                emailBodyContent += eachEmailNode.outerHTML;
        });
        this.emailDto.Body.Body = emailBodyContent;
        if (isTagRemoved) {
            if (!GlobalFunctions.isEmpty(tag)) {
                if (!GlobalFunctions.isEmpty(this.emailDto.Header) && !GlobalFunctions.isEmpty(tag.Subject) && this.emailDto.Header.Subject == tag.Subject)
                    this.emailDto.Header.Subject = "";
                if (!GlobalFunctions.isEmpty(this.toEmailList) && !GlobalFunctions.isEmpty(tag.ToEmailAddresses)) {
                    let toEmailAddressArray = tag.ToEmailAddresses.split(';');
                    for (let i = 0; i < toEmailAddressArray.length; i++) {
                        let index = this.toEmailList.findIndex(x => x.text == toEmailAddressArray[i]);
                        this.toEmailList.splice(index, 1);
                    }
                }
                if (!GlobalFunctions.isEmpty(this.ccEmailList) && !GlobalFunctions.isEmpty(tag.CcEmailAddresses)) {
                    let ccEmailAddressArray = tag.CcEmailAddresses.split(';');
                    for (let i = 0; i < ccEmailAddressArray.length; i++) {
                        let index = this.ccEmailList.findIndex(x => x.text == ccEmailAddressArray[i]);
                        this.ccEmailList.splice(index, 1);
                    }
                }
                if (!GlobalFunctions.isEmpty(this.bccEmailList) && !GlobalFunctions.isEmpty(tag.BccEmailAddresses)) {
                    let bccEmailAddressArray = tag.BccEmailAddresses.split(';');
                    for (let i = 0; i < bccEmailAddressArray.length; i++) {
                        let index = this.bccEmailList.findIndex(x => x.text == bccEmailAddressArray[i]);
                        this.bccEmailList.splice(index, 1);
                    }
                }
                if (this.fileAttachments.length > 0)
                    this.fileAttachments = GlobalFunctions.removeByAttr(this.fileAttachments, 'fromTemplate', true);
            }
        }
        else {
            if (!GlobalFunctions.isEmpty(this.selectedEmailTemplates)) {
                if (!GlobalFunctions.isEmpty(this.selectedEmailTemplates[0].Subject))
                    this.emailDto.Header.Subject = this.selectedEmailTemplates[0].Subject;
                if (!GlobalFunctions.isEmpty(this.selectedEmailTemplates[0].ToEmailAddresses)) {
                    let toItemList = [];
                    const toEmailAddressess = this.selectedEmailTemplates[0].ToEmailAddresses.split(';');
                    toEmailAddressess.forEach(toEmailAddress => toItemList.push({ text: toEmailAddress }));
                    this.toEmailList = toItemList;
                }
                if (!GlobalFunctions.isEmpty(this.selectedEmailTemplates[0].CcEmailAddresses)) {
                    let ccItemList = [];
                    const ccEmailAddressess = this.selectedEmailTemplates[0].CcEmailAddresses.split(';');
                    ccEmailAddressess.forEach(ccEmailAddress => ccItemList.push({ text: ccEmailAddress }));
                    this.ccEmailList = ccItemList;
                }
                if (!GlobalFunctions.isEmpty(this.selectedEmailTemplates[0].BccEmailAddresses)) {
                    let bccItemList = [];
                    this.showBccField = true;
                    const bccEmailAddressess = this.selectedEmailTemplates[0].BccEmailAddresses.split(';');
                    bccEmailAddressess.forEach(bccEmailAddress => bccItemList.push({ text: bccEmailAddress }));
                    this.bccEmailList = bccItemList;
                }
                if (!GlobalFunctions.isEmpty(this.selectedEmailTemplates[0].Attachments) && this.selectedEmailTemplates[0].Attachments.length > 0) {
                    let attachments = [];
                    for (let i = 0; i < this.selectedEmailTemplates[0].Attachments.length; i++)
                        attachments.push({ Text: this.selectedEmailTemplates[0].Attachments[i].Name, NameOnServer: this.selectedEmailTemplates[0].Attachments[i].Path, fromTemplate: true });
                    this.fileAttachments = this.fileAttachments.concat(attachments);
                }
            }
        }
    }
    ;
    getHtmlBody() {
        return "<div id='newEmailContent'><p></p><p></p><p></p><p></p> <br/><br/><br/><br/><div id='emailSignatureDiv'><p></p></div></div>";
    }
    mailboxChanged() {
        try {
            let emailSignature = this.getSignatureFromMultipleEmailConfig(this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Email_Entities_Email, "MULTIPLEEMAILCONFIGURATION"));
            let emailBodyContent = this.emailDto.Body.Body;
            let emailBody = $(emailBodyContent);
            if (emailBody.length > 0) {
                emailBodyContent = "";
                emailBody.each((i, eachEmailNode) => {
                    if (eachEmailNode.nodeName.toUpperCase() == "DIV") {
                        if (!GlobalFunctions.isEmpty(eachEmailNode.id) && eachEmailNode.id == "emailSignatureDiv")
                            eachEmailNode.outerHTML = "<div id='emailSignatureDiv'>" + emailSignature + "</div>";
                        else if (((!GlobalFunctions.isEmpty(eachEmailNode.id) && eachEmailNode.id != "replyOrForwardEmailBodyContent") || GlobalFunctions.isEmpty(eachEmailNode.id)) && !GlobalFunctions.isEmpty(eachEmailNode.outerHTML) && eachEmailNode.outerHTML.indexOf("emailSignatureDiv") != -1) {
                            eachEmailNode.childNodes.forEach(childNode => {
                                if (childNode.nodeName.toUpperCase() == "DIV" && !GlobalFunctions.isEmpty(childNode.id) && childNode.id == "emailSignatureDiv")
                                    childNode.outerHTML = "<div id='emailSignatureDiv'>" + emailSignature + "</div>";
                            });
                        }
                    }
                });
                emailBody.each((i, eachEmailNode) => {
                    if (eachEmailNode.nodeName.toUpperCase() == "#TEXT")
                        emailBodyContent += eachEmailNode.data;
                    else
                        emailBodyContent += eachEmailNode.outerHTML;
                });
                this.emailDto.Body.Body = emailBodyContent;
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    registerDialogShortcutKey() {
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.send());
    }
    getSignatureFromMultipleEmailConfig(multipleEmailConfigXml) {
        let emailSignature = '';
        try {
            if (!GlobalFunctions.isEmpty(multipleEmailConfigXml)) {
                const xmlDoc = $.parseXML(multipleEmailConfigXml), $xml = $(xmlDoc), mailboxes = $xml.find('MAILBOX');
                if (mailboxes?.length > 0) {
                    mailboxes.each((i, mailbox) => {
                        const mailboxName = $(mailbox).find('MAILBOXLOGINNAME')[0].textContent;
                        if (!GlobalFunctions.isEmpty(this.emailDto.Header) && !GlobalFunctions.isEmpty(this.emailDto.Header.To) && !this.emailDto.Header.To[0].toLowerCase().includes(this.defaultUserMailbox.MailboxId?.toLowerCase()) && !GlobalFunctions.isEmpty(this.emailDto.Header.To[0]) && mailboxName?.toLowerCase() == this.emailDto.Header.To[0]?.toLowerCase())
                            emailSignature = $(mailbox).find('MAILBOXSIGNATURE')[0].textContent;
                        else if (!GlobalFunctions.isEmpty(this.defaultUserMailbox.MailboxId) && this.defaultUserMailbox.MailboxId?.toLowerCase() === mailboxName?.toLowerCase())
                            emailSignature = $(mailbox).find('MAILBOXSIGNATURE')[0].textContent;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return emailSignature;
    }
    resize() {
        const windowHeight = $(window).height();
        if (this.sessionManager.jkcParentPanel)
            $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel.parameters.TopSpace) - 100 + "px") });
        $("#emailBasketContainer").height($("#jkcParentPanel").height() - $("#emailBasketHeader").height() - $("#emailBasketFooter").height() - 30 + "px");
        $(".tox-tinymce").height($("#jkcParentPanel").height() - $("#emailBasketHeader").height() - $("#emailBasketFooter").height() - (this.showBccField ? 455 : 405) + "px");
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    templateTagAdded(tag) {
        if (this.selectedEmailTemplates.length > 1) {
            this.selectedEmailTemplates.splice(1, 1);
            tag = this.selectedEmailTemplates[0];
        }
        this.templateChanged(false, tag);
    }
    templateTagRemoved(tag) {
        this.selectedEmailTemplates = [];
        this.templateChanged(true, tag);
    }
    setTemplates(query) {
        const items = [];
        if (this.emailTemplates.length > 0) {
            for (let i = 0; i < this.emailTemplates.length; i++) {
                if ((this.emailTemplates[i].Name && this.emailTemplates[i].Name?.toLowerCase().indexOf(query?.toLowerCase()) > -1) || (GlobalFunctions.isEmpty(query) && this.selectedEmailTemplates.length == 0)) {
                    this.emailTemplates[i].text = this.emailTemplates[i].Name;
                    items.push(this.emailTemplates[i]);
                }
            }
        }
        this.selectedEmailTemplateItems = items;
    }
    templateTypeChanged() {
        this.emailTemplates = this.emailTemplateSettings.getTemplateByType(this.selectedEmailTemplateType);
        this.setTemplates('');
    }
    assignTypeAsPerTicketType() {
        if (GlobalFunctions.isEmpty(this.OutboxItems) || this.templateTypes.length == 0)
            return;
        this.OutboxItems.forEach(item => {
            if (!GlobalFunctions.isEmpty(item.Type) && item.Type == EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket) {
                let objItem = JSON.parse(item.JsonItem);
                let type = objItem.TicketTypeText;
                if (!GlobalFunctions.isEmpty(type)) {
                    for (let i = 0; i < this.templateTypes.length; i++) {
                        if (this.templateTypes[i].Name?.toLowerCase() == type?.toLowerCase()) {
                            this.selectedEmailTemplateType = this.templateTypes[i];
                            this.templateTypeChanged();
                            break;
                        }
                    }
                }
            }
        });
    }
    //>> link email to ticket
    linkEmailToTicket(emailDto, sentEmailId) {
        let recentTicket = GlobalFunctions.getLastTicketFromSession(this.sessionManager.detailViewCachedEntityList);
        if (!GlobalFunctions.isEmpty(recentTicket)) {
            let destinationEntityList = new Array();
            let sourceEntity = new SearchObject(recentTicket.Id, recentTicket.RelatedEntityFqdn, recentTicket.ObjectSource, recentTicket.ExternalId);
            destinationEntityList.push(new SearchObject(sentEmailId, GlobalFunctions.toContentType(GlobalFunctions.getObjectTypeName(emailDto.RelatedEntityFqdn)), emailDto.ObjectSource, ""));
            this.ticketService.linkRelatedEntity(sourceEntity, destinationEntityList, null);
        }
    }
    //<< link email to ticket
    setDefaultEmailTemplate() {
        if (this.sessionManager.jkcParentPanel != null && this.sessionManager.jkcParentPanel.parameters != null && this.sessionManager.jkcParentPanel.parameters.EntityParameter != null) {
            this.selectedEmailTemplateType = this.sessionManager.jkcParentPanel.parameters.EntityParameter.TypeId;
            this.templateTypeChanged();
            let emailTemplate = jlinq.from(this.emailTemplates).starts("Id", this.sessionManager.jkcParentPanel.parameters.EntityParameter.Id).first();
            if (emailTemplate != null) {
                this.selectedEmailTemplates = [];
                emailTemplate.text = emailTemplate.Name;
                this.selectedEmailTemplates.push(emailTemplate);
                this.templateTagAdded();
            }
        }
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close(false);
    }
    close(result) {
        const option = new Object();
        option.result = result;
        option.emailType = this.emailType;
        option.isArchiveEmail = this.isArchiveEmail;
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel.parameters.CallbackMethod))
            this.sessionManager.jkcParentPanel.parameters.CallbackMethod(option);
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
    initEditor() {
        this.tinymceOptions = {
            base_url: '/tinymce',
            plugins: 'link image table autolink lists',
            iframe_aria_text: GlobalFunctions.removeHTMLTags(this.emailDto.Body.Body),
            toolbar: 'undo redo | fontfamily blocks fontsize | bold italic underline | alignleft aligncenter alignright | bullist numlist | outdent indent | table | forecolor backcolor | link image | standardFormat',
            resize: false,
            contextmenu: false,
            browser_spellcheck: true,
            elementpath: false,
            menubar: false,
            font_size_formats: TinyMCE.FONT_SIZE_FORMATS,
            font_family_formats: TinyMCE.FONT_FAMILY_FORMATS,
            apply_source_formatting: true,
            statusbar: false,
            entity_encoding: 'raw',
            content_style: "body {font: 400 15px 'Open Sans', sans-serif !important;}",
            height: $("#jkcParentPanel").height() - $("#emailBasketHeader").height() - $("#emailBasketFooter").height() - 405 + "px",
            file_picker_types: 'image',
            images_upload_base_path: '/cacheddata/' + GlobalFunctions.getSessionTokenAsString() + '/',
            paste_postprocess: (plugin, args) => args.node.setAttribute('id', '42'),
            paste_data_images: true,
            force_br_newlines: false,
            forced_root_block: 'div',
            init_instance_callback: editor => {
                GlobalFunctions.setEditorBodyHeight();
                this.editor = editor;
                editor.on('keydown', event => {
                    if (event.keyCode === 27)
                        this.close(true);
                });
            },
            file_picker_callback: (cb, value, meta) => {
                let input = document.createElement('input');
                input.setAttribute('type', 'file');
                input.setAttribute('accept', 'image/*');
                input.style.display = 'none';
                document.body.appendChild(input);
                input.onchange = () => {
                    let file = input.files[0];
                    this.uploadedFile = file;
                    let size = file.size / 1024;
                    let x = document.getElementsByClassName("tox-dialog__footer-start");
                    let lastHtmlElement = x[x.length - 1];
                    let stringArray = file.name.split(".");
                    let extension = stringArray[stringArray.length - 1];
                    let whitelistedExtension = this.applicationSettingManager.getApplicationSettingValueByKey("WhitelistedImageExtensionsForUpload");
                    if (size > 4096)
                        lastHtmlElement.innerHTML = "<p style='color:red;'>" + this.translateService.instant("LBL_IMAGE_SIZE_ERROR_MSG") + "</p>";
                    else if (file.type.indexOf("image") == -1 || (!GlobalFunctions.isEmpty(whitelistedExtension) && whitelistedExtension.toLowerCase().indexOf(extension.toLowerCase()) === -1))
                        lastHtmlElement.innerHTML = "<p style='color:red;'>" + this.translateService.instant("LBL_IMAGE_TYPE_ERROR_MSG") + "</p>";
                    else {
                        let reader = new FileReader();
                        reader.onload = () => {
                            let id = EntityName.EMAIL;
                            let blobCache = this.editor.editorUpload.blobCache;
                            let base64 = reader.result.toString().split(',')[1];
                            let blobInfo = blobCache.create(id, file, base64);
                            blobCache.add(blobInfo);
                            cb(blobInfo.blobUri(), { title: file.name, alt: file.name });
                            lastHtmlElement.innerHTML = "";
                        };
                        reader.readAsDataURL(file);
                    }
                };
                input.click();
            },
            images_upload_handler: this.uploadHandler,
            setup: (editor) => {
                //Enable common style
                if (this.standardStyle.IsEnabled) {
                    editor.ui.registry.addButton('standardFormat', {
                        icon: 'template',
                        tooltip: this.translateService.instant("LBL_APPLY_STANDARD_STYLE"),
                        onAction: () => {
                            this.applyCommonStandardStyle(editor);
                        }
                    });
                }
                //Automatically apply common-style
                if (this.standardStyle.IsAutoStyleEnabled)
                    this.applyAutomaticCommonStandardStyle(editor);
                editor.on('init', function () {
                    // Pasting content into editor - Optionally, apply CSS to remove any extra spacing around <p> and <br> tags
                    editor.dom.addStyle('.mce-content-body p { margin: 0; padding: 0; }');
                    editor.dom.addStyle('.mce-content-body br { line-height: 1; }');
                });
            }
        };
    }
    applyCommonStandardStyle(editor) {
        if (!editor || !this?.standardStyle)
            return;
        let standardStyle = {
            fontName: this.standardStyle.FontName,
            fontSize: this.standardStyle.FontSize,
            fontColor: this.standardStyle.FontColor
        };
        editor?.formatter?.register?.('standardStyle', {
            inline: 'span',
            styles: {
                'font-family': standardStyle.fontName,
                'font-size': standardStyle.fontSize,
                'color': standardStyle.fontColor
            }
        });
        let selectedNode = editor?.selection?.getNode?.();
        let emailSignatureDiv = editor?.dom?.select?.('#emailSignatureDiv')?.[0];
        if (!editor?.selection?.isCollapsed?.()) {
            if (!emailSignatureDiv || (selectedNode && !emailSignatureDiv.contains(selectedNode))) {
                editor?.formatter?.apply?.('standardStyle');
            }
        }
        else {
            let bodyDivs = editor?.dom?.select?.('#tinymce > div') ?? [];
            bodyDivs.forEach((bodyText) => {
                if (!bodyText)
                    return;
                let elementsToStyle = emailSignatureDiv ? Array.from(bodyText.childNodes).filter((child) => !emailSignatureDiv.contains(child)) : [bodyText];
                elementsToStyle.forEach((element) => {
                    if (!element)
                        return;
                    editor?.selection?.select?.(element, true);
                    editor?.formatter?.apply?.('standardStyle');
                });
            });
        }
    }
    applyAutomaticCommonStandardStyle(editor) {
        if (!editor || typeof editor.on !== 'function')
            return;
        // Register the custom format once on init
        editor.on('init', () => {
            if (!this?.standardStyle)
                return;
            if (!this.standardStyle.FontName && !this.standardStyle.FontSize && !this.standardStyle.FontColor)
                return;
            editor.formatter?.register?.('customStandardStyle', {
                inline: 'span',
                styles: {
                    'font-family': this.standardStyle?.FontName,
                    'font-size': this.standardStyle?.FontSize,
                    'color': this.standardStyle?.FontColor
                },
                exact: true
            });
        });
        // Apply style only when user types actual characters
        editor.on('keypress', (event) => {
            if (!event || typeof event.key !== 'string')
                return;
            let isTypingKey = event.key.length === 1 || event.key === 'Enter' || event.key === 'Backspace';
            if (!isTypingKey)
                return;
            let selectedNode = editor.selection?.getNode?.();
            let emailSignatureDivs = editor.dom?.select?.('#emailSignatureDiv');
            let emailSignatureDiv = Array.isArray(emailSignatureDivs) ? emailSignatureDivs[0] : null;
            if (emailSignatureDiv && selectedNode && emailSignatureDiv.contains(selectedNode))
                return;
            editor.formatter?.apply?.('customStandardStyle');
        });
    }
};
__decorate([
    ViewChild('form')
], EmailBasketComponent.prototype, "form", void 0);
__decorate([
    ViewChild('picker')
], EmailBasketComponent.prototype, "datePicker", void 0);
EmailBasketComponent = __decorate([
    Component({
        selector: 'email-basket',
        templateUrl: './email-basket.component.html',
        styleUrls: ['./email-basket.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], EmailBasketComponent);
export { EmailBasketComponent };
//# sourceMappingURL=email-basket.component.js.map