var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { RoutePath, SideMenuItem } from '../../../../shared/constants';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let EmailAssignComponent = class EmailAssignComponent extends BaseDialogComponent {
    constructor(router, dialog, emailService, sessionManager, shortcutManager, translateService, dialogRef) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.emailService = emailService;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.dateJS = Date;
        this.handlerTags = [];
        this.assignEmailResponseReceived = this.assignEmailResponseReceived.bind(this);
    }
    ngOnInit() {
        try {
            if (this.sessionManager.detailViewCachedEntityList != null && this.sessionManager.detailViewCachedEntityList != undefined) {
                let cachedEntities = this.sessionManager.detailViewCachedEntityList;
                if (cachedEntities != null && cachedEntities.length > 0) {
                    this.cachedEmployeeEntities = new Array();
                    cachedEntities.forEach(value => {
                        let actualEntityType = value.value.replace(/\./g, '_');
                        if (EntityFqdn["" + actualEntityType + ""] == 22)
                            this.cachedEmployeeEntities.push(value.key);
                    });
                }
            }
            this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.assignEmail());
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    handlerTagAdded(tag) {
        let inputbox = $("#handlerTagControl").find("input");
        if (inputbox != undefined && inputbox != null) {
            inputbox[0].attributes["placeholder"].value = "";
            //inputbox[0].style.display = "none";
        }
    }
    ;
    handlerTagRemoved(tag) {
        let inputbox = $("#handlerTagControl").find("input");
        if (inputbox != undefined && inputbox != null) {
            inputbox[0].attributes["placeholder"].value = this.translateService.instant("LBL_SELECT_HANDLER");
            //inputbox[0].removeAttribute("style");
        }
        //if (this.handlerTags != undefined && this.handlerTags != null && this.handlerTags.length > 0)
        //  this.initCalendar();
        //else
        //  this.currentAvailability = new Object();
    }
    ;
    loadItems(query) {
        //deferred = $q.defer();
        //if (query != undefined && query.trim() == "") {
        //  if (this.cachedEmployeeEntities != null && this.cachedEmployeeEntities.length > 0) {
        //    deferred.resolve(this.cachedEmployeeEntities);
        //  }
        //}
        //else {
        //  let handlerList = Array();
        //  handlerList = cacheManager.getEmployeeList(true);
        //  let items = cacheManager.searchHandler(query, handlerList);
        //  deferred.resolve(items);
        //}
        //return deferred.promise;
    }
    ;
    assignEmail() {
        if (this.handlerTags.length === 0 || this.form.invalid)
            return;
        if (this.handlerTags.length > 0) {
            this.startSpinner();
            this.emailService.assignEmail(this.sessionManager.selectedEntity.Id, this.handlerTags[0].Id, this.assignEmailResponseReceived);
        }
        else
            this.linkTypeError = "LBL_MSG_EMPTY_HANDLER";
    }
    ;
    assignEmailResponseReceived(result) {
        this.stopSpinner();
        if (result.Result == 0) {
            this.close();
            this.emailService.selectedEmailOption = this.emailService.lastSelectedEmailOption;
            this.emailService.selectedMailbox = this.emailService.lastSelectedMailbox;
            this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, SideMenuItem.EMAIL]);
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: this.translateService.instant("LBL_MSG_FAIL_ASSIGN_EMAIL") });
    }
    ;
    close() {
        this.dialogRef.close();
    }
};
__decorate([
    ViewChild('form')
], EmailAssignComponent.prototype, "form", void 0);
EmailAssignComponent = __decorate([
    Component({
        selector: 'email-assign',
        templateUrl: './email-assign.component.html',
        styleUrls: ['./email-assign.component.scss']
    })
], EmailAssignComponent);
export { EmailAssignComponent };
//# sourceMappingURL=email-assign.component.js.map