var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ContextMenuView, FieldDataType, FieldGroupLayout } from 'src/app/core/enums/common-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu } from 'src/app/core/models/common/menu';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { BroadCastEventKeys, RoutePath } from '../../../../shared/constants';
import { BaseDetailComponent } from '../../../common/base-detail.component';
let DomainDetailComponent = class DomainDetailComponent extends BaseDetailComponent {
    constructor(router, cacheManager, sessionManager, contextMenuService, domainService, integrationSettingManager, eventProvider, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.router = router;
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.contextMenuService = contextMenuService;
        this.domainService = domainService;
        this.integrationSettingManager = integrationSettingManager;
        this.eventProvider = eventProvider;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.fieldDataTypeEnum = FieldDataType;
        this.fieldGroupLayoutEnum = FieldGroupLayout;
        this.timeoutIds = [];
        this.detailResponse = (domainDto) => {
            this.stopSpinner();
            this.sessionManager.loadedFromRelatedView = false;
            if (domainDto != null) {
                this.menu.addOrUpdateMenuItem(0, "DomainDetail", domainDto.Type, false, true, true);
                this.addMenuItem.emit(this.menu);
                let screen = this.integrationSettingManager.getDomainScreenSetting(domainDto.Type, "Detail");
                this.domainService.initializeData(domainDto, screen);
                this.sessionManager.selectedEntity = domainDto;
                this.sendRelatedRequest.emit();
                //Create ContextMenu if not created since the domain is loaded from deeplinking url               
                if (this.sessionManager.contextMenu == null) {
                    this.sessionManager.loadedFromRelatedView = false;
                    let contentType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn);
                    this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${contentType}/${this.sessionManager.selectedEntity.Id}`;
                    this.sessionManager.addBreadcrumbItems([this.sessionManager.selectedEntity], null, this.router.url);
                    let oldContentType = GlobalFunctions.toContentType(contentType);
                    this.sessionManager.contextMenu = new ContextMenu(oldContentType, contentType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
                }
                this.alignFieldGroups();
            }
        };
        this.detailResponse = this.detailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    ngOnInit() {
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        this.loadDetail();
    }
    ;
    loadDetail() {
        try {
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.Partial == true) {
                let partialDto = new Object();
                partialDto.Id = this.sessionManager.selectedEntity.Id;
                partialDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
                this.domainService.fetchDetail(partialDto, this.detailResponse);
                this.startSpinner();
            }
            else {
                this.menu.addOrUpdateMenuItem(0, "DomainDetail", this.sessionManager.selectedEntity.Type, false, true, true);
                this.addMenuItem.emit(this.menu);
                this.sendRelatedRequest.emit();
                this.alignFieldGroups();
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    alignFieldGroups() {
        this.timeoutIds.push(setTimeout(() => {
            $('div[id^="fieldGroupDetail_"]').each(function (key, element) {
                if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.FieldGroups[key].Layout) && this.sessionManager.selectedEntity.FieldGroups[key].Layout == FieldGroupLayout.Right && key > 0) {
                    let previousElement = $("#fieldGroupDetail_" + (key - 1));
                    let previousElementContainer = previousElement.find(".container");
                    let previousElementTable = !GlobalFunctions.isEmpty(previousElementContainer) ? previousElementContainer : previousElement.find(".table");
                    element = $(element);
                    let elementContainer = element.find(".container");
                    let elementTable = !GlobalFunctions.isEmpty(elementContainer) ? elementContainer : element.find(".table");
                    let maxHeight = elementTable.innerHeight() > previousElementTable.innerHeight() ? elementTable.innerHeight() : previousElementTable.innerHeight();
                    if (maxHeight != null) {
                        element.height(maxHeight + 21);
                        previousElement.height(maxHeight + 21);
                    }
                    previousElement[0].style.clear = 'both';
                }
            });
        }, 300));
    }
    ;
};
DomainDetailComponent = __decorate([
    Component({
        selector: 'domain-detail',
        templateUrl: './domain-detail.component.html',
        styleUrls: ['./domain-detail.component.scss']
    })
], DomainDetailComponent);
export { DomainDetailComponent };
;
//# sourceMappingURL=domain-detail.component.js.map