var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { BroadCastEventKeys, RoutePath } from 'src/app/shared/constants';
import { SubSink } from 'subsink';
import { MessageboxComponent } from '../../../../components/common/messagebox/messagebox.component';
import { FieldDataType, FieldGroupLayout, ScreenMode } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { TaskHandlerType } from '../../../../core/enums/task-enum';
import { DomainFieldDataDto } from '../../../../core/models/domain/domain-fieldDto';
import { DomainRelatedEntityDto } from '../../../../core/models/domain/domain-relation-entityDto';
import { DomainDto } from '../../../../core/models/domain/domainDto';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { EmployeePanelComponent } from '../../employee/panel/employee-panel.component';
let DomainAddEditComponent = class DomainAddEditComponent extends BaseDialogComponent {
    constructor(sessionManager, dialogManager, translateService, ruleService, shortcutManager, domainService, applicationSettingManager, cacheManager, dialog, router, viewContainerRef, eventProvider) {
        super();
        this.sessionManager = sessionManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.ruleService = ruleService;
        this.shortcutManager = shortcutManager;
        this.domainService = domainService;
        this.applicationSettingManager = applicationSettingManager;
        this.cacheManager = cacheManager;
        this.dialog = dialog;
        this.router = router;
        this.viewContainerRef = viewContainerRef;
        this.eventProvider = eventProvider;
        this.fieldDataTypeEnum = FieldDataType;
        this.fieldGroupLayoutEnum = FieldGroupLayout;
        this.showMandatoryField = false;
        this.hasRelations = false;
        this.currentHandlerType = { 'option': "Employee" };
        this.currentHandlerName = '';
        this.handlerTypeOption = null;
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.domainType = null;
        this.domainDto = null;
        this.title = "";
        this.createDomainStatus = "";
        this.subs = new SubSink();
        this.timeoutIds = [];
        this.loadFieldListItems = function (query, field) {
            let items = [];
            if (field.FieldList && !GlobalFunctions.isEmpty(field.FieldList.Entries)) {
                let entryList = field.FieldList.Entries;
                for (let i = 0; i < entryList.length; i++) {
                    if (GlobalFunctions.isEmpty(entryList[i].text))
                        entryList[i].text = entryList[i].Title;
                    if (entryList[i].Visible && entryList[i].text.toLowerCase().indexOf(query.toLowerCase()) > -1)
                        items.push(entryList[i]);
                }
            }
            return items;
        };
        this.createOrUpdateDomainResponse = this.createOrUpdateDomainResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ;
    ngOnInit() {
        try {
            this.ruleService.setHandlerCallback = this.setHandler;
            this.sessionManager.startSessionIfPossible("domain", this.sessionManager.jkcParentPanel.parameters.EditMode ? ScreenMode.Edit : ScreenMode.Add);
            this.domainType = Object.assign({}, jlinq.from(this.sessionManager.jkcParentPanel.parameters.EntitySubType.Screens).equals("Type", "Add").first());
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
            if (!this.sessionManager.jkcParentPanel?.parameters?.EntityObject)
                this.initializeDomain();
            else
                this.initializeEditDomain();
            this.registerDialogShortcutKey();
            this.setHandlerTags();
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ;
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    createOrUpdateDomainResponse(response) {
        this.stopSpinner();
        if (response.Result == 0 && response.Domain != null) {
            this.close(false);
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = response.Domain;
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/domain`;
            this.sessionManager.addBreadcrumbItems([response.Domain], null, RoutePath.DETAIL_PATH);
            this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
            //Add domain object to current session as it is new domain and it should be part of session
            this.sessionManager.addEntityToSession(this.sessionManager.selectedEntity, "Domain");
        }
        else {
            if (response.Result == 2)
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_DOMAIN'), textMsg: this.translateService.instant("LBL_DOMAIN_EXISTS_MESSAGE") });
        }
    }
    ;
    fieldTypeListOnChange(field) {
        $('[name="' + field.Title.replace(/[\s]/g, '') + '"]').removeClass('error');
    }
    fieldListEntryTagAdded(field) {
        let inputbox = $('[name="' + field.Title.replace(/[\s]/g, '') + '"]').find("input");
        if (!GlobalFunctions.isEmpty(inputbox))
            inputbox[0].attributes["placeholder"].value = "";
        $('[name="' + field.Title.replace(/[\s]/g, '') + '"]').removeClass('error');
    }
    ;
    fieldListEntryTagRemoved(field) {
        let inputbox = $('[name="' + field.Title.replace(/[\s]/g, '') + '"]').find("input");
        if (!GlobalFunctions.isEmpty(inputbox) && GlobalFunctions.isEmpty(field.DisplayData))
            inputbox[0].attributes["placeholder"].value = this.translateService.instant("LBL_SELECT_ANY");
    }
    ;
    searchEmployee() {
        this.dialogManager.openJsPanelOrDialog('SEARCH_EMPLOYEE_POPUP_PANEL', null, null, null, this.viewContainerRef, EmployeePanelComponent).afterClosed().subscribe(result => {
            if (result?.selectedEmployee) {
                result.selectedEmployee.text = result.selectedEmployee.StringRepresentation;
                this.handlerTags.push(result.selectedEmployee);
            }
        });
    }
    ;
    handlerTagAdded(tag) {
        this.removeSelectHandlerPlaceholder();
    }
    ;
    removeSelectHandlerPlaceholder() {
        let inputbox = $("#assignHandlerDomainTagsInputControl").find("input");
        if (inputbox != undefined && inputbox != null)
            inputbox[0].attributes["placeholder"].value = "";
    }
    ;
    handlerTagRemoved(tag) {
        let inputbox = $("#assignHandlerDomainTagsInputControl").find("input");
        if (inputbox != undefined && inputbox != null)
            inputbox[0].attributes["placeholder"].value = this.translateService.instant("LBL_SELECT_HANDLER");
    }
    ;
    setHandlerTags() {
        switch (this.currentHandlerType) {
            case 'Employee':
                return this.handlerTagItems = this.cacheManager.getEmployeeList(true);
            case 'Department':
                return this.handlerTagItems = this.cacheManager.getDepartmentList();
            case 'Mailbox':
                return this.handlerTagItems = this.cacheManager.getTaskMailboxList();
        }
    }
    changedHandlerType() {
        this.setHandlerTags();
        this.handlerTags = [];
        document.getElementById('assignHandlerDomainTagsInputControl')?.focus();
    }
    ;
    setHandler(handlerIds, handlerType = "Employee") {
        this.handlerTags.length = 0;
        let handlerIdList = handlerIds.split(';');
        for (let i = 0; i < handlerIdList.length; i++) {
            let handler = null;
            if (handlerType == "Employee")
                handler = this.cacheManager.getEmployeeById(handlerIdList[i]);
            else if (handlerType == "Department")
                handler = this.cacheManager.getDepartmentById(handlerIdList[i]);
            else if (handlerType == "Mailbox")
                handler = this.cacheManager.getTaskMailboxById(handlerIdList[i]);
            if (!GlobalFunctions.isEmpty(handler)) {
                this.handlerTags.push(handler);
                this.currentHandlerType.option = handlerType;
            }
        }
    }
    ;
    //Method:Handler >>
    saveDomain() {
        if (this.handlerTags.length === 0 || this.form.invalid)
            return;
        this.showMandatoryField = false;
        this.createDomainStatus = "";
        this.domainDto.CreatedBy = GlobalFunctions.getLoggedInUserId();
        this.domainDto.HandlerList = new Array();
        if (this.handlerTags != undefined && this.handlerTags != null && this.handlerTags.length > 0) {
            for (let i = 0; i < this.handlerTags.length; i++) {
                let domainHandler = new Object();
                domainHandler.HandlerId = this.handlerTags[i].HandlerId ? this.handlerTags[i].HandlerId : this.handlerTags[i].Id;
                domainHandler.StringRepresentation = this.handlerTags[i].StringRepresentation;
                domainHandler.HandlerType = this.currentHandlerType.option;
                this.domainDto.HandlerList.push(domainHandler);
            }
        }
        ;
        this.domainDto.RelatedEntityList = new Array();
        if (this.hasRelations) {
            let cachedEntities = this.sessionManager.detailViewCachedEntityList;
            if (cachedEntities != null && cachedEntities.length > 0) {
                this.domainDto.RelatedEntityList = new Array();
                cachedEntities.forEach((value, key) => {
                    if (value != undefined && value.key != null && value.key != undefined && value.key.IsMarked) {
                        let actualEntityType = value.value.replace(/\./g, '_');
                        let relatedEntityDto = new DomainRelatedEntityDto();
                        relatedEntityDto.EntityId = value.key.Id;
                        relatedEntityDto.EntityType = EntityFqdn["" + actualEntityType + ""];
                        relatedEntityDto.ObjectSource = value.key.ObjectSource;
                        relatedEntityDto.DomainId = this.domainDto.Id;
                        this.domainDto.RelatedEntityList.push(relatedEntityDto);
                    }
                });
            }
        }
        //>> Add field data list
        if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups)) {
            for (let i = 0; i < this.domainType.FieldGroups.length; i++) {
                if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields)) {
                    for (let j = 0; j < this.domainType.FieldGroups[i].Fields.length; j++) {
                        if (!GlobalFunctions.isEmpty(this.domainDto.Id)) {
                            let domainFieldDataDto = new DomainFieldDataDto();
                            domainFieldDataDto.DomainId = this.domainDto.Id;
                            domainFieldDataDto.FieldId = this.domainType.FieldGroups[i].Fields[j].Id;
                            domainFieldDataDto.FieldType = this.domainType.FieldGroups[i].Fields[j].DataType;
                            domainFieldDataDto.SubFieldId = this.domainType.FieldGroups[i].Fields[j].FieldListId;
                            if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields[j].DisplayData)) {
                                let fieldListEntries = "";
                                for (let k = 0; k < this.domainType.FieldGroups[i].Fields[j].DisplayData.length; k++) {
                                    fieldListEntries += this.domainType.FieldGroups[i].Fields[j].DisplayData[k].Key + ";";
                                }
                                domainFieldDataDto.Data = fieldListEntries.substring(0, fieldListEntries.length - 1);
                                delete this.domainType.FieldGroups[i].Fields[j].DisplayData;
                            }
                            else
                                domainFieldDataDto.Data = this.domainType.FieldGroups[i].Fields[j].Data;
                            this.domainDto.FieldDataList.push(domainFieldDataDto);
                        }
                        else {
                            let editField = jlinq.from(this.domainDto.FieldDataList).equals("FieldId", this.domainType.FieldGroups[i].Fields[j].Id).first();
                            if (editField == null) {
                                let domainFieldDataDto = new DomainFieldDataDto();
                                domainFieldDataDto.DomainId = this.domainDto.Id;
                                domainFieldDataDto.FieldId = this.domainType.FieldGroups[i].Fields[j].Id;
                                domainFieldDataDto.FieldType = this.domainType.FieldGroups[i].Fields[j].DataType;
                                domainFieldDataDto.SubFieldId = this.domainType.FieldGroups[i].Fields[j].FieldListId;
                                if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields[j].DisplayData)) {
                                    let fieldListEntries = "";
                                    for (let k = 0; k < this.domainType.FieldGroups[i].Fields[j].DisplayData.length; k++) {
                                        fieldListEntries += this.domainType.FieldGroups[i].Fields[j].DisplayData[k].Key + ";";
                                    }
                                    domainFieldDataDto.Data = fieldListEntries.substring(0, fieldListEntries.length - 1);
                                    delete this.domainType.FieldGroups[i].Fields[j].DisplayData;
                                }
                                else
                                    domainFieldDataDto.Data = this.domainType.FieldGroups[i].Fields[j].Data;
                                this.domainDto.FieldDataList.push(domainFieldDataDto);
                            }
                            else {
                                if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields[j].DisplayData)) {
                                    let fieldListEntries = "";
                                    for (let k = 0; k < this.domainType.FieldGroups[i].Fields[j].DisplayData.length; k++) {
                                        fieldListEntries += this.domainType.FieldGroups[i].Fields[j].DisplayData[k].Key + ";";
                                    }
                                    editField.Data = fieldListEntries.substring(0, fieldListEntries.length - 1);
                                    delete this.domainType.FieldGroups[i].Fields[j].DisplayData;
                                }
                                else
                                    editField.Data = this.domainType.FieldGroups[i].Fields[j].Data;
                            }
                        }
                    }
                }
            }
        }
        this.domainService.createOrUpdateDomain(this.domainDto, this.createOrUpdateDomainResponse);
        this.startSpinner();
    }
    ;
    registerDialogShortcutKey() {
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.saveDomain());
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel.parameters.TopSpace) - 5 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#addDomainHeader").height() - $("#addDomainFooter").height() + "px";
        $("#addDomainContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
        this.alignFieldGroups();
    }
    alignFieldGroups() {
        $('div[id^="fieldGroup_"]').each((key, element) => {
            if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups[key].Layout) && this.domainType.FieldGroups[key].Layout == FieldGroupLayout.Right && key > 0) {
                let previousElement = $("#fieldGroup_" + (key - 1));
                let previousElementTable = previousElement.find(".table");
                element = $(element);
                let elementTable = element.find(".table");
                let maxHeight = elementTable.innerHeight() > previousElementTable.innerHeight() ? elementTable.innerHeight() : previousElementTable.innerHeight();
                element.height(maxHeight + 31);
                previousElement.height(maxHeight + 31);
                previousElement[0].style.clear = 'both';
            }
        });
    }
    ;
    //common
    initializeDomain() {
        this.domainDto = new DomainDto();
        this.domainDto.Type = this.sessionManager.jkcParentPanel.parameters.EntitySubType.SourceName;
        this.title = this.translateService.instant('LBL_ADD') + " " + this.sessionManager.jkcParentPanel.parameters.EntitySubType.Name;
        if (this.currentHandlerType.option == "Employee")
            this.setHandler(GlobalFunctions.getLoggedInUserId(), "Employee");
        this.domainDto.FieldDataList = [];
        if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups)) {
            this.domainType.FieldGroups = jlinq.from(this.domainType.FieldGroups).sort("Order").select();
            for (let i = 0; i < this.domainType.FieldGroups.length; i++) {
                if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields)) {
                    this.domainType.FieldGroups[i].Fields = jlinq.from(this.domainType.FieldGroups[i].Fields).sort("Order").select();
                    for (let j = 0; j < this.domainType.FieldGroups[i].Fields.length; j++) {
                        if (this.domainType.FieldGroups[i].Fields[j].DataType == FieldDataType.Handler) {
                            this.handlerTypeOption = this.applicationSettingManager.getUIHandlerTypeOption(this.domainType.FieldGroups[i].Fields[j].DataTypeRule);
                            if (this.handlerTypeOption.EmployeeHandler)
                                this.currentHandlerType.option = "Employee";
                            else if (this.handlerTypeOption.DepartmentHandler)
                                this.currentHandlerType.option = "Department";
                            else if (this.handlerTypeOption.MailboxHandler)
                                this.currentHandlerType.option = "Mailbox";
                        }
                        else if (this.domainType.FieldGroups[i].Fields[j].DataType == FieldDataType.ListMultiSelect) {
                            if (this.domainType.FieldGroups[i].Fields[j].FieldList && !GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields[j].FieldList.Entries)) {
                                for (let k = 0; k < this.domainType.FieldGroups[i].Fields[j].FieldList.Entries.length; k++)
                                    this.domainType.FieldGroups[i].Fields[j].FieldList.Entries[k].text = this.domainType.FieldGroups[i].Fields[j].FieldList.Entries[k].Title;
                                if (GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields[j].DisplayData))
                                    this.domainType.FieldGroups[i].Fields[j].DisplayData = [];
                            }
                        }
                        else if (this.domainType.FieldGroups[i].Fields[j].DataType == FieldDataType.Relations)
                            this.hasRelations = true;
                    }
                }
            }
        }
        this.resetFieldListEntriesVisibility();
    }
    ;
    initializeEditDomain() {
        this.domainDto = jQuery.extend(true, {}, this.sessionManager.jkcParentPanel.parameters.EntityObject);
        this.title = this.translateService.instant('LBL_EDIT') + " " + this.sessionManager.jkcParentPanel.parameters.EntitySubType.Name;
        if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups)) {
            for (let i = 0; i < this.domainType.FieldGroups.length; i++) {
                if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields)) {
                    for (let j = 0; j < this.domainType.FieldGroups[i].Fields.length; j++) {
                        if (this.domainType.FieldGroups[i].Fields[j].DataType == FieldDataType.DateTime)
                            this.domainType.FieldGroups[i].Fields[j].Data = GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields[j].Data) ? null : new Date(this.domainType.FieldGroups[i].Fields[j].Data);
                        else if (this.domainType.FieldGroups[i].Fields[j].DataType == FieldDataType.Handler)
                            this.handlerTypeOption = this.applicationSettingManager.getUIHandlerTypeOption(this.domainType.FieldGroups[i].Fields[j].DataTypeRule);
                        else if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields[j].DataType) && this.domainType.FieldGroups[i].Fields[j].DataType == FieldDataType.ListMultiSelect && this.domainType.FieldGroups[i].Fields[j].FieldList && !GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields[j].FieldList.Entries)) {
                            for (let k = 0; k < this.domainType.FieldGroups[i].Fields[j].FieldList.Entries.length; k++)
                                this.domainType.FieldGroups[i].Fields[j].FieldList.Entries[k].text = this.domainType.FieldGroups[i].Fields[j].FieldList.Entries[k].Title;
                        }
                        else if (this.domainType.FieldGroups[i].Fields[j].DataType == FieldDataType.Boolean)
                            this.domainType.FieldGroups[i].Fields[j].Data = this.domainType.FieldGroups[i].Fields[j].Data == "true" ? true : false;
                        else if (this.domainType.FieldGroups[i].Fields[j].DataType == FieldDataType.Relations)
                            this.hasRelations = true;
                    }
                }
            }
        }
        //Handler
        for (let h = 0; h < this.domainDto.HandlerList?.length; h++) {
            let handler = this.domainDto.HandlerList[h];
            let handlerData = null;
            if (handler.HandlerType == TaskHandlerType.Department || handler.HandlerType == "Department") {
                handlerData = this.cacheManager.getDepartmentById(handler.HandlerId);
                handler.EntityType = 2;
                this.currentHandlerType.option = "Department";
            }
            else if (handler.HandlerType == TaskHandlerType.Employee || handler.HandlerType == "Employee") {
                handlerData = this.cacheManager.getEmployeeById(handler.HandlerId);
                handler.EntityType = 1;
                this.currentHandlerType.option = "Employee";
            }
            else if (handler.HandlerType == TaskHandlerType.Mailbox || handler.HandlerType == "Mailbox") {
                handlerData = this.cacheManager.getTaskMailboxById(handler.HandlerId);
                handler.EntityType = 3;
                this.currentHandlerType.option = "Mailbox";
            }
            handler.text = handlerData != null ? handlerData.StringRepresentation : "";
            this.handlerTags.push(handler);
        }
    }
    ;
    resetFieldListEntriesVisibility() {
        if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups)) {
            for (let i = 0; i < this.domainType.FieldGroups.length; i++) {
                if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields)) {
                    for (let j = 0; j < this.domainType.FieldGroups[i].Fields.length; j++) {
                        if (!GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields[j]) && (this.domainType.FieldGroups[i].Fields[j].DataType == FieldDataType.List || this.domainType.FieldGroups[i].Fields[j].DataType == FieldDataType.ListMultiSelect) && !GlobalFunctions.isEmpty(this.domainType.FieldGroups[i].Fields[j].FieldList.Entries)) {
                            for (let e = 0; e < this.domainType.FieldGroups[i].Fields[j].FieldList.Entries.length; e++) {
                                this.domainType.FieldGroups[i].Fields[j].FieldList.Entries[e].Visible = true;
                            }
                        }
                    }
                }
            }
        }
    }
    ;
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close(false);
    }
    ;
    addFileErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_ADD_ERROR_MSG"), [this.translateService.instant("LBL_FILE")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBLL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_FILE"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    ;
    showMessageBox(header, message) {
        let messageInfo = DialogHelper.getMessage(header, message, true, null, null, null, null, this.translateService);
        return DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
    }
    close(result) {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
};
__decorate([
    ViewChild('form')
], DomainAddEditComponent.prototype, "form", void 0);
DomainAddEditComponent = __decorate([
    Component({
        selector: 'domain-add-edit',
        templateUrl: './domain-add-edit.component.html',
        styleUrls: ['./domain-add-edit.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], DomainAddEditComponent);
export { DomainAddEditComponent };
//# sourceMappingURL=domain-add-edit.component.js.map