var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseSearchResultComponent } from 'src/app/components/common/base-search-result.component';
import { AlternateSearchType } from 'src/app/core/enums/common-enums';
import { SearchResultSource } from 'src/app/core/enums/search-result-source.enum';
import { BroadCastEventKeys, EntityName, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
let DocumentSearchResultComponent = class DocumentSearchResultComponent extends BaseSearchResultComponent {
    constructor(activatedRoute, router, translateService, documentService, sessionManager, searchService, sortManager, changeDetectorRef, cacheManager, eventProvider, applicationSettingManager, employeeService, formatManager, localSearchResultDataService, integrationSettingManager, datePipe) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.translateService = translateService;
        this.documentService = documentService;
        this.sessionManager = sessionManager;
        this.searchService = searchService;
        this.sortManager = sortManager;
        this.changeDetectorRef = changeDetectorRef;
        this.cacheManager = cacheManager;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.localSearchResultDataService = localSearchResultDataService;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.searchQuery = '';
        this.selectDeSelectAllText = this.translateService.instant('LBL_SELECT_ALL');
        this.loggedInUserId = '';
        this.searchStatusContainerId = '';
        this.searchDocumentCompletedStatus = this.searchDocumentCompletedStatus.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = EntityName.DOCUMENT;
        this.resultList = [];
        this.filteredSearchResult = [];
        this.loggedInUserId = GlobalFunctions.getLoggedInUserId();
        try {
            if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "document") {
                this.sourceCount = 0;
                this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
                this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
                this.localSearchResultDataService.localSearchResultData.localResult = [];
                this.localSearchResultDataService.localSearchResultData.contentType = "";
            }
            else {
                this.resultCount = 0;
                this.alternateSearchSources = [];
                this.searchStatusMessage = '';
                if (this.router.url.indexOf(RoutePath.DASHBOARD) === -1) {
                    if (this.searchService.isAdvancedSearch)
                        this.advanceSearchDocument();
                    else
                        this.searchDocument();
                }
                else
                    this.searchPendingDocument();
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
        this.searchStatusQuery = "";
    }
    searchPendingDocument() {
        this.searchStatusQuery = this.sessionManager.pendingCount.DocumentTitle;
        this.updateSearchStatus(this.activeHandlersObj);
        this.documentService.searchPendingDocument(this.searchResultFound, this.searchStartedStatus, this.searchDocumentCompletedStatus);
    }
    searchDocument() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.documentService.search(this.searchStatusQuery, false, AlternateSearchType.None, this.searchService.selectedSearchOption?.sourceLocation, "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived);
    }
    advanceSearchDocument() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.documentService.advancedSearch(this.searchService.advancedSearchOption.searchDto, AlternateSearchType.None, this.searchService.advancedSearchOption.sourceLocation, "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived);
        this.searchStatusQuery = this.searchService.advancedSearchQuery;
    }
    selectDocument(document, event) {
        if (this.searchResultSource == SearchResultSource.Dashboard) {
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.setBreadcrumbGrammer(document);
            this.sessionManager.selectedEntity = document;
            this.sessionManager.addBreadcrumbItems(this.resultList, document, this.router.url);
        }
        this.select(document, event);
    }
    fetchSourceCaption(document) {
        this.sessionManager.fetchSourceCaption(document.additionalObjectSource, null);
    }
    alternateSearch(item) {
        this.resultList = [];
        this.filteredSearchResult = [];
        this.alternateSearchSources = [];
        this.alternateSearchSuggestions = [];
        if (this.searchService.isAdvancedSearch)
            this.documentService.advancedSearch(this.searchService.advancedSearchOption.searchDto, AlternateSearchType.AlternateHandlerSearch, "", item.Handler, this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived);
        else
            this.documentService.search(this.searchStatusQuery, false, AlternateSearchType.AlternateHandlerSearch, "", item.Handler, this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived);
    }
    alternateSearchSuggestion(item) {
        this.alternateSearchSources = [];
        this.alternateSearchSuggestions = [];
        this.searchQuery = item;
        this.searchStatusQuery = item;
        this.documentService.search(item, false, AlternateSearchType.None, "", "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived);
        this.sendResultCount.emit(this.resultList.length);
    }
    searchDocumentCompletedStatus(message) {
        console.log('DocumentController->updateSearchStatus:', message);
        this.sourceCount = 0;
        this.sessionManager.pendingCount.DocumentCount = this.resultList.length;
        this.updateSearchStatus({ ActiveHandlers: [] });
    }
    lockUnlockDocument(event, document) {
        event.stopPropagation();
        event.cancelBubble = false;
        let checkbox = event.target;
        if (checkbox.checked) {
            let handlerObject = this.cacheManager.getEmployeeById(GlobalFunctions.getLoggedInUserId());
            document.HandlerName = handlerObject.StringRepresentation;
            document.HandlerId = GlobalFunctions.getLoggedInUserId();
            document.HandlerBySelf = true;
            this.documentService.lockDocument(document.Id);
        }
        else {
            document.HandlerName = "";
            document.HandlerId = "";
            document.HandlerBySelf = false;
            this.documentService.unlockDocument(document.Id);
        }
    }
    hasDashboardView() {
        if (this.searchResultSource == SearchResultSource.Dashboard)
            return true;
        else
            return false;
    }
    initializeSearchStatus() {
        if (this.localSearchResultDataService.localSearchResultData.localResult.length == 0 || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() != "documents") {
            this.searchStatusContainerId = "dashboardContainer";
            this.sourceCount = null;
            this.searchStatusMessage = this.translateService.instant('LBL_SEARCHING_STARTED');
        }
        if (this.localSearchResultDataService.localSearchResultData && this.localSearchResultDataService.localSearchResultData.localResult && this.localSearchResultDataService.localSearchResultData.localResult.length > 0)
            this.sessionManager.pendingCount.DocumentCount = this.localSearchResultDataService.localSearchResultData.localResult.length;
    }
};
DocumentSearchResultComponent = __decorate([
    Component({
        selector: 'document-search-result',
        templateUrl: './document-search-result.component.html',
        styleUrls: ['./document-search-result.component.scss']
    })
], DocumentSearchResultComponent);
export { DocumentSearchResultComponent };
//# sourceMappingURL=document-search-result.component.js.map