var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { ScannerSettingDto } from 'src/app/core/models/document/scanner-setting-dto';
import { LanaguageCode, Locale } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
let ScanBasketComponent = class ScanBasketComponent extends BaseDialogComponent {
    constructor(sessionManager, basketService, translateService, dialog, dialogRef) {
        super();
        this.sessionManager = sessionManager;
        this.basketService = basketService;
        this.translateService = translateService;
        this.dialog = dialog;
        this.dialogRef = dialogRef;
        this.scannerSetting = new ScannerSettingDto();
        this.scannerList = [];
        this.formatList = [];
        this.resolutionList = [];
        this.heightList = [];
        this.widthList = [];
        this.scanStarted = false;
        this.fileName = null;
        this.scannedResponse = null;
        this.timeoutIds = [];
        this.searchScannerResponse = this.searchScannerResponse.bind(this);
    }
    ngOnInit() {
        try {
            this.timeoutIds.push(setTimeout(() => {
                console.log("State " + this.sessionManager.contactSessionNotesState.UIState);
                this.resize();
            }, 50));
            this.initialize();
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, e, true);
        }
    }
    ngOnDestroy() {
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    searchScannerResponse(response) {
        if (response != null && response.ScannerList != null && response.ScannerList.length > 0) {
            this.scannerList = response.ScannerList;
            this.scannerSetting.Name = this.scannerList[0];
            this.showSpinner = false;
        }
        else {
            this.showSpinner = true;
            setTimeout(() => {
                this.showSpinner = false;
            }, 2000);
        }
    }
    select() {
        if (this.scannedResponse != null) {
            let option = new Object();
            option.FileName = this.scannedResponse.FileName;
            option.FilePath = this.scannedResponse.FilePath;
            this.dialogRef.close(option);
        }
        else
            this.errorMessage = this.translateService.instant("LBL_MSG_NO_SCAN_AVAILABLE");
    }
    scanBasket() {
        if (GlobalFunctions.isEmpty(this.scannerSetting.Name))
            this.errorMessage = this.translateService.instant("LBL_MSG_SELECT_SCANNER");
        else {
            this.errorMessage = "";
            this.scanStarted = true;
            this.startSpinner();
            this.basketService.scanBasket(this.scannerSetting, this.scanBaksetResponse);
        }
    }
    scanBaksetResponse(response) {
        this.scanStarted = false;
        this.stopSpinner();
        if (response != null && !GlobalFunctions.isEmpty(response.FileName)) {
            this.scannedResponse = response;
            this.fileName = "/CachedData/Scan/" + response.FileName;
        }
    }
    resize() {
        let windowHeight = $(window).height();
        let newHeight = windowHeight - $("#scanBasketHeader").height() - $("#scanBasketFooter").height() - 65 + "px";
        $("#scanBasketContainer").height(535 + "px");
    }
    initialize() {
        this.formatList.push("PDF");
        this.formatList.push("PNG");
        this.formatList.push("JPEG");
        this.formatList.push("TIFF");
        this.resolutionList.push("100");
        this.resolutionList.push("150");
        this.resolutionList.push("175");
        this.resolutionList.push("200");
        this.heightList.push("1100");
        this.heightList.push("1700");
        this.heightList.push("1600");
        this.widthList.push("850");
        this.widthList.push("1250");
        this.widthList.push("1200");
        this.scannerSetting.Name = "";
        this.scannerSetting.Format = "JPEG";
        this.scannerSetting.Resolution = "100";
        this.scannerSetting.Height = "1100";
        this.scannerSetting.Width = "850";
        this.scannerSetting.Mode = "1";
        this.basketService.searchScanner(this.searchScannerResponse);
    }
    getLanguageCode() {
        let locale = Locale.NL_NL;
        if (navigator.language === LanaguageCode.EN_CODE) {
            locale = Locale.EN_EN;
        }
        return locale;
    }
    close() {
        this.dialogRef.close();
    }
};
ScanBasketComponent = __decorate([
    Component({
        selector: 'scan-basket',
        templateUrl: './scan-basket.component.html',
        styleUrls: ['./scan-basket.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], ScanBasketComponent);
export { ScanBasketComponent };
//# sourceMappingURL=scan-basket.component.js.map