var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDetailComponent } from 'src/app/components/common/base-detail.component';
import { ContextMenuView } from 'src/app/core/enums/common-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu } from 'src/app/core/models/common/menu';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { BroadCastEventKeys } from '../../../../shared/constants';
let DocumentDetailComponent = class DocumentDetailComponent extends BaseDetailComponent {
    constructor(sessionManager, documentService, systemComponentService, integrationSettingManager, eventProvider, phoneManager, dialogManager, translateService, contextMenuService) {
        super(phoneManager, dialogManager, translateService);
        this.sessionManager = sessionManager;
        this.documentService = documentService;
        this.systemComponentService = systemComponentService;
        this.integrationSettingManager = integrationSettingManager;
        this.eventProvider = eventProvider;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.contextMenuService = contextMenuService;
        this.documentDetailFound = this.documentDetailFound.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    ngOnInit() {
        if (this.sessionManager.selectedEntity != null)
            this.sessionManager.addItemToSession(this.sessionManager.selectedEntity);
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        this.menu.addOrUpdateMenuItem(0, "DocumentDetail", this.translateService.instant("LBL_DOCUMENT"), false, true, true);
        this.addMenuItem.emit(this.menu);
        this.sendRelatedRequest.emit();
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity)) {
            if (this.sessionManager.selectedEntity.Partial == true) {
                let partialDto = new Object();
                partialDto.Id = this.sessionManager.selectedEntity.Id;
                partialDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
                this.documentService.fetchDetail(partialDto, this.documentDetailFound);
                this.startSpinner();
            }
            this.systemComponentService.lockEntity(this.sessionManager.selectedEntity.Id, this.sessionManager.selectedEntity.RelatedEntityFqdn, null);
        }
    }
    documentDetailFound(result) {
        this.stopSpinner();
        if (result != null && result.length > 0)
            this.sessionManager.selectedEntity = result[0];
    }
};
DocumentDetailComponent = __decorate([
    Component({
        selector: 'document-detail',
        templateUrl: './document-detail.component.html',
        styleUrls: ['./document-detail.component.scss']
    })
], DocumentDetailComponent);
export { DocumentDetailComponent };
//# sourceMappingURL=document-detail.component.js.map