var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { MessageboxComponent } from 'src/app/components/common/messagebox/messagebox.component';
import { SearchPopupComponent } from 'src/app/components/common/search-popup/search-popup.component';
import { DocumentMethod, DOCUMENTMETHOD, OperationType, RecordSelection } from 'src/app/core/enums/common-enums';
import { EntityFqdn } from 'src/app/core/enums/core-enums';
import { EmailSource } from 'src/app/core/enums/global-enum';
import { BaseDto } from 'src/app/core/models/common/baseDto';
import { SearchObject } from 'src/app/core/models/common/search-objectDto';
import { AddDocumentAsEmailRequest } from 'src/app/core/models/document/add-document-as-email-request';
import { AddNewDocumentRequest } from 'src/app/core/models/document/add-new-document-request';
import { DocumentDto } from 'src/app/core/models/document/documentDto';
import { FileDocumentDto } from 'src/app/core/models/document/file-documentDto';
import { TicketRelatedEntityDto } from 'src/app/core/models/ticket/ticket-related-entityDto';
import { BroadCastEventKeys, EntityName, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { JkcPanel } from 'src/app/shared/helper/jkc-panel-helper';
import { SubSink } from 'subsink';
import { OrganizationAddEditComponent } from '../../organization/add-edit/organization-add-edit.component';
import { RepresentativeAddComponent } from '../../organization/add-representative/organization-add-representative.component';
import { PersonAddEditComponent } from '../../person/add-edit/person-add-edit.component';
import { ScanBasketComponent } from '../scan-basket/scan-basket.component';
let DocumentAddComponent = class DocumentAddComponent extends BaseDialogComponent {
    constructor(sessionManager, shortcutManager, translateService, dialogManager, applicationSettingManager, personService, cacheManager, ticketService, organizationService, integrationSettingManager, documentService, dialog, viewContainerRef, router, eventProvider) {
        super();
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.dialogManager = dialogManager;
        this.applicationSettingManager = applicationSettingManager;
        this.personService = personService;
        this.cacheManager = cacheManager;
        this.ticketService = ticketService;
        this.organizationService = organizationService;
        this.integrationSettingManager = integrationSettingManager;
        this.documentService = documentService;
        this.dialog = dialog;
        this.viewContainerRef = viewContainerRef;
        this.router = router;
        this.eventProvider = eventProvider;
        this.title = this.translateService.instant('LBL_ADD_DOCUMENT').toUpperCase();
        this.DateJS = Date;
        this.relationType = 'Person';
        this.isOpenInSourceEnabled = true;
        this.documentDto = new DocumentDto();
        this.relationTypeItems = [];
        this.representatives = [];
        this.linkTypeError = "";
        this.enabledEditContact = false;
        this.relatedEntities = [];
        this.fileDocuments = [];
        this.template = { 'Key': '' };
        this.mergeTemplates = [];
        this.fetchingTemplates = true;
        this.FetchingDocumentType = false;
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.isTemplateEnable = false;
        this.docMethod = null;
        this.selectedEmail = null;
        this.selectedFindFrom = "";
        this.caseTags = [];
        this.documentTypeList = [];
        this.isNameEmpty = false;
        this.files = [];
        this.formSubmitted = false;
        this.subs = new SubSink();
        this.rights = {
            organization: false,
            person: false
        };
        this.timeoutIds = [];
        this.enableDepartmentNameInHandler = this.applicationSettingManager.isDepartmentNameInHandlerEnabled();
        this.createDocumentResponse = this.createDocumentResponse.bind(this);
        this.addPersonResponse = this.addPersonResponse.bind(this);
        this.addOrganizationResponse = this.addOrganizationResponse.bind(this);
        this.onDocumentTypesSuccessResponse = this.onDocumentTypesSuccessResponse.bind(this);
        this.createDocumentErrorCallback = this.createDocumentErrorCallback.bind(this);
        this.onGetMergeTemplatesResponse = this.onGetMergeTemplatesResponse.bind(this);
        this.relatedRepresentatives = this.relatedRepresentatives.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        this.setRights();
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.RelatedEntityFqdn == EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email])
            this.selectedEmail = this.sessionManager.selectedEntity;
        this.sessionManager.jkcParentPanel.parameters.Scope = this;
        let collectionId = null;
        let ticketId = null;
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.ObjectSource) && (this.sessionManager.selectedEntity.ObjectSource.toLowerCase().indexOf("ticket") > -1)) {
            collectionId = this.sessionManager.selectedEntity.TicketType.Title;
            ticketId = this.sessionManager.selectedEntity.Id;
        }
        this.documentService.getMergeTemplates(ticketId, collectionId, this.onGetMergeTemplatesResponse);
        try {
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
            if (this.selectedEmail != null) {
                this.documentDto.Subject = this.selectedEmail.Header.Subject;
                if (this.selectedEmail.Body != null)
                    this.documentDto.AdditionalInfo = this.selectedEmail.Body.IsBodyHtml ? String(this.selectedEmail.Body.Body).replace(/<[^>]+>/gm, '') : this.selectedEmail.Body.Body;
            }
            this.selectDefaultRelationTypeOption();
            this.registerDialogShortcutKey();
            let getDocumentMethodSettings = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Documents_Entities_Document, "DOCUMENTMETHOD");
            let isTemplateEnableStr = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Documents_Entities_Document, "ENABLETEMPLATE");
            this.isTemplateEnable = !GlobalFunctions.isEmpty(isTemplateEnableStr) && isTemplateEnableStr.toLowerCase() == "true" ? true : false;
            if (!GlobalFunctions.isEmpty(getDocumentMethodSettings)) {
                this.docMethod = getDocumentMethodSettings;
                this.assignSettingToUI(this.docMethod);
            }
            else
                console.log("Document integration setting is empty");
            this.handlerTagItems = this.cacheManager.getEmployeeList(true);
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, null, true, e.message, "");
        }
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    setRights() {
        this.rights.organization = GlobalFunctions.checkRights('Organization', 3);
        this.rights.person = GlobalFunctions.checkRights('Person', 3);
    }
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel.parameters.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#addDocumentHeader").height() - $("#addDocumentFooter").height() + "px";
        $("#addDocumentContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
        let formheight = $("#createDocumentForm").height();
        $("#emailSection").height(formheight);
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close(false);
    }
    assignSettingToUI(docMethod) {
        switch (docMethod) {
            case "0":
                this.documentMethodSetting = 'Document';
                this.documentMethod = 'Document';
                break;
            case "1":
                this.documentMethodSetting = 'CaseBaseDocument';
                this.documentMethod = 'CaseBaseDocument';
                break;
            case "2":
                this.documentMethodSetting = 'Both';
                this.documentMethod = 'Document';
                break;
        }
        if (docMethod != "0") {
            //Pre-Fill Case, if any loaded in the current session
            let result = GlobalFunctions.getLastCaseFromSession(this.sessionManager.detailViewCachedEntityList);
            if (result != null && !GlobalFunctions.isEmpty(result)) {
                this.documentMethod = 'CaseBaseDocument';
                this.preFillLastCase(result);
            }
        }
    }
    onGetMergeTemplatesResponse(response) {
        if (response.MergeTemplates)
            this.mergeTemplates = response.MergeTemplates;
        this.fetchingTemplates = false;
    }
    changeRelationType() {
        this.selectedRepresentative = null;
        this.selectedFindFrom = 'Anonymous';
        this.changeFindFrom();
    }
    ;
    registerDialogShortcutKey() {
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.createDocument());
    }
    changeFindFrom() {
        this.enabledEditContact = false;
        this.relationTypeItems = [];
        this.representatives = [];
        $("#selectedPersonOrOrganization").removeAttr("disabled");
        switch (this.selectedFindFrom) {
            case "Anonymous":
                {
                    $("#selectedPersonOrOrganization").attr("disabled", "true");
                    $("#selectedRepresentative").attr("disabled", "true");
                    break;
                }
            case "Related":
                {
                    this.fillRelatedEntities();
                    break;
                }
            case "Search":
                {
                    this.openSearchPopup(this.relationType, "RelationType");
                    this.selectedFindFrom = "SelectAny";
                    break;
                }
            case "RegisterNew":
                {
                    if (this.relationType == "Organization") {
                        if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                            this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addOrganizationHeader', 'addOrganizationFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                            this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                            this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.addOrganizationResponse;
                            this.dialogManager.openJkcChildPanelDialogue(OrganizationAddEditComponent, 'addOrganizationContainer', this.viewContainerRef);
                        }
                        else
                            DialogHelper.getMessage(this.translateService.instant("LBL_APPLICATION_TITLE"), this.translateService.instant("LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE"), false, null, null, null, null, this.translateService);
                        $("#selectedRepresentative").attr("disabled", "true");
                    }
                    else if (this.relationType == "Person") {
                        if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                            this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addPersonHeader', 'addPersonFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                            this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                            this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.addPersonResponse;
                            this.dialogManager.openJkcChildPanelDialogue(PersonAddEditComponent, 'addPersonContainer', this.viewContainerRef);
                        }
                        else
                            DialogHelper.getMessage(this.translateService.instant("LBL_APPLICATION_TITLE"), this.translateService.instant("LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE"), false, null, null, null, null, this.translateService);
                        $("#selectedRepresentative").attr("disabled", "true");
                    }
                    else {
                        $("#selectedPersonOrOrganization").attr("disabled", "true");
                        $("#selectedRepresentative").attr("disabled", "true");
                    }
                    break;
                }
        }
        if (this.selectedFindFrom != 'ManualEntry')
            this.documentDto.PrimarySubjectName = "";
    }
    addPersonResponse(selectedEntity) {
        this.setMainEntity(selectedEntity, "Person");
        this.registerDialogShortcutKey();
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.findFromSelectOption.nativeElement.focus();
    }
    addOrganizationResponse(selectedEntity) {
        this.setMainEntity(selectedEntity, "Organization");
        this.registerDialogShortcutKey();
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.findFromSelectOption.nativeElement.focus();
    }
    relatedRepresentatives(result) {
        if (result?.length > 0) {
            const getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
            if (!GlobalFunctions.isEmpty(getGrammerValue)) {
                for (let i = 0; i < result.length; i++) {
                    GlobalFunctions.setStringPresentation(result[i], getGrammerValue);
                    this.representatives.push(result[i]);
                }
                this.selectedRepresentative = this.representatives[this.representatives.length - 1];
            }
        }
    }
    ;
    addDefaultRepresentative() {
        this.representatives.push({ StringRepresentation: this.translateService.instant("LBL_NEW"), value: "new" });
    }
    changeRepresentative() {
        if (this.selectedRepresentative?.value?.toUpperCase() == "NEW") {
            if (this.relationType == "Organization") {
                DialogHelper.openDialog(this.dialog, RepresentativeAddComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { organizationId: this.selectedRelationTypeItem?.Id || '', editMode: false }).afterClosed().subscribe(representative => {
                    if (representative) {
                        this.relatedRepresentatives([representative]);
                        this.selectedRepresentative = representative;
                        this.registerDialogShortcutKey();
                    }
                });
            }
        }
    }
    showPersonDeceasedWarning(personEntity) {
        if (personEntity.Details == null || !GlobalFunctions.isPersonDeceased(personEntity.Details.DateOfExpiration))
            return;
        let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_CALLBACK_NOTE"), this.translateService.instant("LBL_WARNING_PERSON_DECEASED"), true, null, null, null, null, this.translateService);
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
            if (!result)
                this.relationTypeItems = [];
        });
    }
    setMainEntity(searchEntity, relationType) {
        if (searchEntity) {
            this.relationTypeItems = [];
            if (relationType == 'Person') {
                if (GlobalFunctions.isPersonDeceased(searchEntity.Details.DateOfExpiration))
                    this.showPersonDeceasedWarning(searchEntity);
                GlobalFunctions.setStringPresentation(searchEntity, this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote"));
            }
            else {
                $("#selectedRepresentative").removeAttr("disabled");
                if (GlobalFunctions.hasRight(GlobalFunctions.toContentType("Person"), OperationType.Add))
                    this.addDefaultRepresentative();
                searchEntity.StringRepresentation = searchEntity.Name;
                this.personService.clearCallbacks();
                this.personService.searchRelatedRepresentativeRequest(this.relatedRepresentatives, searchEntity);
            }
            this.relationTypeItems.push(searchEntity);
            this.selectedRelationTypeItem = searchEntity;
        }
    }
    onUpload(files) {
        this.startSpinner();
        let fileDocument = new Object();
        fileDocument.Text = files.name;
        fileDocument.NameOnServer = "";
        this.fileDocuments.push(fileDocument);
        this.errorMessage = '';
    }
    onError(response) {
        this.fileDocuments.splice(this.fileDocuments.length - 1, 1);
        this.errorMessage = GlobalFunctions.getFileUploadErrorText(response, this.translateService);
        this.stopSpinner();
    }
    onSuccess(response) {
        this.fileDocuments[this.fileDocuments.length - 1].NameOnServer = response[0].fileName;
        this.errorMessage = '';
        this.stopSpinner();
    }
    openSearchPopup(entity, type) {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: entity, recordSelection: RecordSelection.Single }).afterClosed().subscribe(searchEntity => {
            if (type == "Case") {
                if (searchEntity != null) {
                    GlobalFunctions.setPlaceholder("#caseControl", "");
                    this.caseTags = [];
                    searchEntity.StringRepresentation = searchEntity.Description;
                    searchEntity.text = searchEntity.StringRepresentation;
                    this.caseTags.push(searchEntity);
                    if (entity === "CaseEntity") {
                        this.documentDto.CaseId = searchEntity.Id;
                        this.getDocumentTypes(searchEntity.CaseTypeId);
                    }
                }
                $("#searchCaseButton").focus();
            }
            else {
                if (type == "RelationType") {
                    if (searchEntity)
                        this.setMainEntity(searchEntity, entity);
                    $("#findFromSelectOption").focus();
                }
            }
        });
    }
    createDocumentAsEmailErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_ERROR_MSG"), [this.translateService.instant("LBL_DOCUMENT")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_DOCUMENT"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    createDocumentErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_ERROR_MSG"), [this.translateService.instant("LBL_DOCUMENT")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_DOCUMENT"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    createDocument() {
        this.formSubmitted = true;
        if ((this.documentMethod === 'CaseBaseDocument' && this.caseTags.length === 0) || (this.documentMethod === 'Document' && this.handlerTags.length === 0) || this.form.invalid)
            return;
        this.relatedEntities = [];
        if (!GlobalFunctions.isEmpty(this.handlerTags) && this.handlerTags.length > 0)
            this.documentDto.HandlerName = this.handlerTags[0].StringRepresentation;
        if (this.relationType == 'Person' && this.selectedRelationTypeItem != null)
            this.documentDto.PrimarySubjectName = this.selectedRelationTypeItem.StringRepresentation;
        let relationTypeItem = this.selectedRelationTypeItem;
        if (relationTypeItem != null)
            this.addItemToRelatedEntityObjects(relationTypeItem, true);
        if (this.sessionManager.detailViewCachedEntityList != null && this.sessionManager.detailViewCachedEntityList.length > 0) {
            this.sessionManager.detailViewCachedEntityList.forEach(value => {
                if (value != undefined && value.key != null && value.key != undefined && value.key.IsMarked)
                    this.addItemToRelatedEntityObjects(value.key, false);
            });
        }
        this.startSpinner();
        if (this.selectedEmail == null) {
            let addDocumentRequest = new AddNewDocumentRequest();
            addDocumentRequest.DocumentDto = this.documentDto;
            addDocumentRequest.RelatedEntities = this.relatedEntities;
            addDocumentRequest.FileDocuments = this.getFileDocuments();
            addDocumentRequest.DocumentMethod = DOCUMENTMETHOD[this.documentMethod];
            addDocumentRequest.TemplateKey = this.template.Key;
            this.documentService.createDocument(addDocumentRequest, this.createDocumentResponse, this.createDocumentErrorCallback);
        }
        else {
            this.selectedEmail.AttachmentList = null;
            let addDocumentAsEmailRequest = new AddDocumentAsEmailRequest();
            this.documentDto.DocumentMethod = DocumentMethod[this.documentMethod];
            addDocumentAsEmailRequest.Document = this.documentDto;
            if (this.selectedEmail.Header != null)
                addDocumentAsEmailRequest.EmailId = this.selectedEmail.Header.Uid;
            addDocumentAsEmailRequest.RelatedEntities = this.relatedEntities;
            addDocumentAsEmailRequest.FileDocuments = this.getFileDocuments();
            this.documentService.createDocumentAsEmail(addDocumentAsEmailRequest, this.createDocumentResponse, this.createDocumentAsEmailErrorCallback);
        }
    }
    getFileDocuments() {
        let fileDocumentDtos = [];
        if (this.fileDocuments != null && this.fileDocuments.length > 0) {
            for (let index = 0; index < this.fileDocuments.length; index++) {
                let file = new FileDocumentDto();
                file.FileName = this.fileDocuments[index].NameOnServer;
                file.Description = this.fileDocuments[index].Text;
                fileDocumentDtos.push(file);
            }
        }
        return fileDocumentDtos;
    }
    linkEntityCallBack(response) {
        if (response.Result == 0) {
            if (response.FromHandler != null && response.FromHandler.toLowerCase().indexOf("ticket") > -1 && this.LinkedEntityDto != null) {
                let relatedEntityDto = new TicketRelatedEntityDto();
                relatedEntityDto.EntityId = this.LinkedEntityDto.Id;
                relatedEntityDto.EntityType = EntityFqdn.Decos_Kcs_Documents_Entities_Document;
                relatedEntityDto.ObjectSource = this.LinkedEntityDto.ObjectSource;
                relatedEntityDto.TicketId = this.sessionManager.selectedEntity.Id;
                if (this.sessionManager.selectedEntity.RelatedEntityList == null)
                    this.sessionManager.selectedEntity.RelatedEntityList = [];
                this.sessionManager.selectedEntity.RelatedEntityList.push(relatedEntityDto);
                this.router.navigate([this.router.url]);
            }
        }
        else if (response.FromHandler != null && response.FromHandler.toLowerCase().indexOf("ticket") > -1) {
            let btns = [{ result: true, label: this.translateService.instant("LBL_OK"), cssClass: 'yesButton confirmBtn' }];
            let dialogBox = DialogHelper.getMessage(this.translateService.instant("LBL_LINK_ENTITY_FAILED"), this.translateService.instant("LBL_TICKET"), false, null, null, null, null, this.translateService);
        }
        else if (response.FromHandler != null && response.FromHandler.toLowerCase().indexOf("cases") > -1) {
            let btns = [{ result: true, label: this.translateService.instant("LBL_OK"), cssClass: 'yesButton confirmBtn' }];
            let dialogBox = DialogHelper.getMessage(this.translateService.instant("LBL_LINK_DOCUMENT_TO_CASE_FAILED"), this.translateService.instant("LBL_TICKET"), false, null, null, null, null, this.translateService);
        }
    }
    createDocumentResponse(response) {
        this.stopSpinner();
        if (response?.NewDocumentDto) {
            this.processArchive(response);
            this.close(false);
            this.sessionManager.loadedFromRelatedView = false;
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.ObjectSource) && (this.sessionManager.selectedEntity.ObjectSource.toLowerCase().indexOf("ticket") > -1)) {
                this.LinkedEntityDto = response.NewDocumentDto;
                let sourceEntity = new SearchObject(this.sessionManager.selectedEntity.Id, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket]), this.sessionManager.selectedEntity.ObjectSource, this.sessionManager.selectedEntity.ExternalId);
                let destinationEntity = new SearchObject(this.LinkedEntityDto.Id, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Documents_Entities_Document]), this.LinkedEntityDto.ObjectSource, "");
                this.ticketService.linkRelatedEntity(sourceEntity, destinationEntity, this.linkEntityCallBack);
            }
            else {
                this.sessionManager.selectedEntity = response.NewDocumentDto;
                this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${EntityName.DOCUMENT}`;
                this.sessionManager.addBreadcrumbItems([response.NewDocumentDto], null, this.sessionManager.selectedEntity.locationUrl);
                this.router.navigate([RoutePath.DETAIL_PATH, EntityName.DOCUMENT]);
            }
            if (this.isOpenInSourceEnabled && response.NewDocumentDto.SourceApplicationDeeplink)
                window.open(response.NewDocumentDto.SourceApplicationDeeplink, "_blank");
            console.log(" URL: " + response.NewDocumentDto.SourceApplicationDeeplink);
            //Send a request for storing External data
            let selectedObject = this.selectedRelationTypeItem;
            if (!GlobalFunctions.isEmpty(selectedObject)) {
                let objectType = GlobalFunctions.getContentTypeByPropertyName("RelatedEntityFqdn", selectedObject);
                let objectTypeName = GlobalFunctions.getObjectTypeName(objectType);
                selectedObject = GlobalFunctions.setEntityType(selectedObject, GlobalFunctions.toJsonFqdnType(objectTypeName));
                if (!GlobalFunctions.isEmpty(this.documentDto.PhoneNumber) || !GlobalFunctions.isEmpty(this.documentDto.EmailAddress)) {
                    if (this.selectedRelationTypeItem.RelatedEntityFqdn === "Decos_Kcs_Persons_Entities_Person")
                        this.personService.saveExternalData(selectedObject, this.documentDto.PhoneNumber, this.documentDto.EmailAddress);
                    if (this.selectedRelationTypeItem.RelatedEntityFqdn === "Decos_Kcs_Organizations_Entities_Organization")
                        this.organizationService.saveExternalData(selectedObject, this.documentDto.PhoneNumber, this.documentDto.EmailAddress);
                }
            }
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_DOCUMENT'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_DOCUMENT") });
    }
    processArchive(response) {
        if (this.selectedEmail != null) {
            if (this.applicationSettingManager.isArchiveMailOptionRequired()) {
                if (GlobalFunctions.isEmpty(response.ArchivedEmailId)) {
                    let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_MSG_FAILED_TO_ARCHIVE_EMAIL"), this.translateService.instant("LBL_EMAIL"), false, null, null, null, null, this.translateService);
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
                }
                else {
                    this.sessionManager.selectedEntity.Id = response.ArchivedEmailId;
                    if (this.sessionManager.selectedEntity.Header != null) {
                        this.sessionManager.selectedEntity.Header.Id = response.ArchivedEmailId;
                        this.sessionManager.selectedEntity.Header.Uid = response.ArchivedEmailId;
                        this.sessionManager.selectedEntity.Header.EmailSource = EmailSource.Archive;
                    }
                }
            }
            else
                this.sessionManager.removeFromDetailViewCachedEntityList(this.selectedEmail.Id);
        }
    }
    /*code to prefill the session items*/
    addItemToRelatedEntityObjects(item, addFqdn) {
        if (this.relatedEntities != null && this.relatedEntities.length > 0) {
            for (let index = 0; index < this.relatedEntities.length; index++) {
                if (this.relatedEntities[index].Id == item.Id)
                    return;
            }
        }
        let relatedEntityDto = this.getRelatedEntityObject(item, addFqdn);
        this.relatedEntities.push(relatedEntityDto);
    }
    getRelatedEntityObject(item, addFqdn) {
        let relatedEntity = new BaseDto();
        relatedEntity.Id = item.Id;
        if (addFqdn)
            relatedEntity.IsMarked = addFqdn;
        relatedEntity.ObjectSource = item.ObjectSource;
        return relatedEntity;
    }
    fillRelatedEntities() {
        let cachedEntities = this.sessionManager.detailViewCachedEntityList;
        if (cachedEntities != null && cachedEntities.length > 0) {
            cachedEntities.forEach(value => {
                if (value != undefined && value.key != null && value.key != undefined) {
                    if (value.value.indexOf(this.relationType) != -1) {
                        this.relationTypeItems.push(value.key);
                        this.selectedRelationTypeItem = value.key;
                    }
                }
            });
        }
        if (this.relationTypeItems.length == 0) {
            let relatedList = this.cacheManager.relatedResultList;
            if (relatedList != null && relatedList.length > 0) {
                let relatedPersonOrOrganizationList = relatedList[this.relationType.toUpperCase()];
                if (relatedPersonOrOrganizationList != null && relatedPersonOrOrganizationList.length > 0) {
                    relatedPersonOrOrganizationList.forEach(relatedItem => {
                        if (relatedItem != null) {
                            this.sessionManager.setBreadcrumbGrammer(relatedItem);
                            this.relationTypeItems.push(relatedItem);
                            this.selectedRelationTypeItem = relatedItem;
                        }
                    });
                }
            }
        }
    }
    selectDefaultRelationTypeOption() {
        let relationType = '';
        if (this.sessionManager.detailViewCachedEntityList?.length > 0) {
            this.sessionManager.detailViewCachedEntityList.forEach(entity => {
                if (entity?.key) {
                    if (entity.value.includes('Person')) {
                        relationType = 'Person';
                        return;
                    }
                    else if (entity.value.includes('Organization'))
                        relationType = 'Organization';
                }
            });
        }
        if (relationType) {
            this.relationType = relationType;
            this.selectedFindFrom = 'Related';
        }
        else {
            const manualEntity = GlobalFunctions.isContainsPersonOrganizationName(this.sessionManager.selectedEntity);
            if (!GlobalFunctions.isEmpty(manualEntity)) {
                this.selectedFindFrom = 'ManualEntry';
                this.documentDto.PrimarySubjectName = manualEntity;
            }
            else
                this.selectedFindFrom = 'Anonymous';
        }
        this.changeFindFrom();
        if (relationType == 'Organization')
            this.setMainEntity(GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList), "Organization");
    }
    searchCase() {
        if (event.target["className"].indexOf("remove") > -1)
            event.stopPropagation();
        else
            this.openSearchPopup("CaseEntity", "Case");
    }
    caseRemoved(tag) {
        this.documentDto.CaseId = null;
    }
    getDocumentTypes(caseTypeId) {
        if (!GlobalFunctions.isEmpty(caseTypeId)) {
            this.FetchingDocumentType = true;
            this.documentService.getDocumentTypes(caseTypeId, this.onDocumentTypesSuccessResponse);
        }
    }
    onDocumentTypesSuccessResponse(getDocumentTypeList) {
        if (getDocumentTypeList.length > 0)
            this.documentTypeList = getDocumentTypeList;
        this.FetchingDocumentType = false;
    }
    preFillLastCase(result) {
        this.caseTags = [];
        result.StringRepresentation = result.Description;
        result.text = result.StringRepresentation;
        this.caseTags.push(result);
        this.documentDto.CaseId = result.Id;
        this.getDocumentTypes(result.CaseTypeId);
    }
    scan() {
        DialogHelper.openDialog(this.dialog, ScanBasketComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState)).afterClosed().subscribe(result => {
            if (result != null) {
                let fileDocument = new Object();
                fileDocument.text = this.translateService.instant("LBL_SCAN") + "_" + new this.DateJS().toString('HH-mm-ss');
                fileDocument.NameOnServer = result.FilePath + "\\" + result.FileName;
                this.fileDocuments.push(fileDocument);
            }
        });
    }
    searchEmployee() {
        const searchPopup = this.dialogManager.openJsPanelOrDialog('SEARCH_EMPLOYEE_POPUP_PANEL').afterClosed().subscribe(result => {
            if (result?.selectedEmployee) {
                result.selectedEmployee.text = result.selectedEmployee.StringRepresentation;
                this.handlerTags.push(result.selectedEmployee);
            }
        });
        // Set isParentPopup to false (will not open in detail view) when opening EmployeePanel from Document
        if (searchPopup && searchPopup.componentInstance)
            searchPopup.componentInstance.isParentPopup = false;
    }
    onSelect(event) {
        this.files.push(...event.addedFiles);
    }
    onRemove(event) {
        this.files.splice(this.files.indexOf(event), 1);
    }
    onResized(event) {
        console.log("onResized...");
    }
    close(result) {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
};
__decorate([
    ViewChild('form')
], DocumentAddComponent.prototype, "form", void 0);
__decorate([
    ViewChild('findFromSelectOption')
], DocumentAddComponent.prototype, "findFromSelectOption", void 0);
DocumentAddComponent = __decorate([
    Component({
        selector: 'document-add',
        templateUrl: './document-add.component.html',
        styleUrls: ['./document-add.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], DocumentAddComponent);
export { DocumentAddComponent };
//# sourceMappingURL=document-add.component.js.map