var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { ContextMenuView, DateCompareType, DocumentFormat, NumericCompareType, StringCompareType } from '../../../../core/enums/common-enums';
import { ContextMenu } from '../../../../core/models/common/context-menu';
import { CreateExportReportRequest } from '../../../../core/models/report/create-export-report-request';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseSearchResultComponent } from '../../../common/base-search-result.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
import { PrintComponent } from '../../../common/print/print.component';
import { SearchDto } from 'src/app/core/models/common/searchDto';
import { DateCriteriaDto } from 'src/app/core/models/common/date-criteria';
import { StringCriteriaDto } from 'src/app/core/models/common/string-criteria';
import { NumericCriteriaDto } from 'src/app/core/models/common/numeric-criteria';
import { ContactHistorySearchField } from 'src/app/core/models/jkc-object/jkc-object';
import { BroadCastEventKeys, EntityName } from '../../../../shared/constants';
let ContactHistorySearchResultComponent = class ContactHistorySearchResultComponent extends BaseSearchResultComponent {
    constructor(activatedRoute, applicationSettingManager, changeDetectorRef, contactHistoryService, dialog, dialogManager, downloadService, employeeService, eventProvider, router, sessionManager, searchService, sortManager, translateService, datePipe, cacheManager, formatManager, integrationSettingManager, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.activatedRoute = activatedRoute;
        this.applicationSettingManager = applicationSettingManager;
        this.changeDetectorRef = changeDetectorRef;
        this.contactHistoryService = contactHistoryService;
        this.dialog = dialog;
        this.dialogManager = dialogManager;
        this.downloadService = downloadService;
        this.employeeService = employeeService;
        this.eventProvider = eventProvider;
        this.router = router;
        this.sessionManager = sessionManager;
        this.searchService = searchService;
        this.sortManager = sortManager;
        this.translateService = translateService;
        this.datePipe = datePipe;
        this.cacheManager = cacheManager;
        this.formatManager = formatManager;
        this.integrationSettingManager = integrationSettingManager;
        this.localSearchResultDataService = localSearchResultDataService;
        this.isSearchedOnPrivateField = false;
        this.isTagFeatureEnabled = this.applicationSettingManager.tagSetting.tagList.length > 0;
        this.dateJS = Date;
        this.onTagClick = (tag, $event) => {
            //this.applicationSettingManager.tagSetting.handleAction(tag, this.sessionManager, this.searchService, this.dialogManager, $rootScope, $event);
        };
        this.createReportResponse = this.createReportResponse.bind(this);
        this.searchPrivateFieldValidationResponseFound = this.searchPrivateFieldValidationResponseFound.bind(this);
        this.subs.sink = activatedRoute.queryParams.subscribe(queryParams => this.selectedOption = queryParams.filter || '');
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = EntityName.CONTACT_HISTORY;
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && (this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "contacthistory" || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "advanced")) {
            this.sourceCount = 0;
            this.resultList = [];
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            if (!this.selectedOption)
                this.advanceSearchContactHistory();
            else
                this.searchByParam();
        }
        this.sessionManager.contextMenu = new ContextMenu('', 'CONTACTMOMENT', this.translateService, null, GlobalFunctions.getLoggedInUserId(), ContextMenuView.SearchList, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    searchByParam() {
        if (!GlobalFunctions.isEmpty(this.selectedOption)) {
            const searchDto = this.prepareSearchDtoByParam();
            if (searchDto == null)
                this.prepareSearchDtoForHandler();
            else {
                this.contactHistoryService.setRecentHistoryCallbacks(this.searchResultFound, this.updateSearchStatus);
                this.contactHistoryService.advancedSearch(searchDto, false, this.searchPrivateFieldValidationResponseFound);
                let paramArray = decodeURIComponent(this.selectedOption).split('_');
                if (paramArray.length == 2)
                    this.searchService.advancedSearchQuery = paramArray[1];
                else
                    this.searchService.advancedSearchQuery += "{" + this.translateService.instant("LBL_" + this.selectedOption.toUpperCase()) + "}";
            }
            this.searchStatusQuery = this.searchService.advancedSearchQuery;
        }
    }
    prepareSearchDtoForHandler() {
        this.searchService.advancedSearchQuery = '';
        const handlerId = this.sessionManager.selectedEntity.Id;
        const handlerName = `${this.sessionManager.selectedEntity.FirstName} ${this.sessionManager.selectedEntity.Surname}`;
        const searchDto = new SearchDto();
        const stringCriteriaDto = new StringCriteriaDto();
        stringCriteriaDto.Name = GlobalFunctions.isEmpty(handlerId) ? ContactHistorySearchField.Handler : ContactHistorySearchField.HandlerId;
        stringCriteriaDto.Value = GlobalFunctions.isEmpty(handlerId) ? handlerName : handlerId;
        stringCriteriaDto.CompareType = StringCompareType.Like;
        stringCriteriaDto.DisplayName = 'LBL_HANDLER';
        searchDto.StringCriteriaList.push(stringCriteriaDto);
        this.searchService.advancedSearchQuery += '{' + this.translateService.instant(stringCriteriaDto.DisplayName) + '} ' + this.translateService.instant("LBL_LIKE") + " " + handlerName + " ";
        this.searchService.advanceSearch({ searchDto, searchFrom: 'dashboard', searchType: 'contacthistory' });
    }
    prepareSearchDtoByParam() {
        let searchDto = new SearchDto();
        searchDto.StringCriteriaList = [];
        searchDto.NumericCriteriaList = [];
        searchDto.DateCriteriaList = [];
        searchDto.EnumCriteriaList = [];
        this.searchService.advancedSearchQuery = '';
        let dateSearchCriteria = new DateCriteriaDto();
        dateSearchCriteria.CompareType = DateCompareType.Between;
        dateSearchCriteria.Name = ContactHistorySearchField.EndDate;
        dateSearchCriteria.Value = new this.dateJS().toString('M/d/yyyy HH:mm:ss');
        dateSearchCriteria.ToDate = new this.dateJS().toString('M/d/yyyy HH:mm:ss');
        searchDto.DateCriteriaList.push(dateSearchCriteria);
        let taskSearchCriteria = new StringCriteriaDto();
        taskSearchCriteria.Name = ContactHistorySearchField.ContactTypes;
        taskSearchCriteria.CompareType = StringCompareType.EqualsTo;
        taskSearchCriteria.Value = "7,8,10,16,17,19";
        let socialSearchCriteria = new StringCriteriaDto();
        socialSearchCriteria.Name = ContactHistorySearchField.ContactTypes;
        socialSearchCriteria.CompareType = StringCompareType.EqualsTo;
        socialSearchCriteria.Value = "5,13,14,15";
        switch (this.selectedOption.toLowerCase()) {
            case "handledtaskbyme":
            case "handledsocialmediabyme":
            case "handledemailbyme":
            case "contactbyme":
                {
                    switch (this.selectedOption.toLowerCase()) {
                        case "handledtaskbyme":
                            {
                                searchDto.StringCriteriaList.push(taskSearchCriteria);
                                break;
                            }
                        case "handledsocialmediabyme":
                            {
                                searchDto.StringCriteriaList.push(socialSearchCriteria);
                                break;
                            }
                        case "handledemailbyme":
                            {
                                let emailSearchCriteria = new NumericCriteriaDto();
                                emailSearchCriteria.Name = ContactHistorySearchField.ContactType;
                                emailSearchCriteria.CompareType = NumericCompareType.EqualsTo;
                                emailSearchCriteria.Value = 2; //email
                                searchDto.NumericCriteriaList.push(emailSearchCriteria);
                                break;
                            }
                    }
                    let handlerSearchCriteria = new StringCriteriaDto();
                    handlerSearchCriteria.Name = ContactHistorySearchField.HandlerId;
                    handlerSearchCriteria.CompareType = StringCompareType.EqualsTo;
                    handlerSearchCriteria.Value = GlobalFunctions.getLoggedInUserId();
                    searchDto.StringCriteriaList.push(handlerSearchCriteria);
                    break;
                }
            case "handledtaskbyrole":
            case "contactbyrole":
                {
                    if (this.selectedOption.toLowerCase() == "handledtaskbyrole")
                        searchDto.StringCriteriaList.push(taskSearchCriteria);
                    let roleSearchCriteria = new StringCriteriaDto();
                    roleSearchCriteria.Name = ContactHistorySearchField.RoleId;
                    roleSearchCriteria.CompareType = StringCompareType.EqualsTo;
                    roleSearchCriteria.Value = this.sessionManager.selectedRole.Id;
                    searchDto.StringCriteriaList.push(roleSearchCriteria);
                    break;
                }
            case "handledtaskbydepartment":
            case "handledsocialmediabydepartment":
            case "contactbydepartment":
                {
                    if (this.selectedOption.toLowerCase() == "handledtaskbydepartment")
                        searchDto.StringCriteriaList.push(taskSearchCriteria);
                    else if (this.selectedOption.toLowerCase() == "handledsocialmediabydepartment")
                        searchDto.StringCriteriaList.push(socialSearchCriteria);
                    let departmentMembers = this.cacheManager.getMembersOfDepartment(this.employeeService.loggedInEmployee.DepartmentId);
                    let departmentSearchCriteria = new StringCriteriaDto();
                    departmentSearchCriteria.Name = ContactHistorySearchField.HandlerId;
                    departmentSearchCriteria.CompareType = StringCompareType.EqualsTo;
                    departmentSearchCriteria.Value = departmentMembers != null && departmentMembers.length > 0 ? departmentMembers.join(',').trim() : GlobalFunctions.getLoggedInUserId();
                    ;
                    searchDto.StringCriteriaList.push(departmentSearchCriteria);
                    break;
                }
            case "contactbyall":
                {
                    //Nothing
                    break;
                }
            default:
                {
                    let paramArray = decodeURIComponent(this.selectedOption.toLowerCase()).split('_');
                    if (paramArray.length == 2) {
                        searchDto.DateCriteriaList = [];
                        let objectSearchCriteria = new StringCriteriaDto();
                        objectSearchCriteria.Name = ContactHistorySearchField.ObjectId;
                        objectSearchCriteria.CompareType = StringCompareType.EqualsTo;
                        objectSearchCriteria.Value = paramArray[0];
                        searchDto.StringCriteriaList.push(objectSearchCriteria);
                    }
                    else if (paramArray.length == 1) {
                        const handlerName = `${this.sessionManager.selectedEntity.FirstName} ${this.sessionManager.selectedEntity.Surname}`;
                        searchDto.DateCriteriaList = [];
                        let objectSearchCriteria = new StringCriteriaDto();
                        objectSearchCriteria.Name = ContactHistorySearchField.ObjectId;
                        objectSearchCriteria.CompareType = StringCompareType.EqualsTo;
                        objectSearchCriteria.Value = paramArray[0];
                        objectSearchCriteria.DisplayName = "LBL_HANDLER";
                        searchDto.StringCriteriaList.push(objectSearchCriteria);
                        this.searchService.advancedSearchQuery += '{' + this.translateService.instant(objectSearchCriteria.DisplayName) + '} ' + this.translateService.instant("LBL_LIKE") + " " + handlerName + " ";
                    }
                    else
                        searchDto = null;
                    break;
                }
        }
        return searchDto;
    }
    advanceSearchContactHistory() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.contactHistoryService.setRecentHistoryCallbacks(this.searchResultFound, this.updateSearchStatus);
        this.contactHistoryService.advancedSearch(this.searchService.advancedSearchOption.searchDto, false, this.searchPrivateFieldValidationResponseFound);
        this.searchStatusQuery = this.searchService.advancedSearchQuery;
    }
    executeMenuItem(key) {
        switch (key.toUpperCase()) {
            case 'BULKHANDLE':
                if (this.filteredSearchResult.length > 0)
                    this.dialogManager.bulkHandle(this.filteredSearchResult);
                else
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_BULK_HANDLE'), textMsg: this.translateService.instant('LBL_MSG_BULK_HANDLE_NO_TASK') });
                break;
            case "BULKDELETE":
                {
                    this.dialogManager.bulkDeleteContactHistory(this.filteredSearchResult);
                    break;
                }
            case 'SENDTOEXCEL':
                this.sendToReport(DocumentFormat.Xlsx);
                break;
            case 'SENDTOPRINTER':
                this.sendToReport(DocumentFormat.Pdf);
                break;
        }
    }
    sendToReport(documentFormat) {
        if (!GlobalFunctions.isEmpty(this.filteredSearchResult)) {
            DialogHelper.openDialog(this.dialog, PrintComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
            let exportReportRequest = new CreateExportReportRequest();
            exportReportRequest.DocumentFormat = documentFormat;
            exportReportRequest.SearchQuery = this.sessionManager.localSearchQuery;
            exportReportRequest.LogOnName = this.employeeService.loggedInEmployee.LoggedInUserName;
            if (this.router.url.toLowerCase().indexOf('contacthistory') > -1)
                this.contactHistoryService.createReport(this.getContactHistoryIdFromList(this.filteredSearchResult), documentFormat, this.employeeService.loggedInEmployee.LoggedInUserName, this.sessionManager.localSearchQuery, this.createReportResponse);
        }
    }
    createReportResponse(response) {
        this.dialog.closeAll();
        if (!GlobalFunctions.isEmpty(response) && !GlobalFunctions.isEmpty(response.DownloadTicketId))
            this.subs.sink = this.downloadService.downloadFile(response.DownloadTicketId).subscribe(res => { GlobalFunctions.downloadFileAsBlob(res); });
    }
    getContactHistoryIdFromList(chList) {
        let contactHistoryIdList = [];
        if (!GlobalFunctions.isEmpty(chList)) {
            chList.forEach(ch => {
                if (!GlobalFunctions.isEmpty(ch))
                    contactHistoryIdList.push(ch.Id);
            });
        }
        return contactHistoryIdList;
    }
    searchPrivateFieldValidationResponseFound(result) {
        if (!GlobalFunctions.isEmpty(result) && !GlobalFunctions.isEmpty(result.SearchedPrivateFields) && result.SearchedPrivateFields.length > 0)
            this.isSearchedOnPrivateField = true;
    }
};
__decorate([
    ViewChild('picker')
], ContactHistorySearchResultComponent.prototype, "datePicker", void 0);
ContactHistorySearchResultComponent = __decorate([
    Component({
        selector: 'contact-history-search-result',
        templateUrl: './contact-history-search-result.component.html',
        styleUrls: ['./contact-history-search-result.component.scss']
    })
], ContactHistorySearchResultComponent);
export { ContactHistorySearchResultComponent };
//# sourceMappingURL=contact-history-search-result.component.js.map