var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDetailComponent } from '../../../../components/common/base-detail.component';
import { ContextMenuView, OperationType } from '../../../../core/enums/common-enums';
import { ContextMenu } from '../../../../core/models/common/context-menu';
import { Menu } from '../../../../core/models/common/menu';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { CallerIdInfoDto } from '../../../../core/models/phone/phone-caller-id-infoDto';
import { BroadCastEventKeys, EntityName, RoutePath } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
let ContactHistoryDetailComponent = class ContactHistoryDetailComponent extends BaseDetailComponent {
    constructor(sessionManager, changeDetectorRef, dialog, contextMenuService, applicationSettingManager, cacheManager, eventProvider, contactHistoryService, integrationSettingManager, searchService, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.sessionManager = sessionManager;
        this.changeDetectorRef = changeDetectorRef;
        this.dialog = dialog;
        this.contextMenuService = contextMenuService;
        this.applicationSettingManager = applicationSettingManager;
        this.cacheManager = cacheManager;
        this.eventProvider = eventProvider;
        this.contactHistoryService = contactHistoryService;
        this.integrationSettingManager = integrationSettingManager;
        this.searchService = searchService;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.isPersonExpired = false;
        this.additionalInformationTab = 'Partner';
        this.showRelatedPartner = false;
        this.showRelatedParents = false;
        this.showRelatedChildren = false;
        this.showHistoricAddress = false;
        this.showTravelDocuments = false;
        this.callerIdInfo = new CallerIdInfoDto();
        this.personPrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Person, OperationType.PrivateField);
        this.detailResponse = this.detailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        this.loadContactHistoryDetail();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    loadContactHistoryDetail() {
        try {
            this.menu.addOrUpdateMenuItem(0, "ContactHistoryDetail", this.translateService.instant("LBL_CONTACT_HISTORY"), false, true, true);
            this.addMenuItem.emit(this.menu);
            if (this.sessionManager.selectedEntity && this.sessionManager.selectedEntity.Partial) {
                this.startSpinner();
                this.contactHistoryService.setFetchDetailResponseCallback(this.detailResponse);
                this.contactHistoryService.fetchDetail(this.sessionManager.selectedEntity);
            }
            else
                this.sendRelatedRequest.emit();
        }
        catch (e) {
            console.error(e.message);
        }
    }
    detailResponse(contactMomentDto) {
        this.stopSpinner();
        this.setDetail(contactMomentDto);
        this.sessionManager.selectedEntity = contactMomentDto;
        this.sessionManager.selectedEntity.locationUrl = `/${RoutePath.DETAIL_PATH}/${EntityName.CONTACT_HISTORY}`;
        this.sendRelatedRequest.emit();
    }
    ;
    setDetail(contactMomentDto) {
        this.updateContactHistoryListWithHandlerName(contactMomentDto);
        this.updateContactMessageList(contactMomentDto);
        contactMomentDto.duration = this.contactHistoryService.getDuration(contactMomentDto);
        contactMomentDto.AssignedMailboxName = this.getTaskMailboxName();
        contactMomentDto.TagList = this.applicationSettingManager.tagSetting.searchTagById(contactMomentDto.Tags);
        if (!GlobalFunctions.isEmpty(contactMomentDto.CreatedById))
            contactMomentDto.CreatedBy = this.cacheManager.getEmployeeById(contactMomentDto.CreatedById);
    }
    updateContactHistoryListWithHandlerName(result) {
        if (result != null) {
            let handler = result.HandlerDto;
            if (handler != null) {
                let userId = handler.UserId;
                if (userId != null && userId != '') {
                    result.HandlerDto.HandlerObject = this.cacheManager.getEmployeeById(userId);
                }
            }
        }
    }
    ;
    updateContactMessageList(contactMomentDto) {
        if (!GlobalFunctions.isEmpty(contactMomentDto.ContactMessages)) {
            contactMomentDto.ContactMessages = jlinq.from(contactMomentDto.ContactMessages).sort("OnDateTime").select();
            for (let index = 0; index < contactMomentDto.ContactMessages.length; index++) {
                let employee = this.cacheManager.getEmployeeById(contactMomentDto.ContactMessages[index].UserId);
                if (employee != null) {
                    let employeeList = new Array();
                    employeeList.push(employee);
                    contactMomentDto.ContactMessages[index].UserName = employee.StringRepresentation;
                    contactMomentDto.ContactMessages[index].Picture = employee.PictureData;
                }
                else {
                    contactMomentDto.ContactMessages[index].UserName = this.translateService.instant('LBL_ANONYMOUS');
                    contactMomentDto.ContactMessages[index].Picture = './assets/images/nophoto.png';
                }
            }
        }
    }
    ;
    getTaskMailboxName() {
        let taskMailboxName = "";
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.AssignedMailbox)) {
            let assignedTaskMailbox = this.cacheManager.getTaskMailboxById(this.sessionManager.selectedEntity.AssignedMailbox);
            if (!GlobalFunctions.isEmpty(assignedTaskMailbox))
                taskMailboxName = assignedTaskMailbox.Name;
        }
        return taskMailboxName;
    }
    ;
    onTagClick(tag) {
        this.applicationSettingManager.tagSetting.handleAction(tag, this.sessionManager, this.searchService, this.dialogManager, this.eventProvider);
    }
    ;
};
ContactHistoryDetailComponent = __decorate([
    Component({
        selector: 'contact-history-detail',
        templateUrl: './contact-history-detail.component.html',
        styleUrls: ['./contact-history-detail.component.scss']
    })
], ContactHistoryDetailComponent);
export { ContactHistoryDetailComponent };
//# sourceMappingURL=contact-history-detail.component.js.map