var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { EntityName, RoutePath } from 'src/app/shared/constants';
import { SubSink } from 'subsink';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let ContactHistoryBulkDeleteComponent = class ContactHistoryBulkDeleteComponent extends BaseDialogComponent {
    constructor(translateService, data, sessionManager, contactHistoryService, dialogRef, shortcutManager, dialog, router) {
        super();
        this.translateService = translateService;
        this.data = data;
        this.sessionManager = sessionManager;
        this.contactHistoryService = contactHistoryService;
        this.dialogRef = dialogRef;
        this.shortcutManager = shortcutManager;
        this.dialog = dialog;
        this.router = router;
        this.message = '';
        this.subs = new SubSink();
        this.bulkDeleteContactHistoryResponse = this.bulkDeleteContactHistoryResponse.bind(this);
    }
    ngOnInit() {
        try {
            if (GlobalFunctions.isEmpty(this.data.resultList) || this.data.resultList.length == 0)
                this.message = this.translateService.instant("LBL_MSG_BULK_DELETE_NO_CONTACT_HISTORY");
            else {
                this.message = this.translateService.instant("LBL_MSG_BULK_DELETE_CONTACT_HISTORY");
                this.message = GlobalFunctions.formatStringValue(this.message, [this.data.resultList.length]);
                this.message = this.translateService.instant(this.message);
            }
            this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.bulkDelete());
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, e, true);
        }
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    bulkDelete() {
        if (!GlobalFunctions.isEmpty(this.data.resultList) && this.data.resultList.length > 0) {
            let idList = [];
            this.data.resultList.forEach(resultItem => idList.push(resultItem.Id));
            this.contactHistoryService.bulkDeleteContactHistory(idList, this.bulkDeleteContactHistoryResponse);
        }
        else
            this.close();
    }
    ;
    bulkDeleteContactHistoryResponse(response) {
        switch (response.Result) {
            case 0:
                this.close();
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.SEARCH_PATH, EntityName.CONTACT_HISTORY]);
                break;
            case 1:
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_BULK_DELETE'), textMsg: this.translateService.instant("LBL_MSG_BULK_DELETE_FAIL_CONTACT_HISTORY") }).afterClosed().subscribe(() => {
                    this.close();
                    this.router.navigate([RoutePath.DASHBOARD, RoutePath.SEARCH_PATH, EntityName.CONTACT_HISTORY]);
                });
                break;
        }
    }
    ;
    close() {
        this.dialogRef.close();
    }
};
ContactHistoryBulkDeleteComponent = __decorate([
    Component({
        selector: 'contact-history-bulk-delete',
        templateUrl: './contact-history-bulk-delete.component.html',
        styleUrls: ['./contact-history-bulk-delete.component.scss']
    }),
    __param(1, Inject(MAT_DIALOG_DATA))
], ContactHistoryBulkDeleteComponent);
export { ContactHistoryBulkDeleteComponent };
//# sourceMappingURL=contact-history-bulk-delete.component.js.map