var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { LicenseSpecificFeature, OperationType } from '../../../../core/enums/common-enums';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { BaseViewerComponent } from '../../../common/base-viewer.component';
let CaseViewerComponent = class CaseViewerComponent extends BaseViewerComponent {
    constructor(dialogManager, sessionManager, translateService, cacheManager, phoneManager) {
        super(phoneManager, dialogManager, translateService);
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.cacheManager = cacheManager;
        this.phoneManager = phoneManager;
        this.onShowLocationMap = new EventEmitter();
        this.hasRightLocation = false;
    }
    ngOnInit() {
        this.hasRightLocation = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.AddressesAndBuildings) && GlobalFunctions.hasRight(GlobalFunctions.toContentType("Location"), OperationType.View) && !GlobalFunctions.isEmpty(this.selectedViewerEntity.LocationLatitude) && !GlobalFunctions.isEmpty(this.selectedViewerEntity.LocationLongitude);
    }
    emitShowLocationMap() {
        this.onShowLocationMap.emit();
    }
    openEmployeeDetailPopUpByName(employeeName) {
        const employee = this.cacheManager.getEmployeeByName(employeeName);
        this.openEmployeeDetailPopUp(employee.Id);
    }
};
__decorate([
    Input()
], CaseViewerComponent.prototype, "selectedViewerEntity", void 0);
__decorate([
    Output()
], CaseViewerComponent.prototype, "onShowLocationMap", void 0);
CaseViewerComponent = __decorate([
    Component({
        selector: 'case-viewer',
        templateUrl: './case-viewer.component.html',
        styleUrls: ['./case-viewer.component.scss']
    })
], CaseViewerComponent);
export { CaseViewerComponent };
//# sourceMappingURL=case-viewer.component.js.map