var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { AlternateSearchType } from '../../../../core/enums/common-enums';
import { BroadCastEventKeys } from '../../../../shared/constants';
import { BaseSearchResultComponent } from '../../../common/base-search-result.component';
let CaseSearchResultComponent = class CaseSearchResultComponent extends BaseSearchResultComponent {
    constructor(router, sortManager, caseService, searchService, sessionManager, translateService, changeDetectorRef, eventProvider, applicationSettingManager, employeeService, activatedRoute, formatManager, cacheManager, integrationSettingManager, datePipe, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.router = router;
        this.sortManager = sortManager;
        this.caseService = caseService;
        this.searchService = searchService;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.changeDetectorRef = changeDetectorRef;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.employeeService = employeeService;
        this.activatedRoute = activatedRoute;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.localSearchResultDataService = localSearchResultDataService;
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = "caseentity";
        this.resultCount = 0;
        this.alternateSearchSources = [];
        this.resultList = [];
        this.filteredSearchResult = [];
        this.searchStatusMessage = '';
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && (this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == this.type.toLowerCase() || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "advanced")) {
            this.sourceCount = 0;
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            if (this.searchService.isAdvancedSearch)
                this.advanceSearchCase();
            else
                this.searchCase();
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    searchCase() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.caseService.search(this.searchStatusQuery, false, AlternateSearchType.None, this.searchService.selectedSearchOption?.sourceLocation, "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived);
    }
    advanceSearchCase() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.caseService.advancedSearch(this.searchService.advancedSearchOption.searchDto, AlternateSearchType.None, this.searchService.advancedSearchOption.sourceLocation, "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived);
        this.searchStatusQuery = this.searchService.advancedSearchQuery;
    }
    alternateSearch(item) {
        this.resultList = [];
        this.filteredSearchResult = [];
        this.alternateSearchSources = [];
        this.alternateSearchSuggestions = [];
        if (this.searchService.isAdvancedSearch)
            this.caseService.advancedSearch(this.searchService.advancedSearchOption.searchDto, AlternateSearchType.AlternateHandlerSearch, "", item.Handler, this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived);
        else
            this.caseService.search(this.searchStatusQuery, false, AlternateSearchType.AlternateHandlerSearch, "", item.Handler, this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived);
    }
    alternateSearchSuggestion(item) {
        this.resultList = [];
        this.filteredSearchResult = [];
        this.alternateSearchSources = [];
        this.alternateSearchSuggestions = [];
        this.searchStatusQuery = item;
        this.caseService.search(item, false, AlternateSearchType.None, "", "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived);
        this.sendResultCount.emit(this.resultCount);
    }
    ;
};
CaseSearchResultComponent = __decorate([
    Component({
        selector: 'case-search-result',
        templateUrl: './case-search-result.component.html',
        styleUrls: ['./case-search-result.component.scss']
    })
], CaseSearchResultComponent);
export { CaseSearchResultComponent };
//# sourceMappingURL=case-search-result.component.js.map