var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ContextMenuView, LicenseSpecificFeature, OperationType } from '../../../../core/enums/common-enums';
import { ContextMenu } from '../../../../core/models/common/context-menu';
import { Menu } from '../../../../core/models/common/menu';
import { BroadCastEventKeys } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { BaseDetailComponent } from '../../../common/base-detail.component';
let CaseDetailComponent = class CaseDetailComponent extends BaseDetailComponent {
    constructor(caseService, cacheManager, sessionManager, contextMenuService, eventProvider, integrationSettingManager, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.caseService = caseService;
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.contextMenuService = contextMenuService;
        this.eventProvider = eventProvider;
        this.integrationSettingManager = integrationSettingManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.fetchCaseDetailResponse = this.fetchCaseDetailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    ngOnInit() {
        this.loadCaseDetail();
    }
    loadCaseDetail() {
        try {
            const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
            const oldContentType = GlobalFunctions.toContentType(detailEntityType);
            this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
            this.contextMenuService.loadActionButton(detailEntityType);
            this.menu.addOrUpdateMenuItem(0, "CaseEntityDetail", this.translateService.instant("LBL_CASE"), false, true, true);
            this.addMenuItem.emit(this.menu);
            this.sendRelatedRequest.emit();
            this.hasRightLocation = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.AddressesAndBuildings) && GlobalFunctions.hasRight(GlobalFunctions.toContentType("Location"), OperationType.View) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LocationLatitude) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LocationLongitude);
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.Partial == true) {
                let partialDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
                this.caseService.fetchDetail(partialDto, this.fetchCaseDetailResponse);
                this.startSpinner();
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    fetchCaseDetailResponse(result) {
        this.stopSpinner();
        if (result != null && result.length > 0)
            this.sessionManager.selectedEntity = result[0];
    }
    ;
    openEmployeeDetailPopUpByName(employeeName) {
        const employee = this.cacheManager.getEmployeeByName(employeeName);
        this.openEmployeeDetailPopUp(employee.Id);
    }
};
CaseDetailComponent = __decorate([
    Component({
        selector: 'case-detail',
        templateUrl: './case-detail.component.html',
        styleUrls: ['./case-detail.component.scss']
    })
], CaseDetailComponent);
export { CaseDetailComponent };
//# sourceMappingURL=case-detail.component.js.map