var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { Mapper } from '../../../../core/models/common/mapper';
import { Menu } from '../../../../core/models/common/menu';
import { BroadCastEventKeys, Domain, Parameters, RoutePath } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { BaseSearchResultComponent } from '../../../common/base-search-result.component';
let AllSourceSearchResultComponent = class AllSourceSearchResultComponent extends BaseSearchResultComponent {
    constructor(activatedRoute, router, zone, translateService, allSourceService, sessionManager, sortManager, changeDetectorRef, eventProvider, applicationSettingManager, employeeService, searchService, formatManager, cacheManager, integrationSettingManager, datePipe, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.zone = zone;
        this.translateService = translateService;
        this.allSourceService = allSourceService;
        this.sessionManager = sessionManager;
        this.sortManager = sortManager;
        this.changeDetectorRef = changeDetectorRef;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.employeeService = employeeService;
        this.searchService = searchService;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.localSearchResultDataService = localSearchResultDataService;
        this.originalResultList = [];
        this.masterResultList = [];
        this.searchQuery = "";
        this.selectedItem = "ALLSOURCES";
        this.type = "ALLSOURCES";
        this.menu = new Menu();
        this.resultFound = this.resultFound.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = "allsource";
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && (this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "allsources" || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "advanced")) {
            this.sourceCount = 0;
            this.searchStatusQuery = this.translateService.instant("LBL_ALLSOURCES");
            const groupedItems = jlinq.from(this.localSearchResultDataService.localSearchResultData.localResult).group("RelatedEntityFqdn");
            const groupedKeys = Object.keys(groupedItems);
            groupedKeys.forEach(key => this.resultFound(groupedItems[key.toString().toUpperCase()]));
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            this.alternateSearchSources = [];
            this.resultList = [];
            this.filteredSearchResult = [];
            this.searchStatusMessage = '';
            this.searchAllSource();
        }
    }
    ;
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    searchAllSource() {
        if (this.searchService.isAdvancedSearch)
            this.searchStatusQuery = this.searchService.advancedSearchQuery;
        else
            this.searchStatusQuery = this.searchService.searchQuery;
        this.updateSearchStatus(this.activeHandlersObj);
        this.allSourceService.search(this.searchStatusQuery);
        this.allSourceService.setSearchResultCallbacks(this.resultFound, this.updateSearchStatus);
    }
    ;
    resultFound(result) {
        try {
            if (result?.length > 0) {
                let contentType = GlobalFunctions.getObjectTypeName(result[0].RelatedEntityFqdn);
                this.originalResultList = this.originalResultList.concat(result);
                let mapperObject = new Mapper();
                mapperObject.translateService = this.translateService;
                mapperObject.applicationSettingManager = this.applicationSettingManager;
                mapperObject.searchQuery = this.searchQuery;
                this.sessionManager.setBgColorBasedOnObjectSource(result);
                this.resultList = this.resultList.concat(mapperObject.getMappedItems(result, contentType, "universal_dto"));
                this.resultList = this.sortManager.sortEntityBasedOnApplicationSetting('UNIVERSALENTITY', this.resultList);
                this.resultCount = this.resultList.length;
                this.masterResultList = this.resultList;
                this.changeDetectorRef.markForCheck();
                this.sendResultCount.emit(this.resultCount);
                this.menu.addOrUpdateMenuItem(this.resultList.length, "ALLSOURCES", this.translateService.instant("LBL_ALLSOURCES"), true, true);
                let count = jlinq.from(this.resultList).starts("UnderlyingObjectContentType", contentType).select().length;
                let title = this.translateService.instant("LBL_" + contentType.toUpperCase() + "S");
                this.menu.addOrUpdateMenuItem(count, contentType.toUpperCase(), title, true, true);
                this.updateMenu.emit(this.menu);
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    select(item) {
        if (item != null) {
            let domain = GlobalFunctions.getObjectTypeName(item.UnderlyingObject.RelatedEntityFqdn);
            domain = domain.toLowerCase();
            if (domain === "item")
                window.open(item.UnderlyingObject.Link, '_blank');
            else {
                if (!GlobalFunctions.isEmpty(item.UnderlyingObject) && !GlobalFunctions.isEmpty(item.UnderlyingObject.ObjectSource) && item.UnderlyingObject.ObjectSource.toLowerCase() == 'decos.kcs.products.wordpress' && !GlobalFunctions.isEmpty(item.DetailDescription)) {
                    let titleArray = item.DetailDescription.split(":");
                    if (titleArray.length > 1)
                        item.UnderlyingObject.Name = titleArray[1];
                }
                this.sessionManager.loadedFromRelatedView = false;
                this.sessionManager.selectedEntity = item.UnderlyingObject;
                this.originalResultList.forEach(resultObject => {
                    resultObject.locationUrl = `${RoutePath.DETAIL_PATH}/${GlobalFunctions.getObjectTypeName(resultObject.RelatedEntityFqdn)}`;
                    resultObject.searchStatusQuery = this.searchStatusQuery;
                });
                this.sessionManager.addBreadcrumbItems(this.originalResultList, item.UnderlyingObject, this.router.url);
                switch (domain.toUpperCase()) {
                    case Domain.THEME:
                        this.zone.run(() => this.router.navigate([RoutePath.DETAIL_PATH, Parameters.THEME]));
                        break;
                    default:
                        this.zone.run(() => this.router.navigate([RoutePath.DETAIL_PATH, domain]));
                        break;
                }
            }
        }
    }
};
AllSourceSearchResultComponent = __decorate([
    Component({
        selector: 'all-source-search-result',
        templateUrl: './all-source-search-result.component.html',
        styleUrls: ['./all-source-search-result.component.scss']
    })
], AllSourceSearchResultComponent);
export { AllSourceSearchResultComponent };
//# sourceMappingURL=all-source-search-result.component.js.map