var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { ScreenMode, SocialMediaType } from '../../../core/enums/common-enums';
import { EntityFqdn } from '../../../core/enums/core-enums';
import { ActivityItems } from '../../../core/models/common/activity-items';
import { Menu, SubMenuItem } from '../../../core/models/common/menu';
import { BroadCastEventKeys, EntityName, RoutePath, Viewer } from '../../../shared/constants';
import { GlobalFunctions } from '../../../shared/global-functions';
import { ThemeViewerComponent } from '../../domain/theme/viewer/theme-viewer.component';
let ViewerComponent = class ViewerComponent {
    constructor(sessionManager, applicationSettingManager, phoneManager, userSettingManager, systemComponentService, cacheManager, integrationSettingManager, domainService, contactHistoryService, documentService, employeeService, socialMediaService, fileService, linkService, organizationService, personService, productService, questionanswerService, themeService, ticketService, chatService, translateService, taskService, caseentityService, noteService, issueService, emailService, formatManager, applicationFeatureManager, router, eventProvider, changeDetector, geoLayerService, downloadService) {
        this.sessionManager = sessionManager;
        this.applicationSettingManager = applicationSettingManager;
        this.phoneManager = phoneManager;
        this.userSettingManager = userSettingManager;
        this.systemComponentService = systemComponentService;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.domainService = domainService;
        this.contactHistoryService = contactHistoryService;
        this.documentService = documentService;
        this.employeeService = employeeService;
        this.socialMediaService = socialMediaService;
        this.fileService = fileService;
        this.linkService = linkService;
        this.organizationService = organizationService;
        this.personService = personService;
        this.productService = productService;
        this.questionanswerService = questionanswerService;
        this.themeService = themeService;
        this.ticketService = ticketService;
        this.chatService = chatService;
        this.translateService = translateService;
        this.taskService = taskService;
        this.caseentityService = caseentityService;
        this.noteService = noteService;
        this.issueService = issueService;
        this.emailService = emailService;
        this.formatManager = formatManager;
        this.applicationFeatureManager = applicationFeatureManager;
        this.router = router;
        this.eventProvider = eventProvider;
        this.changeDetector = changeDetector;
        this.geoLayerService = geoLayerService;
        this.downloadService = downloadService;
        this.subs = new SubSink();
        this.selectedViewerEntity = this.sessionManager.jkcViewerPanel.parameters.EditedData;
        this.phoneState = this.phoneManager.phoneState;
        this.showNoActivityFoundMessage = false;
        this.relatedResultList = [];
        this.relatedViews = [];
        this.predicate = [];
        this.reverse = [];
        this.menu = new Menu();
        this.isTagFeatureEnabled = this.applicationSettingManager.tagSetting.tagList.length > 0;
        this.popupMenu = { isOpened: false };
        this.relatedFor = "VIEWER";
        this.isPreviousEntitiyAvailable = this.sessionManager.jkcViewerBreadCrumbList.length > 1 ? true : false;
        this.subMenuItem = new SubMenuItem();
        this.timeoutObjects = [];
        this.activityItems = [];
        this.groupedActivityKeys = [];
        this.groupedActivityItems = [];
        this.activityItemsToDisplay = 5;
        this.relatedResultFound = this.relatedResultFound.bind(this);
        this.viewerEntityResponse = this.viewerEntityResponse.bind(this);
        this.registerRelatedCallback = this.registerRelatedCallback.bind(this);
        this.downloadRelatedFileReponse = this.downloadRelatedFileReponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_VIEWER_VIEW).subscribe(obj => {
            if (obj != null)
                this.select(obj.type, obj.item);
        });
    }
    ngOnInit() {
        this.init();
        this.setUIState();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    loadPreviosItem() {
        let currentEntity = jlinq.from(this.sessionManager.jkcViewerBreadCrumbList).starts("Id", this.selectedViewerEntity.Id).first();
        let index = this.sessionManager.jkcViewerBreadCrumbList.indexOf(currentEntity);
        if (index == 0)
            index = this.sessionManager.jkcViewerBreadCrumbList.length;
        let item = this.sessionManager.jkcViewerBreadCrumbList[index - 1];
        this.select(item.RelatedEntityFqdn, item);
    }
    openFromRelated(type) {
        switch (type.toUpperCase()) {
            case 'EMAIL': {
                if (this.relatedResultList != null && this.relatedResultList["EMAIL"] != null && this.relatedResultList["EMAIL"].length > 0)
                    this.select("Email", this.relatedResultList["EMAIL"][0]);
                break;
            }
        }
    }
    ;
    select(type, item) {
        if (item != null) {
            this.selectedViewerEntity = item;
            this.relatedResultList = [];
            this.relatedViews = [];
            this.menu = new Menu();
            this.subMenuItem = new SubMenuItem();
            this.init();
        }
    }
    close() {
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.TOGGLE_VIEWER_PANEL);
        this.sessionManager.closeJkcViewerPanel();
    }
    toggleUIState(isPinned) {
        if (!GlobalFunctions.isEmpty(isPinned)) {
            this.sessionManager.jkcViewerPanel.parameters.IsPanelPinned = isPinned;
            let jkcViewerPanel = $("#jkcViewerPanel");
            if (jkcViewerPanel) {
                isPinned ? this.sessionManager.viewerPanel.dragit('disable') : this.sessionManager.viewerPanel.dragit('enable');
                isPinned ? this.sessionManager.viewerPanel.resizeit('disable') : this.sessionManager.viewerPanel.resizeit('enable');
                this.sessionManager.resetJkcPanel();
            }
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.TOGGLE_VIEWER_PANEL);
            this.userSettingManager.setUserSettingValueByKey("VIEWERPANELPINSTATE", isPinned.toString());
            let userSettingDto = new Object();
            userSettingDto.Key = "VIEWERPANELPINSTATE";
            userSettingDto.Value = isPinned.toString();
            userSettingDto.UserId = GlobalFunctions.getLoggedInUserId();
            this.systemComponentService.updateUserSetting(userSettingDto);
            let panel = jkcViewerPanel;
            panel[0].options.dragit.containment = [-47, this.sessionManager.jkcViewerPanel?.sessionNotesUIState.UIState == 1 ? $('#contactSessionNotes').width() : 0, 0, 0];
            panel[0].options.resizeit.containment = [-47, this.sessionManager.jkcViewerPanel?.sessionNotesUIState.UIState == 1 ? $('#contactSessionNotes').width() : 0, 0, 0];
        }
    }
    loadInDetailView() {
        let type = GlobalFunctions.getObjectTypeName(this.selectedViewerEntity.RelatedEntityFqdn).toLowerCase();
        if (type.toLowerCase() === "contactmoment")
            type = EntityName.CONTACT_HISTORY;
        this.sessionManager.selectedEntity = this.selectedViewerEntity;
        this.sessionManager.selectedEntity.Partial = true;
        if (GlobalFunctions.supportsDeeplinking(type, this.sessionManager.selectedEntity.ObjectSource))
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${type}/${this.sessionManager.selectedEntity.Id}`;
        else
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${type}`;
        this.sessionManager.addBreadcrumbItems([this.sessionManager.selectedEntity], null, RoutePath.DETAIL_PATH);
        const isDetailView = this.router.url.includes(RoutePath.DETAIL_PATH);
        this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
        if (isDetailView)
            setTimeout(() => this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW), 300);
        this.close();
    }
    updateActivityItems(contentType, result) {
        let activityItems = new ActivityItems();
        activityItems.addOrUpdateActivityItem(result, contentType, this.translateService);
        let dateJS = Date;
        for (let i = 0; i < activityItems.activityItemList.length; i++) {
            if (activityItems.activityItemList[i].date > new dateJS.today().addMonths(-6) || activityItems.activityItemList[i].date < 0) {
                if (activityItems.activityItemList[i].contentType == 'TASK')
                    activityItems.activityItemList[i].contentType = activityItems.activityItemList[i].entityObject.TaskType;
                this.activityItems.push(activityItems.activityItemList[i]);
            }
        }
        GlobalFunctions.remove_duplicates(this.activityItems);
        this.activityItems.sort((a, b) => (a.fullDate < b.fullDate) ? 1 : -1);
        this.showActivityItems(this.activityItems.slice(0, 5));
    }
    showActivityItems(activityItemList) {
        this.activityItemsToDisplay = activityItemList.length;
        this.groupedActivityItems = jlinq.from(activityItemList).group("date");
        this.groupedActivityKeys = Object.keys(this.groupedActivityItems);
    }
    resetActivityItems() {
        this.activityItems = [];
        this.groupedActivityKeys = [];
        this.groupedActivityItems = [];
    }
    addSubMenuItems() {
        if (this.selectedViewerEntity != null) {
            switch (this.selectedViewerEntity.RelatedEntityFqdn) {
                case EntityFqdn[EntityFqdn.Decos_Kcs_Products_Entities_Product].toString():
                    {
                        if (this.selectedViewerEntity.Descriptions != null && this.selectedViewerEntity.Descriptions.length > 0) {
                            for (let index = 0; index < this.selectedViewerEntity.Descriptions.length; index++) {
                                if (this.selectedViewerEntity.Descriptions[index].Title != "" && this.selectedViewerEntity.Descriptions[index].Title != undefined)
                                    this.subMenuItem.addMenuItem(this.selectedViewerEntity.Descriptions[index].Title, index.toString());
                            }
                        }
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Faqs_Entities_QuestionAnswer].toString():
                    {
                        if (this.selectedViewerEntity.ChannelQuestionAnswers[0].Answers != null && this.selectedViewerEntity.ChannelQuestionAnswers[0].Answers.length > 0) {
                            for (let index = 0; index < this.selectedViewerEntity.ChannelQuestionAnswers[0].Answers.length; index++) {
                                if (this.selectedViewerEntity.ChannelQuestionAnswers[0].Answers[index].Title != "" && this.selectedViewerEntity.ChannelQuestionAnswers[0].Answers[index].Title != undefined)
                                    this.subMenuItem.addMenuItem(this.selectedViewerEntity.ChannelQuestionAnswers[0].Answers[index].Title, index.toString());
                            }
                        }
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_News_Entities_Item].toString():
                    {
                        if (this.selectedViewerEntity.Descriptions != null && this.selectedViewerEntity.Descriptions.length > 0) {
                            for (let index = 0; index < this.selectedViewerEntity.Descriptions.length; index++) {
                                if (this.selectedViewerEntity.Descriptions[index].Title != "" && this.selectedViewerEntity.Descriptions[index].Title != undefined)
                                    this.subMenuItem.addMenuItem(this.selectedViewerEntity.Descriptions[index].Title, index.toString());
                            }
                        }
                        break;
                    }
            }
        }
    }
    setUIState() {
        let isPinned = this.userSettingManager.getUserSettingValueByKey("VIEWERPANELPINSTATE");
        if (GlobalFunctions.isEmpty(isPinned))
            isPinned = "true";
        this.toggleUIState(isPinned === "true");
    }
    viewerEntityResponse(viewerDto) {
        this.showProgressBar = false;
        if (viewerDto != null) {
            switch (this.selectedViewerEntity.RelatedEntityFqdn) {
                case EntityFqdn[EntityFqdn.Decos_Kcs_Notes_Entities_NoteEntity].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_Cases_Entities_CaseEntity].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_Documents_Entities_Document].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email].toString():
                    {
                        if (!GlobalFunctions.isEmpty(viewerDto[0]))
                            this.selectedViewerEntity = viewerDto[0];
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Links_Entities_Link].toString():
                    {
                        if (!GlobalFunctions.isEmpty(viewerDto.LinkDto))
                            this.selectedViewerEntity = viewerDto.LinkDto;
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Appointment].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_ReportImprovement].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Assignment].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_CallbackNote].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_InformationRequest].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_News_Entities_Item].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_Products_Entities_Product].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_Persons_Entities_Person].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_Files_Entities_FileEntity].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_Faqs_Entities_QuestionAnswer].toString():
                case EntityFqdn[EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket].toString():
                    {
                        this.selectedViewerEntity = viewerDto;
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Organizations_Entities_Organization].toString():
                    {
                        this.selectedViewerEntity = viewerDto;
                        this.sessionManager.addItemToSession(this.selectedViewerEntity);
                        if (this.cacheManager.relatedResultList && this.cacheManager.relatedResultList["ORGANIZATION"] && this.cacheManager.relatedResultList["ORGANIZATION"][0])
                            this.cacheManager.relatedResultList["ORGANIZATION"][0] = this.selectedViewerEntity;
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Domains_Entities_Domain].toString():
                    {
                        let screen = this.integrationSettingManager.getDomainScreenSetting(viewerDto.Type, "Detail");
                        this.domainService.initializeData(viewerDto, screen);
                        this.selectedViewerEntity = viewerDto;
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Themes_Entities_Theme].toString():
                    {
                        this.selectedViewerEntity = viewerDto;
                        if (this.themeViewerReference && this.selectedViewerEntity)
                            this.themeViewerReference.parseThemePageDescription(this.selectedViewerEntity);
                        break;
                    }
            }
            setTimeout(() => this.selectedViewerEntity, 1);
            this.sendViewerRelatedRequest();
        }
    }
    sendViewerRelatedRequest() {
        this.addSubMenuItems();
        this.registerRelatedCallback();
        this.organizationService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.caseentityService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.documentService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.noteService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.issueService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.ticketService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.taskService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.productService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.questionanswerService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.employeeService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.fileService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.themeService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.linkService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.chatService.sendViewerRelatedRequest(this.selectedViewerEntity);
        this.systemComponentService.sendViewerNewsRelatedRequest(this.selectedViewerEntity);
        this.domainService.sendViewerRelatedRequest(this.selectedViewerEntity);
        if (!GlobalFunctions.isEmpty(this.selectedViewerEntity.RelatedEntityFqdn)) {
            if (this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("link") < 0)
                this.personService.sendViewerRelatedRequest(this.selectedViewerEntity);
            if (this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("link") < 0)
                this.emailService.sendViewerRelatedRequest(this.selectedViewerEntity, this.applicationFeatureManager.isShowNextEmailFeatureEnabled);
            if (this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("product") < 0 && this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("questionanswer") < 0 && this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("link") < 0 && this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("noteentity") < 0)
                this.contactHistoryService.sendViewerRelatedRequest(this.selectedViewerEntity);
            if ((this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("contactmoment") > 0 || this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("callbacknote") > 0 || this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("appointment") > 0 || this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("informationrequest") > 0 || this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("informationresponse") > 0) || this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("ticket") > 0 || this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("person") > 0 || this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("organization") > 0)
                this.socialMediaService.sendViewerRelatedRequest(this.selectedViewerEntity);
            if (this.selectedViewerEntity.RelatedEntityFqdn.toLowerCase().indexOf("organization") > 0)
                this.personService.searchRelatedRepresentativeRequest(this.relatedResultFound, this.selectedViewerEntity);
        }
    }
    registerRelatedCallback() {
        let uniqueId = GlobalFunctions.createGuid();
        this.caseentityService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.contactHistoryService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.documentService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.documentService.setViewerFileRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.personService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.organizationService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.ticketService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.taskService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.productService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.employeeService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.noteService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.questionanswerService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.emailService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.fileService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.themeService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.linkService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.socialMediaService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.chatService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.issueService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.systemComponentService.setViewerNewsRelatedResultCallback(this.relatedResultFound, uniqueId);
        this.domainService.setViewerRelatedResultCallback(this.relatedResultFound, uniqueId);
    }
    relatedResultFound(result, contentType, title) {
        if (result?.length > 0) {
            contentType = contentType.toUpperCase();
            this.isPersonClassified(contentType, result);
            switch (contentType.toUpperCase()) {
                case 'TASK':
                case 'CONTACTMOMENT':
                    {
                        this.formatManager.setHandler(contentType, result);
                        this.formatManager.setTag(contentType, result);
                        this.updateActivityItems(contentType, result);
                        break;
                    }
                case "NOTEENTITY":
                case "SOCIALMEDIAHISTORY":
                    this.formatManager.setHandler(contentType, result[0].SocialMediaContactHistoryList);
                    break;
                case "EMPLOYEE":
                    this.formatManager.setEmployee(result);
                    break;
                case "PERSON":
                    this.formatManager.setStringPresentation(result, "PersonDto_Breadcrumb");
                    break;
            }
            // TODO FUTURE: split out all task subdomains for better functionality?
            if (contentType.toUpperCase() === 'TASK') {
                switch (result[0].RelatedEntityFqdn) {
                    case EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Appointment]: {
                        if (result[0].ObjectSource.toLowerCase() === 'decos.kcs.tasks.smartcjm') {
                            title = this.translateService.instant('LBL_APPOINTMENTS');
                            contentType = 'APPOINTMENT';
                            break;
                        }
                    }
                }
            }
            if (this.relatedResultList[contentType] == null)
                this.relatedResultList[contentType] = [];
            this.concatUniqueOnly(contentType, result);
            this.menu.addOrUpdateMenuItem(this.relatedResultList[contentType].length, contentType, title, true, false, false, true);
            this.setRelatedViews(contentType);
            if (contentType.indexOf("FILEDOCUMENT") != -1 && contentType.toLowerCase() == 'email')
                this.selectedViewerEntity.AttachmentList = this.relatedResultList['FILEDOCUMENT'];
            this.resize();
            this.changeDetector.markForCheck();
        }
    }
    isPersonClassified(objcontentType, resultData) {
        if (objcontentType.toUpperCase() == "PERSON" && this.selectedViewerEntity && this.selectedViewerEntity.MainEntityType == 1) {
            for (let i = 0; i < resultData.length; i++) {
                if (this.selectedViewerEntity.MainEntityId == resultData[i].Id) {
                    this.selectedViewerEntity.personClassifiedValue = resultData[i].ConfidentialityLevel;
                    break;
                }
            }
        }
    }
    resize() {
        if (this.sessionManager.jkcViewerPanel != null && this.sessionManager.jkcViewerPanel.parameters != null) {
            let windowHeight = $(window).height();
            let viewerPanelHeight = windowHeight - parseInt(this.sessionManager.jkcViewerPanel.parameters.TopSpace);
            $("#jkcViewerPanel").css({ 'height': (viewerPanelHeight - 100 + "px") });
            $("#viewerDetailContainerPage").height(viewerPanelHeight - 100 - $("#viewerHeader").height() + "px");
            let panelWidth = $("#jkcViewerPanel").width();
            $('#' + this.sessionManager.jkcViewerPanel.parameters.HeaderId).css({ 'width': (panelWidth) });
            let panel = $("#jkcViewerPanel");
            panel[0].options.dragit.containment = [-47, this.sessionManager.jkcViewerPanel?.sessionNotesUIState.UIState == 1 ? $('#contactSessionNotes').width() : 0, 0, 0];
            panel[0].options.resizeit.containment = [-47, this.sessionManager.jkcViewerPanel?.sessionNotesUIState.UIState == 1 ? $('#contactSessionNotes').width() : 0, 0, 0];
        }
    }
    concatUniqueOnly(contentType, result) {
        for (let i = 0; i < result.length; i++) {
            let found = $.grep(this.relatedResultList[contentType], existingItem => existingItem.Id == result[i].Id && existingItem.ObjectSource == result[i].ObjectSource);
            if (found.length == 0)
                this.relatedResultList[contentType].push(result[i]);
        }
    }
    setRelatedViews(contentType) {
        let relatedView = jlinq.from(this.relatedViews).starts("ContentType", contentType).first();
        if (relatedView)
            relatedView.Count = this.relatedResultList[contentType].length;
        else {
            let relatedViewObj = null;
            if (contentType.indexOf("DOMAIN") == -1) {
                relatedViewObj = {
                    "ContentType": contentType,
                    "Count": contentType != "LOCATION" ? this.relatedResultList[contentType].length : Number.MAX_VALUE,
                };
            }
            else
                relatedViewObj = this.getDomainRelatedView(contentType);
            this.relatedViews.push(relatedViewObj);
        }
        this.relatedViews.sort((x, y) => (y.Count - x.Count));
        return this.relatedViews;
    }
    getDomainRelatedView(contentType) {
        let relatedViewObj = new Object();
        relatedViewObj.Title = GlobalFunctions.capitalize(contentType.split('_')[1].toLowerCase());
        relatedViewObj.ContentType = contentType;
        relatedViewObj.Count = Number.MAX_VALUE;
        let screen = this.integrationSettingManager.getDomainScreenSetting(relatedViewObj.Title, "Related");
        if (screen != null && screen.FieldGroups != null && screen.FieldGroups.length > 0)
            relatedViewObj.Fields = screen.FieldGroups[0].Fields;
        else
            relatedViewObj.Fields = [];
        return relatedViewObj;
    }
    init() {
        if (this.selectedViewerEntity != null) {
            this.sessionManager.addItemToSession(this.selectedViewerEntity);
            this.sessionManager.setBreadcrumbGrammer(this.selectedViewerEntity);
            this.resetActivityItems();
            this.selectedViewerEntity.RelatedEntityFqdn = GlobalFunctions.toEntityFqdnString(this.selectedViewerEntity.RelatedEntityFqdn);
            switch (this.selectedViewerEntity.RelatedEntityFqdn) {
                case EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_CallbackNote].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.CALLBACK_NOTE_VIEWER, this.translateService.instant("LBL_CALLBACK_NOTE"), false, true, true);
                        this.title = this.translateService.instant("LBL_CALLBACK_NOTE");
                        this.viewerPage = Viewer.CALLBACK_NOTE_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.taskService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_InformationRequest].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.INFORMATION_REQUEST_VIEWER, this.translateService.instant("LBL_INFORMATION_REQUEST"), false, true, true);
                        this.title = this.translateService.instant("LBL_INFORMATION_REQUEST");
                        this.viewerPage = Viewer.INFORMATION_REQUEST_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.taskService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_ReportImprovement].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.REPORT_IMPROVEMENT_VIEWER, this.translateService.instant("LBL_REPORT_IMPROVEMENT"), false, true, true);
                        this.title = this.translateService.instant("LBL_REPORT_IMPROVEMENT");
                        this.viewerPage = Viewer.REPORT_IMPROVEMENT_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.taskService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Appointment].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.APPOINTMENT_VIEWER, this.translateService.instant("LBL_APPOINTMENT"), false, true, true);
                        this.title = this.translateService.instant("LBL_APPOINTMENT");
                        this.viewerPage = Viewer.APPOINTMENT_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.taskService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Assignment].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.ASSIGNMENT_VIEWER, this.translateService.instant("LBL_ASSIGNMENT"), false, true, true);
                        this.title = this.translateService.instant("LBL_ASSIGNMENT");
                        this.viewerPage = Viewer.ASSIGNMENT_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.taskService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_ContactHistory_Entities_ContactMoment].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.CONTACT_HISTORY_VIEWER, this.translateService.instant("LBL_CONTACT_HISTORY"), false, true, true);
                        this.title = this.translateService.instant("LBL_CONTACT_HISTORY");
                        this.viewerPage = Viewer.CONTACT_HISTORY_VIEWER;
                        if (this.selectedViewerEntity.Partial) {
                            this.contactHistoryService.setFetchDetailResponseCallback(this.viewerEntityResponse);
                            this.contactHistoryService.fetchDetail(this.selectedViewerEntity);
                        }
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.EMAIL_VIEWER, this.translateService.instant("LBL_EMAIL"), false, true, true);
                        this.title = this.translateService.instant("LBL_EMAIL");
                        this.viewerPage = Viewer.EMAIL_VIEWER;
                        if (!this.selectedViewerEntity.Partial)
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Cases_Entities_CaseEntity].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, "CaseEntityViewer", this.translateService.instant("LBL_CASE_ENTITY"), false, true, true);
                        this.title = this.translateService.instant("LBL_CASE_ENTITY");
                        this.viewerPage = Viewer.CASE_ENTITY_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.caseentityService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        this.geoLayerService.init('caseentity', this.sessionManager.selectedEntity, this);
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Documents_Entities_Document].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.DOCUMENT_VIEWVER, this.translateService.instant("LBL_DOCUMENT"), false, true, true);
                        this.title = this.translateService.instant("LBL_DOCUMENT");
                        this.viewerPage = Viewer.DOCUMENT_VIEWVER;
                        if (this.selectedViewerEntity.Partial)
                            this.documentService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.EMAIL_VIEWER, this.translateService.instant("LBL_EMAIL"), false, true, true);
                        this.title = this.translateService.instant("LBL_EMAIL");
                        this.viewerPage = Viewer.EMAIL_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.emailService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Employees_Entities_Employee].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.EMPLOYEE_VIEWER, this.translateService.instant("LBL_EMPLOYEE"), false, true, true);
                        this.title = this.translateService.instant("LBL_EMPLOYEE");
                        this.viewerPage = Viewer.EMPLOYEE;
                        this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_Facebook].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, "FacebookViewer", this.translateService.instant("LBL_FACEBOOK"), false, true, true);
                        this.title = this.translateService.instant("LBL_FACEBOOK");
                        this.viewerPage = Viewer.FACEBOOK_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.socialMediaService.fetchDetail(this.selectedViewerEntity, SocialMediaType.Facebook, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_Twitter].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, "TwitterViewer", this.translateService.instant("LBL_TWITTER"), false, true, true);
                        this.title = this.translateService.instant("LBL_TWITTER");
                        this.viewerPage = Viewer.TWITTER_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.socialMediaService.fetchDetail(this.selectedViewerEntity, SocialMediaType.Twitter, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_WhatsApp].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, "WhatsAppViewer", this.translateService.instant("LBL_WHATSAPP"), false, true, true);
                        this.title = this.translateService.instant("LBL_WHATSAPP");
                        this.viewerPage = Viewer.WHATSAPP_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.socialMediaService.fetchDetail(this.selectedViewerEntity, SocialMediaType.WhatsApp, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Files_Entities_FileEntity].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, "FileEntityViewer", this.translateService.instant("LBL_FILE_ENTITY"), false, true, true);
                        this.title = this.translateService.instant("LBL_FILE_ENTITY");
                        this.viewerPage = Viewer.FILE_VIEWVER;
                        if (this.selectedViewerEntity.Partial)
                            this.fileService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse, null);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Issues_Entities_Issue].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, "IssueViewer", this.translateService.instant("LBL_ISSUE"), false, true, true);
                        this.title = this.translateService.instant("LBL_ISSUE");
                        this.viewerPage = Viewer.ISSUE_VIEWER;
                        this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_News_Entities_Item].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, "ItemViewer", this.translateService.instant("LBL_ITEM"), false, true, true, true, false, this.subMenuItem);
                        this.title = this.translateService.instant("LBL_ITEM");
                        this.viewerPage = "Views/Item/Viewer.html?" + GlobalFunctions.templateUniqueId;
                        if (this.selectedViewerEntity.Partial)
                            this.systemComponentService.fetchNewsDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Links_Entities_Link].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.LINK_VIEWVER, this.translateService.instant("LBL_LINK"), false, true, true);
                        this.title = this.translateService.instant("LBL_LINK");
                        this.viewerPage = Viewer.LINK_VIEWVER;
                        if (this.selectedViewerEntity.Partial)
                            this.linkService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse, null);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Notes_Entities_NoteEntity].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, "NoteentityViewer", this.translateService.instant("LBL_NOTE"), false, true, true);
                        this.title = this.translateService.instant("LBL_NOTE");
                        this.viewerPage = Viewer.NOTE_ENTITY;
                        if (this.selectedViewerEntity.Partial)
                            this.noteService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Organizations_Entities_Organization].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.ORGANIZATION_VIEWER, this.translateService.instant("LBL_ORGANIZATION"), false, true, true);
                        this.title = this.translateService.instant("LBL_ORGANIZATION");
                        this.viewerPage = Viewer.ORGANIZATION_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.organizationService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        this.geoLayerService.init("organization", this.selectedViewerEntity, this);
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Persons_Entities_Person].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.PERSON_VIEWVER, this.translateService.instant("LBL_PERSON"), false, true, true);
                        this.title = this.translateService.instant("LBL_PERSON");
                        this.viewerPage = Viewer.PERSON_VIEWVER;
                        if (this.selectedViewerEntity.Partial)
                            this.personService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        this.geoLayerService.init("person", this.selectedViewerEntity, this);
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Products_Entities_Product].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, "ProductViewer", this.translateService.instant("LBL_PRODUCT"), false, true, true, true, false, this.subMenuItem);
                        this.title = this.translateService.instant("LBL_PRODUCT");
                        this.viewerPage = Viewer.PRODUCT_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.productService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Faqs_Entities_QuestionAnswer].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, "QuestionAnswerViewer", this.translateService.instant("LBL_QUESTION_ANSWER"), false, true, true, true, false, this.subMenuItem);
                        this.title = this.translateService.instant("LBL_QUESTION_ANSWER");
                        this.viewerPage = Viewer.QUESTION_ANSWER_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.questionanswerService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Themes_Entities_Theme].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.THEME_VIEWVER, this.translateService.instant("LBL_THEME"), false, true, true);
                        this.title = this.translateService.instant("LBL_THEME");
                        this.viewerPage = Viewer.THEME_VIEWVER;
                        if (this.selectedViewerEntity.Partial)
                            this.themeService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, "TicketViewer", this.translateService.instant("LBL_TICKET"), false, true, true);
                        this.title = this.translateService.instant("LBL_TICKET");
                        this.viewerPage = Viewer.TICKET_VIEWER;
                        if (this.selectedViewerEntity.Partial)
                            this.ticketService.fetchDetail(this.selectedViewerEntity.Id, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Domains_Entities_Domain].toString():
                    {
                        this.menu.addOrUpdateMenuItem(0, Viewer.DOMAIN_VIEWVER, this.selectedViewerEntity.Type, false, true, true);
                        this.title = this.selectedViewerEntity.Type;
                        this.viewerPage = Viewer.DOMAIN_VIEWVER;
                        if (this.selectedViewerEntity.Partial)
                            this.domainService.fetchDetail(this.selectedViewerEntity, this.viewerEntityResponse);
                        else
                            this.sendViewerRelatedRequest();
                        break;
                    }
            }
            if (!GlobalFunctions.isEmpty(this.selectedViewerEntity.StringRepresentation))
                this.title = this.selectedViewerEntity.StringRepresentation;
            if (!jlinq.from(this.sessionManager.jkcViewerBreadCrumbList).starts("Id", this.selectedViewerEntity.Id).any()) {
                this.sessionManager.jkcViewerBreadCrumbList.push(this.selectedViewerEntity);
                this.isPreviousEntitiyAvailable = this.sessionManager.jkcViewerBreadCrumbList.length > 1 ? true : false;
            }
            this.sessionManager.startSessionIfPossible(this.viewerPage?.split('/')[1], ScreenMode.Detail);
            if (this.selectedViewerEntity.Partial) {
                if (GlobalFunctions.getObjectTypeName(this.selectedViewerEntity.RelatedEntityFqdn).toLowerCase() === 'email' || GlobalFunctions.getObjectTypeName(this.selectedViewerEntity.RelatedEntityFqdn).toLowerCase() === 'employee')
                    this.showProgressBar = false;
                else
                    this.showProgressBar = true;
            }
        }
        setTimeout(() => this.resize(), 200);
    }
    navigate(item, sub) {
        if (item) {
            item.newUpdate = false;
            this.popupMenu.isOpened = false;
            let id = 'VIEWER_RELATED_' + (sub ? sub : '') + item.contentType;
            if (id == 'VIEWER_RELATED_SUB_0')
                id = 'VIEWER_RELATED_TITLE';
            document.getElementById('viewerDetailContainerPage').scroll({ top: document.getElementById(id).offsetTop, behavior: 'smooth' });
        }
    }
    showLocationMap() {
        this.relatedResultFound(["dummy"], "location", this.translateService.instant("LBL_LOCATION"));
        this.geoLayerService.plotGeoMap();
    }
    downloadRelatedFile(relatedEntity) {
        if (this.relatedResultList['FILEDOCUMENT'] != null && this.relatedResultList['FILEDOCUMENT'].length > 0) {
            let file = jlinq.from(this.relatedResultList['FILEDOCUMENT']).equals("Id", relatedEntity.RelatedEntityId).first();
            if (file != null)
                this.fileService.downloadFile(file, this.downloadRelatedFileReponse);
        }
    }
    ;
    downloadRelatedFileReponse(message) {
        if (message != null && !GlobalFunctions.isEmpty(message.TicketId))
            this.subs.sink = this.downloadService.downloadFile(message.TicketId).subscribe(res => { GlobalFunctions.downloadFileAsBlob(res); });
    }
    ;
    openEmail() {
        if (this.relatedResultList["EMAIL"] && this.relatedResultList["EMAIL"].length > 0)
            this.select("Email", this.relatedResultList["EMAIL"][0]);
    }
    ;
    openSocialMedia() {
        if (this.relatedResultList["SOCIALMEDIA"] && this.relatedResultList["SOCIALMEDIA"].length > 0)
            this.select(this.relatedResultList["SOCIALMEDIA"][0].Type.toLowerCase(), this.relatedResultList["SOCIALMEDIA"][0]);
    }
    ;
};
__decorate([
    ViewChild(ThemeViewerComponent)
], ViewerComponent.prototype, "themeViewerReference", void 0);
ViewerComponent = __decorate([
    Component({
        selector: 'viewer',
        templateUrl: './viewer.component.html',
        styleUrls: ['./viewer.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], ViewerComponent);
export { ViewerComponent };
//# sourceMappingURL=viewer.component.js.map