var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { environment } from '../../../../environments/environment';
import { FileUploadSource } from '../../../core/enums/common-enums';
import { GlobalFunctions } from '../../../shared/global-functions';
import { UrlHelper } from '../../../shared/helper/url-helper';
let UploadFileComponent = class UploadFileComponent {
    constructor(fileService, translateService) {
        this.fileService = fileService;
        this.translateService = translateService;
        this.class = "scanButton secondary-button";
        this.error = false;
        this.label = this.translateService.instant("LBL_BROWSE");
        this.url = UrlHelper.getUploadFileURL(environment.api_url, FileUploadSource.None, GlobalFunctions.getSessionTokenAsString());
        this.onUpload = new EventEmitter();
        this.onSuccess = new EventEmitter();
        this.onError = new EventEmitter();
        this.fileName = '';
        this.fileUploadResponse = this.fileUploadResponse.bind(this);
        this.fileUploadErrorResponse = this.fileUploadErrorResponse.bind(this);
    }
    ngOnDestroy() { }
    uploadFile(event) {
        try {
            const file = event.target.files[0];
            if (file) {
                const formData = new FormData();
                this.onUpload.emit(file);
                formData.append("file", file);
                this.fileService.uploadFile(formData, this.url, this.fileUploadResponse, this.fileUploadErrorResponse);
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    fileUploadResponse(response) {
        this.onSuccess.emit(response);
    }
    fileUploadErrorResponse(error) {
        this.onError.emit(error);
    }
};
__decorate([
    Input()
], UploadFileComponent.prototype, "class", void 0);
__decorate([
    Input()
], UploadFileComponent.prototype, "error", void 0);
__decorate([
    Input()
], UploadFileComponent.prototype, "label", void 0);
__decorate([
    Input()
], UploadFileComponent.prototype, "url", void 0);
__decorate([
    Output()
], UploadFileComponent.prototype, "onUpload", void 0);
__decorate([
    Output()
], UploadFileComponent.prototype, "onSuccess", void 0);
__decorate([
    Output()
], UploadFileComponent.prototype, "onError", void 0);
UploadFileComponent = __decorate([
    Component({
        selector: 'upload-file',
        templateUrl: './upload-file.component.html',
        styleUrls: ['./upload-file.component.scss']
    })
], UploadFileComponent);
export { UploadFileComponent };
//# sourceMappingURL=upload-file.component.js.map