var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { OperationType } from 'src/app/core/enums/common-enums';
import { BaseDto } from 'src/app/core/models/common/baseDto';
import { GlobalFunctions } from 'src/app/shared/global-functions';
let LinkSectionComponent = class LinkSectionComponent {
    constructor(sessionManager) {
        this.sessionManager = sessionManager;
        this.linkList = [];
        this.onLinkItem = new EventEmitter();
    }
    ngOnInit() {
        if (this.section.Items?.length > 0) {
            const links = [];
            for (let index = 0; index < this.section.Items.length; index++) {
                if (GlobalFunctions.hasRight(GlobalFunctions.toContentType(this.section.Items[index].Entity), OperationType.View)) {
                    const link = new BaseDto();
                    link.Id = this.section.Items[index].Id;
                    link.ObjectSource = this.section.Items[index].Source;
                    link.ObjectSourceCaption = this.section.Items[index].Entity;
                    link.StringRepresentation = this.section.Items[index].Title;
                    links.push(link);
                }
            }
            if (links.length > 0) {
                this.sessionManager.setBgColorBasedOnObjectSource(links);
                this.linkList = links;
            }
        }
    }
    emitLinkItem(link) {
        this.onLinkItem.emit(link);
    }
};
__decorate([
    Input()
], LinkSectionComponent.prototype, "section", void 0);
__decorate([
    Input()
], LinkSectionComponent.prototype, "maxSectionWidth", void 0);
__decorate([
    Input()
], LinkSectionComponent.prototype, "maxSectionHeight", void 0);
__decorate([
    Output()
], LinkSectionComponent.prototype, "onLinkItem", void 0);
LinkSectionComponent = __decorate([
    Component({
        selector: 'link-section',
        templateUrl: './link-section.component.html',
        styleUrls: ['./link-section.component.scss']
    })
], LinkSectionComponent);
export { LinkSectionComponent };
//# sourceMappingURL=link-section.component.js.map