var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
let EmployeeSectionComponent = class EmployeeSectionComponent {
    constructor(cacheManager, employeeService) {
        this.cacheManager = cacheManager;
        this.employeeService = employeeService;
        this.employeeList = [];
        this.onEmployee = new EventEmitter();
    }
    ngOnInit() {
        if (this.section.Items?.length > 0) {
            const employees = [];
            for (let index = 0; index < this.section.Items.length; index++) {
                let employee = this.cacheManager.getEmployeeById(this.section.Items[index].Id);
                if (employee)
                    employees.push(employee);
            }
            this.employeeService.setEmployeeAvailability(employees);
            this.employeeList = employees;
        }
    }
    emitEmployee(employee) {
        this.onEmployee.emit(employee);
    }
};
__decorate([
    Input()
], EmployeeSectionComponent.prototype, "section", void 0);
__decorate([
    Input()
], EmployeeSectionComponent.prototype, "maxSectionHeight", void 0);
__decorate([
    Output()
], EmployeeSectionComponent.prototype, "onEmployee", void 0);
EmployeeSectionComponent = __decorate([
    Component({
        selector: 'employee-section',
        templateUrl: './employee-section.component.html',
        styleUrls: ['./employee-section.component.scss']
    })
], EmployeeSectionComponent);
export { EmployeeSectionComponent };
//# sourceMappingURL=employee-section.component.js.map