var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { OperationType } from 'src/app/core/enums/common-enums';
import { ContentType, TaskDtoSource } from 'src/app/core/models/jkc-object/jkc-object';
import { GlobalFunctions } from 'src/app/shared/global-functions';
let CbnTemplateSectionComponent = class CbnTemplateSectionComponent {
    constructor() {
        this.cbnTemplateList = [];
        this.onCbnTemplate = new EventEmitter();
    }
    ngOnInit() {
        if (this.section.Items?.length > 0) {
            const cbnTemplates = [];
            if (GlobalFunctions.hasRight(ContentType.Task, OperationType.Add, TaskDtoSource.CallbackNotes)) {
                for (let index = 0; index < this.section.Items.length; index++)
                    cbnTemplates.push(this.section.Items[index]);
            }
            if (cbnTemplates.length > 0)
                this.cbnTemplateList = cbnTemplates;
        }
    }
    emitCbnTemplate(cbnTemplate) {
        this.onCbnTemplate.emit(cbnTemplate);
    }
};
__decorate([
    Input()
], CbnTemplateSectionComponent.prototype, "section", void 0);
__decorate([
    Input()
], CbnTemplateSectionComponent.prototype, "maxSectionWidth", void 0);
__decorate([
    Input()
], CbnTemplateSectionComponent.prototype, "maxSectionHeight", void 0);
__decorate([
    Output()
], CbnTemplateSectionComponent.prototype, "onCbnTemplate", void 0);
CbnTemplateSectionComponent = __decorate([
    Component({
        selector: 'cbn-template-section',
        templateUrl: './cbn-template-section.component.html',
        styleUrls: ['./cbn-template-section.component.scss']
    })
], CbnTemplateSectionComponent);
export { CbnTemplateSectionComponent };
//# sourceMappingURL=cbn-template-section.component.js.map