var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { SearchObject } from '../../../core/models/common/search-objectDto';
import { GlobalFunctions } from '../../../shared/global-functions';
import { BaseDialogComponent } from '../base-dialog.component';
let SessionItemListComponent = class SessionItemListComponent extends BaseDialogComponent {
    constructor(ticketService, data, sessionManager, translateService, dialogRef) {
        super();
        this.ticketService = ticketService;
        this.data = data;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.errorMessage = '';
        this.selectContent = true;
        this.sessionEntityList = [];
        this.linkToTicketResponseReceived = this.linkToTicketResponseReceived.bind(this);
    }
    ngOnInit() {
        setTimeout(() => this.resize(), 300);
        if (this.sessionManager.detailViewCachedEntityList != null && this.sessionManager.detailViewCachedEntityList.length > 0) {
            let cacheEntityListLength = this.sessionManager.detailViewCachedEntityList;
            for (let i = 0; i < cacheEntityListLength.length; i++) {
                let sessionItem = cacheEntityListLength[i];
                let entityTypes = sessionItem.value.split('.');
                let entityType = entityTypes[entityTypes.length - 1];
                if (sessionItem != null && entityType.toLowerCase() != 'location' && sessionItem.key.Id != this.sessionManager.selectedEntity.Id) {
                    let sessionEntity = this.generalEntity(entityType, sessionItem.key);
                    if (!this.data.isLinkPersonOrOrganization)
                        this.sessionEntityList.push(sessionEntity);
                    else {
                        if (sessionEntity.Type.toLowerCase() == this.sessionManager.selectedEntity.currentRelationType.toLowerCase()) {
                            this.sessionEntityList.push(sessionEntity);
                            break;
                        }
                    }
                }
            }
        }
    }
    selectAll() {
        if (this.sessionEntityList != null && this.sessionEntityList.length > 0) {
            this.sessionEntityList.forEach(value => {
                if (value != null)
                    value.Item.IsMarked = this.selectContent;
            });
        }
        this.selectContent = !this.selectContent;
    }
    ;
    close() {
        if (this.data.isLinkPersonOrOrganization && (this.sessionManager.selectedEntity.RelatedEntityFqdn.indexOf('SocialMedia') != -1 || this.sessionManager.selectedEntity.RelatedEntityFqdn.indexOf('Email') != -1))
            this.dialogRef.close();
        else
            this.dialogRef.close(this.sessionEntityList);
    }
    ;
    saveSessionItemList() {
        if (this.sessionManager.selectedEntity.RelatedEntityFqdn == 'Decos_Kcs_Tickets_Entities_Ticket')
            this.linkEntityToTicket();
        if (this.data.isLinkPersonOrOrganization && (this.sessionManager.selectedEntity.RelatedEntityFqdn.indexOf('SocialMedia') != -1 || this.sessionManager.selectedEntity.RelatedEntityFqdn.indexOf('Email') != -1))
            this.dialogRef.close(this.sessionEntityList);
    }
    ;
    getSelectedItems() {
        let sessionEntityList = [];
        if (this.sessionEntityList != null && this.sessionEntityList.length > 0) {
            this.sessionEntityList.forEach(value => {
                if (value != null && value.Item.IsMarked)
                    sessionEntityList.push(value.Item);
            });
        }
        return sessionEntityList;
    }
    ;
    linkEntityToTicket() {
        let sessionEntityList = this.getSelectedItems();
        if (sessionEntityList.length > 0) {
            this.startSpinner();
            let sourceEntity = new SearchObject(this.sessionManager.selectedEntity.Id, this.sessionManager.selectedEntity.RelatedEntityFqdn, this.sessionManager.selectedEntity.ObjectSource, this.sessionManager.selectedEntity.ExternalId);
            let destinationEntityList = [];
            sessionEntityList.forEach(value => destinationEntityList.push(new SearchObject(value.Id, GlobalFunctions.toContentType(GlobalFunctions.getObjectTypeName(value.RelatedEntityFqdn)), value.ObjectSource, '')));
            this.ticketService.linkRelatedEntity(sourceEntity, destinationEntityList, this.linkToTicketResponseReceived);
        }
        else
            this.errorMessage = 'LBL_LINK_MESSAGE';
    }
    ;
    linkToTicketResponseReceived(response) {
        this.stopSpinner();
        if (response.Result == 0)
            this.close();
        else
            this.errorMessage = 'LBL_MESSAGE_LINK_TO_ENTITY_FAILED';
    }
    ;
    generalEntity(entityType, content) {
        let entityContent = new Object();
        entityContent.Type = entityType;
        entityContent.TypeText = this.translateService.instant('LBL_' + entityType.toUpperCase());
        entityContent.Item = content;
        entityContent.Item.IsMarked = false;
        return entityContent;
    }
    resize() {
        let windowHeight = $(window).height();
        let newHeight = windowHeight - $('#sessionItemListNameHeader').height() - $('#sessionItemListFooter').height() - 250 + 'px';
        $('#sessionItemListContent').height(newHeight);
    }
};
SessionItemListComponent = __decorate([
    Component({
        selector: 'session-item-list',
        templateUrl: './session-item-list.component.html',
        styleUrls: ['./session-item-list.component.scss'],
        host: { '(window:resize)': 'resize()' }
    }),
    __param(1, Inject(MAT_DIALOG_DATA))
], SessionItemListComponent);
export { SessionItemListComponent };
//# sourceMappingURL=session-item-list.component.js.map