import { BusinessExceptionDto } from "src/app/core/models/common/business-exceptionDto";
import { ExceptionHelper } from "src/app/shared/helper/exception-helper";
import { BroadCastEventKeys, RoutePath } from "../../shared/constants";
import { GlobalFunctions } from "../../shared/global-functions";
import { BaseComponent } from "../base-component";
export class SearchComponent extends BaseComponent {
    constructor(router, searchService, popularService, sessionManager, translateService, eventProvider, serviceManager, zone, dialog, changeDetectorRef, viewContainerRef) {
        super(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef);
        this.router = router;
        this.searchService = searchService;
        this.popularService = popularService;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.eventProvider = eventProvider;
        this.serviceManager = serviceManager;
        this.zone = zone;
        this.dialog = dialog;
        this.changeDetectorRef = changeDetectorRef;
        this.viewContainerRef = viewContainerRef;
        this.popularList = [];
        this.currentEntity = '';
        this.completedPopularList = this.completedPopularList.bind(this);
        this.entityDetailResponse = this.entityDetailResponse.bind(this);
    }
    popularSelect(popularItem) {
        this.clearTextValue();
        if (popularItem != null) {
            popularItem.Partial = true;
            if (popularItem.RelatedEntityFqdn === undefined) {
                let entity = GlobalFunctions.getObjectTypeName(popularItem.ContentType).toLowerCase();
                if (!GlobalFunctions.isEmpty(entity)) {
                    let entityName = "";
                    entityName = this.serviceManager.getInstance(entity);
                    popularItem.Id = popularItem.EntityId;
                    this.currentEntity = entity.toUpperCase();
                    switch (entity.toLowerCase()) {
                        case "questionanswer":
                        case "product":
                        case "organization":
                        case "theme":
                            let partial = new Object();
                            partial.Id = popularItem.EntityId;
                            partial.ObjectSource = popularItem.EntitySource;
                            partial.Name = popularItem.DisplayName;
                            entityName.fetchDetail(partial, this.entityDetailResponse);
                            break;
                        default:
                            entityName.fetchDetail(popularItem, this.entityDetailResponse);
                            break;
                    }
                }
            }
            else {
                if (popularItem.RelatedEntityFqdn == "QuestionAnswer")
                    popularItem.RelatedEntityFqdn = "Decos_Kcs_Faqs_Entities_QuestionAnswer";
                else if (popularItem.RelatedEntityFqdn == "Theme")
                    popularItem.RelatedEntityFqdn = "Decos_Kcs_Themes_Entities_Theme";
                else if (popularItem.RelatedEntityFqdn === null || popularItem.RelatedEntityFqdn == "" || popularItem.RelatedEntityFqdn == "Product")
                    popularItem.RelatedEntityFqdn = "Decos_Kcs_Products_Entities_Product";
                let entityType = GlobalFunctions.getObjectTypeName(popularItem.RelatedEntityFqdn).toLowerCase();
                if (GlobalFunctions.isEmpty(entityType))
                    return;
                this.sessionManager.loadedFromRelatedView = false;
                this.sessionManager.selectedEntity = popularItem;
                this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${entityType}`;
                this.sessionManager.addBreadcrumbItems([popularItem], null, location.pathname);
                this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
                if (this.router.url.substring(1) === this.sessionManager.selectedEntity.locationUrl)
                    this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
            }
        }
    }
    completedPopularList(result) {
        this.popularList = result;
    }
    entityDetailResponse(detailDto) {
        if (detailDto != null) {
            this.sessionManager.loadedFromRelatedView = false;
            let selectedEntityDto = Array.isArray(detailDto) ? detailDto[0] : detailDto;
            this.sessionManager.selectedEntity = selectedEntityDto;
            let entityType = GlobalFunctions.getObjectTypeName(selectedEntityDto.RelatedEntityFqdn).toLowerCase();
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${entityType}`;
            this.sessionManager.addBreadcrumbItems([selectedEntityDto], null, location.pathname);
            this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
        }
        else {
            if (!GlobalFunctions.isEmpty(this.currentEntity)) {
                let exception = new BusinessExceptionDto();
                exception.Message = this.translateService.instant("LBL_" + this.currentEntity + "_NOT_FOUND");
                exception.HelpText = this.translateService.instant("LBL_" + this.currentEntity + "_NOT_FOUND_MESSAGE");
                exception.Title = this.currentEntity;
                ExceptionHelper.showException(this.dialog, exception);
                this.router.navigate(['/']);
            }
        }
    }
    clearTextValue() {
        GlobalFunctions.clearValue();
        this.searchService.searchQuery = '';
    }
}
//# sourceMappingURL=search.component.js.map