var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject, ViewChild } from '@angular/core';
import { MatAutocompleteTrigger } from '@angular/material/autocomplete';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { SubSink } from 'subsink';
import { OperationType, RecordSelection } from '../../../core/enums/common-enums';
import { EntityFqdn } from '../../../core/enums/core-enums';
import { ContentType } from '../../../core/models/jkc-object/jkc-object';
import { BroadCastEventKeys } from '../../../shared/constants';
import { GlobalFunctions } from '../../../shared/global-functions';
import { ExceptionHelper } from '../../../shared/helper/exception-helper';
import { BaseComponent } from '../../base-component';
let SearchPopupComponent = class SearchPopupComponent extends BaseComponent {
    constructor(data, sessionManager, dialogRef, applicationSettingManager, translateService, cacheManager, integrationSettingManager, changeDetectorRef, zone, dialog, viewContainerRef, router, eventProvider, searchService) {
        super(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef);
        this.data = data;
        this.sessionManager = sessionManager;
        this.dialogRef = dialogRef;
        this.applicationSettingManager = applicationSettingManager;
        this.translateService = translateService;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.changeDetectorRef = changeDetectorRef;
        this.zone = zone;
        this.dialog = dialog;
        this.viewContainerRef = viewContainerRef;
        this.router = router;
        this.eventProvider = eventProvider;
        this.searchService = searchService;
        this.selectedEntities = [];
        this.selectedEntity = null;
        this.entityType = 'LBL_' + this.data.name?.toUpperCase().replace("ENTITY", '_ENTITY')?.toUpperCase();
        this.alternateSearchSources = [];
        this.searchValidationMessage = "";
        this.searchPlaceholder = this.applicationSettingManager.getSearchDescriptionText(GlobalFunctions.toContentType(this.data.name));
        this.searchText = { 'query': '' };
        this.sourceLocationList = [];
        this.sourceOptions = [];
        this.submitted = false;
        this.searchStatusQuery = "";
        this.canLoadSearchComponent = false;
        this.isSearchResult = false;
        this.subs = new SubSink();
        this.localSearchFilter = "";
        this.searchPanelHide = false;
        this.entitySource = null;
        this.recordSelection = RecordSelection.Multiple;
        this.timeoutIds = [];
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.SINGLE_RECORD_SELECTION).subscribe(entity => this.select(entity));
    }
    ngOnInit() {
        try {
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
            this.sessionManager.localSearchQuery = "";
            if (this.data.name.toLowerCase().indexOf('#') >= 0) {
                const entity = this.data.name.split('#');
                this.data.name = entity[0];
                this.entitySource = entity[1];
            }
            if (this.data.name.toLowerCase().indexOf('|') >= 0) {
                const entity = this.data.name.split('|');
                this.data.name = entity[0];
                this.searchText.query = entity[1];
                this.data.autoSearch = true;
            }
            if (this.data.name.toLowerCase().indexOf('link') >= 0)
                this.entityType = 'LBL_LINKS';
            else
                this.entityType = 'LBL_' + this.data.name?.toUpperCase().replace("ENTITY", '_ENTITY')?.toUpperCase();
            if (this.data.searchPanelHide != undefined)
                this.searchPanelHide = this.data.searchPanelHide;
            this.sourceLocationList = this.applicationSettingManager.getSourceLocationsByEntity(this.data.name);
            if (this.data.name.toLowerCase().indexOf('ticket') >= 0 && this.sourceLocationList.length > 0) {
                this.ticketConfiguration = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
                if (!GlobalFunctions.isEmpty(this.ticketConfiguration.TicketTypes) && this.ticketConfiguration.TicketTypes.length > 0) {
                    this.sourceLocationList.forEach(source => {
                        let sourceLocationName = source.SourceLocationName?.toUpperCase();
                        if (sourceLocationName != this.translateService.instant("LBL_ALL_SOURCES")?.toUpperCase()) {
                            this.ticketConfiguration.TicketTypes.forEach(ticketType => {
                                if (ticketType.Title?.toUpperCase() == sourceLocationName && !GlobalFunctions.hasRight(ContentType.Ticket, OperationType.View, ticketType.Id))
                                    this.sourceLocationList.splice(this.sourceLocationList.indexOf(source), 1);
                            });
                        }
                    });
                }
            }
            if (this.data.query) {
                this.searchText.query = this.data.query;
                this.search();
            }
            if (this.data.recordSelection !== null)
                this.recordSelection = this.data.recordSelection;
            if (this.data.autoSearch === true) {
                if (this.data.name.toLowerCase() == 'fileentity')
                    this.autoSearchFiles();
                else
                    this.search(this.entitySource);
            }
            this.sourceLocationList.forEach(sourceLocation => sourceLocation.formattedText = this.translateService.instant("LBL_SEARCH_IN") + " " + sourceLocation.SourceLocationName);
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, e, true);
        }
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    autoSearchFiles() {
        this.searchValidationMessage = "";
        this.canLoadSearchComponent = true;
        this.changeDetectorRef.markForCheck();
    }
    ;
    selected(sourceLocation) {
        sourceLocation = sourceLocation == this.translateService.instant("LBL_ALL_SOURCES") ? "" : sourceLocation;
        this.search(sourceLocation);
    }
    search(sourceLocation = null) {
        if (!this.isSearchNameEmpty()) {
            if (this.searchText.query && this.searchText.query.length > 0) {
                this.clearPreviousResults();
                this.searchValidationMessage = "";
                this.searchStatusQuery = this.searchText.query;
                this.canLoadSearchComponent = true;
                if (!GlobalFunctions.isEmpty(this.autocomplete))
                    this.autocomplete.openPanel();
                if (this.sourceOptions.length > 0) {
                    this.searchService.isAdvancedSearch = false;
                    this.searchService.selectedSearchOption = { searchQuery: this.searchStatusQuery, entitySource: this.entitySource, sourceLocation };
                    if (!GlobalFunctions.isEmpty(this.autocomplete))
                        this.autocomplete.closePanel();
                }
                // merge - Person(Cdr)/Organization(Cdr) search result list from search popup
                else if (this.data.name.toLowerCase() === "person" || this.data.name.toLowerCase() === 'organization')
                    this.searchService.selectedSearchOption = { searchQuery: this.searchStatusQuery, handler: this.entitySource };
            }
            this.searchService.isAdvancedSearch = false;
            this.searchService.isSearchFromPopup = true;
            this.canLoadSearchComponent = true;
            this.submitted = true;
        }
        else {
            this.searchValidationMessage = this.translateService.instant("LBL_VAL_MINIMUM_CHARACTER");
            this.canLoadSearchComponent = false;
        }
    }
    ;
    selectEntity(selectedObject) {
        if (!this.recordSelection) {
            this.selectedEntity = selectedObject;
            this.close();
        }
    }
    multiSelect() {
        if (this.selectedEntities.length > 0) {
            this.selectedEntity = this.selectedEntities;
            this.close();
        }
    }
    select(event) {
        if (event.isCheck)
            this.selectedEntities.push(event.domainObj);
        else {
            let index = this.selectedEntities.indexOf(event.domainObj);
            this.selectedEntities.splice(index, 1);
        }
    }
    selectAll(event, filteredEntities) {
        if (event.isCheck && event.filteredEntities.length > 0) {
            event.filteredEntities.forEach(value => {
                if (value != null) {
                    value.checked = true;
                    this.selectedEntities.push(value);
                    this.changeDetectorRef.detectChanges();
                }
            });
        }
        else {
            event.filteredEntities.forEach(item => item.checked = false);
            this.selectedEntities = [];
        }
    }
    clearSearchValue() {
        this.searchText.query = '';
        $(".searchPopup.jkcSearchCircleClose").hide();
        this.canLoadSearchComponent = false;
    }
    showClearButton(event) {
        if (event.keyCode === 13)
            this.search();
        this.searchText.query != '' ? $(".searchPopup.jkcSearchCircleClose").show() : $(".searchPopup.jkcSearchCircleClose").hide();
        if (event.target.value.length >= 1) {
            this.sourceOptions = this.sourceLocationList;
            if (!GlobalFunctions.isEmpty(this.autocomplete))
                this.autocomplete.updatePosition();
        }
        else
            this.sourceOptions = null;
    }
    resize() {
        setTimeout(() => {
            let windowHeight = $(window).height();
            let newHeight = windowHeight - $("#searchPopupDialogHeader").height() - $("#searchPanel").height() - $("#searchResultPanel").height() - $("#searchPopupFooter").height();
            $(".fht-tbody").height(newHeight - 250);
            GlobalFunctions.resizejkcBootstrapTable();
        }, 300);
    }
    isSearchNameEmpty() {
        this.data.name = this.data.name?.toUpperCase();
        return GlobalFunctions.isEmpty(this.searchText.query);
    }
    updateLocalFilter(event) {
        this.searchService.isLocalSearch = true;
        this.localSearchFilter = event.target.value;
        this.sessionManager.localSearchQuery = this.localSearchFilter;
    }
    close() {
        this.dialogRef.close(this.selectedEntity);
        if (this.searchService.selectedSearchOption)
            this.searchService.selectedSearchOption.autoSearch = false;
    }
    onKeyUp(event) {
        const inputElement = event.target;
        if (event.key === 'Backspace' || event.key === 'Delete') {
            if (inputElement.value.length === 0) {
                this.clearSearchValue();
            }
        }
        else {
            if (inputElement.selectionStart === 0 && inputElement.selectionEnd === inputElement.value.length) {
                this.clearPreviousResults();
            }
        }
    }
    clearPreviousResults() {
        this.selectedEntities = [];
        this.canLoadSearchComponent = false;
        this.searchStatusQuery = "";
        this.searchService.isSearchFromPopup = false;
        this.searchService.isAdvancedSearch = false;
        this.searchService.selectedSearchOption = null;
        if (!GlobalFunctions.isEmpty(this.autocomplete))
            this.autocomplete.closePanel();
        this.changeDetectorRef.markForCheck();
    }
};
__decorate([
    ViewChild(MatAutocompleteTrigger)
], SearchPopupComponent.prototype, "autocomplete", void 0);
SearchPopupComponent = __decorate([
    Component({
        selector: 'search-popup',
        templateUrl: './search-popup.component.html',
        styleUrls: ['./search-popup.component.scss'],
        host: { '(window:resize)': 'resize()' }
    }),
    __param(0, Inject(MAT_DIALOG_DATA))
], SearchPopupComponent);
export { SearchPopupComponent };
//# sourceMappingURL=search-popup.component.js.map