var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Input } from '@angular/core';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { BroadCastEventKeys, RoutePath } from '../../../shared/constants';
let NotificationComponent = class NotificationComponent {
    constructor(router, noteService, eventProvider, sessionManager, applicationSettingManager) {
        this.router = router;
        this.noteService = noteService;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.applicationSettingManager = applicationSettingManager;
        this.notificationItems = [];
    }
    removeNotification(item, $event) {
        if (item && item.NoteEntity) {
            this.noteService.setNotificationMessageViewerStatus(item.Id);
            this.notificationItems = GlobalFunctions.removeItem(this.notificationItems, item);
            if ($event.stopPropagation)
                $event.stopPropagation();
            if ($event.preventDefault)
                $event.preventDefault();
            $event.cancelBubble = true;
            $event.returnValue = false;
        }
    }
    select(type, selectedEntity) {
        if (selectedEntity) {
            if (this.sessionManager.isViewerFeatureEnabled && this.sessionManager.hasViewerAccess && this.applicationSettingManager.viewerSetting.loadFromRelatedItem(type))
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.OPEN_VIEWER_PANEL, selectedEntity);
            else
                this.openItemInDetailView(type, selectedEntity);
        }
    }
    ;
    openItemInDetailView(type, item) {
        if (type.toUpperCase() == 'PERSON' && GlobalFunctions.isEmpty(item.Id) && !GlobalFunctions.isEmpty(item.AdministeredPersonDto) && !GlobalFunctions.isEmpty(item.AdministeredPersonDto.ServiceNumber))
            item.Id = item.AdministeredPersonDto.ServiceNumber;
        if (type.toUpperCase() == 'EMPLOYEE' && !GlobalFunctions.isEmpty(item.IsDeleted) && item.IsDeleted)
            return;
        this.sessionManager.loadedFromRelatedView = true;
        this.sessionManager.selectedEntity = item;
        if (type.toLowerCase() == 'contacthistory' && !GlobalFunctions.isEmpty(item.ContactType) && item.ContactType == "CallbackAttempt")
            type = "CallbackAttempt";
        type = type.toLowerCase();
        if (GlobalFunctions.supportsDeeplinking(type, item.ObjectSource))
            item.locationUrl = `${RoutePath.DETAIL_PATH}/${type}/${item.Id}`;
        else
            item.locationUrl = `${RoutePath.DETAIL_PATH}/${type}`;
        this.sessionManager.setBreadcrumbGrammer(item);
        this.sessionManager.addBreadcrumbItems([item], null, RoutePath.DETAIL_PATH);
        this.router.navigate([item.locationUrl]);
    }
    ;
};
__decorate([
    Input()
], NotificationComponent.prototype, "notificationItems", void 0);
NotificationComponent = __decorate([
    Component({
        selector: 'notification',
        templateUrl: './notification.component.html',
        styleUrls: ['./notification.component.scss']
    })
], NotificationComponent);
export { NotificationComponent };
//# sourceMappingURL=notification.component.js.map