var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { GlobalFunctions } from '../../../shared/global-functions';
import { ExceptionHelper } from '../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../base-dialog.component';
let ManageLocalGroupPrivilegeComponent = class ManageLocalGroupPrivilegeComponent extends BaseDialogComponent {
    constructor(result, sessionManager, translateService, dialogRef, dialog) {
        super();
        this.result = result;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.dialog = dialog;
        this.title = this.translateService.instant("LBL_MANAGE_LOCAL_GROUP_PRIVILEGE");
        this.localUserGroups = this.result.localUserGroups;
        this.privilegedGroupIds = this.result.privilegedGroupIds;
        this.showErrorMessage = false;
    }
    ngOnInit() {
        try {
            if (!GlobalFunctions.isEmpty(this.localUserGroups) && this.localUserGroups.length > 0)
                this.localUserGroups.sort((a, b) => a.Name.localeCompare(b.Name));
            if (!GlobalFunctions.isEmpty(this.privilegedGroupIds)) {
                this.localUserGroups.forEach(userGroup => {
                    if (this.privilegedGroupIds.indexOf(userGroup.Id) != -1)
                        userGroup.AllowEnum = 0;
                    else
                        userGroup.AllowEnum = 2;
                });
            }
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, e, true);
        }
    }
    ;
    saveLocalGroupPrivilege() {
        this.privilegedGroupIds = '';
        this.localUserGroups.forEach(userGroup => {
            if (userGroup.AllowEnum == 0)
                this.privilegedGroupIds += userGroup.Id + ';';
        });
        this.dialogRef.close(this.privilegedGroupIds);
    }
    close() {
        this.dialogRef.close();
    }
    ;
};
ManageLocalGroupPrivilegeComponent = __decorate([
    Component({
        selector: 'manage-local-group-privilege',
        templateUrl: './manage-local-group-privilege.component.html',
        styleUrls: ['./manage-local-group-privilege.component.scss']
    }),
    __param(0, Inject(MAT_DIALOG_DATA))
], ManageLocalGroupPrivilegeComponent);
export { ManageLocalGroupPrivilegeComponent };
//# sourceMappingURL=manage-local-group-privilege.component.js.map