var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { ContentType } from 'src/app/core/models/jkc-object/jkc-object';
import { BroadCastEventKeys } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { SubSink } from 'subsink';
import { LicenseSpecificFeature, LinkUnlinkActionType, RecordSelection } from '../../../core/enums/common-enums';
import { EntityFqdn } from '../../../core/enums/core-enums';
import { SearchObject } from '../../../core/models/common/search-objectDto';
import { BaseDialogComponent } from '../base-dialog.component';
import { MessageboxComponent } from '../messagebox/messagebox.component';
import { SearchPopupComponent } from '../search-popup/search-popup.component';
let LinkUnlinkEntityComponent = class LinkUnlinkEntityComponent extends BaseDialogComponent {
    constructor(result, sessionManager, applicationSettingManager, translateService, dialogRef, systemComponentService, cacheManager, ticketService, shortcutManager, dialog, changeDetectorRef, eventProvider, htmlToPlainTextPipe) {
        super();
        this.result = result;
        this.sessionManager = sessionManager;
        this.applicationSettingManager = applicationSettingManager;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.systemComponentService = systemComponentService;
        this.cacheManager = cacheManager;
        this.ticketService = ticketService;
        this.shortcutManager = shortcutManager;
        this.dialog = dialog;
        this.changeDetectorRef = changeDetectorRef;
        this.eventProvider = eventProvider;
        this.htmlToPlainTextPipe = htmlToPlainTextPipe;
        this.linkEntityList = [];
        this.title = "";
        this.linkUnlinkMessage = "";
        this.content = null;
        this.isUnlinkType = this.result.linkUnlinkActionType == LinkUnlinkActionType.Unlink ? true : false;
        this.existEntityLinkList = null;
        this.linkEntities = [];
        this.groupedLinkEntities = {};
        this.timeoutIds = [];
        this.addToCase = false;
        this.addToCaseAllowed = false;
        this.subs = new SubSink();
        this.getManualEntityLinkItemsResponse = this.getManualEntityLinkItemsResponse.bind(this);
        this.linkUnlinkEntityItemsResponse = this.linkUnlinkEntityItemsResponse.bind(this);
        this.linkUnlinkErrorCallback = this.linkUnlinkErrorCallback.bind(this);
    }
    ngOnInit() {
        try {
            this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.saveLinkUnlinkEntity());
            this.initManualLinkEntities();
            this.linkEntities = jlinq.from(this.linkEntities).sort("linkEntityText").select();
            this.selectedLinkEntitySearchValue = this.linkEntities[0].linkEntityValue;
            this.init();
            this.timeoutIds.push(setTimeout(() => this.resize()));
            this.addToCaseAllowed = this.getSelectedEntityType() == 'CONTACTMOMENT' && this.applicationSettingManager.isLinkCSNToCaseSystemEnabled;
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, e, true);
        }
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    init() {
        this.timeoutIds.push(setTimeout(() => { this.systemComponentService.getEntityLinkItems(GlobalFunctions.toString(this.result.selectedEntity.RelatedEntityFqdn), this.result.selectedEntity.Id, this.result.selectedEntity.ObjectSource, this.getManualEntityLinkItemsResponse); }, 1000));
        let entityTitle = this.sessionManager.selectedEntity.Title == undefined ? this.sessionManager.selectedEntity.StringRepresentation : this.sessionManager.selectedEntity.Title;
        entityTitle = this.htmlToPlainTextPipe.transform(entityTitle);
        if (entityTitle != null) {
            this.title = this.isUnlinkType ? this.translateService.instant(("LBL_UNLINK").toUpperCase()) : this.translateService.instant(("LBL_LINK").toUpperCase()) + " " + this.translateService.instant(("LBL_TO").toUpperCase()) + " " + entityTitle.toUpperCase();
            this.linkUnlinkMessage = this.isUnlinkType ? this.translateService.instant("LBL_UNLINK_MESSAGE") : this.translateService.instant("LBL_LINK_MESSAGE");
            this.startSpinner();
        }
    }
    getSelectedEntityType() {
        if (!GlobalFunctions.isEmpty(this.result.selectedEntity))
            return GlobalFunctions.getObjectTypeName(this.result.selectedEntity.RelatedEntityFqdn).toUpperCase();
    }
    initManualLinkEntities() {
        this.linkEntities = [
            { linkEntityValue: "NoteEntity", linkEntityText: this.translateService.instant("LBL_NOTE_ENTITY") },
            { linkEntityValue: "FileEntity", linkEntityText: this.translateService.instant("LBL_FILE_ENTITY") },
            { linkEntityValue: "Employee", linkEntityText: this.translateService.instant("LBL_EMPLOYEE") },
            { linkEntityValue: "Organization", linkEntityText: this.translateService.instant("LBL_ORGANIZATION") },
            { linkEntityValue: "Product", linkEntityText: this.translateService.instant("LBL_PRODUCT") },
            { linkEntityValue: "QuestionAnswer", linkEntityText: this.translateService.instant("LBL_QUESTION_ANSWER") },
        ];
        if (GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Ticket) && !GlobalFunctions.isEmpty(this.result.selectedEntity) && GlobalFunctions.getObjectTypeName(this.result.selectedEntity.RelatedEntityFqdn).toUpperCase() !== 'THEME')
            this.linkEntities.push({ linkEntityValue: "Ticket", linkEntityText: this.translateService.instant("LBL_TICKET") });
        //Don't add Document/Person/Case for Theme page
        if (!GlobalFunctions.isEmpty(this.result.selectedEntity) && GlobalFunctions.getObjectTypeName(this.result.selectedEntity.RelatedEntityFqdn).toUpperCase() != 'THEME') {
            this.linkEntities.push({ linkEntityValue: "Document", linkEntityText: this.translateService.instant("LBL_DOCUMENT") });
            if (GlobalFunctions.getObjectTypeName(this.result.selectedEntity.RelatedEntityFqdn).toUpperCase() != 'LINK')
                this.linkEntities.push({ linkEntityValue: "Person", linkEntityText: this.translateService.instant("LBL_PERSON") });
            this.linkEntities.push({ linkEntityValue: "CaseEntity", linkEntityText: this.translateService.instant("LBL_CASE") });
        }
        else {
            this.linkEntities.push({ linkEntityValue: "Theme", linkEntityText: this.translateService.instant("LBL_THEME") });
            this.linkEntities.push({ linkEntityValue: "News", linkEntityText: this.translateService.instant("LBL_NEWS") });
            this.linkEntities.push({ linkEntityValue: "PopularNumber", linkEntityText: this.translateService.instant("LBL_POPULAR_NUMBER") });
        }
        //Don't add link for Person/CaseType
        if (!GlobalFunctions.isEmpty(this.result.selectedEntity) && GlobalFunctions.getObjectTypeName(this.result.selectedEntity.RelatedEntityFqdn).toUpperCase() != 'PERSON' && GlobalFunctions.getObjectTypeName(this.result.selectedEntity.RelatedEntityFqdn).toUpperCase() != 'CASETYPE')
            this.linkEntities.push({ linkEntityValue: "Link", linkEntityText: this.translateService.instant("LBL_LINKS") });
    }
    getManualEntityLinkItemsResponse(response) {
        this.stopSpinner();
        if (response != null && response.EntityLinkList != null && response.EntityLinkList.length > 0) {
            this.existEntityLinkList = response.EntityLinkList;
            for (let index = 0; index < response.EntityLinkList.length; index++)
                this.addLinkItem(response.EntityLinkList[index].TargetObject.ObjectItem, response.EntityLinkList[index].TargetObject.ObjectContentType);
        }
        this.fillRelatedEntityList();
        this.groupedLinkEntities = jlinq.from(this.linkEntityList).group("entityName");
        this.groupedLinkEntitiesKeys = Object.keys(this.groupedLinkEntities).sort();
        this.changeDetectorRef.detectChanges();
    }
    linkUnlinkEntityItemsResponse(response) {
        this.stopSpinner();
        if (response != null) {
            if (response.ActionResult == 0) {
                this.close();
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
            }
            else
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_LINK'), textMsg: this.translateService.instant("LBL_LINK_UNLINK_FAILED_MESSAGE") });
        }
    }
    selectAll() {
        if (this.linkEntityList != null && this.linkEntityList.length > 0) {
            this.linkEntityList.forEach(value => {
                if (value != null)
                    value.content.IsMarked = this.selectContent;
            });
        }
        this.selectContent = !this.selectContent;
    }
    addLinkItem(linkEntity, contentType, isManual = true) {
        if (linkEntity != null) {
            let isExists = false;
            if (this.linkEntityList != null && this.linkEntityList.length > 0) {
                for (let index = 0; index < this.linkEntityList.length; index++) {
                    if (this.linkEntityList[index].content.Id == linkEntity.Id && this.linkEntityList[index].content.ObjectSource == linkEntity.ObjectSource) {
                        isExists = true;
                        break;
                    }
                }
            }
            if (!isExists) {
                let entityContent = new Object();
                let menuTitle = "";
                if (contentType.toLowerCase().indexOf("link") >= 0)
                    menuTitle = this.translateService.instant("LBL_LINKS");
                else if (contentType.toLowerCase().indexOf("employee") >= 0 && linkEntity.IsPopular)
                    menuTitle = this.translateService.instant("LBL_POPULAR_NUMBER");
                else
                    menuTitle = this.translateService.instant("LBL_" + GlobalFunctions.getObjectTypeName(contentType).toUpperCase());
                entityContent.entityName = menuTitle;
                entityContent.content = linkEntity;
                entityContent.content.IsMarked = true;
                entityContent.linkEntityIcon = contentType.toLowerCase().indexOf("popularnumber") >= 0
                    ? "jkcPopularNumberBlue jkcSizeSmall"
                    : this.getRelatedEntityStyleIconClass(contentType);
                entityContent.isManual = isManual;
                this.linkEntityList.push(entityContent);
            }
        }
    }
    saveLinkUnlinkEntity() {
        this.startSpinner();
        let request = new Object();
        request.EntityLinkDtoList = this.getManualEntityLinkList();
        request.AddToCase = this.addToCase;
        this.systemComponentService.linkUnlinkEntityItems(request, this.linkUnlinkEntityItemsResponse, this.linkUnlinkErrorCallback);
        this.unlinkRelatedEntityList();
        this.close();
    }
    linkUnlinkErrorCallback() {
        this.stopSpinner();
        let title = this.isUnlinkType ? this.translateService.instant("LBL_UNLINK").toUpperCase() : this.translateService.instant("LBL_LINK").toUpperCase();
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_LINK_UNLINK_ERROR_MSG"), [title]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, title);
        ExceptionHelper.showException(this.dialog, exception, true);
    }
    getManualEntityLinkList() {
        let entityLinkList = [];
        if (this.linkEntityList.length > 0) {
            for (let index = 0; index < this.linkEntityList.length; index++) {
                if (this.linkEntityList[index].isManual) {
                    let linkItem = this.linkEntityList[index].content;
                    let existEntityLinkDto = this.isEntityLinkExists(linkItem);
                    if (this.result.selectedEntity.Id != linkItem.Id) {
                        if (existEntityLinkDto == null) {
                            let entityLinkDto = new Object();
                            //Code to add SourceEntityDetails
                            let sourceEntityLinkDetailDto = new Object();
                            sourceEntityLinkDetailDto.ObjectId = this.result.selectedEntity.Id;
                            sourceEntityLinkDetailDto.ObjectContentType = GlobalFunctions.toString(this.result.selectedEntity.RelatedEntityFqdn);
                            sourceEntityLinkDetailDto.ObjectSource = this.result.selectedEntity.ObjectSource;
                            sourceEntityLinkDetailDto.ObjectItem = this.convertManualLinkItem(this.result.selectedEntity);
                            entityLinkDto.SourceObject = sourceEntityLinkDetailDto;
                            //Code to add TargetEntityDetails
                            let targetEntityLinkDetailDto = new Object();
                            targetEntityLinkDetailDto.ObjectId = linkItem.Id;
                            targetEntityLinkDetailDto.ObjectContentType = GlobalFunctions.toString(linkItem.RelatedEntityFqdn);
                            targetEntityLinkDetailDto.ObjectSource = linkItem.ObjectSource;
                            targetEntityLinkDetailDto.ObjectItem = this.convertManualLinkItem(linkItem);
                            entityLinkDto.TargetObject = targetEntityLinkDetailDto;
                            entityLinkDto.TargetObject.IsMarked = linkItem.IsMarked;
                            entityLinkDto.CreatedById = GlobalFunctions.getLoggedInUserId();
                            entityLinkList.push(entityLinkDto);
                        }
                        else {
                            existEntityLinkDto.TargetObject.IsMarked = linkItem.IsMarked;
                            entityLinkList.push(existEntityLinkDto);
                        }
                    }
                }
            }
        }
        return entityLinkList;
    }
    convertManualLinkItem(linkItem) {
        let objectType = GlobalFunctions.getContentTypeByPropertyName("RelatedEntityFqdn", linkItem);
        let relatedEntity = linkItem;
        relatedEntity.Id = linkItem.Id;
        relatedEntity.ObjectSource = linkItem.ObjectSource;
        return relatedEntity;
    }
    isEntityLinkExists(linkEntity) {
        let existEntityLinkItem = null;
        if (this.existEntityLinkList != null && this.existEntityLinkList.length > 0) {
            for (let index = 0; index < this.existEntityLinkList.length; index++) {
                let linkedItem = this.existEntityLinkList[index].TargetObject.ObjectItem;
                if (linkedItem != null && linkedItem.Id == linkEntity.Id && linkedItem.ObjectSource == linkEntity.ObjectSource) {
                    existEntityLinkItem = this.existEntityLinkList[index];
                    break;
                }
            }
        }
        return existEntityLinkItem;
    }
    searchLinkType(value = null) {
        if (value)
            this.selectedLinkEntitySearchValue = value;
        this.openSearchPopup(this.selectedLinkEntitySearchValue);
    }
    openSearchPopup(entity) {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: entity, recordSelection: RecordSelection.Multiple }).afterClosed().subscribe(searchEntities => {
            if (searchEntities != null && searchEntities.length > 0) {
                searchEntities.forEach(searchEntity => {
                    this.sessionManager.setBreadcrumbGrammer(searchEntity);
                    if (searchEntity.RelatedEntityFqdn == 'Decos_Kcs_Notes_Entities_NoteEntity' && !GlobalFunctions.isEmpty(searchEntity.Title))
                        searchEntity.StringRepresentation = searchEntity.Title;
                    this.addLinkItem(searchEntity, searchEntity.RelatedEntityFqdn);
                });
                this.groupedLinkEntities = jlinq.from(this.linkEntityList).group("entityName");
                this.groupedLinkEntitiesKeys = Object.keys(this.groupedLinkEntities);
            }
            $("#linkUnlinkSearchButton").focus();
        });
    }
    getRelatedEntityStyleIconClass(contentType) {
        let iconStyleClass = '';
        contentType = GlobalFunctions.toString(contentType);
        switch (contentType) {
            case ContentType.Case:
                {
                    iconStyleClass = 'jkcCaseBlue jkcSizeSmall';
                    break;
                }
            case ContentType.CallbackNote:
                {
                    iconStyleClass = 'jkcCallbacknoteBlue jkcSizeSmall';
                    break;
                }
            case ContentType.ContactMoment:
                {
                    iconStyleClass = 'jkcContacthistoryBlue jkcSizeSmall';
                    break;
                }
            case ContentType.Document:
                {
                    iconStyleClass = 'jkcDocumentBlue jkcSizeSmall';
                    break;
                }
            case ContentType.Email:
                {
                    iconStyleClass = 'jkcEmailBlue jkcSizeNormal';
                    break;
                }
            case ContentType.Employee:
                {
                    iconStyleClass = 'jkcEmployeeBlue jkcSizeSmall';
                    break;
                }
            case ContentType.File:
                {
                    iconStyleClass = 'jkcDocumentBlue jkcSizeSmall';
                    break;
                }
            case ContentType.Note:
                {
                    iconStyleClass = 'jkcNoteentityBlue jkcSizeSmall';
                    break;
                }
            case ContentType.Organization:
                {
                    iconStyleClass = 'jkcOrganizationBlue jkcSizeSmall';
                    break;
                }
            case ContentType.Person:
                {
                    iconStyleClass = 'jkcPersonBlue jkcSizeSmall';
                    break;
                }
            case ContentType.Product:
                {
                    iconStyleClass = 'jkcProductBlue jkcSizeSmall';
                    break;
                }
            case ContentType.Task:
                {
                    iconStyleClass = 'jkcTaskBlue jkcSizeSmall';
                    break;
                }
            case ContentType.QuestionAnswer:
                {
                    iconStyleClass = 'jkcQuestionanswerBlue jkcSizeSmall';
                    break;
                }
            case ContentType.Theme:
                {
                    iconStyleClass = 'jkcThemeBlue jkcSizeSmall';
                    break;
                }
            case ContentType.Link:
                {
                    iconStyleClass = 'jkcLinkBlue jkcSizeSmall';
                    break;
                }
            case ContentType.News:
                {
                    iconStyleClass = 'jkcNewsBlue jkcSizeSmall';
                    break;
                }
            case ContentType.Ticket:
                {
                    iconStyleClass = 'jkcTicketBlue jkcSizeSmall';
                    break;
                }
            case ContentType.Issue:
                {
                    iconStyleClass = 'jkcIssueBlue jkcSizeSmall';
                    break;
                }
            case ContentType.Domain:
                {
                    iconStyleClass = 'jkcDomainBlue jkcSizeSmall';
                    break;
                }
        }
        return iconStyleClass;
    }
    onResize() {
        this.resize();
    }
    resize() {
        $('#linkUnlinkEntityContainer').height($(window).height() - $('#linkUnlinkEntityHeader').height() - $('#linkUnlinkEntityFooter').height() - 210 + 'px');
    }
    fillRelatedEntityList() {
        if (this.sessionManager.selectedEntity != null) {
            if (this.sessionManager.selectedEntity.RelatedEntityFqdn == EntityFqdn[EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket] && this.sessionManager.selectedEntity.RelatedEntityList != null && this.sessionManager.selectedEntity.RelatedEntityList.length > 0) {
                for (let index = 0; index < this.sessionManager.selectedEntity.RelatedEntityList.length; index++) {
                    let relatedEntity = this.sessionManager.selectedEntity.RelatedEntityList[index];
                    let contentType = GlobalFunctions.getObjectTypeName(relatedEntity.EntityType);
                    relatedEntity = this.cacheManager.getRelatedEntityById(relatedEntity.EntityId, contentType);
                    if (relatedEntity != null) {
                        this.sessionManager.setBreadcrumbGrammer(relatedEntity);
                        contentType = GlobalFunctions.toContentType(contentType);
                        this.addLinkItem(relatedEntity, contentType, false);
                    }
                }
            }
        }
    }
    unlinkRelatedEntityList() {
        if (this.result.selectedEntity.RelatedEntityFqdn == EntityFqdn[EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket] && this.result.selectedEntity.RelatedEntityList != null && this.result.selectedEntity.RelatedEntityList.length > 0) {
            let sourceEntity = new SearchObject(this.result.selectedEntity.Id, this.result.selectedEntity.RelatedEntityFqdn, this.result.selectedEntity.ObjectSource, "");
            let relatedUnlinkEntityList = this.getRelatedUnlinkEntityList();
            if (relatedUnlinkEntityList != null && relatedUnlinkEntityList.length > 0)
                this.ticketService.unlinkRelatedEntity(sourceEntity, relatedUnlinkEntityList, null);
        }
    }
    ;
    getRelatedUnlinkEntityList() {
        let relatedUnlinkEntityList = [];
        if (this.linkEntityList.length > 0) {
            for (let index = 0; index < this.linkEntityList.length; index++) {
                let relatedItem = this.linkEntityList[index];
                if (relatedItem.isManual == false && relatedItem.content.IsMarked == false)
                    relatedUnlinkEntityList.push(new SearchObject(relatedItem.content.Id, relatedItem.content.RelatedEntityFqdn, relatedItem.content.ObjectSource, ""));
            }
        }
        return relatedUnlinkEntityList;
    }
    checkStateChanged($event, linkEntityKey, index) {
        this.groupedLinkEntities[linkEntityKey][index].content.IsMarked = $event.target.checked;
    }
    close() {
        this.dialogRef.close();
    }
};
LinkUnlinkEntityComponent = __decorate([
    Component({
        selector: 'link-unlink-entity',
        templateUrl: './link-unlink-entity.component.html',
        styleUrls: ['./link-unlink-entity.component.scss'],
        host: { '(window:resize)': 'resize()' }
    }),
    __param(0, Inject(MAT_DIALOG_DATA))
], LinkUnlinkEntityComponent);
export { LinkUnlinkEntityComponent };
//# sourceMappingURL=link-unlink-entity.component.js.map