var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, HostListener, Inject, ViewChild } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { BroadCastEventKeys } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { SubSink } from 'subsink';
import { KeyCode, RecordOperationMode, RecordSelection } from '../../../core/enums/common-enums';
import { LinkDataDto } from '../../../core/models/common/link-data-dto';
import { LinkEmailRequest } from '../../../core/models/email/lnk-email-request';
import { LinkSocialMediaRequest } from '../../../core/models/link/link-social-media-request';
import { LinkSocialMediaDto } from '../../../core/models/link/link-social-mediaDto';
import { LinkPhoneNumberRequest } from '../../../core/models/phone/phone-link-phone-number-request';
import { BaseDialogComponent } from '../base-dialog.component';
import { MessageboxComponent } from '../messagebox/messagebox.component';
import { SearchPopupComponent } from '../search-popup/search-popup.component';
import { SessionItemListComponent } from '../session-item-list/session-item-list.component';
let LinkContactInfoComponent = class LinkContactInfoComponent extends BaseDialogComponent {
    constructor(data, sessionManager, translateService, dialogRef, dialogRefSessionItemList, systemComponentService, cacheManager, personService, emailService, organizationService, socialMediaService, shortcutManager, dialog, eventProvider, phoneService) {
        super();
        this.data = data;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.dialogRefSessionItemList = dialogRefSessionItemList;
        this.systemComponentService = systemComponentService;
        this.cacheManager = cacheManager;
        this.personService = personService;
        this.emailService = emailService;
        this.organizationService = organizationService;
        this.socialMediaService = socialMediaService;
        this.shortcutManager = shortcutManager;
        this.dialog = dialog;
        this.eventProvider = eventProvider;
        this.phoneService = phoneService;
        this.DateJS = Date;
        this.currentRelationType = 'Person';
        this.entityContent = new Object();
        this.title = this.translateService.instant("LBL_LINK_" + this.data.contactType.toUpperCase());
        this.linkedEmail = null;
        this.linkedEmailList = [];
        this.linkedPhoneNumber = null;
        this.linkedPhoneNumberList = [];
        this.formSubmitted = false;
        this.subs = new SubSink();
        this.linkEmailResponse = this.linkEmailResponse.bind(this);
        this.linkPhoneNumberResponse = this.linkPhoneNumberResponse.bind(this);
        this.linkSocialMediaResponse = this.linkSocialMediaResponse.bind(this);
        this.fetchPersonDetailResponse = this.fetchPersonDetailResponse.bind(this);
        this.linkSocialMediaErrorCallback = this.linkSocialMediaErrorCallback.bind(this);
        this.fetchOrganizationDetailResponse = this.fetchOrganizationDetailResponse.bind(this);
    }
    ngOnInit() {
        try {
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity)) {
                if (this.data.contactType === 'Email')
                    this.initEmail();
                else if (this.data.contactType === 'PhoneNumber')
                    this.initPhoneNumber();
                this.initLinkedEntity();
            }
            setTimeout(() => this.resize(), 300);
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, e, true);
        }
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    initEmail() {
        try {
            this.sessionManager.selectedEntity.LinkedEntity = null;
            if (this.data.clickedFrom == "from" && this.sessionManager.selectedEntity.Header && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Header.From))
                this.linkedEmailList.push({ key: this.sessionManager.selectedEntity.Header.From, value: this.sessionManager.selectedEntity.Header.From });
            else if (this.data.clickedFrom == "associated" && this.sessionManager.selectedEntity.Body && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Body.AssociatedEmails)) {
                for (let i = 0; i < this.sessionManager.selectedEntity.Body.AssociatedEmails.length; i++) {
                    if (!jlinq.from(this.linkedEmailList).starts("key", this.sessionManager.selectedEntity.Body.AssociatedEmails[i]).any())
                        this.linkedEmailList.push({ key: this.sessionManager.selectedEntity.Body.AssociatedEmails[i], value: this.sessionManager.selectedEntity.Body.AssociatedEmails[i] });
                }
            }
            if (!GlobalFunctions.isEmpty(this.linkedEmailList)) {
                if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LinkedEntityList)) {
                    for (let i = 0; i < this.linkedEmailList.length; i++) {
                        let linkedEntity = jlinq.from(this.sessionManager.selectedEntity.LinkedEntityList).starts("SourceId", this.linkedEmailList[i].key).first();
                        if (!GlobalFunctions.isEmpty(linkedEntity)) {
                            this.sessionManager.selectedEntity.LinkedEntity = linkedEntity;
                            this.linkedEmail = this.linkedEmailList[i];
                            break;
                        }
                    }
                }
                if (GlobalFunctions.isEmpty(this.linkedEmail))
                    this.linkedEmail = this.linkedEmailList[0];
            }
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, e, true);
        }
    }
    initPhoneNumber() {
        try {
            this.sessionManager.selectedEntity.LinkedEntity = null;
            if (this.sessionManager.selectedEntity.Body && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Body.AssociatedPhoneNumbers)) {
                for (let i = 0; i < this.sessionManager.selectedEntity.Body.AssociatedPhoneNumbers.length; i++)
                    this.linkedPhoneNumberList.push({ key: this.sessionManager.selectedEntity.Body.AssociatedPhoneNumbers[i], value: this.sessionManager.selectedEntity.Body.AssociatedPhoneNumbers[i] });
                if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LinkedEntityList)) {
                    for (let i = 0; i < this.linkedPhoneNumberList.length; i++) {
                        let linkedEntity = jlinq.from(this.sessionManager.selectedEntity.LinkedEntityList).starts("SourceId", this.linkedPhoneNumberList[i].key).first();
                        if (!GlobalFunctions.isEmpty(linkedEntity)) {
                            this.sessionManager.selectedEntity.LinkedEntity = linkedEntity;
                            this.linkedPhoneNumber = this.linkedPhoneNumberList[i];
                            break;
                        }
                    }
                }
                if (GlobalFunctions.isEmpty(this.linkedPhoneNumber))
                    this.linkedPhoneNumber = this.linkedPhoneNumberList[0];
            }
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, e, true);
        }
    }
    openSearchPopup() {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: this.currentRelationType, recordSelection: RecordSelection.Single }).afterClosed().subscribe(searchEntity => {
            if (searchEntity != null)
                this.fetchDetail(this.currentRelationType, searchEntity.Id, searchEntity.ObjectSource);
        });
    }
    linkFromSessionPopup() {
        this.sessionManager.selectedEntity.currentRelationType = this.currentRelationType;
        DialogHelper.openDialog(this.dialog, SessionItemListComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { isLinkPersonOrOrganization: true }).afterClosed().subscribe(searchEntity => {
            if (!GlobalFunctions.isEmpty(searchEntity) && searchEntity.length > 0 && searchEntity[0].Item && searchEntity[0].Item.IsMarked)
                this.selectLinkItem(searchEntity[0].Item, this.currentRelationType);
        });
    }
    fetchDetail(objectType, objectId, objectSource) {
        if (!GlobalFunctions.isEmpty(objectType) && !GlobalFunctions.isEmpty(objectId) && !GlobalFunctions.isEmpty(objectSource)) {
            this.startSpinner();
            let partialDto = new Object();
            partialDto.Id = objectId;
            partialDto.ObjectSource = objectSource;
            if (objectType.toLowerCase() === "person")
                this.personService.fetchDetail(partialDto, this.fetchPersonDetailResponse);
            else
                this.organizationService.fetchDetail(partialDto, this.fetchOrganizationDetailResponse);
        }
    }
    fetchPersonDetailResponse(personDto) {
        this.stopSpinner();
        if (personDto != null)
            this.selectLinkItem(personDto, "Person");
    }
    fetchOrganizationDetailResponse(organizationDto) {
        this.stopSpinner();
        if (organizationDto != null)
            this.selectLinkItem(organizationDto, "Organization");
    }
    selectLinkItem(linkEntity, contentType) {
        if (linkEntity != null) {
            this.entityContent.entityName = contentType;
            this.entityContent.content = linkEntity;
            this.sessionManager.setBreadcrumbGrammer(linkEntity);
            this.entityContent.content.StringRepresentation = linkEntity.StringRepresentation;
            this.entityContent.content.IsMarked = true;
        }
    }
    linkContactInfo() {
        if (this.form.valid) {
            if (this.data.contactType === 'SocialMedia')
                this.linkSocialMedia();
            else if (this.data.contactType === 'Email')
                this.linkEmail();
            else
                this.linkPhoneNumber();
        }
    }
    linkSocialMedia() {
        this.startSpinner();
        let req = new LinkSocialMediaRequest();
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LinkedEntity) && this.sessionManager.selectedEntity.LinkedEntity.TargetId == this.entityContent.content.Id && this.entityContent.content.IsMarked == "true")
            this.close();
        else
            req.LinkSocialMediaDto = new LinkSocialMediaDto();
        if (this.entityContent.entityName == "Person")
            req.PersonDto = this.entityContent.content;
        else
            req.OrganizationDto = this.entityContent.content;
        req.OperationMode = this.entityContent.content.IsMarked ? RecordOperationMode.New : RecordOperationMode.Delete;
        req.LinkSocialMediaDto.TargetId = this.entityContent.content.Id;
        req.LinkSocialMediaDto.TargetType = GlobalFunctions.toString(this.entityContent.content.RelatedEntityFqdn);
        req.LinkSocialMediaDto.TargetSource = this.entityContent.content.ObjectSource;
        req.LinkSocialMediaDto.TargetDetail = this.entityContent.content.StringRepresentation;
        req.LinkSocialMediaDto.CreatedOn = new this.DateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        req.LinkSocialMediaDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        req.LinkSocialMediaDto.SourceId = this.sessionManager.selectedEntity.Type == "Twitter" ? this.sessionManager.selectedEntity.User.ScreenName : this.sessionManager.selectedEntity.User.Id;
        req.LinkSocialMediaDto.SourceType = this.sessionManager.selectedEntity.Type;
        this.sessionManager.selectedEntity.LinkedEntity = this.entityContent.content.IsMarked ? req.LinkSocialMediaDto : null;
        this.socialMediaService.linkUnlinkEntityItems(req, this.linkSocialMediaResponse, this.linkSocialMediaErrorCallback);
    }
    linkSocialMediaErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_CREATE_ERROR_MSG"), [this.translateService.instant("LBL_LINK_SOCIALMEDIA")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_LINK_SOCIALMEDIA"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    linkSocialMediaResponse(response) {
        this.stopSpinner();
        if (response != null && response.Result == 0) {
            this.close();
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
        }
        else {
            this.sessionManager.selectedEntity.LinkedEntity = null;
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_LINK_SOCIALMEDIA'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_LINK_SOCIALMEDIA") });
        }
    }
    linkEmail() {
        this.startSpinner();
        let req = new LinkEmailRequest();
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LinkedEntity) && this.sessionManager.selectedEntity.LinkedEntity.TargetId == this.entityContent.content.Id && this.entityContent.content.IsMarked == "true")
            this.close();
        else
            req.LinkEmailDto = new LinkDataDto();
        if (this.entityContent.entityName === "Person")
            req.PersonDto = this.entityContent.content;
        else
            req.OrganizationDto = this.entityContent.content;
        req.OperationMode = this.entityContent.content.IsMarked ? RecordOperationMode.New : RecordOperationMode.Delete;
        req.LinkEmailDto.TargetId = this.entityContent.content.Id;
        req.LinkEmailDto.TargetType = GlobalFunctions.toString(this.entityContent.content.RelatedEntityFqdn);
        req.LinkEmailDto.TargetSource = this.entityContent.content.ObjectSource;
        req.LinkEmailDto.TargetDetail = this.entityContent.content.StringRepresentation;
        req.LinkEmailDto.CreatedOn = new this.DateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        req.LinkEmailDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        req.LinkEmailDto.SourceId = this.linkedEmail && !GlobalFunctions.isEmpty(this.linkedEmail.key) ? this.linkedEmail.key : this.sessionManager.selectedEntity.Header.From;
        this.sessionManager.selectedEntity.LinkedEntity = this.entityContent.content.IsMarked ? req.LinkEmailDto : null;
        this.emailService.linkUnlinkEntityItems(req, this.linkEmailResponse);
        if (this.entityContent.content.IsMarked) {
            if (GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LinkedEntityList))
                this.sessionManager.selectedEntity.LinkedEntityList = [];
            this.sessionManager.selectedEntity.LinkedEntityList.push(req.LinkEmailDto);
        }
        else
            GlobalFunctions.removeByAttr(this.sessionManager.selectedEntity.LinkedEntityList, "SourceId", req.LinkEmailDto.SourceId);
    }
    linkPhoneNumber() {
        this.startSpinner();
        const req = new LinkPhoneNumberRequest();
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LinkedEntity) && this.sessionManager.selectedEntity.LinkedEntity.TargetId == this.entityContent.content.Id && this.entityContent.content.IsMarked == "true")
            this.close();
        else
            req.LinkPhoneNumberDto = new LinkDataDto();
        if (this.entityContent.entityName == "Person")
            req.PersonDto = this.entityContent.content;
        else
            req.OrganizationDto = this.entityContent.content;
        req.OperationMode = this.entityContent.content.IsMarked ? RecordOperationMode.New : RecordOperationMode.Delete;
        req.LinkPhoneNumberDto.TargetId = this.entityContent.content.Id;
        req.LinkPhoneNumberDto.TargetType = GlobalFunctions.toString(this.entityContent.content.RelatedEntityFqdn);
        req.LinkPhoneNumberDto.TargetSource = this.entityContent.content.ObjectSource;
        req.LinkPhoneNumberDto.TargetDetail = this.entityContent.content.StringRepresentation;
        req.LinkPhoneNumberDto.CreatedOn = new this.DateJS().toString('M/d/yyyy HH:mm:ss');
        req.LinkPhoneNumberDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        req.LinkPhoneNumberDto.SourceId = this.linkedPhoneNumber.key;
        this.sessionManager.selectedEntity.LinkedEntity = this.entityContent.content.IsMarked ? req.LinkPhoneNumberDto : null;
        this.phoneService.linkUnlinkEntityItems(req, this.linkPhoneNumberResponse);
        if (this.entityContent.content.IsMarked) {
            if (GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LinkedEntityList))
                this.sessionManager.selectedEntity.LinkedEntityList = new Array();
            this.sessionManager.selectedEntity.LinkedEntityList.push(req.LinkPhoneNumberDto);
        }
        else
            GlobalFunctions.removeByAttr(this.sessionManager.selectedEntity.LinkedEntityList, "SourceId", req.LinkPhoneNumberDto.SourceId);
    }
    linkPhoneNumberResponse(response) {
        this.stopSpinner();
        if (response != null && response.Result == 0) {
            this.sessionManager.selectedEntity.Partial = true;
            this.close();
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
        }
        else {
            this.sessionManager.selectedEntity.LinkedEntity = null;
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_LINK_PHONENUMBER'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_LINK_PHONENUMBER") });
        }
    }
    ;
    changeLinkedEmailOption(selectedLinkedEmail) {
        if (selectedLinkedEmail) {
            this.linkedEmail = selectedLinkedEmail;
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LinkedEntityList)) {
                this.sessionManager.selectedEntity.LinkedEntity = jlinq.from(this.sessionManager.selectedEntity.LinkedEntityList).starts("SourceId", this.linkedEmail.key).first();
                this.initLinkedEntity();
            }
        }
        else
            this.entityContent = new Object();
    }
    changeLinkedPhoneNumberOption(selectedLinkedPhoneNumber) {
        if (selectedLinkedPhoneNumber) {
            this.linkedPhoneNumber = selectedLinkedPhoneNumber;
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LinkedEntityList)) {
                this.sessionManager.selectedEntity.LinkedEntity = jlinq.from(this.sessionManager.selectedEntity.LinkedEntityList).starts("SourceId", this.linkedPhoneNumber.key).first();
                this.initLinkedEntity();
            }
        }
        else
            this.entityContent = new Object();
    }
    ;
    initLinkedEntity() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LinkedEntity)) {
            let entityName = this.sessionManager.selectedEntity.LinkedEntity.TargetType.indexOf('Person') !== -1 ? "Person" : "Organization";
            this.fetchDetail(entityName, this.sessionManager.selectedEntity.LinkedEntity.TargetId, this.sessionManager.selectedEntity.LinkedEntity.TargetSource);
        }
        else
            this.entityContent = new Object();
    }
    linkEmailResponse(response) {
        this.stopSpinner();
        if (response != null && response.Result == 0) {
            this.sessionManager.selectedEntity.Partial = true;
            this.close();
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
        }
        else {
            this.sessionManager.selectedEntity.LinkedEntity = null;
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_LINK_EMAIL'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_LINK_EMAIL") });
        }
    }
    close() {
        this.dialogRef.close();
        this.dialogRefSessionItemList.close();
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        let newHeight;
        if (windowHeight < 700)
            newHeight = windowHeight - $("#linkContactInfoHeader").height() - $("#linkUnlinkEntityFooter").height() - 70 + "px";
        else
            newHeight = windowHeight - $("#linkUnlinkEntityHeader").height() - $("#linkUnlinkEntityFooter").height() - 120 + "px";
        $("#linkUnlinkEntityContainer").height("420");
    }
    handleEscKey(event) {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close();
    }
    ;
    onKeyUp(event) {
        let e = event;
        if (e.key.toLocaleLowerCase() == KeyCode.Escape) {
            this.close();
            e.preventDefault();
        }
    }
};
__decorate([
    ViewChild('form')
], LinkContactInfoComponent.prototype, "form", void 0);
__decorate([
    HostListener('window:keyup.esc', ['$event'])
], LinkContactInfoComponent.prototype, "onKeyUp", null);
LinkContactInfoComponent = __decorate([
    Component({
        selector: 'link-contact-info',
        templateUrl: './link-contact-info.component.html',
        styleUrls: ['./link-contact-info.component.scss'],
        host: { '(window:resize)': 'resize()' }
    }),
    __param(0, Inject(MAT_DIALOG_DATA))
], LinkContactInfoComponent);
export { LinkContactInfoComponent };
//# sourceMappingURL=link-contact-info.component.js.map