var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Input } from '@angular/core';
import { TaskHandlerType } from '../../../core/enums/task-enum';
let HandlerListComponent = class HandlerListComponent {
    constructor(cacheManager, dialogManager) {
        this.cacheManager = cacheManager;
        this.dialogManager = dialogManager;
        this.color = '';
        this.event = true;
        this.handlers = [];
    }
    ngOnChanges(changes) {
        if (changes.handlers?.currentValue?.length > 0)
            this.setHandlerList(changes.handlers.currentValue);
    }
    setHandlerList(handlers) {
        this.handlers = [];
        handlers.forEach(h => {
            let handler;
            if (h.HandlerType == TaskHandlerType.Email || h.HandlerType === "Email") {
                handler = {};
                handler.Id = h.HandlerId;
                handler.StringRepresentation = h.HandlerId;
                handler.EntityType = 4;
            }
            else if (h.HandlerType == TaskHandlerType.Mailbox || h.HandlerType === "Mailbox") {
                handler = this.cacheManager.getTaskMailboxById(h.HandlerId);
                if (handler)
                    handler.EntityType = 3;
            }
            else if (h.HandlerType == TaskHandlerType.Department || h.HandlerType === "Department") {
                handler = this.cacheManager.getDepartmentById(h.HandlerId);
                if (handler)
                    handler.EntityType = 2;
            }
            else {
                handler = this.cacheManager.getEmployeeById(h.HandlerId);
                if (handler)
                    handler.EntityType = 1;
            }
            if (handler)
                this.handlers.push(handler);
        });
    }
    openEmployeeDetailPopUp(employeeId) {
        this.dialogManager.openEmployeeDetailPopUp(employeeId);
    }
};
__decorate([
    Input()
], HandlerListComponent.prototype, "color", void 0);
__decorate([
    Input()
], HandlerListComponent.prototype, "event", void 0);
__decorate([
    Input()
], HandlerListComponent.prototype, "handlers", void 0);
HandlerListComponent = __decorate([
    Component({
        selector: 'handler-list',
        templateUrl: './handler-list.component.html',
        styleUrls: ['./handler-list.component.scss']
    })
], HandlerListComponent);
export { HandlerListComponent };
//# sourceMappingURL=handler-list.component.js.map