var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { EntityHistoryAction } from '../../../core/enums/common-enums';
import { GlobalFunctions } from '../../../shared/global-functions';
import { CommonHelper } from '../../../shared/helper/common-helper';
import { BaseDialogComponent } from '../base-dialog.component';
let EntityHistoryComponent = class EntityHistoryComponent extends BaseDialogComponent {
    constructor(dialogRef, cacheManager, sessionManager, systemComponentService, translateService, datePipe, parseDatePipe) {
        super();
        this.dialogRef = dialogRef;
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.systemComponentService = systemComponentService;
        this.translateService = translateService;
        this.datePipe = datePipe;
        this.parseDatePipe = parseDatePipe;
        this.history = [];
        this.groupedHistoryItems = [];
        this.groupedActivityKeys = [];
        this.extractedDateTime = '';
        this.dateFields = ["Ontvangen", "DueDate", "CallBetweenStartDate", "CallBetweenEndDate"];
        this.getEntityHistoryResponse = this.getEntityHistoryResponse.bind(this);
    }
    ngOnInit() {
        setTimeout(() => this.resize(), 300);
        let objectType = GlobalFunctions.toString(this.sessionManager.selectedEntity.RelatedEntityFqdn);
        let objectSource = this.sessionManager.selectedEntity.ObjectSource;
        let objectId = this.sessionManager.selectedEntity.Id;
        this.systemComponentService.getEntityHistory(objectType, objectId, objectSource, this.sessionManager.selectedEntity.PrivateFields, this.getEntityHistoryResponse);
    }
    getEntityHistoryResponse(historyItems) {
        historyItems.forEach(historyItem => {
            historyItem.Username = GlobalFunctions.getHandlerName(historyItem.UserId, this.cacheManager);
            historyItem.ActionType = EntityHistoryAction[historyItem.Action];
        });
        this.history = historyItems;
        this.groupedHistoryItems = jlinq.from(historyItems).group("OnDateTime");
        this.groupedActivityKeys = Object.keys(this.groupedHistoryItems);
        this.groupedActivityKeys.forEach(item => this.parseDatePipe.transform(item, ""));
        // filter the historyItems to get the Date/Time fields.
        this.historyFilterdData = historyItems.filter(item => (item.ActionType === 4 || item.ActionType === 1) &&
            this.dateFields.includes(item.FieldName));
        this.setDateFormatInHistoryPopup();
        this.removeHtmlTagsFromQuestion();
    }
    ;
    close() {
        this.dialogRef.close();
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        let newHeight = windowHeight - $("#entityHistoryNameHeader").height() - $("#entityHistoryFooter").height() - 100 + "px";
        $("#entityHistoryContent").height(newHeight);
    }
    extractDateTimePart(dateTimeString) {
        return dateTimeString?.replace('T', ' ').replace('Z', '');
    }
    setDateFormatInHistoryPopup() {
        const entity = this.sessionManager.selectedEntity;
        this.historyFilterdData.forEach(item => {
            for (const field of this.dateFields) {
                if (!GlobalFunctions.isEmpty(item.CurrentValue) && item.FieldName === field) {
                    if (item.FieldName === 'Ontvangen')
                        item.CurrentValue = this.formatDate(item.CurrentValue);
                    else
                        item.CurrentValue = this.formatDate(entity[field]);
                }
                if (!GlobalFunctions.isEmpty(item.PreviousValue) && item.FieldName === field) {
                    if (item.FieldName === 'Ontvangen')
                        item.PreviousValue = this.formatDate(item.PreviousValue);
                    else
                        item.PreviousValue = this.formatDate(entity[field]);
                }
            }
        });
    }
    formatDate(date) {
        const formattedDate = this.datePipe.transform(date, this.sessionManager.defaultOptions.defaultShortDateTimeFormat, "", CommonHelper.getLanguageCode());
        return GlobalFunctions.removeDotAfterMonth(this.extractDateTimePart(formattedDate));
    }
    removeHtmlTagsFromQuestion() {
        this.filteredCustomerQuestions = this.history.filter(custQuestion => (custQuestion.ActionType === 4 && custQuestion.FieldName === 'CustomerQuestion'));
        this.filteredCustomerQuestions.forEach(item => {
            item.CurrentValue = GlobalFunctions.removeHTMLTags(item.CurrentValue);
            item.PreviousValue = GlobalFunctions.removeHTMLTags(item.PreviousValue);
        });
    }
};
EntityHistoryComponent = __decorate([
    Component({
        selector: 'entity-history',
        templateUrl: './entity-history.component.html',
        styleUrls: ['./entity-history.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], EntityHistoryComponent);
export { EntityHistoryComponent };
//# sourceMappingURL=entity-history.component.js.map