var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, HostListener, Input, Output } from '@angular/core';
import { GlobalFunctions } from '../../../shared/global-functions';
let EmojiComponent = class EmojiComponent {
    constructor(elementRef) {
        this.elementRef = elementRef;
        this.error = false;
        this.onReplyMessage = new EventEmitter();
    }
    ngOnInit() {
    }
    ngOnChanges(changes) {
        if (changes.makeTextAreaEmpty.currentValue != null) {
            this.replyMessage = "";
            this.error = false;
        }
    }
    addEmoji(event) {
        this.replyMessage = `${this.replyMessage}${event.emoji.native}`;
        this.isEmojiPickerVisible = false;
    }
    reply() {
        if (GlobalFunctions.isEmpty(this.replyMessage))
            this.error = !GlobalFunctions.isEmpty(this.attachment) && (!GlobalFunctions.isEmpty(this.attachment.originalName) || !GlobalFunctions.isEmpty(this.attachment.uploadedName)) ? false : true;
        this.onReplyMessage.emit(this.replyMessage);
    }
    onKeydown(event) {
        if (this.isEmojiPickerVisible) {
            this.isEmojiPickerVisible = false;
            event.preventDefault();
        }
    }
    onClick(event) {
        if (this.isEmojiPickerVisible && !this.elementRef.nativeElement.contains(event.target)) {
            this.isEmojiPickerVisible = false;
        }
    }
};
__decorate([
    Input()
], EmojiComponent.prototype, "replyMessage", void 0);
__decorate([
    Input()
], EmojiComponent.prototype, "isEmojiPickerVisible", void 0);
__decorate([
    Input()
], EmojiComponent.prototype, "makeTextAreaEmpty", void 0);
__decorate([
    Input()
], EmojiComponent.prototype, "error", void 0);
__decorate([
    Input()
], EmojiComponent.prototype, "attachment", void 0);
__decorate([
    Output()
], EmojiComponent.prototype, "onReplyMessage", void 0);
__decorate([
    HostListener('document:keydown.escape', ['$event'])
], EmojiComponent.prototype, "onKeydown", null);
__decorate([
    HostListener('document:click', ['$event'])
], EmojiComponent.prototype, "onClick", null);
EmojiComponent = __decorate([
    Component({
        selector: 'emoji',
        templateUrl: './emoji.component.html',
        styleUrls: ['./emoji.component.scss']
    })
], EmojiComponent);
export { EmojiComponent };
//# sourceMappingURL=emoji.component.js.map