var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject, ViewChild } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { RecordSelection } from 'src/app/core/enums/common-enums';
import { EntityName } from 'src/app/shared/constants';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { BaseDto } from '../../../core/models/common/baseDto';
import { StartContentRequest } from '../../../core/models/common/start-content-request';
import { GlobalFunctions } from '../../../shared/global-functions';
import { BaseDialogComponent } from '../base-dialog.component';
import { MessageboxComponent } from '../messagebox/messagebox.component';
import { SearchPopupComponent } from '../search-popup/search-popup.component';
import { SubSink } from 'subsink';
let EformComponent = class EformComponent extends BaseDialogComponent {
    constructor(parentData, dialogRef, sessionManager, productService, translateService, dialog, applicationSettingManager, shortcutManager) {
        super();
        this.parentData = parentData;
        this.dialogRef = dialogRef;
        this.sessionManager = sessionManager;
        this.productService = productService;
        this.translateService = translateService;
        this.dialog = dialog;
        this.applicationSettingManager = applicationSettingManager;
        this.shortcutManager = shortcutManager;
        this.showCase = false;
        this.showPerson = false;
        this.showOrganization = false;
        this.relationTypeCaseItems = [];
        this.relationTypePersonItems = [];
        this.relationTypeOrganisationItems = [];
        this.selectedCaseValue = null;
        this.selectedPersonValue = null;
        this.selectedOrganisationValue = null;
        this.subs = new SubSink();
        this.startContentResponse = this.startContentResponse.bind(this);
    }
    ngOnInit() {
        this.timeoutIds.push(setTimeout(() => {
            try {
                this.productService.setStartContentCallback(this.startContentResponse);
                this.startPrefillResponseReceived(this.parentData.startPrefillResponse);
                this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.createEform());
            }
            catch (e) {
                ExceptionHelper.showException(null, null, false, e.message, "");
            }
        }, 100));
    }
    ngOnDestroy() {
        super.ngOnDestroy();
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    openSearchPopup(entity) {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: entity, recordSelection: RecordSelection.Single }).afterClosed().subscribe(searchEntity => {
            if (searchEntity != null) {
                if (entity.toLowerCase() == EntityName.PERSON.toLocaleLowerCase()) {
                    GlobalFunctions.setStringPresentation(searchEntity, this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote"));
                    if (!GlobalFunctions.containsObject(searchEntity, this.relationTypePersonItems)) {
                        this.relationTypePersonItems.push({ key: searchEntity, value: entity, type: entity });
                        this.selectedPersonValue = searchEntity;
                    }
                }
                else if (entity.toLocaleLowerCase() == EntityName.ORGANIZATION.toLocaleLowerCase()) {
                    searchEntity.StringRepresentation = searchEntity.Name;
                    if (!GlobalFunctions.containsObject(searchEntity, this.relationTypeOrganisationItems)) {
                        this.relationTypeOrganisationItems.push({ key: searchEntity, value: entity, type: entity });
                        this.selectedOrganisationValue = searchEntity;
                    }
                }
                else {
                    searchEntity.StringRepresentation = searchEntity.Description;
                    if (!GlobalFunctions.containsObject(searchEntity, this.relationTypeCaseItems)) {
                        this.relationTypeCaseItems.push({ key: searchEntity, value: entity, type: entity });
                        this.selectedCaseValue = searchEntity;
                    }
                }
            }
        });
    }
    startPrefillResponseReceived(response) {
        response.BaseDtoList.forEach((baseDto) => {
            if (!GlobalFunctions.isEmpty(baseDto.ObjectSource) && !$.isNumeric(baseDto.ObjectSource)) {
                if (baseDto.ObjectSource.indexOf("Person") != -1)
                    this.showPerson = true;
                else if (baseDto.ObjectSource.indexOf("Organization") != -1)
                    this.showOrganization = true;
                else if (baseDto.ObjectSource.indexOf("Case") != -1)
                    this.showCase = true;
            }
        });
        this.fillRelatedEntities();
    }
    createEform() {
        if (this.validateForm()) {
            this.startSpinner();
            let relatedEntities = [];
            if (this.showPerson) {
                let relationTypeItem = this.selectedPersonValue;
                if (relationTypeItem != null) {
                    let baseItem = new BaseDto();
                    baseItem.Id = relationTypeItem.Id;
                    baseItem.ObjectSource = relationTypeItem.ObjectSource;
                    relatedEntities.push(baseItem);
                }
            }
            if (this.showOrganization) {
                let relationTypeItem = this.selectedOrganisationValue;
                if (relationTypeItem != null) {
                    let baseItem = new BaseDto();
                    baseItem.Id = relationTypeItem.AdministeredOrganizationDto.Identification;
                    baseItem.ObjectSource = relationTypeItem.ObjectSource;
                    relatedEntities.push(baseItem);
                }
            }
            if (this.showCase) {
                let relationTypeItem = this.selectedCaseValue;
                if (relationTypeItem != null) {
                    let baseItem = new BaseDto();
                    baseItem.Id = relationTypeItem.Id;
                    baseItem.ObjectSource = relationTypeItem.ObjectSource;
                    relatedEntities.push(baseItem);
                }
            }
            let startContentRequest = new StartContentRequest();
            startContentRequest.LinkUrl = (GlobalFunctions.isEmpty(this.parentData.eformLinkValue)) ? this.sessionManager.selectedEntity.Links[0].UriText : this.parentData.eformLinkValue;
            startContentRequest.BaseDtoList = relatedEntities;
            startContentRequest.ProudctId = (GlobalFunctions.isEmpty(this.parentData.eformLinkValue)) ? this.sessionManager.selectedEntity.Id : "";
            this.productService.startContentRequest(startContentRequest, null);
        }
    }
    validateForm() {
        let validForm = this.form.valid;
        if (!this.selectedPersonValue)
            validForm = false;
        return validForm;
    }
    startContentResponse(response) {
        this.stopSpinner();
        if (response != null && !GlobalFunctions.isEmpty(response.FormUrl)) {
            window.open(response.FormUrl, "_blank");
            this.close(false);
        }
        else {
            let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_E_FORM"), this.translateService.instant("LBL_MESSAGE_FAIL_OPEN_PRE_FILL"), false, null, null, null, null, this.translateService);
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
        }
    }
    close(result) {
        this.dialogRef.close();
    }
    fillRelatedEntities() {
        let cachedEntities = this.sessionManager.detailViewCachedEntityList;
        if (cachedEntities != null && cachedEntities.length > 0) {
            cachedEntities.forEach((value, key) => {
                if (value != undefined && value.key != null && value.key != undefined) {
                    if (value.value.indexOf("Person") != -1 && this.showPerson == true) {
                        value.type = 'Person';
                        this.relationTypePersonItems.push(value);
                    }
                    else if (value.value.indexOf("Organization") != -1 && this.showOrganization == true) {
                        value.type = 'Organization';
                        this.relationTypeOrganisationItems.push(value);
                    }
                    else if (value.value.indexOf("Case") != -1 && this.showCase == true) {
                        value.type = 'CaseEntity';
                        this.relationTypeCaseItems.push(value);
                    }
                }
            });
        }
    }
};
__decorate([
    ViewChild('form')
], EformComponent.prototype, "form", void 0);
EformComponent = __decorate([
    Component({
        selector: 'eform',
        templateUrl: './eform.component.html',
        styleUrls: ['./eform.component.scss']
    }),
    __param(0, Inject(MAT_DIALOG_DATA))
], EformComponent);
export { EformComponent };
//# sourceMappingURL=eform.component.js.map