import { SubSink } from "subsink";
import { ForwardTaskType, LinkUnlinkActionType, RecordOperationMode } from '../../core/enums/common-enums';
import { EntityFqdn, TaskSource } from "../../core/enums/core-enums";
import { AttachmentType } from "../../core/enums/files-enum";
import { EmailSource, EmailType } from "../../core/enums/global-enum";
import { TaskHandlerType, TaskStatus } from "../../core/enums/task-enum";
import { BaseDto } from "../../core/models/common/baseDto";
import { MakeAppointmentExternalRequest } from "../../core/models/common/make-appointment-external-request";
import { FavouriteDto } from "../../core/models/dashboard/favouriteDto";
import { DeleteSocialMediaMessageRequest } from "../../core/models/social-media/delete-social-media-message-request";
import { TaskHandlerDto } from "../../core/models/task/task-handlerDto";
import { TaskHistoryDto } from "../../core/models/task/task-historyDto";
import { BroadCastEventKeys, EntityName, RoutePath, SideMenuItem } from "../../shared/constants";
import { GlobalFunctions } from "../../shared/global-functions";
import { DialogHelper } from "../../shared/helper/dialog-helper";
import { ExceptionHelper } from "../../shared/helper/exception-helper";
import { BaseComponent } from "../base-component";
import { CaseAddEditComponent } from "../domain/case/add-edit/case-add-edit.component";
import { EmployeeAddEditComponent } from "../domain/employee/add-edit/employee-add-edit.component";
import { FileAddEditComponent } from "../domain/file/add-edit/file-add-edit.component";
import { LinkAddEditComponent } from "../domain/link/add-edit/link-add-edit.component";
import { NoteAddEditComponent } from "../domain/note/add-edit/note-add-edit.component";
import { OrganizationAddEditComponent } from "../domain/organization/add-edit/organization-add-edit.component";
import { PersonAddEditComponent } from "../domain/person/add-edit/person-add-edit.component";
import { ThemeAddEditComponent } from "../domain/theme/add-edit/theme-add-edit.component";
import { TicketForwardComponent } from "../domain/ticket/forward/ticket-forward.component";
import { MessageboxComponent } from "./messagebox/messagebox.component";
import { PrintComponent } from './print/print.component';
import { SessionItemListComponent } from "./session-item-list/session-item-list.component";
export class ContextMenuComponent extends BaseComponent {
    constructor(cacheManager, dialogManager, sessionManager, userSettingManager, integrationSettingManager, noteService, emailService, systemComponentService, translateService, router, zone, dialog, changeDetectorRef, viewContainerRef, eventProvider, suggestionPanelManager, taskService, linkService, socialMediaService, themeService, contactHistoryService, fileentityService, localSearchResultDataService, productService, ticketService, phoneManager, organizationService, personService, shortcutManager, contextMenuService, location, applicationSettingManager) {
        super(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef);
        this.cacheManager = cacheManager;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.userSettingManager = userSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.noteService = noteService;
        this.emailService = emailService;
        this.systemComponentService = systemComponentService;
        this.translateService = translateService;
        this.router = router;
        this.zone = zone;
        this.dialog = dialog;
        this.changeDetectorRef = changeDetectorRef;
        this.viewContainerRef = viewContainerRef;
        this.eventProvider = eventProvider;
        this.suggestionPanelManager = suggestionPanelManager;
        this.taskService = taskService;
        this.linkService = linkService;
        this.socialMediaService = socialMediaService;
        this.themeService = themeService;
        this.contactHistoryService = contactHistoryService;
        this.fileentityService = fileentityService;
        this.localSearchResultDataService = localSearchResultDataService;
        this.productService = productService;
        this.ticketService = ticketService;
        this.phoneManager = phoneManager;
        this.organizationService = organizationService;
        this.personService = personService;
        this.shortcutManager = shortcutManager;
        this.contextMenuService = contextMenuService;
        this.location = location;
        this.applicationSettingManager = applicationSettingManager;
        this.dateJS = Date;
        this.subs = new SubSink();
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.TAGS_SELECTED).subscribe(tags => this.suggestionPanelManager.autoShow(tags, viewContainerRef));
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.TAG_SELECTED).subscribe(tag => this.suggestionPanelManager.initialize(tag, viewContainerRef));
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.CLEAR_SESSION).subscribe(() => this.suggestionPanelManager.close());
        this.deleteResponse = this.deleteResponse.bind(this);
        this.deleteTaskResponse = this.deleteTaskResponse.bind(this);
        this.deleteAppointmentResponse = this.deleteAppointmentResponse.bind(this);
        this.deleteNoteResponse = this.deleteNoteResponse.bind(this);
        this.deleteFileResponse = this.deleteFileResponse.bind(this);
        this.deleteThemeResponse = this.deleteThemeResponse.bind(this);
        this.sendToTaskErrorCallback = this.sendToTaskErrorCallback.bind(this);
        this.sendToTaskResponseReceived = this.sendToTaskResponseReceived.bind(this);
        this.emailDeleteResponseReceived = this.emailDeleteResponseReceived.bind(this);
        this.emailArchiveResponseReceived = this.emailArchiveResponseReceived.bind(this);
        this.deleteTicketResponseReceived = this.deleteTicketResponseReceived.bind(this);
        this.deleteContactHistoryResponse = this.deleteContactHistoryResponse.bind(this);
        this.markContactHistoryDeleteStateResponse = this.markContactHistoryDeleteStateResponse.bind(this);
    }
    executeMenuItem(key, contentType, menuItem = null) {
        if (contentType.toUpperCase() == "EMAIL") {
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Header) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Header.LookingOn) && this.sessionManager.selectedEntity.Header.LookingOn != GlobalFunctions.getLoggedInUserId()) {
                let userObject = this.cacheManager.getEmployeeById(this.sessionManager.selectedEntity.Header.LookingOn);
                let warningMessage = this.translateService.instant("LBL_ASSIGNED_ITEM_WARNING_MESSAGE");
                warningMessage = GlobalFunctions.formatStringValue(warningMessage, [userObject.StringRepresentation]);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_" + contentType.toUpperCase()), textMsg: warningMessage, isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                    if (result)
                        this.executeMenuItemOperation(key, contentType, menuItem);
                });
            }
            else
                this.executeMenuItemOperation(key, contentType, menuItem);
        }
        else if (contentType.toUpperCase() == "APPOINTMENT" || contentType.toUpperCase() == "ASSIGNMENT" || contentType.toUpperCase() == "CALLBACKNOTE" || contentType.toUpperCase() == "REPORTIMPROVEMENT" || contentType.toUpperCase() == "INFORMATIONREQUEST" || contentType.toUpperCase() == "TASK") {
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LookingBy) && this.sessionManager.selectedEntity.LookingBy != GlobalFunctions.getLoggedInUserId()) {
                let userObject = this.cacheManager.getEmployeeById(this.sessionManager.selectedEntity.LookingBy);
                let warningMessage = this.translateService.instant("LBL_ASSIGNED_ITEM_WARNING_MESSAGE");
                warningMessage = GlobalFunctions.formatStringValue(warningMessage, [userObject.StringRepresentation]);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_" + contentType.toUpperCase()), textMsg: warningMessage, isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                    if (result)
                        this.executeMenuItemOperation(key, contentType, menuItem);
                });
            }
            else
                this.executeMenuItemOperation(key, contentType, menuItem);
        }
        else if (contentType.toUpperCase() == "DOCUMENT") {
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LookingOn) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.LookingOn.UserId) && this.sessionManager.selectedEntity.LookingOn.UserId != GlobalFunctions.getLoggedInUserId()) {
                let userObject = this.cacheManager.getEmployeeById(this.sessionManager.selectedEntity.LookingOn.UserId);
                let warningMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_ASSIGNED_ITEM_WARNING_MESSAGE"), [userObject.StringRepresentation]);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_" + contentType.toUpperCase()), textMsg: warningMessage, isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                    if (result)
                        this.executeMenuItemOperation(key, contentType, menuItem);
                });
            }
            else
                this.executeMenuItemOperation(key, contentType, menuItem);
        }
        else
            this.executeMenuItemOperation(key, contentType, menuItem);
    }
    ;
    executeMenuItemOperation(key, contentType, menuItem) {
        switch (key.toUpperCase()) {
            case "CUSTOMCONTEXTMENU": {
                this.executeCustomContextMenuOption(menuItem);
                break;
            }
            case "ADDNOTE":
                this.dialogManager.openJsPanelOrDialog("ADD_NOTE", false, null, null, this.viewContainerRef, NoteAddEditComponent);
                break;
            case "ADDIMPROVEMENT":
                {
                    this.dialogManager.addImprovement(false);
                    break;
                }
            case "LINK":
                this.dialogManager.linkUnlink(LinkUnlinkActionType.Link);
                break;
            case "UNLINK":
                this.dialogManager.linkUnlink(LinkUnlinkActionType.Unlink);
                break;
            case "ADDTOBASKET":
                this.addToBasket(key, contentType);
                break;
            case "SENDVIAEMAIL":
                this.openDialog(key, contentType);
                break;
            case "PRINT":
                this.printItem(contentType);
                break;
            case "SOURCEAPPLICATIONDEEPLINK":
                this.openInSource();
                break;
            case "ADDASSIGNMENT":
                this.dialogManager.openJsPanelOrDialog("ADD_ASSIGNMENT", false, null, false, this.viewContainerRef);
                break;
            case "MERGEDATA":
                this.dialogManager.openMergeData(contentType);
                break;
            default:
                {
                    switch (contentType.toUpperCase()) {
                        case "PRODUCT":
                            {
                                switch (key.toUpperCase()) {
                                    case "SUMMARIZE":
                                        let pdcContentToSummarize = this.sessionManager.selectedEntity?.Descriptions.map(item => item.Description).join('');
                                        let titleOfProduct = this.sessionManager.selectedEntity?.Name;
                                        let fullRouteUrl = window.location.origin + '/' + this.location.prepareExternalUrl(this.router.serializeUrl(this.router.createUrlTree([RoutePath.SUMMARIZE_DOCUMENT])));
                                        GlobalFunctions.openSummarizationInNewWindow(pdcContentToSummarize, titleOfProduct, fullRouteUrl);
                                        break;
                                    case "ADDCASE":
                                        this.dialogManager.openJsPanelOrDialog("ADD_CASE", false, null, false, this.viewContainerRef, CaseAddEditComponent);
                                        break;
                                    case "PRODUCTID":
                                        setTimeout(() => {
                                            document.getElementById('detailMenuDropDownToggle').click();
                                            this.showProductId(menuItem);
                                        }, 1);
                                        break;
                                    case "EFORM":
                                    case "E-FORM":
                                        {
                                            this.openEformLink();
                                            break;
                                        }
                                }
                                break;
                            }
                        case "EMAIL":
                            {
                                switch (key.toUpperCase()) {
                                    case "REPLY":
                                    case "FORWARD": {
                                        this.openDialog(key, contentType);
                                        this.emailService.addEmailAndRelatedPersonOrOrganizationIntoSession(this.cacheManager);
                                        break;
                                    }
                                    case "REASSIGNEMAIL":
                                        this.dialogManager.openAssignEmailPopUp();
                                        break;
                                    case "ADDTOCASE": {
                                        this.emailService.addEmailAndRelatedPersonOrOrganizationIntoSession(this.cacheManager);
                                        this.dialogManager.openLinkEmailPopUp();
                                        break;
                                    }
                                    case "ADDCASEFROMEMAIL": {
                                        this.emailService.addEmailAndRelatedPersonOrOrganizationIntoSession(this.cacheManager);
                                        this.dialogManager.addEmailAsCase(this.viewContainerRef);
                                        break;
                                    }
                                    case "ADDDOCUMENTFROMEMAIL": {
                                        this.emailService.addEmailAndRelatedPersonOrOrganizationIntoSession(this.cacheManager);
                                        this.dialogManager.addDocumentFromContextMenu(this.viewContainerRef);
                                        break;
                                    }
                                    case "LINKTOTICKET": {
                                        this.emailService.addEmailAndRelatedPersonOrOrganizationIntoSession(this.cacheManager);
                                        this.dialogManager.openLinkTicketPopUp();
                                        break;
                                    }
                                    case "ADDTICKET":
                                        {
                                            this.emailService.addEmailAndRelatedPersonOrOrganizationIntoSession(this.cacheManager);
                                            let ticketConfiguration = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
                                            let ticketType = jlinq.from(ticketConfiguration.TicketTypes).equals("Title", menuItem.customItem.StringRepresentation).first();
                                            this.dialogManager.openAddTicket(ticketType, this.viewContainerRef);
                                            break;
                                        }
                                    case "DELETE":
                                        this.deleteEmail();
                                        break;
                                    case "ARCHIVE":
                                        this.archiveEmail();
                                        break;
                                }
                                break;
                            }
                        case "APPOINTMENT":
                        case "ASSIGNMENT":
                        case "CALLBACKNOTE":
                        case "REPORTIMPROVEMENT":
                        case "INFORMATIONREQUEST":
                        case "TASK":
                            {
                                if (contentType.toUpperCase() === "TASK")
                                    contentType = this.sessionManager.selectedEntity.TaskType;
                                switch (key.toUpperCase()) {
                                    case "HANDLE":
                                        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.SubTaskType) && this.sessionManager.selectedEntity.SubTaskType.toUpperCase() == 'EMAIL')
                                            this.openItemInDetailView("EMAIL");
                                        else if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.SubTaskType) && this.sessionManager.selectedEntity.SubTaskType.toUpperCase() == 'SOCIALMEDIA')
                                            this.openItemInDetailView("SOCIALMEDIA");
                                        else
                                            this.dialogManager.handleTask(contentType.toUpperCase(), this.viewContainerRef);
                                        break;
                                    case "REASSIGN":
                                        this.dialogManager.openForwardTaskPopUp();
                                        break;
                                    case "DELETE":
                                        this.deleteEntities("LBL_" + contentType.toUpperCase(), contentType.toUpperCase());
                                        break;
                                    case "EDIT":
                                        {
                                            if (contentType.toUpperCase() === "CALLBACKNOTE")
                                                this.openCallbacknote(this.sessionManager.selectedEntity);
                                            else if (contentType.toUpperCase() === "APPOINTMENT")
                                                this.openAppointment(this.sessionManager.selectedEntity);
                                            else if (contentType.toUpperCase() === "REPORTIMPROVEMENT")
                                                this.dialogManager.addImprovement(true);
                                            else if (contentType.toUpperCase() === "INFORMATIONREQUEST")
                                                this.openInformationRequest(this.sessionManager.selectedEntity);
                                            else if (contentType.toUpperCase() === "ASSIGNMENT")
                                                this.openAssignment(this.sessionManager.selectedEntity);
                                            break;
                                        }
                                    case "SENDTOTASK":
                                        {
                                            this.sendToTaskRequest();
                                            break;
                                        }
                                        ;
                                }
                                break;
                            }
                        case "TICKET":
                            {
                                switch (key.toUpperCase()) {
                                    case "EDIT":
                                        this.dialogManager.openJsPanelOrDialog("ADD_TICKET", true, this.sessionManager.selectedEntity, false, this.viewContainerRef);
                                        break;
                                    case "REASSIGN":
                                        DialogHelper.openDialog(this.dialog, TicketForwardComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
                                        break;
                                    case "ADDDOCUMENT":
                                        this.dialogManager.addDocumentFromContextMenu(this.viewContainerRef);
                                        break;
                                    case "DELETE":
                                        this.deleteTicket(this.sessionManager.selectedEntity.Id);
                                        break;
                                    case "LINKFROMSESSION":
                                        DialogHelper.openDialog(this.dialog, SessionItemListComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { isLinkPersonOrOrganization: false });
                                        break;
                                    case "INFORMATIONREQUEST":
                                        this.sessionManager.addItemsToDetailViewCacheList(this.sessionManager.selectedEntity, GlobalFunctions.toString(this.sessionManager.selectedEntity.RelatedEntityFqdn), true);
                                        this.dialogManager.openJsPanelOrDialog("ADD_INFORMATIONREQUEST", false, null, false, this.viewContainerRef);
                                        break;
                                    case "HANDLE":
                                        this.dialogManager.handleTicket(this.viewContainerRef);
                                        break;
                                }
                                break;
                            }
                        case "CASEENTITY":
                            {
                                switch (key.toUpperCase()) {
                                    case "ADDDOCUMENT":
                                        this.dialogManager.addDocumentFromContextMenu(this.viewContainerRef);
                                        break;
                                }
                                break;
                            }
                        case "DOCUMENT":
                            {
                                switch (key.toUpperCase()) {
                                    case "ADD":
                                        this.dialogManager.addDocumentFromContextMenu(this.viewContainerRef);
                                        break;
                                    case "LINKTOTICKET":
                                        this.dialogManager.openLinkTicketPopUp();
                                        break;
                                    case "ADDTICKET":
                                        {
                                            let ticketConfiguration = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
                                            let ticketType = jlinq.from(ticketConfiguration.TicketTypes).equals("Title", menuItem.customItem.StringRepresentation).first();
                                            this.dialogManager.openAddTicket(ticketType, this.viewContainerRef);
                                            break;
                                        }
                                }
                                break;
                            }
                        case "EMPLOYEE":
                            {
                                switch (key.toUpperCase()) {
                                    case "CALLBACKNOTE":
                                        {
                                            this.openCallbacknote();
                                            break;
                                        }
                                    case "EDIT":
                                        this.dialogManager.editEmployeeFromContextMenu(EmployeeAddEditComponent, this.viewContainerRef);
                                        break;
                                }
                                break;
                            }
                        case "FACEBOOK":
                        case "TWITTER":
                        case "WHATSAPP":
                        case "SOCIALMEDIA":
                            {
                                switch (key.toUpperCase()) {
                                    case "CALLBACKNOTE":
                                        {
                                            this.sessionManager.addItemsToDetailViewCacheList(this.sessionManager.selectedEntity, GlobalFunctions.toString(this.sessionManager.selectedEntity.RelatedEntityFqdn), true);
                                            this.openCallbacknote();
                                            break;
                                        }
                                    case "INFORMATIONREQUEST":
                                        {
                                            this.sessionManager.addItemsToDetailViewCacheList(this.sessionManager.selectedEntity, GlobalFunctions.toString(this.sessionManager.selectedEntity.RelatedEntityFqdn), true);
                                            this.dialogManager.openJsPanelOrDialog("ADD_INFORMATIONREQUEST", false, null, false, this.viewContainerRef);
                                            break;
                                        }
                                    case "REASSIGN":
                                        {
                                            this.dialogManager.openReassignMessage();
                                            break;
                                        }
                                    case "ADDTICKET":
                                        {
                                            let ticketConfiguration = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
                                            let ticketType = jlinq.from(ticketConfiguration.TicketTypes).equals("Title", menuItem.customItem.StringRepresentation).first();
                                            this.dialogManager.openAddTicket(ticketType, this.viewContainerRef);
                                            break;
                                        }
                                    case "LINKTOTICKET":
                                        this.dialogManager.openLinkTicketPopUp();
                                        break;
                                    case "ADDCASE":
                                        this.dialogManager.openJsPanelOrDialog("ADD_CASE", true);
                                        break;
                                    case "DELETE":
                                        this.deleteEntities("LBL_" + contentType.toUpperCase(), contentType.toUpperCase());
                                        break;
                                    case "ARCHIVESOCIALMEDIA":
                                        // TODO - Check with old application.
                                        //if (this.$parent.selectedSocialEntities.length > 0)
                                        //  this.archiveMessage(this.$parent.selectedSocialEntities);
                                        //else
                                        //  DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_ARCHIVE"), textMsg: this.translateService.instant("LBL_MSG_ARCHIVE_NO_MESSAGE") });
                                        break;
                                }
                                break;
                            }
                        case "NOTEENTITY":
                            {
                                switch (key.toUpperCase()) {
                                    case "DELETE":
                                        this.deleteEntities("LBL_NOTE", "NOTEENTITY");
                                        break;
                                    case "EDIT": this.dialogManager.openJsPanelOrDialog("ADD_NOTE", true, null, null, this.viewContainerRef, NoteAddEditComponent);
                                }
                                break;
                            }
                        case "CONTACTMOMENT":
                            {
                                switch (key.toUpperCase()) {
                                    case "EDIT":
                                        this.dialogManager.editContactHistoryFromContextMenu(this.viewContainerRef);
                                        break;
                                    case "DELETE":
                                        this.deleteEntities("LBL_CONTACT_HISTORIES", "CONTACTMOMENT");
                                        break;
                                    case "MARKASNEVERDELETE":
                                        {
                                            this.markContactHistoryDeleteState(true);
                                            break;
                                        }
                                    case "MARKASDELETABLE":
                                        {
                                            this.markContactHistoryDeleteState(false);
                                            break;
                                        }
                                    case "BULKDELETE":
                                        {
                                            //this.dialogManager.bulkDeleteContactHistory(this.$parent.filteredList);
                                            break;
                                        }
                                }
                            }
                            break;
                        case "PERSON":
                            {
                                switch (key.toUpperCase()) {
                                    case "EDIT":
                                        this.dialogManager.openJsPanelOrDialog("ADD_PERSON", true, null, null, this.viewContainerRef, PersonAddEditComponent);
                                        break;
                                    case "ADDTICKET":
                                        {
                                            let ticketConfiguration = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
                                            let ticketType = jlinq.from(ticketConfiguration.TicketTypes).equals("Title", menuItem?.customItem?.StringRepresentation).first();
                                            this.dialogManager.openAddTicket(ticketType, this.viewContainerRef);
                                            break;
                                        }
                                    case "MERGELETTERTEMPLATE":
                                        {
                                            this.dialogManager.openJsPanelOrDialog("MERGE_LETTER");
                                            break;
                                        }
                                    case "DELETE":
                                        {
                                            this.deletePerson();
                                            break;
                                        }
                                }
                                break;
                            }
                        case "FILEENTITY":
                            {
                                switch (key.toUpperCase()) {
                                    case "EDIT":
                                        this.dialogManager.openJsPanelOrDialog("ADD_FILE", true, null, null, this.viewContainerRef, FileAddEditComponent);
                                        break;
                                    case "DELETE":
                                        this.deleteEntities("LBL_FILEENTITY", "FILEENTITY");
                                        break;
                                }
                                break;
                            }
                        case "ORGANIZATION":
                            {
                                switch (key.toUpperCase()) {
                                    case "EDIT":
                                        this.dialogManager.openJsPanelOrDialog("ADD_ORGANIZATION", true, null, null, this.viewContainerRef, OrganizationAddEditComponent);
                                        break;
                                    case "ADDREPRESENTATIVE":
                                        this.dialogManager.addRepresentative(this.sessionManager.selectedEntity.Id);
                                        break;
                                    case "ADDTICKET":
                                        {
                                            let ticketConfiguration = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
                                            let ticketType = jlinq.from(ticketConfiguration.TicketTypes).equals("Title", menuItem.customItem.StringRepresentation).first();
                                            this.dialogManager.openAddTicket(ticketType, this.viewContainerRef);
                                            break;
                                        }
                                    case "MERGELETTERTEMPLATE":
                                        {
                                            this.dialogManager.openJsPanelOrDialog("MERGE_LETTER");
                                            break;
                                        }
                                    case "DELETE":
                                        {
                                            this.deleteOrganization();
                                            break;
                                        }
                                }
                                break;
                            }
                        case "THEME":
                            {
                                switch (key.toUpperCase()) {
                                    case "SUMMARIZE":
                                        let contentToSummarize = this.sessionManager.selectedEntity?.FormattedDescription;
                                        let titleOfTheme = this.sessionManager.selectedEntity?.Title;
                                        let fullRouteUrl = window.location.origin + '/' + this.location.prepareExternalUrl(this.router.serializeUrl(this.router.createUrlTree([RoutePath.SUMMARIZE_DOCUMENT])));
                                        GlobalFunctions.openSummarizationInNewWindow(contentToSummarize, titleOfTheme, fullRouteUrl);
                                        break;
                                    case "EDIT":
                                        this.dialogManager.openJsPanelOrDialog("ADD_THEME", true, null, null, this.viewContainerRef, ThemeAddEditComponent);
                                        break;
                                    case "DELETE":
                                        this.deleteEntities(this.translateService.instant("LBL_THEME"), "THEME");
                                        break;
                                }
                                break;
                            }
                        case "LINK":
                            {
                                switch (key.toUpperCase()) {
                                    case "EDIT":
                                        this.dialogManager.openJsPanelOrDialog("ADD_LINK", true, null, null, this.viewContainerRef, LinkAddEditComponent);
                                        break;
                                    case "DELETE":
                                        this.deleteEntities("LBL_LINKS", "LINK");
                                        break;
                                }
                                break;
                            }
                    }
                    break;
                }
        }
    }
    ;
    actForAll(actionItem) {
        if (actionItem) {
            let url = actionItem.ActionValue;
            if (!GlobalFunctions.isEmpty(url)) {
                let mcol = url.match(/{[0-9a-zA-Z.\[\]]+\}/g);
                if (mcol && mcol.length > 0) {
                    let loadedEntity = { ...this.sessionManager.selectedEntity };
                    if (loadedEntity) {
                        for (let index = 0; index < mcol.length; index++) {
                            let temp = mcol[index];
                            if (temp) {
                                GlobalFunctions.setStringPresentation(loadedEntity, temp);
                                url = url.replace(temp, loadedEntity.StringRepresentation);
                            }
                        }
                    }
                }
            }
            if (!GlobalFunctions.isEmpty(url))
                window.open(url, "_blank");
        }
    }
    ;
    actForSelected(actionItem) {
        if (actionItem && !GlobalFunctions.isEmpty(actionItem.ActionValue)) {
            let loadedEntity = { ...this.sessionManager.selectedEntity };
            if (loadedEntity) {
                GlobalFunctions.setStringPresentation(loadedEntity, actionItem.ActionValue);
                if (!GlobalFunctions.isEmpty(loadedEntity.StringRepresentation))
                    window.open(loadedEntity.StringRepresentation, "_blank");
            }
        }
    }
    ;
    executeCustomContextMenuOption(menuItem) {
        if (menuItem?.customItem?.ActionList) {
            let actionList = menuItem.customItem.ActionList;
            for (let index = 0; index < actionList.length; index++) {
                let actionItem = actionList[index];
                if (actionItem) {
                    switch (actionItem.ActionType) {
                        case 0:
                            {
                                if (menuItem.customItem.ActForSelected)
                                    this.actForAll(actionItem);
                                else
                                    this.actForSelected(actionItem);
                                break;
                            }
                    }
                }
            }
        }
    }
    ;
    deleteEntities(header, entityType) {
        let message = this.translateService.instant("LBL_MSG_DELETE_SELECTED_ITEM");
        if (entityType == "FILEENTITY") {
            if (this.sessionManager.selectedEntity.AttachmentType == AttachmentType.Upload)
                message = message + "\n" + this.translateService.instant("LBL_MSG_DELETE_SELECTED_ITEM_FILE");
            else
                message = message + "\n" + this.translateService.instant("LBL_MSG_DELETE_SELECTED_ITEM_LINK_FILE");
        }
        let messageInfo = DialogHelper.getMessage(this.translateService.instant(header), message, true, null, null, null, null, this.translateService);
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
            if (result) {
                switch (entityType) {
                    case "ASSIGNMENT":
                    case "CALLBACKNOTE":
                    case "REPORTIMPROVEMENT":
                    case "INFORMATIONREQUEST":
                        {
                            this.taskService.deleteTask(this.sessionManager.selectedEntity, this.deleteTaskResponse);
                            break;
                        }
                    case "APPOINTMENT":
                        {
                            if (this.sessionManager.selectedEntity.TaskSource === TaskSource.SmartCJM) {
                                this.taskService.deleteAppointment(this.sessionManager.selectedEntity.Id, this.deleteAppointmentResponse);
                            }
                            else if (this.sessionManager.selectedEntity.TaskSource === TaskSource.Qmatic) {
                                const request = new MakeAppointmentExternalRequest();
                                request.AppointmentId = this.sessionManager.selectedEntity.Id;
                                request.RequestId = "DELETE";
                                this.taskService.makeAppointmentExternal(request);
                                this.lastSelectedBreadcrumb();
                            }
                            else if (this.sessionManager.selectedEntity.TaskSource === TaskSource.Jcc) {
                                const request = new MakeAppointmentExternalRequest();
                                request.AppointmentId = this.sessionManager.selectedEntity.Id;
                                request.RequestId = "VERWIJDERAFSPRAAK";
                                this.taskService.makeAppointmentExternal(request);
                                this.lastSelectedBreadcrumb(true);
                            }
                            else
                                this.taskService.deleteTask(this.sessionManager.selectedEntity, this.deleteTaskResponse);
                            break;
                        }
                    case "NOTEENTITY":
                        this.noteService.deleteNote(this.sessionManager.selectedEntity, this.deleteNoteResponse);
                        break;
                    case "FILEENTITY":
                        this.fileentityService.deleteFile(this.sessionManager.selectedEntity, this.deleteFileResponse);
                        break;
                    case "CONTACTMOMENT":
                        this.contactHistoryService.setContactHistoryDeleteResponseReceived(this.deleteContactHistoryResponse);
                        this.contactHistoryService.deleteContactHistory(this.sessionManager.selectedEntity.Id);
                        break;
                    case "THEME":
                        this.themeService.deleteTheme(this.sessionManager.selectedEntity, this.deleteThemeResponse);
                        break;
                    case "LINK":
                        this.linkService.deleteLink(this.sessionManager.selectedEntity, this.deleteFileResponse);
                        break;
                    case "FACEBOOK":
                    case "TWITTER":
                    case "WHATSAPP":
                    case "SOCIALMEDIA":
                        let socialMediaMessageList = [];
                        socialMediaMessageList.push(this.sessionManager.selectedEntity);
                        let deleteSocialMediaMessageRequest = new DeleteSocialMediaMessageRequest();
                        deleteSocialMediaMessageRequest.SocialMediaMessageList = socialMediaMessageList;
                        this.socialMediaService.deleteSocialMediaMessage(deleteSocialMediaMessageRequest, this.deleteSocialMediaMessageResponse, null);
                        break;
                }
                this.updateIsFavouriteForDeletedEntity(this.sessionManager.selectedEntity);
            }
        });
    }
    ;
    openInSource() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.SourceApplicationDeeplink))
            window.open(this.sessionManager.selectedEntity.SourceApplicationDeeplink, "_blank");
    }
    ;
    deleteTicket(ticketId) {
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_TICKET"), textMsg: this.translateService.instant("LBL_MSG_DELETE_SELECTED_ITEM"), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
            if (result)
                this.ticketService.deleteTicket(ticketId, this.deleteTicketResponseReceived);
        });
    }
    ;
    deleteTicketResponseReceived(response) {
        if (response.Result == 1)
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_TICKET"), textMsg: this.translateService.instant("LBL_DELETED_ENTITY_FAILED") }).afterClosed().subscribe(() => this.lastSelectedBreadcrumb());
        else {
            this.sessionManager.removeFromDetailViewCachedEntityList(this.sessionManager.selectedEntity.Id);
            this.lastSelectedBreadcrumb();
        }
    }
    ;
    lastSelectedBreadcrumb(gotoDashboard = false) {
        let breadCrumbItems = [];
        let isFromSearchResult = false;
        let index = this.sessionManager.selectedBreadcrumbIndex;
        let currentBreadcrumItem = this.sessionManager.BreadcrumbItems[index];
        this.sessionManager.BreadcrumbItems[index][0].isDeleted = true;
        if (index < this.sessionManager.BreadcrumbItems.length) {
            for (let i = index + 1; i < this.sessionManager.BreadcrumbItems.length; i++) {
                breadCrumbItems = this.sessionManager.BreadcrumbItems[i];
                if (!GlobalFunctions.isEmpty(breadCrumbItems)) {
                    for (let j = 0; j < breadCrumbItems.length; j++) {
                        if (currentBreadcrumItem != undefined && currentBreadcrumItem[0].itemData != null && (currentBreadcrumItem[0].itemData.Id == breadCrumbItems[j].itemData.Id) || (currentBreadcrumItem[0].itemData.ObjectSourceDto != undefined && currentBreadcrumItem[0].itemData.ObjectSourceDto.Id == breadCrumbItems[j].itemData.Id)) {
                            isFromSearchResult = true;
                            if (breadCrumbItems.length == 1)
                                breadCrumbItems[0].isDeleted = true;
                            else {
                                let index = breadCrumbItems.indexOf(breadCrumbItems[j]);
                                breadCrumbItems.splice(index, 1);
                            }
                        }
                    }
                }
            }
            breadCrumbItems = this.sessionManager.BreadcrumbItems[this.sessionManager.selectedBreadcrumbIndex + 1];
        }
        if ((isFromSearchResult || !isFromSearchResult && this.sessionManager.loadedFromRelatedView) && !gotoDashboard) {
            if (breadCrumbItems[0].sourceUrl.toLowerCase().indexOf(RoutePath.LIST_PATH) == -1 || this.sessionManager.loadedFromRelatedView) {
                if (breadCrumbItems[0].itemData.ScheduledWorkType != undefined && breadCrumbItems[0].itemData.ObjectSourceDto != undefined)
                    this.sessionManager.selectedEntity = breadCrumbItems[0].itemData.ObjectSourceDto;
                else
                    this.sessionManager.selectedEntity = breadCrumbItems[0].itemData;
                breadCrumbItems[0].isSelected = true;
                this.sessionManager.SelectedBreadcrumbItem = breadCrumbItems[0];
                this.router.navigate([breadCrumbItems[0].locationUrl]);
            }
            else {
                this.localSearchResultDataService.localSearchResultData.localResult = [];
                this.localSearchResultDataService.localSearchResultData.contentType = "";
                if (breadCrumbItems != null && breadCrumbItems.length > 0) {
                    this.localSearchResultDataService.localSearchResultData.contentType = breadCrumbItems[0].sourceUrl.substring(breadCrumbItems[0].sourceUrl.lastIndexOf("/") + 1);
                    breadCrumbItems.forEach((el, i) => {
                        if (!el.isDeleted)
                            this.localSearchResultDataService.localSearchResultData.localResult.push(el.itemData);
                        this.localSearchResultDataService.localSearchResultData.contentType = el.sourceUrl.substring(el.sourceUrl.lastIndexOf("/") + 1);
                    });
                    breadCrumbItems[0].isSelected = true;
                    this.sessionManager.addBreadcrumbTypeItems(breadCrumbItems, false);
                    GlobalFunctions.navigateWithOptionalQueryParam(this.router, breadCrumbItems[0].sourceUrl);
                }
            }
        }
        else
            this.router.navigate(['/']);
    }
    printItem(contentType) {
        let isPersonConfident = this.showPersonConfidentialWarning(this.sessionManager.selectedEntity, contentType);
        if (!isPersonConfident) {
            this.sessionManager.addBasketItem();
            DialogHelper.openDialog(this.dialog, PrintComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
        }
    }
    ;
    showPersonConfidentialWarning(personEntity, contentType) {
        let isConfidentPerson = false;
        if (!GlobalFunctions.isEmpty(contentType) && contentType.toUpperCase() == "PERSON" && !GlobalFunctions.isEmpty(personEntity.Details) && GlobalFunctions.isPersonConfident(personEntity.ConfidentialityLevel)) {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_PERSON'), textMsg: this.translateService.instant('LBL_MSG_CONFIDENTIALITY_DETAILS_FOR_PERSON') });
            isConfidentPerson = true;
        }
        return isConfidentPerson;
    }
    ;
    addToBasket(key, contentType) {
        let isPersonConfident = this.showPersonConfidentialWarning(this.sessionManager.selectedEntity, contentType);
        if (!isPersonConfident) {
            let addPersonDeceasedWarning = this.showPersonDeceasedWarning(this.sessionManager.selectedEntity, contentType);
            addPersonDeceasedWarning.then(result => {
                if (result) {
                    this.sessionManager.addBasketItem();
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_OUTBOX"), textMsg: this.translateService.instant("LBL_ADDED_TO_BASKET") });
                }
            });
        }
    }
    ;
    openDialog(dialogName, contentType) {
        switch (dialogName.toUpperCase()) {
            case "SENDVIAEMAIL":
                {
                    if (this.sessionManager.selectedEntity != null && this.sessionManager.selectedEntity != undefined) {
                        if (contentType.toLowerCase() == 'ticket')
                            this.dialogManager.openJsPanelOrDialog("ATTACH_TO_EMAIL", false, null, false, this.viewContainerRef);
                        else {
                            let isPersonConfident = this.showPersonConfidentialWarning(this.sessionManager.selectedEntity, contentType);
                            if (!isPersonConfident) {
                                let addPersonDeceasedWarning;
                                addPersonDeceasedWarning = this.showPersonDeceasedWarning(this.sessionManager.selectedEntity, contentType);
                                addPersonDeceasedWarning.then(result => {
                                    if (result) {
                                        this.sessionManager.selectedEntity.IsMarked = true;
                                        this.sessionManager.addBasketItem();
                                        let baskItemList = this.sessionManager.getMarkedItems(this.sessionManager.getBasketItems());
                                        this.dialogManager.openEmailBasket(this.viewContainerRef, null, EmailType.Send, baskItemList);
                                    }
                                });
                            }
                        }
                    }
                    break;
                }
            case "REPLY":
            case "FORWARD":
                {
                    if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && dialogName.toUpperCase() == 'REPLY')
                        this.sessionManager.selectedEntity.EmailType = EmailType.Reply;
                    else
                        this.sessionManager.selectedEntity.EmailType = EmailType.Forward;
                    let baskItemList = this.sessionManager.getMarkedBasketItems();
                    this.dialogManager.openEmailBasket(this.viewContainerRef, null, this.sessionManager.selectedEntity.EmailType, baskItemList);
                    break;
                }
        }
    }
    showPersonDeceasedWarning(personEntity, contentType) {
        return new Promise((resolve, reject) => {
            if (contentType != "PERSON" && personEntity.Details == null || !GlobalFunctions.isPersonDeceased(personEntity.Details.DateOfExpiration))
                return resolve(true);
            else {
                const messageInfo = DialogHelper.getMessage(this.translateService.instant('LBL_CALLBACK_NOTE'), this.translateService.instant('LBL_WARNING_PERSON_DECEASED'), true, null, null, null, null, this.translateService);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => resolve(result));
            }
        });
    }
    ;
    openItemInDetailView(entityName) {
        if (this.cacheManager.relatedResultList != null && !GlobalFunctions.isEmpty(this.cacheManager.relatedResultList[entityName]) && !GlobalFunctions.isEmpty(this.cacheManager.relatedResultList[entityName][0])) {
            let item = this.cacheManager.relatedResultList[entityName][0];
            this.sessionManager.selectedEntity = item;
            entityName = entityName.toLowerCase();
            if (entityName == 'socialmedia' && !GlobalFunctions.isEmpty(item.Type))
                entityName = item.Type.toLowerCase();
            item.locationUrl = `${RoutePath.DETAIL_PATH}/${entityName}`;
            this.sessionManager.setBreadcrumbGrammer(item);
            this.sessionManager.addBreadcrumbItems([item], null, RoutePath.DETAIL_PATH);
            this.router.navigate([item.locationUrl]);
        }
    }
    ;
    sendToTaskRequest() {
        let sendToTaskHandlerId = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "SENDTOTASKHANDLERID");
        let sendToTaskHandlerType = TaskHandlerType[this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "SENDTOTASKHANDLERTYPE")];
        if (sendToTaskHandlerType != TaskHandlerType.None && !GlobalFunctions.isEmpty(sendToTaskHandlerId)) {
            let taskHistoryDto = new TaskHistoryDto();
            taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            taskHistoryDto.Status = TaskStatus.Forwarded;
            taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
            let taskHandler = new TaskHandlerDto();
            taskHandler.HandlerId = sendToTaskHandlerId;
            taskHandler.HandlerType = sendToTaskHandlerType;
            let baseDtoObject = new BaseDto();
            baseDtoObject.Id = taskHandler.HandlerId;
            taskHandler.HandlerObject = baseDtoObject;
            taskHistoryDto.TaskHandlerList = new Array();
            taskHistoryDto.TaskHandlerList.push(taskHandler);
            let taskDto = { ...this.sessionManager.selectedEntity };
            taskDto.TaskHistoryList = new Array();
            taskDto.TaskHistoryList.push(taskHistoryDto);
            this.taskService.forwardTask(taskDto, ForwardTaskType.SendTo, this.sendToTaskResponseReceived, this.sendToTaskErrorCallback);
        }
    }
    ;
    sendToTaskErrorCallback() {
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), this.translateService.instant("LBL_TASK_ERROR_MSG"), this.translateService.instant("LBL_TASK"));
        ExceptionHelper.showException(this.dialog, exception, true);
    }
    ;
    sendToTaskResponseReceived(result) {
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TASK_STATISTIC);
        if (result.Result == 0)
            this.loadLastSelectedSearchResult();
        else {
            let message = this.translateService.instant("LBL_MSG_FAILED_TO_FORWARD_TASK");
            let header = this.translateService.instant("LBL_EMAIL");
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message });
        }
    }
    ;
    loadLastSelectedSearchResult() {
        let index = this.sessionManager.selectedBreadcrumbIndex;
        let currentBreadcrumItem = this.sessionManager.BreadcrumbItems[index];
        this.sessionManager.BreadcrumbItems[index][0].isDeleted = true;
        if (index < this.sessionManager.BreadcrumbItems.length)
            index = index + 1;
        let breadCrumbItems = this.sessionManager.BreadcrumbItems[index];
        if (breadCrumbItems != undefined || breadCrumbItems != null)
            breadCrumbItems.forEach(breadCrumbItem => {
                if (currentBreadcrumItem != undefined && currentBreadcrumItem[0].itemData != null && breadCrumbItem.itemData.ObjectSourceDto != null && currentBreadcrumItem[0].itemData.Id == breadCrumbItem.itemData.ObjectSourceDto.Id) {
                    if (breadCrumbItems.length == 1)
                        breadCrumbItems[0].isDeleted = true;
                    else {
                        index = breadCrumbItems.indexOf(breadCrumbItem);
                        breadCrumbItems.splice(index, 1);
                    }
                }
            });
        this.router.navigate([RoutePath.DASHBOARD, RoutePath.SEARCH_PATH, SideMenuItem.TASK]);
    }
    ;
    openAssignment(taskSessionData) {
        if (!GlobalFunctions.isEmpty(taskSessionData)) {
            let items = [];
            if (!GlobalFunctions.isEmpty(taskSessionData.CurrentHandlerList) && taskSessionData.CurrentHandlerList.length > 0) {
                taskSessionData.CurrentHandlerType = taskSessionData.CurrentHandlerList[0].HandlerType;
                for (let i = 0; i < taskSessionData.CurrentHandlerList.length; i++) {
                    let handler = taskSessionData.CurrentHandlerList[i];
                    if (!GlobalFunctions.isEmpty(handler)) {
                        let handleData = null;
                        if (handler.HandlerType == TaskHandlerType.Employee || handler.HandlerType == "Employee")
                            handleData = this.cacheManager.getEmployeeById(handler.HandlerId);
                        else
                            handleData = this.cacheManager.getDepartmentById(handler.HandlerId);
                        if (handleData != null) {
                            handleData.text = handleData.StringRepresentation;
                            items.push(handleData);
                        }
                    }
                }
            }
            else
                taskSessionData.CurrentHandlerType = "Employee";
            taskSessionData.HandlerTags = items;
            this.dialogManager.openJsPanelOrDialog("ADD_ASSIGNMENT", true, taskSessionData, false, this.viewContainerRef);
        }
        else
            this.dialogManager.openJsPanelOrDialog("ADD_ASSIGNMENT", false, null, false, this.viewContainerRef);
    }
    openCallbacknote(taskData) {
        if (!GlobalFunctions.isEmpty(taskData)) {
            let items = [];
            if (!GlobalFunctions.isEmpty(taskData.CurrentHandlerList) && taskData.CurrentHandlerList.length > 0) {
                taskData.CurrentHandlerType = taskData.CurrentHandlerList[0].HandlerType;
                for (let i = 0; i < taskData.CurrentHandlerList.length; i++) {
                    let handler = taskData.CurrentHandlerList[i];
                    if (!GlobalFunctions.isEmpty(handler)) {
                        let handleData = null;
                        if (handler.HandlerType == TaskHandlerType.Employee || handler.HandlerType == "Employee")
                            handleData = this.cacheManager.getEmployeeById(handler.HandlerId);
                        else
                            handleData = this.cacheManager.getDepartmentById(handler.HandlerId);
                        if (handleData != null) {
                            handleData.text = handleData.StringRepresentation;
                            items.push(handleData);
                        }
                    }
                }
            }
            else
                taskData.CurrentHandlerType = "Employee";
            taskData.HandlerTags = items;
            this.dialogManager.openJsPanelOrDialog("ADD_CALLBACKNOTE", true, taskData, false, this.viewContainerRef);
        }
        else
            this.dialogManager.openJsPanelOrDialog("ADD_CALLBACKNOTE", false, null, false, this.viewContainerRef);
    }
    ;
    openAppointment(taskData) {
        if (!GlobalFunctions.isEmpty(taskData)) {
            let items = [];
            if (!GlobalFunctions.isEmpty(taskData.CurrentHandlerList) && taskData.CurrentHandlerList.length > 0) {
                taskData.CurrentHandlerType = taskData.CurrentHandlerList[0].HandlerType;
                for (let i = 0; i < taskData.CurrentHandlerList.length; i++) {
                    let handler = taskData.CurrentHandlerList[i];
                    if (!GlobalFunctions.isEmpty(handler)) {
                        let handleData = null;
                        if (handler.HandlerType == TaskHandlerType.Employee || handler.HandlerType == "Employee")
                            handleData = this.cacheManager.getEmployeeById(handler.HandlerId);
                        else
                            handleData = this.cacheManager.getDepartmentById(handler.HandlerId);
                        if (handleData != null) {
                            handleData.text = handleData.StringRepresentation;
                            items.push(handleData);
                        }
                    }
                }
            }
            else
                taskData.CurrentHandlerType = "Employee";
            taskData.HandlerTags = items;
        }
        this.dialogManager.openJsPanelOrDialog("ADD_APPOINTMENT", true, taskData, false, this.viewContainerRef);
    }
    ;
    openInformationRequest(taskSessionData) {
        if (!GlobalFunctions.isEmpty(taskSessionData)) {
            let items = [];
            if (!GlobalFunctions.isEmpty(taskSessionData.CurrentHandlerList) && taskSessionData.CurrentHandlerList.length > 0) {
                taskSessionData.CurrentHandlerType = taskSessionData.CurrentHandlerList[0].HandlerType;
                for (let i = 0; i < taskSessionData.CurrentHandlerList.length; i++) {
                    let handler = taskSessionData.CurrentHandlerList[i];
                    if (!GlobalFunctions.isEmpty(handler)) {
                        let handleData = null;
                        if (handler.HandlerType == TaskHandlerType.Employee || handler.HandlerType == "Employee")
                            handleData = this.cacheManager.getEmployeeById(handler.HandlerId);
                        else
                            handleData = this.cacheManager.getDepartmentById(handler.HandlerId);
                        if (handleData != null) {
                            handleData.text = handleData.StringRepresentation;
                            items.push(handleData);
                        }
                    }
                }
            }
            else
                taskSessionData.CurrentHandlerType = "Employee";
            taskSessionData.HandlerTags = items;
            this.dialogManager.openJsPanelOrDialog("ADD_INFORMATIONREQUEST", true, taskSessionData, false, this.viewContainerRef);
        }
        else
            this.dialogManager.openJsPanelOrDialog("ADD_INFORMATIONREQUEST", false, null, false, this.viewContainerRef);
    }
    deleteAppointmentResponse(response) {
        if (response.Result == 1) {
            let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_APPOINTMENT"), this.translateService.instant("LBL_DELETED_ENTITY_FAILED"), true, null, null, null, null, this.translateService);
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(() => this.lastSelectedBreadcrumb());
        }
        else {
            this.sessionManager.removeFromDetailViewCachedEntityList(this.sessionManager.selectedEntity.Id);
            this.lastSelectedBreadcrumb();
        }
    }
    deleteTaskResponse(response) {
        if (response.Result == 1) {
            let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_CALLBACK_NOTE"), this.translateService.instant("LBL_DELETED_ENTITY_FAILED"), true, null, null, null, null, this.translateService);
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(() => this.lastSelectedBreadcrumb());
        }
        else {
            this.sessionManager.removeFromDetailViewCachedEntityList(this.sessionManager.selectedEntity.Id);
            this.lastSelectedBreadcrumb();
        }
    }
    deleteNoteResponse(response) {
        if (response.Result == 1) {
            let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_NOTE"), this.translateService.instant("LBL_DELETED_ENTITY_FAILED"), false, null, null, null, null, this.translateService);
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(() => this.lastSelectedBreadcrumb());
        }
        else {
            this.sessionManager.removeFromDetailViewCachedEntityList(this.sessionManager.selectedEntity.Id);
            this.lastSelectedBreadcrumb();
        }
    }
    deleteFileResponse(response) {
        if (response.Result == 1) {
            let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_FILEENTITY"), this.translateService.instant("LBL_DELETED_ENTITY_FAILED"), false, null, null, null, null, this.translateService);
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(() => this.lastSelectedBreadcrumb());
        }
        else
            this.lastSelectedBreadcrumb();
    }
    deleteThemeResponse(response) {
        if (response.Result == 1) {
            let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_THEME"), this.translateService.instant("LBL_DELETED_ENTITY_FAILED"), false, null, null, null, null, this.translateService);
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
        }
        else {
            this.sessionManager.removeFromDetailViewCachedEntityList(this.sessionManager.selectedEntity.Id);
            this.lastSelectedBreadcrumb();
        }
    }
    deleteContactHistoryResponse(response) {
        if (response.Result == 1) {
            let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_CONTACTMOMENT"), this.translateService.instant("LBL_DELETED_ENTITY_FAILED"), false, null, null, null, null, this.translateService);
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(() => this.lastSelectedBreadcrumb());
        }
        else {
            this.sessionManager.removeFromDetailViewCachedEntityList(this.sessionManager.selectedEntity.Id);
            this.lastSelectedBreadcrumb();
        }
    }
    deleteSocialMediaMessageResponse(response) {
        switch (response.Result) {
            case 0:
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.SOCIAL_MEDIA]);
                let currentUrl = this.router.url;
                this.router.navigate([currentUrl]);
                break;
            case 1:
                let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_SOCIALMEDIA"), this.translateService.instant("LBL_DELETED_ENTITY_FAILED"), false, null, null, null, null, this.translateService);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(() => {
                    this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.SOCIAL_MEDIA]);
                    let currentUrl = this.router.url;
                    this.router.navigate([currentUrl]);
                });
                break;
        }
    }
    openEformLink() {
        if (this.sessionManager.selectedEntity != null && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Links) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Links[0].UriText))
            this.productService.showEform(this.sessionManager.selectedEntity.Links[0].UriText);
    }
    showProductId(menuItem) {
        if (this.sessionManager.selectedEntity != null) {
            menuItem.entityId = this.sessionManager.selectedEntity.Id;
            menuItem.showId = true;
        }
    }
    ;
    deleteEmail() {
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: this.translateService.instant("LBL_MSG_DELETE_SELECTED_ITEM"), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
            if (result)
                this.emailService.deleteMailRecord(this.sessionManager.selectedEntity, this.emailDeleteResponseReceived);
        });
    }
    ;
    archiveEmail() {
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: this.translateService.instant("LBL_MSG_ARCHIVE_EMAIL"), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
            if (result)
                this.emailService.archiveEmail(this.sessionManager.selectedEntity, this.emailArchiveResponseReceived);
        });
    }
    ;
    emailDeleteResponseReceived(response) {
        if (response.Result == 0) {
            if (this.sessionManager.isAssignmentTaskAutoIgnoreSessionValid(this.cacheManager, "email"))
                this.sessionManager.autoIgnoreSession(this.dialog, this.dialogManager, this.cacheManager, this.phoneManager);
            else {
                this.emailService.selectedMailbox = this.emailService.lastSelectedMailbox;
                this.emailService.selectedEmailOption = this.emailService.lastSelectedEmailOption;
                this.lastSelectedBreadcrumb();
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.EMAIL], { queryParams: { filter: this.emailService.selectedEmailOption, mailbox: this.sessionManager.selectedMailbox } });
            }
        }
        else {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: this.translateService.instant("LBL_DELETED_ENTITY_FAILED") });
            this.lastSelectedBreadcrumb();
        }
    }
    ;
    emailArchiveResponseReceived(response) {
        if (response.Result == 0) {
            if (this.sessionManager.isAssignmentTaskAutoIgnoreSessionValid(this.cacheManager, "email"))
                this.sessionManager.autoIgnoreSession(this.dialog, this.dialogManager, this.cacheManager, this.phoneManager);
            else {
                this.emailService.selectedMailbox = this.emailService.lastSelectedMailbox;
                this.emailService.selectedEmailOption = this.emailService.lastSelectedEmailOption;
                const loadedEntity = { ...this.sessionManager.selectedEntity };
                this.sessionManager.removeFromDetailViewCachedEntityList(this.sessionManager.selectedEntity.Id);
                this.lastSelectedBreadcrumb();
                loadedEntity.Id = response.EntityId;
                loadedEntity.Partial = true;
                loadedEntity.Header.EmailSource = EmailSource.Archive;
                this.sessionManager.addItemsToDetailViewCacheList(loadedEntity, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email]), true);
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.EMAIL], { queryParams: { filter: this.emailService.selectedEmailOption, mailbox: this.sessionManager.selectedMailbox } });
            }
        }
        else {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: this.translateService.instant("LBL_MSG_FAILED_TO_ARCHIVE_EMAIL") });
            this.lastSelectedBreadcrumb();
        }
    }
    ;
    markContactHistoryDeleteState(state) {
        let idList = [];
        idList.push(this.sessionManager.selectedEntity.Id);
        this.contactHistoryService.markDeleteStateContactHistory(idList, state, this.markContactHistoryDeleteStateResponse);
    }
    ;
    markContactHistoryDeleteStateResponse(response) {
        switch (response.Result) {
            case 0:
                {
                    this.sessionManager.selectedEntity.NeverDelete = !this.sessionManager.selectedEntity.NeverDelete;
                    this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
                    break;
                }
            case 1:
                {
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CONTACT_HISTORY"), textMsg: this.translateService.instant("LBL_MSG_DELETE_FAIL_CONTACT_HISTORY") });
                    break;
                }
        }
    }
    deleteOrganization() {
        let header = this.translateService.instant("LBL_ORGANIZATION");
        let message = this.translateService.instant("LBL_MSG_DELETE_SELECTED_ITEM");
        let messageInfo = DialogHelper.getMessage(this.translateService.instant(header), message, true, null, null, null, null, this.translateService);
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
            if (result) {
                let partialDto = new Object();
                partialDto.Id = this.sessionManager.selectedEntity.Id;
                partialDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
                this.organizationService.delete(partialDto, this.deleteResponse);
            }
        });
        this.updateIsFavouriteForDeletedEntity(this.sessionManager.selectedEntity);
    }
    ;
    deletePerson() {
        let header = this.translateService.instant("LBL_PERSON");
        let message = this.translateService.instant("LBL_MSG_DELETE_SELECTED_ITEM");
        let messageInfo = DialogHelper.getMessage(this.translateService.instant(header), message, true, null, null, null, null, this.translateService);
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
            if (result) {
                let partialDto = new Object();
                partialDto.Id = this.sessionManager.selectedEntity.Id;
                partialDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
                this.personService.delete(partialDto, this.deleteResponse);
            }
        });
        this.updateIsFavouriteForDeletedEntity(this.sessionManager.selectedEntity);
    }
    ;
    deleteResponse(response, title) {
        if (response.Result == 1) {
            let message = this.translateService.instant("LBL_DELETED_ENTITY_FAILED");
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: title, textMsg: message }).afterClosed().subscribe(() => this.lastSelectedBreadcrumb());
        }
        else {
            this.sessionManager.removeFromDetailViewCachedEntityList(this.sessionManager.selectedEntity.Id);
            this.lastSelectedBreadcrumb();
        }
    }
    ;
    bindShortcuts() {
        this.shortcutManager.init().then(() => {
            this.shortcutManager.bind('LBL_SHORTCUT_ACTION_BUTTON_1', () => this.executeActionButton1());
            this.shortcutManager.bind('LBL_SHORTCUT_ACTION_BUTTON_2', () => this.executeActionButton2());
            this.shortcutManager.bind('LBL_SHORTCUT_CONTEXT_MENU', () => this.openContextMenu());
        });
    }
    unbindShortcuts() {
        this.shortcutManager.unbind('LBL_SHORTCUT_ACTION_BUTTON_1');
        this.shortcutManager.unbind('LBL_SHORTCUT_ACTION_BUTTON_2');
        this.shortcutManager.unbind('LBL_SHORTCUT_CONTEXT_MENU');
    }
    executeActionButton1() {
        const actionButton = this.contextMenuService.actionButtons[0];
        if (this.router.url.includes('detail') && actionButton)
            this.executeMenuItem(actionButton._KEY, actionButton.CONTENTTYPE);
    }
    executeActionButton2() {
        const actionButton = this.contextMenuService.actionButtons[1];
        if (this.router.url.includes('detail') && actionButton)
            this.executeMenuItem(actionButton._KEY, actionButton.CONTENTTYPE);
    }
    openContextMenu() {
        if (this.router.url.includes('detail'))
            document.getElementById('detailMenuDropDownToggle').click();
    }
    ;
    updateIsFavouriteForDeletedEntity(entityDto) {
        // update 'Myfavourite' List on Dashboard after deleting main entity.
        if (!GlobalFunctions.isEmpty(entityDto)) {
            if (entityDto.IsFavourite) {
                let favouriteDto = new FavouriteDto(entityDto);
                this.systemComponentService.makeFavourite(favouriteDto, RecordOperationMode.Delete);
                entityDto.IsFavourite = false;
                this.cacheManager.removeItemFromDashboardCache("MyFavourite", favouriteDto);
            }
        }
    }
}
//# sourceMappingURL=context-menu.component.js.map