var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { ContactSessionNotesUIState, HandlerType, ScreenMode } from '../../../core/enums/common-enums';
import { EntityFqdn } from '../../../core/enums/core-enums';
import { EmailType } from '../../../core/enums/global-enum';
import { CallStatus, PhoneStatus } from '../../../core/enums/phone-enum';
import { UIState } from '../../../core/enums/session-enum';
import { ContactHandleInfo } from '../../../core/models/common/contact-handle-info';
import { ContactHistoryMomentDto } from '../../../core/models/contact-history/contact-history-momentDto';
import { ContactHistoryObjectDto } from '../../../core/models/contact-history/contact-history-objectDto';
import { BroadCastEventKeys, RoutePath } from '../../../shared/constants';
import { GlobalFunctions } from '../../../shared/global-functions';
import { DialogHelper } from '../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../shared/helper/exception-helper';
import { SessionSaveComponent } from '../../domain/task/subdomains/session/save/session-save.component';
import { MessageboxComponent } from '../messagebox/messagebox.component';
import { OutboxComponent } from '../outbox/outbox.component';
let ContactSessionNotesComponent = class ContactSessionNotesComponent {
    constructor(router, dialog, chatService, cacheManager, phoneManager, dialogManager, searchService, eventProvider, sessionManager, sessionService, employeeService, shortcutManager, translateService, viewContainerRef, htmlToPlainTextPipe, contactHistoryService, systemComponentService, applicationSettingManager, applicationFeatureManager, integrationSettingManager) {
        this.router = router;
        this.dialog = dialog;
        this.chatService = chatService;
        this.cacheManager = cacheManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.searchService = searchService;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.sessionService = sessionService;
        this.employeeService = employeeService;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.viewContainerRef = viewContainerRef;
        this.htmlToPlainTextPipe = htmlToPlainTextPipe;
        this.contactHistoryService = contactHistoryService;
        this.systemComponentService = systemComponentService;
        this.applicationSettingManager = applicationSettingManager;
        this.applicationFeatureManager = applicationFeatureManager;
        this.integrationSettingManager = integrationSettingManager;
        this.isLoadedFromSource = "";
        this.contactedDate = new Date();
        this.customerRoles = [];
        this.questionList = [];
        this.answerList = [];
        this.questionIndex = null;
        this.roleIndex = null;
        this.answerIndex = null;
        this.questionListOriginalLength = 0;
        this.answerListOriginalLength = 0;
        this.enableQuestionValidation = false;
        this.enableAnswerValidation = false;
        this.nextEmailEnabled = this.applicationFeatureManager.isShowNextEmailFeatureEnabled;
        this.sessionProduct = null;
        this.taskDto = null;
        this.callbackDefaultAnswer = "Terugbelnotitie gemaakt";
        this.appointmentDefaultAnswer = "Afspraak gemaakt";
        this.assignmentDefaultAnswer = "Taak gemaakt";
        this.reportImprovementDefaultAnswer = "Verbeterpunt gemaakt";
        this.informationRequestDefaultAnswer = "Informatie verzoek gemaakt";
        this.emailDefaultQuestion = "E-mail vraag";
        this.emailDefaultAnswer = "E-mail beantwoord";
        this.ContactSessionNotesUIStateEnum = ContactSessionNotesUIState;
        this.contactSessionPanelWidth = 600;
        this.contactHandleInfo = new ContactHandleInfo();
        this.updatePhoneStatus = true;
        this.dateJS = Date;
        this.rights = {
            canChangeContactChannel: false,
            chat: false,
            email: false,
            showIgnoreSessionButton: false,
            socialMedia: false,
        };
        this.tagItems = [];
        this.forwardedToHandlerItems = [];
        this.handledOnBehalfHandlerItems = [];
        this.timeoutIds = [];
        this.incomingCallStatus = CallStatus.Ringing;
        this.enableDepartmentNameInHandler = this.applicationSettingManager.isDepartmentNameInHandlerEnabled();
        this.enableWarningForCsnDuringPhoneCall = this.applicationSettingManager.isWarningForCsnDuringPhoneCallEnabled();
        this.subs = new SubSink();
        this.ignoreSessionResponse = this.ignoreSessionResponse.bind(this);
        this.createContactHistoryCallback = this.createContactHistoryCallback.bind(this);
        this.contactQuestionAnswerReceived = this.contactQuestionAnswerReceived.bind(this);
    }
    ngOnInit() {
        try {
            this.setRights();
            this.contactHistoryService.connect().then(() => {
                if (GlobalFunctions.isEmpty(this.integrationSettingManager.contactQuestionAnswerList))
                    this.contactHistoryService.fetchContactQuestionAnswerList(this.contactQuestionAnswerReceived);
                else
                    this.initialize();
                this.subs.sink = this.integrationSettingManager.cacheHandlerSettings().subscribe(() => this.setDefaultRoles());
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.CONTACT_HISTORY_SERVICE_CONNECTED);
            });
            this.contactHistoryService.setDefaultUIState();
            this.shortcutManager.bind('LBL_SHORTCUT_END_SESSION', () => this.endSession(false));
            this.subs.sink = this.eventProvider.event(BroadCastEventKeys.CLEAR_SESSION).subscribe(() => this.resetFields());
            this.subs.sink = this.eventProvider.event(BroadCastEventKeys.SET_CONTACT_SESSION_QUESTION_ANSWERS).subscribe(() => this.initialize());
            this.subs.sink = this.eventProvider.event(BroadCastEventKeys.ADDED_ENTITY_TO_CURRENT_SESSION).subscribe(() => {
                if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.CustomerRole)) {
                    let role = this.integrationSettingManager.roleSetting.getPossibleRole(this.sessionManager.selectedEntity);
                    if (role) {
                        let customerRoleIndex = this.checkPresence(this.customerRoles, role.Name);
                        if (customerRoleIndex !== -1) {
                            this.roleIndex = customerRoleIndex;
                            this.sessionManager.contactSessionNotesState.ContactHistoryDto.CustomerRole = role.Name;
                        }
                    }
                }
            });
            this.subs.sink = this.eventProvider.event(BroadCastEventKeys.AUTO_END_SESSION).subscribe(entityFqdn => {
                if (entityFqdn == EntityFqdn.Decos_Kcs_Email_Entities_Email) {
                    if (!GlobalFunctions.isEmpty(this.questionList)) {
                        this.sessionManager.contactSessionNotesState.ContactHistoryDto.Subject = this.questionList[this.questionList.length - 1];
                        let answerList = this.integrationSettingManager.getAnswers(this.questionList[this.questionList.length - 1]);
                        if (!GlobalFunctions.isEmpty(answerList)) {
                            this.sessionManager.contactSessionNotesState.ContactHistoryDto.Memo = answerList[answerList.length - 1];
                            this.saveSession(false);
                        }
                    }
                }
            });
            this.setForwardedToHandlers();
            this.setHandledOnBehalfHandlers();
            this.tagItems = this.applicationSettingManager.tagSetting.searchTagByQuery('');
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    setRights() {
        this.rights.canChangeContactChannel = GlobalFunctions.checkRights('ContactMoment', 70);
        this.rights.chat = GlobalFunctions.checkRights('Chat');
        this.rights.email = GlobalFunctions.checkRights('Email');
        this.rights.showIgnoreSessionButton = GlobalFunctions.checkRights('ContactMoment', 71);
        this.rights.socialMedia = GlobalFunctions.checkRights('SocialMedia');
    }
    startSessionOnNoteChange() {
        this.sessionManager.startSessionIfPossible("SESSIONNOTE", ScreenMode.Add);
        let sessionNoteObject = {};
        sessionNoteObject.Notes = this.sessionManager.contactSessionNotesState.ContactHistoryDto.Notes;
        sessionNoteObject.SubjectFreeText = this.sessionManager.contactSessionNotesState.ContactHistoryDto.SubjectFreeText;
        sessionNoteObject.MemoFreeText = this.sessionManager.contactSessionNotesState.ContactHistoryDto.MemoFreeText;
        sessionNoteObject.RelatedEntityFqdn = EntityFqdn.Decos_Kcs_Sessions_Entities_Session;
        let newTags = [];
        this.sessionManager.contactSessionNotesState.Tags = this.applicationSettingManager.tagSetting.getPossibleTags(this.sessionManager.contactSessionNotesState.Tags, sessionNoteObject, newTags);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.TAGS_SELECTED, newTags);
    }
    changeQuestionOption(isFromSelection) {
        if (!GlobalFunctions.isEmpty(this.questionIndex)) {
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.Subject = this.questionList[this.questionIndex];
            this.enableQuestionValidation = (this.questionList.length == (this.questionIndex + 1));
            let answerList = this.integrationSettingManager.getAnswers(this.questionList[this.questionIndex]);
            if (!GlobalFunctions.isEmpty(answerList) && answerList.length > 0) {
                this.answerList = answerList;
                let indexOfAnswer = -1;
                this.taskDto = GlobalFunctions.getFirstTaskFromSession(this.sessionManager.detailViewCachedEntityList);
                const emailDto = GlobalFunctions.getLastEmailFromSession(this.sessionManager.detailViewCachedEntityList);
                const letterDto = GlobalFunctions.getLastLetterFromSession(this.sessionManager.detailViewCachedEntityList);
                const caseDto = GlobalFunctions.getLastCaseFromSession(this.sessionManager.detailViewCachedEntityList);
                const issueDto = GlobalFunctions.getLastIssueFromSession(this.sessionManager.detailViewCachedEntityList);
                const documentDto = GlobalFunctions.getLastDocumentFromSession(this.sessionManager.detailViewCachedEntityList);
                const ticketDto = GlobalFunctions.getLastTicketFromSession(this.sessionManager.detailViewCachedEntityList);
                if (this.taskDto != null) {
                    switch (this.taskDto.TaskType.toLowerCase()) {
                        case "callbacknote":
                            indexOfAnswer = this.answerOperation(this.answerList, this.taskDto.RelatedEntityFqdn);
                            break;
                        case "appointment":
                            indexOfAnswer = this.answerOperation(this.answerList, this.taskDto.RelatedEntityFqdn);
                            break;
                        case "assignment":
                            indexOfAnswer = this.answerOperation(this.answerList, this.taskDto.RelatedEntityFqdn);
                            break;
                        case "reportimprovement":
                            indexOfAnswer = this.answerOperation(this.answerList, this.taskDto.RelatedEntityFqdn);
                            break;
                        case "informationrequest":
                            indexOfAnswer = this.answerOperation(this.answerList, this.taskDto.RelatedEntityFqdn);
                            break;
                    }
                    if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.SubjectFreeText))
                        this.sessionManager.contactSessionNotesState.ContactHistoryDto.SubjectFreeText = this.htmlToPlainTextPipe.transform(this.taskDto.CustomerQuestion);
                }
                else if (!GlobalFunctions.isEmpty(emailDto) && !GlobalFunctions.isEmpty(emailDto.Header)) {
                    switch (emailDto.EmailType) {
                        case EmailType.Send:
                            indexOfAnswer = this.answerOperation(this.answerList, emailDto.RelatedEntityFqdn, EmailType[EmailType.Send]);
                            break;
                        case EmailType.Reply:
                            indexOfAnswer = this.answerOperation(this.answerList, emailDto.RelatedEntityFqdn, EmailType[EmailType.Reply]);
                            break;
                        case EmailType.Forward:
                            indexOfAnswer = this.answerOperation(this.answerList, emailDto.RelatedEntityFqdn, EmailType[EmailType.Forward]);
                            break;
                    }
                }
                else if (!GlobalFunctions.isEmpty(caseDto))
                    indexOfAnswer = this.answerOperation(this.answerList, caseDto.RelatedEntityFqdn);
                else if (!GlobalFunctions.isEmpty(issueDto))
                    indexOfAnswer = this.answerOperation(this.answerList, issueDto.RelatedEntityFqdn);
                else if (!GlobalFunctions.isEmpty(letterDto))
                    indexOfAnswer = this.answerOperation(this.answerList, letterDto.RelatedEntityFqdn);
                else if (!GlobalFunctions.isEmpty(documentDto))
                    indexOfAnswer = this.answerOperation(this.answerList, documentDto.RelatedEntityFqdn);
                else if (!GlobalFunctions.isEmpty(ticketDto))
                    indexOfAnswer = this.answerOperation(this.answerList, ticketDto.RelatedEntityFqdn);
                else if (this.dialogManager.openContactHistorySource === "JccAppointment")
                    indexOfAnswer = this.answerOperation(this.answerList, 'Decos_Kcs_Tasks_Entities_Appointment');
                if (indexOfAnswer != -1 || isFromSelection) {
                    this.answerIndex = indexOfAnswer != -1 ? indexOfAnswer : 0;
                    this.changeAnswerOption(false);
                }
                $('#selectQuestions').removeClass('error');
                $('#selectAnswers').removeClass('error');
                $('#contactTypeField').removeClass('error');
            }
        }
        else {
            this.questionIndex = null;
            this.answerIndex = null;
            this.answerList = [];
        }
    }
    ;
    changeCustomerRoleOption() {
        this.sessionManager.contactSessionNotesState.ContactHistoryDto.CustomerRole = this.customerRoles[this.roleIndex];
        if (!GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.CustomerRole))
            document.getElementById('customerRolesCombo')?.classList.remove('error');
    }
    ;
    changeQuestionIndex(index) {
        this.sessionManager.contactSessionNotesState.ContactHistoryDto.Subject = this.questionList[index];
        this.questionIndex = index;
        this.enableQuestionValidation = (this.questionList.length == (this.questionIndex + 1));
    }
    ;
    changeAnswerIndex(index) {
        this.sessionManager.contactSessionNotesState.ContactHistoryDto.Memo = this.answerList[index];
        this.answerIndex = index;
        this.enableAnswerValidation = (this.answerList.length == (this.answerIndex + 1));
    }
    ;
    changeAnswerOption(isFromSelection) {
        this.sessionManager.contactSessionNotesState.ContactHistoryDto.Memo = this.answerList[this.answerIndex];
        this.enableAnswerValidation = (this.answerList.length == (this.answerIndex + 1));
        this.setForwardedToField();
        this.setHandledOnBehalfField();
    }
    ;
    setDefaultQuestion() {
        this.questionList = this.integrationSettingManager.getQuestions();
        if (this.isLoadedFromSource === "JccAppointment") {
            let index = this.checkPresence(this.questionList, "Product Burgerzaken");
            if (index !== -1)
                this.questionIndex = index;
        }
        if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.Subject))
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.Subject = this.questionList[this.questionIndex];
        else {
            let index = this.checkPresence(this.questionList, this.sessionManager.contactSessionNotesState.ContactHistoryDto.Subject);
            if (index !== -1)
                this.questionIndex = index;
        }
        this.changeQuestionOption(false);
    }
    ;
    setDefaultAnswer() {
        if (!GlobalFunctions.isEmpty(this.questionIndex)) {
            this.answerList = this.integrationSettingManager.getAnswers(this.questionList[this.questionIndex]);
            if (this.isLoadedFromSource === "JccAppointment") {
                let index = this.checkPresence(this.answerList, "Afspraak gemaakt");
                if (index !== -1)
                    this.answerIndex = index;
            }
            if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.Memo))
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.Memo = this.answerList[this.answerIndex];
            else {
                let index = this.checkPresence(this.answerList.map(answer => answer.Answer), this.sessionManager.contactSessionNotesState.ContactHistoryDto.Memo.Answer);
                if (index !== -1)
                    this.answerIndex = index;
            }
            this.changeAnswerOption(false);
        }
    }
    ;
    setDefaultRoles() {
        if (GlobalFunctions.isEmpty(this.customerRoles)) {
            let roleList = this.integrationSettingManager.roleSetting.roleList;
            if (roleList != null && roleList.length > 0) {
                for (let index = 0; index < roleList.length; index++)
                    this.customerRoles.push(roleList[index].Name);
                this.changeCustomerRoleOption();
            }
        }
        else if (!GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.CustomerRole)) {
            let customerRoleIndex = this.checkPresence(this.customerRoles, this.sessionManager.contactSessionNotesState.ContactHistoryDto.CustomerRole);
            if (customerRoleIndex !== -1)
                this.roleIndex = customerRoleIndex;
        }
    }
    ;
    setRepliedEmailQuestion() {
        this.questionIndex = this.checkPresence(this.questionList, this.emailDefaultQuestion);
        if (this.questionIndex < 0)
            this.questionIndex = 0;
        this.sessionManager.contactSessionNotesState.ContactHistoryDto.Subject = this.questionList[this.questionIndex];
    }
    ;
    setQuestionAnswer() {
        if (this.nextEmailEnabled && !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType) && isNaN(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType) && this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType.toLowerCase() == "email") {
            this.setRepliedEmailQuestion();
            this.setRepliedEmailAnswer();
        }
    }
    ;
    setRepliedEmailAnswer() {
        this.answerIndex = this.checkPresence(this.answerList, this.emailDefaultAnswer);
        if (this.answerIndex < 0)
            this.answerIndex = 0;
        this.changeAnswerOption(true);
        this.sessionManager.contactSessionNotesState.ContactHistoryDto.Memo = this.answerList[this.answerIndex];
    }
    ;
    checkPresence(arrayList, value) {
        let index = -1;
        if (arrayList != null && arrayList.length > 0) {
            value = value.replace("\n", "");
            for (let i = 0; i < arrayList.length; i++) {
                arrayList[i] = arrayList[i].replace("\n", "");
                if (arrayList[i].toLowerCase() == value.toLowerCase()) {
                    index = i;
                    break;
                }
            }
        }
        return index;
    }
    answerOperation(arrayList, entityFqdn, operation) {
        let index = -1;
        if (arrayList != null && arrayList.length > 0) {
            for (let i = 0; i < arrayList.length; i++) {
                if (!GlobalFunctions.isEmpty(arrayList[i]) && !GlobalFunctions.isEmpty(arrayList[i].Fqdn)) {
                    for (let j = 0; j < arrayList[i].Fqdn.length; j++) {
                        if (!GlobalFunctions.isEmpty(arrayList[i].Fqdn[j]) && arrayList[i].Fqdn[j].indexOf(entityFqdn) !== -1) {
                            if (!GlobalFunctions.isEmpty(operation)) {
                                if (arrayList[i].Fqdn[j].includes(operation)) {
                                    index = i;
                                    break;
                                }
                            }
                            else {
                                index = i;
                                break;
                            }
                        }
                    }
                }
                if (index !== -1)
                    break;
            }
        }
        return index;
    }
    createContactHistoryCallback(status) {
        if (status == 0)
            this.timeoutIds.push(setTimeout(() => this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_CONTACT_STATISTIC), 500));
        else {
            let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_CREATE_ERROR_MSG"), [this.translateService.instant("LBL_CONTACT_HISTORY")]);
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_CONTACT_HISTORY"));
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    ;
    isValid() {
        let isValid = true;
        this.form.onSubmit(null);
        if (this.form.invalid)
            isValid = false;
        if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.SubjectFreeText) && this.enableQuestionValidation) {
            document.getElementById('contentFieldQuestion')?.classList.add('error');
            if (isValid)
                document.getElementById('contentFieldQuestion')?.focus();
            isValid = false;
        }
        else
            document.getElementById('contentFieldQuestion')?.classList.remove('error');
        if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.MemoFreeText) && this.enableAnswerValidation) {
            document.getElementById('contentFieldAnswer')?.classList.add('error');
            if (isValid)
                document.getElementById('contentFieldAnswer')?.focus();
            isValid = false;
        }
        else
            document.getElementById('contentFieldAnswer')?.classList.remove('error');
        if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto))
            isValid = false;
        return isValid;
    }
    endSession(keepBusy) {
        if (this.phoneManager.phoneState.CurrentCallDto != null && this.enableWarningForCsnDuringPhoneCall) { // It means Call Status can be Active, Hold, Unhold etc.
            let textMessage = this.translateService.instant("LBL_WARNING_DO_NOT_END_SESSION_DURING_CALL");
            this.showActivePhoneCallWarning(textMessage);
        }
        else {
            if (this.isValid()) {
                if (this.sessionManager.outboxItemCount > 0) {
                    const messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_END_SESSION"), this.translateService.instant("LBL_MSG_HAS_OUTBOX_ITEMS"), true, null, null, null, null, this.translateService);
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
                        if (result)
                            DialogHelper.openDialog(this.dialog, OutboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
                        else
                            this.saveSession(keepBusy);
                    });
                }
                else
                    this.saveSession(keepBusy);
            }
        }
    }
    ;
    saveSession(keepBusy) {
        if (this.phoneManager.phoneState.CurrentCallDto != null && this.enableWarningForCsnDuringPhoneCall) { // It means Call Status can be Active, Hold, Unhold etc.
            let textMessage = this.translateService.instant("LBL_WARNING_DO_NOT_PARK_SESSION_DURING_CALL");
            this.showActivePhoneCallWarning(textMessage);
        }
        else {
            if (keepBusy === undefined) {
                const sessionUIDetail = { uiState: UIState.ContactHistory, uiObject: null };
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactTypeSource = this.getContactTypeSource();
                if (this.sessionManager.jkcParentPanel && this.sessionManager.jkcParentPanel.parameters && this.sessionManager.jkcParentPanel.parameters.IsUsed)
                    this.sessionManager.getSessionUIDetails(this.sessionManager.jkcParentPanel.parameters.Scope, sessionUIDetail);
                this.openSaveSessionDialog(sessionUIDetail.uiObject, sessionUIDetail.uiState, null);
            }
            else {
                this.sessionManager.keepPhoneBusy = keepBusy;
                if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType) || this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType == 0)
                    this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType = "Phone";
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.LastChangedDate = new Date();
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.ReceivedDate = this.getReceivedDate();
                const isSessionHold = GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.StartDate);
                this.setSessionStartAndEndTime();
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.HandlerDto = this.contactHistoryService.getHandlerDto();
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
                if (this.sessionManager.phoneTransferStatus === 6 || this.sessionManager.phoneTransferStatus === 9)
                    this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactSource = 4;
                else
                    this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactSource = 0;
                const contactObjectDtoList = [];
                if (this.sessionManager.contactSessionNotesState.RelatedEntityList?.length > 0) {
                    this.sessionManager.contactSessionNotesState.RelatedEntityList.forEach(item => {
                        if (item?.content) {
                            if (item.content.IsMarked) {
                                let contactObject = new ContactHistoryObjectDto();
                                contactObject.ObjectType = item.entityFullName;
                                contactObject.ObjectId = item.content.Id;
                                contactObject.ObjectSource = item.content.ObjectSource;
                                if (contactObject.ObjectSource.toLowerCase() === 'decos.kcs.tasks.cdr')
                                    contactObject.ObjectTitle = GlobalFunctions.sanitizeAndTruncate(item.content.StringRepresentation); //Returns the final, cleaned, and safely shortened version of the text.
                                else
                                    contactObject.ObjectTitle = item.content.StringRepresentation;
                                contactObjectDtoList.push(contactObject);
                            }
                        }
                    });
                }
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.ObjectDtos = contactObjectDtoList;
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.Tags = this.sessionManager.getTags();
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.ObjectDtos = contactObjectDtoList;
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactHistoryType = 0;
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.RelatedEntityFqdn = 3;
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.Memo = this.sessionManager.contactSessionNotesState.ContactHistoryDto.Memo?.Answer;
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.SessionTime = this.getSessionTime(this.sessionManager, isSessionHold);
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactTypeSource = this.getContactTypeSource();
                if (this.sessionManager.selectedRole && !GlobalFunctions.isEmpty(this.sessionManager.selectedRole.Id))
                    this.sessionManager.contactSessionNotesState.ContactHistoryDto.RoleId = this.sessionManager.selectedRole.Id;
                this.setContactHandleForInfo();
                this.contactHistoryService.createContactMoment(this.sessionManager.contactSessionNotesState.ContactHistoryDto, this.createContactHistoryCallback);
                this.updatePhoneStatus = !keepBusy;
                if (!GlobalFunctions.isEmpty(this.sessionManager.currentSession) && !GlobalFunctions.isEmpty(this.sessionManager.currentSession.Id))
                    this.sessionService.handleSession(this.sessionManager.currentSession.Id, this.ignoreSessionResponse);
                else
                    this.ignoreSessionResponse();
            }
        }
    }
    ;
    ignoreSession() {
        if (this.phoneManager.phoneState.CurrentCallDto != null && this.enableWarningForCsnDuringPhoneCall) { // It means Call Status can be Active, Hold, Unhold etc.
            let textMessage = this.translateService.instant("LBL_WARNING_DO_NOT_IGNORE_SESSION_DURING_CALL");
            this.showActivePhoneCallWarning(textMessage);
        }
        else {
            if (this.sessionManager.loadedFromNextEmailButton && this.sessionManager.selectedEntity?.RelatedEntityFqdn && GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn).toLowerCase() == "email") {
                let headerDescription = "";
                const messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_EMAIL"), this.translateService.instant("LBL_NEXT_EMAIL_WARNING"), true, null, null, null, null, this.translateService);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
                    if (result == 1) {
                        if (this.sessionManager.selectedEntity.Header != null && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Header.Subject))
                            headerDescription = this.sessionManager.selectedEntity.Header.Subject;
                        DialogHelper.openDialog(this.dialog, SessionSaveComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { uiObject: null, uiState: null, calledDialog: null, defaultDescription: headerDescription, clickedFrom: 'nextEmail' }, 'sessionSaveComponent').afterClosed().subscribe(innerResult => {
                            if (innerResult)
                                this.ignoreSessionResponse();
                        });
                    }
                });
            }
            else {
                if (this.sessionManager.isSessionStart && this.applicationSettingManager.showWarningOnIgnoreSession) {
                    const messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_SESSION"), this.translateService.instant("LBL_MESSAGE_WARNING_ON_IGNORE_SESSION"), true, null, null, null, null, this.translateService);
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
                        if (result)
                            this.executeIgnoreSession();
                    });
                }
                else
                    this.executeIgnoreSession();
            }
        }
    }
    ;
    executeIgnoreSession() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.currentSession) && !GlobalFunctions.isEmpty(this.sessionManager.currentSession.Id))
            this.sessionService.handleSession(this.sessionManager.currentSession.Id, this.ignoreSessionResponse);
        else
            this.ignoreSessionResponse();
    }
    ;
    setCustomInformationForPerson() {
        if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson)) {
            let relatedEntityFound = GlobalFunctions.isSessionContainsPersonOrganizationRecord(this.sessionManager.detailViewCachedEntityList);
            if (!relatedEntityFound) {
                let taskObject = GlobalFunctions.getFirstTaskFromSession(this.sessionManager.detailViewCachedEntityList);
                if (taskObject != null)
                    this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson = taskObject.ContactPerson;
            }
            if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson) && !GlobalFunctions.isEmpty(this.sessionManager.contactPersonFromRecentActivity))
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson = this.sessionManager.contactPersonFromRecentActivity;
        }
        if (!GlobalFunctions.isEmpty(this.sessionManager.currentCallerId) && this.sessionManager.currentCallerId.length >= 10) {
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = this.sessionManager.currentCallerId;
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.CallId = this.sessionManager.currentCallId;
        }
    }
    ;
    limitContentOfDropdownWithEllipsis(text) {
        let contactSessionNotesBodyElement = document.getElementById('contactSessionNotesBody');
        let sessionNoteWidth = contactSessionNotesBodyElement != null ? contactSessionNotesBodyElement.clientWidth : 0;
        text = GlobalFunctions.limitContentOfDropdownWithEllipsis(text, sessionNoteWidth === 0 ? (window.parent.innerWidth / 4) : sessionNoteWidth); //avoid width 0 while pinning the contact session note
        return text[0];
    }
    ;
    resetFields() {
        $('#selectQuestions').removeClass('error');
        $('#selectAnswers').removeClass('error');
        $('#contactTypeField').removeClass('error');
        this.sessionManager.contactSessionNotesState.ContactHistoryDto = new ContactHistoryMomentDto();
        this.questionIndex = null;
        this.answerIndex = null;
        this.roleIndex = null;
        this.questionList = [];
        this.answerList = [];
        this.customerRoles = [];
        this.setDefaultQuestion();
        this.setDefaultAnswer();
        this.setDefaultRoles();
        this.taskDto = null;
        this.resetTags();
        this.sessionManager.contactSessionNotesState.RelatedEntityList = [];
        this.sessionManager.contactSessionNotesState.ContactHistoryDto.Notes = "";
        // Timeout needed to prevent weird issue of value not updating
        this.timeoutIds.push(setTimeout(() => {
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType = "Phone";
            if (this.applicationSettingManager.isLinkCSNToCaseSystemEnabled)
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.AddToCase = true;
        }));
    }
    ;
    resetTags() {
        this.sessionManager.contactSessionNotesState.Tags = [];
        this.tagItems = this.applicationSettingManager.tagSetting.searchTagByQuery(''); // Reloads dropdown list.
    }
    ;
    openSaveSessionDialog(uiObjectValue, uiStateValue, calledDialogValue) {
        let description = '';
        this.sessionManager.contactSessionNotesState.ContactHistoryDto.ForwardedTo = this.contactHandleInfo.ForwardedToHandlers;
        this.sessionManager.contactSessionNotesState.ContactHistoryDto.HandledOnBehalf = this.contactHandleInfo.HandledOnBehalfHandlers;
        this.sessionManager.contactSessionNotesState.ContactHistoryDto.ForwardedToType = this.contactHandleInfo.ForwardedToType;
        this.sessionManager.contactSessionNotesState.ContactHistoryDto.HandledOnBehalfType = this.contactHandleInfo.HandledOnBehalfType;
        if (this.applicationFeatureManager.isShowNextEmailFeatureEnabled && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.RelatedEntityFqdn) && GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn).toLowerCase() == "email" && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Header.Subject))
            description = this.sessionManager.selectedEntity.Header.Subject;
        DialogHelper.openDialog(this.dialog, SessionSaveComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { uiObject: uiObjectValue, uiState: uiStateValue, calledDialog: calledDialogValue, defaultDescription: description, clickedFrom: '' }, 'sessionSaveComponent').afterClosed().subscribe(result => {
            if (result)
                this.contactHandleInfo = new ContactHandleInfo();
        });
    }
    ignoreSessionResponse() {
        this.dialog.closeAll();
        this.endCurrentChat();
        this.sessionManager.endSession();
        this.phoneManager.clearPhoneState();
        this.form.resetForm();
        document.getElementById('contentFieldQuestion')?.classList.remove('error');
        document.getElementById('contentFieldAnswer')?.classList.remove('error');
        document.getElementById('customerRolesCombo')?.classList.remove('error');
        this.dialogManager.openContactHistorySource = "";
        this.cacheManager.removeDashboardCache();
        this.router.navigate([RoutePath.DASHBOARD]);
        if (this.updatePhoneStatus)
            this.timeoutIds.push(setTimeout(() => this.phoneManager.updatePhoneAvailabilityStatus(PhoneStatus.Available), 1000));
        else
            this.phoneManager.setPhoneStatusAction('4');
        this.updatePhoneStatus = true;
        this.systemComponentService.clearAllEntityLock();
        this.contactHandleInfo = new ContactHandleInfo();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.REFRESH_DASHBOARD);
    }
    ;
    initialize() {
        this.setDefaultQuestion();
        this.setDefaultAnswer();
        this.setQuestionAnswer();
        this.setDefaultRoles();
        this.setCustomInformationForPerson();
        if (!GlobalFunctions.isEmpty(this.sessionManager.sentEmailDetail))
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.MemoFreeText = this.htmlToPlainTextPipe.transform(this.sessionManager.sentEmailDetail);
        if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType) || this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType == 0)
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType = "Phone";
        if (this.applicationSettingManager.isLinkCSNToCaseSystemEnabled)
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.AddToCase = true;
    }
    ;
    contactQuestionAnswerReceived(response) {
        this.integrationSettingManager.contactQuestionAnswerReceived(response);
        this.initialize();
    }
    ;
    changeUIState(uiState, ignoreLastPosition) {
        this.sessionManager.contactSessionNotesState.UIState = uiState;
        this.contactHistoryService.updateContactSessionNoteUIState();
        this.contactHistoryService.changePanelState(ignoreLastPosition);
        this.sessionManager.resetJkcPanel();
        if (this.sessionManager.jkcViewerPanel && !GlobalFunctions.isEmpty(this.sessionManager.jkcViewerPanel.jkcViewerPanelId))
            this.dialogManager.openJkcViewerPanelDialogue(this.sessionManager.jkcViewerPanel.parameters.EditedData, this.viewContainerRef);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.RESIZE_CSN);
    }
    ;
    getReceivedDate() {
        let receivedDate = null;
        switch (this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType.toUpperCase()) {
            case "EMAIL":
                {
                    let email = GlobalFunctions.getLastEmailFromSession(this.sessionManager.detailViewCachedEntityList);
                    if (email != null && email.Header != null)
                        receivedDate = email.Header.Date;
                    break;
                }
            case "LETTER":
                {
                    let letter = GlobalFunctions.getLastLetterFromSession(this.sessionManager.detailViewCachedEntityList);
                    if (letter != null && letter.ReceivedDate != null)
                        receivedDate = letter.ReceivedDate;
                    break;
                }
            case "SOCIALMEDIA":
            case "FACEBOOK":
            case "TWITTER":
            case "WHATSAPP":
                {
                    let socialMedia = GlobalFunctions.getLastSocialMediaFromSession(this.sessionManager.detailViewCachedEntityList);
                    if (socialMedia != null && socialMedia.Message != null)
                        receivedDate = socialMedia.Message.DateTime;
                    break;
                }
        }
        return receivedDate;
    }
    ;
    getContactTypeSource() {
        let contactTypeSource = "";
        switch (this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType?.toUpperCase()) {
            case "EMAIL":
                {
                    let email = GlobalFunctions.getLastEmailFromSession(this.sessionManager.detailViewCachedEntityList);
                    if (email != null && email.Header != null) {
                        switch (email.Header.EmailSource) {
                            case "Inbox":
                                {
                                    if (GlobalFunctions.isEmpty(email.Header.Sender))
                                        contactTypeSource = email.Header.From;
                                    else
                                        contactTypeSource = email.Header.To[0];
                                    break;
                                }
                            case "Archive":
                                contactTypeSource = email.Header.To[0];
                                break;
                            case "SentBox":
                                contactTypeSource = email.Header.From;
                                break;
                        }
                    }
                    break;
                }
            case "FACEBOOK":
            case "TWITTER":
            case "WHATSAPP":
                {
                    let socialMedia = GlobalFunctions.getLastSocialMediaFromSession(this.sessionManager.detailViewCachedEntityList);
                    if (socialMedia != null && socialMedia.Message != null)
                        contactTypeSource = socialMedia.SourceName;
                    break;
                }
        }
        return contactTypeSource;
    }
    ;
    getSessionTime(sessionManager, isSessionHold) {
        let sessionTime = "";
        if (isSessionHold) {
            let startDate = new Date(sessionManager.contactSessionNotesState.ContactHistoryDto.StartDate);
            let endDate = new Date(sessionManager.contactSessionNotesState.ContactHistoryDto.EndDate);
            let delta = Math.abs(endDate - startDate) / 1000;
            let minutes = Math.floor(delta / 60);
            let seconds = delta % 60;
            if (seconds < 10 && seconds.toString().length == 1)
                seconds = "0" + seconds;
            if (minutes < 10 && minutes.toString().length == 1)
                minutes = "0" + minutes;
            sessionTime = minutes.toString() + ":" + seconds.toString();
        }
        else
            sessionTime = sessionManager.minutes + ":" + sessionManager.seconds;
        return sessionTime;
    }
    ;
    setSessionStartAndEndTime() {
        let contactType = this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType.toUpperCase();
        if ((contactType == "FACEBOOK" || contactType == "TWITTER" || contactType == "WHATSAPP") && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.MessageHandling) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.MessageHandling.StartDate)) {
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.StartDate = this.sessionManager.selectedEntity.MessageHandling.StartDate.toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.EndDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        }
        else {
            if (this.sessionManager.isSessionStart)
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.StartDate = !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.StartDate) ? new this.dateJS(this.sessionManager.contactSessionNotesState.ContactHistoryDto.StartDate).toString('M/d/yyyy HH:mm:ss') : new this.dateJS(this.sessionManager.sessionStartDateTime).toString('M/d/yyyy HH:mm:ss');
            else
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.StartDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.EndDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        }
    }
    ;
    onTagClicked(tag) {
        this.applicationSettingManager.tagSetting.handleAction(tag, this.sessionManager, this.searchService, this.dialogManager, this.eventProvider, null, this.viewContainerRef);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.RESIZE_CSN);
    }
    ;
    onTagAdded(tag) {
        if (this.applicationSettingManager.suggestionSetting.autoShow && this.sessionManager.contactSessionNotesState.isSuggestionPanelOpen == false)
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.TAG_SELECTED, tag);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.RESIZE_CSN);
    }
    ;
    setForwardedToField() {
        this.contactHandleInfo.ForwardedToOptions = this.getHandlerOptions(this.answerList[this.answerIndex]?.ForwardedTo);
        this.contactHandleInfo.ForwardedToType = this.toHandlerType(this.contactHandleInfo.ForwardedToOptions);
        if (!GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ForwardedTo) && this.sessionManager.contactSessionNotesState.ContactHistoryDto.ForwardedTo.length > 0) {
            this.contactHandleInfo.ForwardedToHandlers = this.sessionManager.contactSessionNotesState.ContactHistoryDto.ForwardedTo;
            this.contactHandleInfo.ForwardedToType = this.sessionManager.contactSessionNotesState.ContactHistoryDto.ForwardedToType;
        }
        else
            this.clearForwardedToField();
    }
    ;
    clearForwardedToField() {
        this.setForwardedToHandlers();
        this.contactHandleInfo.ForwardedToHandlers = [];
        this.contactHandleInfo.ForwardedToPlaceholder = this.toHandlerPlaceholder(this.contactHandleInfo.ForwardedToType);
    }
    ;
    setForwardedToHandlers() {
        switch (this.contactHandleInfo.ForwardedToType) {
            case HandlerType.Employee:
                return this.forwardedToHandlerItems = this.cacheManager.getEmployeeList(true);
            case HandlerType.Department:
                return this.forwardedToHandlerItems = this.cacheManager.getDepartmentList();
            case HandlerType.Mailbox:
                return this.forwardedToHandlerItems = this.cacheManager.getTaskMailboxList();
            default:
                return this.forwardedToHandlerItems = [];
        }
    }
    ;
    setHandledOnBehalfField() {
        this.contactHandleInfo.HandledOnBehalfOptions = this.getHandlerOptions(this.answerList[this.answerIndex]?.HandledOnBehalf);
        this.contactHandleInfo.HandledOnBehalfType = this.toHandlerType(this.contactHandleInfo.HandledOnBehalfOptions);
        if (!GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.HandledOnBehalf) && this.sessionManager.contactSessionNotesState.ContactHistoryDto.HandledOnBehalf.length > 0) {
            this.contactHandleInfo.HandledOnBehalfHandlers = this.sessionManager.contactSessionNotesState.ContactHistoryDto.HandledOnBehalf;
            this.contactHandleInfo.HandledOnBehalfType = this.sessionManager.contactSessionNotesState.ContactHistoryDto.HandledOnBehalfType;
        }
        else
            this.clearHandledOnBehalfField();
    }
    ;
    clearHandledOnBehalfField() {
        this.setHandledOnBehalfHandlers();
        this.contactHandleInfo.HandledOnBehalfHandlers = [];
        this.contactHandleInfo.HandledOnBehalfPlaceholder = this.toHandlerPlaceholder(this.contactHandleInfo.HandledOnBehalfType);
    }
    ;
    setHandledOnBehalfHandlers() {
        switch (this.contactHandleInfo.HandledOnBehalfType) {
            case HandlerType.Employee:
                return this.handledOnBehalfHandlerItems = this.cacheManager.getEmployeeList(true);
            case HandlerType.Department:
                return this.handledOnBehalfHandlerItems = this.cacheManager.getDepartmentList();
            case HandlerType.Mailbox:
                return this.handledOnBehalfHandlerItems = this.cacheManager.getTaskMailboxList();
            default:
                return this.handledOnBehalfHandlerItems = [];
        }
    }
    ;
    getHandlerOptions(handlerOption) {
        let handlerOptions = [];
        if (!GlobalFunctions.isEmpty(handlerOption)) {
            switch (parseInt(handlerOption)) {
                case 1:
                    handlerOptions.push({ Id: 1, Name: this.translateService.instant('LBL_EMPLOYEE') });
                    break;
                case 2:
                    handlerOptions.push({ Id: 2, Name: this.translateService.instant('LBL_DEPARTMENT') });
                    break;
                case 3:
                    handlerOptions.push({ Id: 3, Name: this.translateService.instant('LBL_MAILBOX') });
                    break;
                case 4:
                    {
                        handlerOptions.push({ Id: 1, Name: this.translateService.instant('LBL_EMPLOYEE') });
                        handlerOptions.push({ Id: 2, Name: this.translateService.instant('LBL_DEPARTMENT') });
                        break;
                    }
                case 5:
                    {
                        handlerOptions.push({ Id: 1, Name: this.translateService.instant('LBL_EMPLOYEE') });
                        handlerOptions.push({ Id: 3, Name: this.translateService.instant('LBL_MAILBOX') });
                        break;
                    }
                case 6:
                    {
                        handlerOptions.push({ Id: 2, Name: this.translateService.instant('LBL_DEPARTMENT') });
                        handlerOptions.push({ Id: 3, Name: this.translateService.instant('LBL_MAILBOX') });
                        break;
                    }
                case 7:
                    {
                        handlerOptions.push({ Id: 1, Name: this.translateService.instant('LBL_EMPLOYEE') });
                        handlerOptions.push({ Id: 2, Name: this.translateService.instant('LBL_DEPARTMENT') });
                        handlerOptions.push({ Id: 3, Name: this.translateService.instant('LBL_MAILBOX') });
                        break;
                    }
            }
        }
        return handlerOptions;
    }
    ;
    toHandlerType(handlerOptions) {
        let handlerType = 0;
        if (handlerOptions != null && handlerOptions.length > 0)
            handlerType = handlerOptions[0].Id;
        return handlerType;
    }
    ;
    toHandlerPlaceholder(handlerType) {
        let handlerPlaceholder = this.translateService.instant('LBL_SELECT_HANDLER');
        switch (handlerType) {
            case 1:
                handlerPlaceholder = this.translateService.instant('LBL_SELECT_EMPLOYEE');
                break;
            case 2:
                handlerPlaceholder = this.translateService.instant('LBL_SELECT_DEPARTMENT');
                break;
            case 3:
                handlerPlaceholder = this.translateService.instant('LBL_SELECT_MAILBOX');
                break;
        }
        return handlerPlaceholder;
    }
    ;
    setContactHandleForInfo() {
        if (this.contactHandleInfo.ForwardedToHandlers != null && this.contactHandleInfo.ForwardedToHandlers.length > 0) {
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ForwardedTo = this.contactHandleInfo.ForwardedToHandlers[0].Id;
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ForwardedToType = this.contactHandleInfo.ForwardedToType;
        }
        else {
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ForwardedTo = null;
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ForwardedToType = HandlerType.None;
        }
        if (this.contactHandleInfo.HandledOnBehalfHandlers != null && this.contactHandleInfo.HandledOnBehalfHandlers.length > 0) {
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.HandledOnBehalf = this.contactHandleInfo.HandledOnBehalfHandlers[0].Id;
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.HandledOnBehalfType = this.contactHandleInfo.HandledOnBehalfType;
        }
        else {
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.HandledOnBehalf = null;
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.HandledOnBehalfType = HandlerType.None;
        }
    }
    ;
    endCurrentChat() {
        if (this.chatService.chatMessage != null && !GlobalFunctions.isEmpty(this.chatService.chatMessage.Id)) {
            let message = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Chat_Entities_Chat, "CHATENDMESSAGE");
            let userName = !GlobalFunctions.isEmpty(this.employeeService.loggedInEmployee) ? this.employeeService.loggedInEmployee.FirstName : "";
            this.chatService.endChat(userName, message);
        }
    }
    ;
    resize() {
        this.contactHistoryService.resizeContactSessionNotes();
    }
    showActivePhoneCallWarning(textMessage) {
        return DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_PHONE"), textMsg: textMessage, isConfirmation: false, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
    }
    ;
    onPhoneNumberChange() {
        let phoneNumber = this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber;
        this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = phoneNumber ? phoneNumber.trim() : phoneNumber;
    }
    ;
};
__decorate([
    ViewChild('form')
], ContactSessionNotesComponent.prototype, "form", void 0);
ContactSessionNotesComponent = __decorate([
    Component({
        selector: 'contact-session-notes',
        templateUrl: './contact-session-notes.component.html',
        styleUrls: ['./contact-session-notes.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], ContactSessionNotesComponent);
export { ContactSessionNotesComponent };
//# sourceMappingURL=contact-session-notes.component.js.map